/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalancePlugInCollection;
import com.kingdee.eas.scm.framework.balance.BalancePlugInFactory;
import com.kingdee.eas.scm.framework.balance.BalancePlugInInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalancePlugInManageUI;
import com.kingdee.eas.scm.framework.balance.client.BalancePlugInEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class BalancePlugInManageUI
extends AbstractBalancePlugInManageUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_ID = "id";
    private static final String COL_SEQ = "seq";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_APPLYRANGE = "applyRange";
    private static final String COL_ISSCHEDULED = "isScheduled";
    private static final String COL_PLUGINCLASS = "plugInClass";
    private static final String COL_DESCRIPTION = "description";
    private boolean isModified = false;
    private BalanceModelInfo balanceModelInfo;
    private BalancePlugInCollection plugInColl;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.balanceModelInfo = (BalanceModelInfo)this.getUIContext().get("ParentNode");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        view.setFilter(filter);
        SorterItemCollection sortor = new SorterItemCollection();
        sortor.add(new SorterItemInfo(COL_SEQ));
        view.setSorter(sortor);
        this.plugInColl = BalancePlugInFactory.getRemoteInstance().getBalancePlugInCollection(view);
        this.loadPlugInTable();
    }

    private void loadPlugInTable() {
        this.tblPlugIn.checkParsed();
        this.tblPlugIn.setEditable(false);
        this.tblPlugIn.removeRows();
        this.tblPlugIn.getSelectManager().setSelectMode(2);
        if (BalanceTypeEnum.RealTime.equals((Object)this.balanceModelInfo.getBalanceType())) {
            this.tblPlugIn.getColumn(COL_APPLYRANGE).getStyleAttributes().setHided(true);
        }
        int size = this.plugInColl.size();
        BalancePlugInInfo plugIn = null;
        for (int i = 0; i < size; ++i) {
            plugIn = this.plugInColl.get(i);
            this.addRow(plugIn);
        }
    }

    private void addRow(BalancePlugInInfo plugIn) {
        IRow row = this.tblPlugIn.addRow();
        this.updateRow(row, plugIn);
    }

    private void updateRow(IRow row, BalancePlugInInfo plugIn) {
        row.getCell(COL_ID).setValue((Object)plugIn.getId().toString());
        row.getCell(COL_SEQ).setValue((Object)plugIn.getSeq());
        row.getCell(COL_NUMBER).setValue((Object)plugIn.getNumber());
        row.getCell(COL_NAME).setValue((Object)plugIn.getName());
        row.getCell(COL_APPLYRANGE).setValue((Object)plugIn.getApplyRange());
        row.getCell(COL_ISSCHEDULED).setValue((Object)plugIn.isIsScheduled());
        row.getCell(COL_PLUGINCLASS).setValue((Object)plugIn.getPlugInClass());
        row.getCell(COL_DESCRIPTION).setValue((Object)plugIn.getDescription());
        row.setUserObject((Object)plugIn);
    }

    protected BalancePlugInInfo createNewData() {
        BalancePlugInInfo plugIn = new BalancePlugInInfo();
        plugIn.setId(BOSUuid.create((BOSObjectType)plugIn.getBOSType()));
        plugIn.setSeq(this.tblPlugIn.getRowCount() + 1);
        plugIn.setBalanceModel(this.balanceModelInfo);
        return plugIn;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        BalancePlugInInfo plugIn = this.createNewData();
        uiContext.put("InitDataObject", plugIn);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.balance.client.BalancePlugInEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        BalancePlugInEditUI plugInEditUI = (BalancePlugInEditUI)uiWindow.getUIObject();
        if (!plugInEditUI.isCancel()) {
            this.addRow(plugIn);
            this.plugInColl.add(plugIn);
            this.isModified = true;
        }
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        BalancePlugInInfo oldPlugIn = (BalancePlugInInfo)row.getUserObject();
        if (oldPlugIn.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"110_BalancePlugInManageUI"));
            SysUtil.abort();
        }
        BalancePlugInInfo newPlugIn = (BalancePlugInInfo)oldPlugIn.clone();
        newPlugIn.setBalanceModel(this.balanceModelInfo);
        UIContext uiContext = new UIContext();
        uiContext.put("InitDataObject", newPlugIn);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BalancePlugInEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        BalancePlugInEditUI plugInEditUI = (BalancePlugInEditUI)uiWindow.getUIObject();
        if (!plugInEditUI.isCancel()) {
            this.updateRow(row, newPlugIn);
            this.plugInColl.remove(oldPlugIn);
            this.plugInColl.add(newPlugIn);
            this.isModified = true;
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        BalancePlugInInfo plugIn = (BalancePlugInInfo)row.getUserObject();
        if (plugIn.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"111_BalancePlugInManageUI"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            this.plugInColl.remove(plugIn);
            BalancePlugInFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(plugIn.getId()));
            this.tblPlugIn.removeRow(row.getRowIndex());
            if (row.getRowIndex() < this.tblPlugIn.getRowCount()) {
                this.adjustPlugInSeq();
                this.isModified = true;
            }
        }
    }

    private void adjustPlugInSeq() {
        int size = this.tblPlugIn.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblPlugIn.getRow(i);
            row.getCell(COL_SEQ).setValue((Object)(i + 1));
            ((BalancePlugInInfo)row.getUserObject()).setSeq(i + 1);
        }
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        int index = row.getRowIndex();
        if (index == 0) {
            return;
        }
        this.tblPlugIn.moveRow(index, index - 1);
        this.adjustPlugInSeq();
        this.tblPlugIn.getSelectManager().select(index - 1, 0);
        this.isModified = true;
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblPlugIn);
        int index = row.getRowIndex();
        if (index == this.tblPlugIn.getRowCount() - 1) {
            return;
        }
        this.tblPlugIn.moveRow(index, index + 1);
        this.adjustPlugInSeq();
        this.tblPlugIn.getSelectManager().select(index + 1, 0);
        this.isModified = true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isModified) {
            return;
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < this.plugInColl.size(); ++i) {
            colls.add((CoreBaseInfo)this.plugInColl.get(i));
        }
        BalancePlugInFactory.getRemoteInstance().saveBatchData(colls);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"112_BalancePlugInManageUI"));
        this.isModified = false;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModified && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"113_BalancePlugInManageUI")))) {
            this.actionSave_actionPerformed(e);
        }
        this.disposeUIWindow();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void checkSelected() {
        if (this.tblPlugIn.getRowCount() == 0 || this.tblPlugIn.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

