/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.TableIndexManageFacadeFactory;
import com.kingdee.eas.scm.framework.balance.client.AbstractCreateIndexUI;
import com.kingdee.eas.scm.framework.model.TableIndexInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class CreateIndexUI
extends AbstractCreateIndexUI {
    private static final long serialVersionUID = 1L;
    private BalanceModelInfo balanceModel;
    private TableIndexInfo indexInfo;
    private boolean isCancel;

    public void onLoad() throws Exception {
        super.onLoad();
        this.balanceModel = (BalanceModelInfo)this.getUIContext().get("BalanceModel");
        this.innerLoadFields();
    }

    private void innerLoadFields() {
        this.listAllField.removeAllElements();
        BalanceFieldModelCollection coll = this.balanceModel.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            this.listAllField.addElement((Object)coll.get(i).getFieldName());
        }
        if (coll.size() > 0) {
            this.listAllField.setSelectedIndex(0);
        }
    }

    @Override
    public void actionCreateIndex_actionPerformed(ActionEvent e) throws Exception {
        int count;
        String indexName = this.txtIndexName.getText();
        if (indexName == null || indexName.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"114_CreateIndexUI"));
            SysUtil.abort();
        }
        if ((count = this.listIndexField.getElementCount()) == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"115_CreateIndexUI"));
            SysUtil.abort();
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            fieldList.add(this.listIndexField.getElement(i).toString());
        }
        boolean isUnique = this.chkIsUnique.isSelected();
        boolean success = TableIndexManageFacadeFactory.getRemoteInstance().createIndex(this.balanceModel.getTabName(), indexName, fieldList, isUnique);
        if (success) {
            this.indexInfo = new TableIndexInfo(this.balanceModel.getTabName(), indexName, isUnique, fieldList);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"116_CreateIndexUI"));
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public TableIndexInfo getData() {
        return this.indexInfo;
    }

    @Override
    public void actionAddField_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.listAllField.getSelectedIndex();
        if (selectIndex < 0) {
            return;
        }
        Object field = this.listAllField.getSelectedValue();
        this.listIndexField.addElement(field);
        this.listAllField.removeElement(field);
        selectIndex = this.listAllField.getElementCount() <= selectIndex ? this.listAllField.getElementCount() - 1 : selectIndex;
        this.listAllField.setSelectedIndex(selectIndex);
    }

    @Override
    public void actionDelField_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.listIndexField.getSelectedIndex();
        if (selectIndex < 0) {
            return;
        }
        Object field = this.listIndexField.getSelectedValue();
        this.listAllField.addElement(field);
        this.listIndexField.removeElement(field);
        selectIndex = this.listIndexField.getElementCount() <= selectIndex ? this.listIndexField.getElementCount() - 1 : selectIndex;
        this.listIndexField.setSelectedIndex(selectIndex);
    }

    @Override
    public void actionClearField_actionPerformed(ActionEvent e) throws Exception {
        this.listIndexField.removeAllElements();
        this.innerLoadFields();
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        int index = this.listIndexField.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        Object field = this.listIndexField.getSelectedValue();
        this.listIndexField.removeElement(field);
        this.listIndexField.insertElement(field, index - 1);
        this.listIndexField.setSelectedValue(field, true);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        int index = this.listIndexField.getSelectedIndex();
        if (index < 0 || index >= this.listIndexField.getElementCount() - 1) {
            return;
        }
        Object field = this.listIndexField.getSelectedValue();
        this.listIndexField.removeElement(field);
        this.listIndexField.insertElement(field, index + 1);
        this.listIndexField.setSelectedValue(field, true);
    }
}

