/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.util;

import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.CompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.StringExpr;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.util.string.StringUtil;

public class BalanceFormulaPaser {
    private BalanceFieldModelCollection coll;

    public BalanceFormulaPaser(BalanceFieldModelCollection coll) {
        this.coll = coll;
    }

    public String getSQLExpression(BalanceFieldModelInfo fieldInfo) throws BalanceModelException {
        StringBuffer expression = new StringBuffer();
        String calExprStr = fieldInfo.getCalExpression();
        if (StringUtil.isEmpty((String)calExprStr)) {
            return expression.toString();
        }
        FormularParser parser = new FormularParser();
        parser.setStringSupported(true);
        try {
            AbstractExpr expr = parser.parse(calExprStr.substring(calExprStr.indexOf("=") + 1));
            expression.append(this.parseExpr(expr));
        }
        catch (StringParsingException e) {
            throw new BalanceModelException(BalanceModelException.FORMULAPARSEERROR, new String[]{e.getMessage()});
        }
        return expression.toString();
    }

    public boolean isCanCalculate(BalanceFieldModelInfo fieldInfo) throws BalanceModelException {
        String calExprStr = fieldInfo.getCalExpression();
        if (StringUtil.isEmpty((String)calExprStr)) {
            return false;
        }
        if (fieldInfo.getBoolean("IsCalculated")) {
            return false;
        }
        boolean result = false;
        FormularParser parser = new FormularParser();
        parser.setStringSupported(true);
        try {
            AbstractExpr expr = parser.parse(calExprStr.substring(calExprStr.indexOf("=") + 1));
            result = this.isExprCanCalculate(expr, fieldInfo);
        }
        catch (StringParsingException e) {
            throw new BalanceModelException(BalanceModelException.FORMULAPARSEERROR, new String[]{e.getMessage()});
        }
        return result;
    }

    private boolean isExprCanCalculate(AbstractExpr expr, BalanceFieldModelInfo fieldInfo) {
        String value;
        BalanceFieldModelInfo field;
        boolean result = false;
        if (expr instanceof CompositeExpr) {
            CompositeExpr compositeExpr = (CompositeExpr)expr;
            result = this.isExprCanCalculate(compositeExpr.getLeftExpr(), fieldInfo);
            if (!result) {
                return result;
            }
            result = this.isExprCanCalculate(compositeExpr.getRightExpr(), fieldInfo);
        } else if (expr instanceof StringExpr && (BizDataTypeEnum.BeginData.equals((Object)(field = this.getFieldByID(value = ((StringExpr)expr).getValue())).getBizDataType()) || StringUtil.isEmpty((String)field.getCalExpression()) || field.getId().equals((Object)fieldInfo.getId()) || field.getBoolean("IsCalculated"))) {
            result = true;
        }
        return result;
    }

    private String parseExpr(AbstractExpr expr) {
        StringBuffer result = new StringBuffer();
        if (expr instanceof CompositeExpr) {
            CompositeExpr compositeExpr = (CompositeExpr)expr;
            result.append(this.parseExpr(compositeExpr.getLeftExpr()));
            result.append(compositeExpr.getOper().getOperString());
            result.append(this.parseExpr(compositeExpr.getRightExpr()));
        } else if (expr instanceof StringExpr) {
            String value = ((StringExpr)expr).getValue();
            result.append(this.getFieldByID(value).getFieldName());
        }
        return result.toString();
    }

    private BalanceFieldModelInfo getFieldByID(String fieldId) {
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < this.coll.size(); ++i) {
            fieldInfo = this.coll.get(i);
            if (!fieldInfo.getId().toString().equals(fieldId)) continue;
            return fieldInfo;
        }
        return null;
    }
}

