/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.RelationTypeEnum;
import com.kingdee.eas.scm.framework.balance.util.BalanceConst;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.Base64Encoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class BalanceUtil {
    public static String getPkName(String tableName) {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 15);
        return "PK_" + name;
    }

    public static String getDataTypeStr(Context ctx, BalanceFieldModelInfo fieldInfo) throws BalanceModelException {
        String dataType = "";
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String)) {
            dataType = "FBillEntryID".equals(fieldInfo.getFieldName()) ? "Varchar(" + fieldInfo.getLength() + ")" : "NVarchar(" + fieldInfo.getLength() + ")";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
            dataType = "DateTime";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.BOSUuid)) {
            dataType = "Varchar(44)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Qty)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            dataType = "Numeric(17, 4)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Price)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            String eClassName = fieldInfo.getBaseDataBOSType();
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BizEnumInfo bizEnum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, (IMetaDataPK)MetaDataPK.create((String)eClassName));
            if (bizEnum == null) {
                throw new BalanceModelException(BalanceModelException.DATATYPEISINVALID);
            }
            if (BizEnumValueType.INTEGER.equals((Object)bizEnum.getDataType())) {
                dataType = "Int";
            } else if (BizEnumValueType.STRING.equals((Object)bizEnum.getDataType())) {
                dataType = "Varchar(100)";
            }
        } else {
            throw new BalanceModelException(BalanceModelException.DATATYPEISINVALID);
        }
        return dataType;
    }

    public static String getDefaultValueSQL(BalanceFieldModelInfo fieldInfo, boolean isCreateSQL) {
        String defaultValue = "";
        if (StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
            return defaultValue;
        }
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Date) || fieldInfo.getDataType().equals((Object)DataTypeEnum.BOSUuid)) {
            defaultValue = "'" + fieldInfo.getDefaultValue() + "'";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Qty) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Price) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            defaultValue = fieldInfo.getDefaultValue();
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            defaultValue = fieldInfo.getDefaultValue();
        }
        if (isCreateSQL) {
            return "default " + defaultValue;
        }
        return defaultValue;
    }

    public static String getJoinSQL(RelationTypeEnum joinType) {
        String result = "";
        result = RelationTypeEnum.Inner_Join.equals((Object)joinType) ? " INNER JOIN " : (RelationTypeEnum.Left_Join.equals((Object)joinType) ? " LEFT JOIN " : " RIGHT JOIN ");
        return result;
    }

    public static String getBosTypeByModelId(String modelId) {
        Map<String, String> bal2BosTypeMap = BalanceConst.BALMODEL2BOSTYPE_MAP;
        if (bal2BosTypeMap.containsKey(modelId)) {
            return bal2BosTypeMap.get(modelId);
        }
        return "12345678";
    }

    public static String getMd5(String msg) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(msg.getBytes());
        byte[] tmp = digest.digest();
        return Base64Encoder.byteArrayToBase64((byte[])tmp);
    }
}

