/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.framework.bizflow.ProcessFactory;
import com.kingdee.eas.scm.framework.bizflow.ProcessGroupException;
import com.kingdee.eas.scm.framework.bizflow.ProcessGroupNodeCollection;
import com.kingdee.eas.scm.framework.bizflow.ProcessGroupNodeFactory;
import com.kingdee.eas.scm.framework.bizflow.ProcessGroupNodeInfo;
import com.kingdee.eas.scm.framework.bizflow.SimpleStatusEnum;
import com.kingdee.eas.scm.framework.bizflow.client.AbstractProcessListUI;
import com.kingdee.eas.scm.framework.bizflow.client.ExportImageUI;
import com.kingdee.eas.scm.framework.bizflow.client.ImportImageUI;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrActionUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ProcessListUI
extends AbstractProcessListUI {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCEPATH = "com.kingdee.eas.scm.framework.bizflow.BizProcessResource";
    private KDTreeNode rootNode = null;
    private static final String rootNodeNum = "root";
    private static final String processGroupResource = "com.kingdee.eas.scm.framework.bizflow.ProcessGroupResource";
    private DefaultTreeModel treeModel = null;
    FilterInfo selectNodeFilterInfo = null;
    private SolutionMgrActionUI solutionMgrActionUI = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(false, false);

    public ProcessListUI() throws Exception {
        this.solutionMgrActionUI = new SolutionMgrActionUI((ListUI)this, this.toolBar, this.tblMain, "number", "FNumber", "EXP_Process");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadMenu2Toolbar();
        this.initGroupButton();
        this.initGroupTree();
    }

    protected void loadMenu2Toolbar() {
        this.hideOrShowAuditResult(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.MenuItemAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnImportImage.setVisible(false);
        this.btnImportImage.setEnabled(false);
        this.btnExportImage.setVisible(false);
        this.btnExportImage.setEnabled(false);
    }

    private void initGroupButton() {
        this.getUIToolBar().remove((Component)this.btnGroupAddNew);
        this.getUIToolBar().remove((Component)this.btnGroupView);
        this.getUIToolBar().remove((Component)this.btnGroupEdit);
        this.getUIToolBar().remove((Component)this.btnGroupRemove);
        this.btnGroupAddNew.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationGroup_New"));
        this.btnGroupView.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationGroup_View"));
        this.btnGroupEdit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationGroup_Update"));
        this.btnGroupRemove.setToolTipText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationGroup_Delete"));
        this.btnGroupView.setEnabled(true);
        this.btnGroupEdit.setEnabled(true);
        this.btnGroupAddNew.setEnabled(true);
        this.btnGroupRemove.setEnabled(true);
        this.btnGroupMove.setEnabled(true);
        this.btnGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnGroupEdit.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.kDTreeView1.getControlPane().add((Component)this.btnGroupAddNew);
        this.kDTreeView1.getControlPane().add((Component)this.btnGroupView);
        this.kDTreeView1.getControlPane().add((Component)this.btnGroupEdit);
        this.kDTreeView1.getControlPane().add((Component)this.btnGroupRemove);
    }

    private void initGroupTree() throws BOSException {
        ProcessGroupNodeInfo rootGroupNode = new ProcessGroupNodeInfo();
        rootGroupNode.setNumber(rootNodeNum);
        String name = ResourceUtil.getMessage((String)processGroupResource, (String)"root_name");
        rootGroupNode.setName(name);
        this.rootNode = new KDTreeNode((Object)rootGroupNode);
        ProcessGroupNodeCollection coll = this.getGroupNodeColl();
        ProcessGroupNodeInfo nodeInfo = null;
        KDTreeNode treeNode = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            nodeInfo = coll.get(i);
            treeNode = new KDTreeNode((Object)nodeInfo);
            this.rootNode.add((MutableTreeNode)treeNode);
        }
        this.treeModel = new DefaultTreeModel((TreeNode)this.rootNode);
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                ProcessListUI.this.kdTreeMain.updateUI();
            }
        });
        this.kdTreeMain.setModel((TreeModel)this.treeModel);
        this.kdTreeMain.setEditable(true);
        this.kdTreeMain.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent e) {
            }
        });
        this.kdTreeMain.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TreePath oldPath = null;
                if (e.getOldValue() instanceof TreePath) {
                    oldPath = (TreePath)e.getOldValue();
                }
                KDTreeNode oldNode = null;
                if (oldPath != null) {
                    oldNode = (KDTreeNode)oldPath.getLastPathComponent();
                    try {
                        ProcessGroupNodeInfo nodeInfo = (ProcessGroupNodeInfo)oldNode.getUserObject();
                        if (nodeInfo != null && ProcessListUI.rootNodeNum.equals(nodeInfo.getNumber())) {
                            return;
                        }
                        ProcessGroupNodeFactory.getRemoteInstance().save((CoreBaseInfo)nodeInfo);
                    }
                    catch (ProcessGroupException ee) {
                        ProcessListUI.this.kdTreeMain.startEditingAtPath(oldPath);
                        ProcessListUI.this.handUIException((Throwable)((Object)ee));
                        SysUtil.abort();
                    }
                    catch (Exception exe) {
                        ProcessListUI.this.handUIException(exe);
                        SysUtil.abort();
                    }
                }
            }
        });
        this.kdTreeMain.getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                KDTreeNode treeNode = null;
                try {
                    if (ProcessListUI.this.kdTreeMain.getSelectionPath() == null || ProcessListUI.this.kdTreeMain.getSelectionPath().getLastPathComponent() == null) {
                        return;
                    }
                    treeNode = (KDTreeNode)ProcessListUI.this.kdTreeMain.getSelectionPath().getLastPathComponent();
                    ProcessGroupNodeInfo nodeInfo = (ProcessGroupNodeInfo)treeNode.getUserObject();
                    if (nodeInfo != null && ProcessListUI.rootNodeNum.equals(nodeInfo.getNumber())) {
                        return;
                    }
                    String name = ProcessListUI.this.kdTreeMain.getCellEditor().getCellEditorValue().toString();
                    nodeInfo.setName(name);
                    ProcessGroupNodeFactory.getRemoteInstance().save((CoreBaseInfo)nodeInfo);
                    treeNode.setText(name);
                    treeNode.setUserObject((Object)nodeInfo);
                }
                catch (ProcessGroupException ee) {
                    treeNode = (KDTreeNode)ProcessListUI.this.kdTreeMain.getSelectionPath().getLastPathComponent();
                    ProcessListUI.this.treeModel.getPathToRoot((TreeNode)treeNode);
                    TreePath treePath = ProcessListUI.this.kdTreeMain.getSelectionPath();
                    ProcessListUI.this.kdTreeMain.startEditingAtPath(treePath);
                    ProcessListUI.this.handUIException((Throwable)((Object)ee));
                    SysUtil.abort();
                }
                catch (Exception exe) {
                    ProcessListUI.this.handUIException(exe);
                    SysUtil.abort();
                }
            }

            @Override
            public void editingStopped(ChangeEvent e) {
            }
        });
        this.kdTreeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    ProcessListUI.this.setMainQueryEntityView();
                    ProcessListUI.this.refresh(null);
                }
                catch (Exception exe) {
                    ProcessListUI.this.handUIException(exe);
                }
            }
        });
    }

    private ProcessGroupNodeCollection getGroupNodeColl() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection seic = new SelectorItemCollection();
        seic.add("name");
        seic.add("number");
        view.setSelector(seic);
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("number"));
        view.setSorter(sic);
        return ProcessGroupNodeFactory.getRemoteInstance().getProcessGroupNodeCollection(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProcessFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.framework.bizflow.client.ProcessDesignUI";
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancelCancel();
        this.refreshList();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode;
        if (this.kdTreeMain.isEditing()) {
            this.kdTreeMain.cancelEditing();
        }
        if ((treeNode = this.getSelectedTreeNode()) != null && !rootNodeNum.equals(((ProcessGroupNodeInfo)treeNode.getUserObject()).getNumber())) {
            ProcessGroupNodeInfo nodeInfo = (ProcessGroupNodeInfo)treeNode.getUserObject();
            this.getUIContext().put("processgroupnode", nodeInfo);
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain)[0];
        BizEnumValueDTO status = (BizEnumValueDTO)this.tblMain.getRow(selectIndex).getCell("status").getValue();
        if (SimpleStatusEnum.ACTIVE.getName().equals(status.getName())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"15_ProcessCheck"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdTreeMain.isEditing()) {
            this.kdTreeMain.cancelEditing();
        }
        ProcessGroupNodeInfo nodeInfo = new ProcessGroupNodeInfo();
        nodeInfo.setId(BOSUuid.create((BOSObjectType)nodeInfo.getBOSType()));
        String name = ResourceUtil.getMessage((String)processGroupResource, (String)"default_node_name");
        nodeInfo.setName(name);
        nodeInfo.setNumber("000");
        KDTreeNode newTreeNode = new KDTreeNode((Object)nodeInfo);
        this.treeModel.insertNodeInto((MutableTreeNode)newTreeNode, (MutableTreeNode)this.rootNode, this.rootNode.getChildCount());
        Object[] nodes = this.treeModel.getPathToRoot((TreeNode)newTreeNode);
        TreePath path = new TreePath(nodes);
        this.kdTreeMain.scrollPathToVisible(path);
        this.kdTreeMain.setSelectionPath(path);
        this.kdTreeMain.startEditingAtPath(path);
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupEdit_actionPerformed(e);
        TreePath treePath = this.kdTreeMain.getSelectionPath();
        this.kdTreeMain.startEditingAtPath(treePath);
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
    }

    @Override
    public void actionGroupMove_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupMove_actionPerformed(e);
        KDTreeNode curTreeNode = this.getSelectedTreeNode();
        if (curTreeNode == null) {
            return;
        }
        KDTreeNode preTreeNode = (KDTreeNode)curTreeNode.getPreviousNode();
        if (preTreeNode == null) {
            return;
        }
        ProcessGroupNodeInfo curNodeInfo = (ProcessGroupNodeInfo)curTreeNode.getUserObject();
        ProcessGroupNodeInfo preNodeInfo = (ProcessGroupNodeInfo)preTreeNode.getUserObject();
        String number = curNodeInfo.getNumber();
        curNodeInfo.setNumber(preNodeInfo.getNumber());
        preNodeInfo.setNumber(number);
        curTreeNode.setUserObject((Object)preNodeInfo);
        preTreeNode.setUserObject((Object)curNodeInfo);
        String text = curTreeNode.getText();
        curTreeNode.setText(preTreeNode.getText());
        preTreeNode.setText(text);
        this.kdTreeMain.updateUI();
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        ProcessGroupNodeInfo nodeInfo = (ProcessGroupNodeInfo)treeNode.getUserObject();
        if (nodeInfo != null) {
            ProcessGroupNodeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(nodeInfo.getId().toString()));
            try {
                PropertyChangeListener[] listeners = this.kdTreeMain.getPropertyChangeListeners();
                if (listeners != null) {
                    int len = listeners.length;
                    for (int i = 0; i < len; ++i) {
                        this.kdTreeMain.removePropertyChangeListener(listeners[i]);
                    }
                }
                this.kdTreeMain.removeNodeFromParent((MutableTreeNode)treeNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private KDTreeNode getSelectedTreeNode() {
        TreePath treePath = this.kdTreeMain.getSelectionPath();
        if (treePath != null) {
            return (KDTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    private void setMainQueryEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        TreePath treePath = this.kdTreeMain.getSelectionPath();
        this.selectNodeFilterInfo = new FilterInfo();
        if (treePath == null) {
            this.mainQuery = view;
            return;
        }
        KDTreeNode node = (KDTreeNode)treePath.getLastPathComponent();
        ProcessGroupNodeInfo nodeInfo = (ProcessGroupNodeInfo)node.getUserObject();
        if (StringUtil.isEmpty((String)nodeInfo.getNumber()) || rootNodeNum.equals(nodeInfo.getNumber())) {
            this.mainQuery = view;
            return;
        }
        this.selectNodeFilterInfo.getFilterItems().add(new FilterItemInfo("processGroup.id", (Object)nodeInfo.getId().toString(), CompareType.EQUALS));
        this.mainQuery.setFilter(this.selectNodeFilterInfo);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        try {
            if (this.mainQuery.getFilter() != null) {
                this.mainQuery.getFilter().mergeFilter(this.selectNodeFilterInfo, "and");
            } else {
                this.mainQuery.setFilter(this.selectNodeFilterInfo);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return exec;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionImportImage_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(ImportImageUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionExportImage_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        IRow row = null;
        String id = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            id = (String)row.getCell("id").getValue();
            ids.add(id);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IDS", ids);
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(ExportImageUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    @Override
    public void actionShowImageBtn_actionPerformed(ActionEvent e) throws Exception {
        this.btnImportImage.setEnabled(!this.btnImportImage.isEnabled());
        this.btnImportImage.setVisible(!this.btnImportImage.isVisible());
        this.btnExportImage.setEnabled(!this.btnExportImage.isEnabled());
        this.btnExportImage.setVisible(!this.btnExportImage.isVisible());
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.tblMain.getInputMap(2);
        ActionMap actionMap = this.tblMain.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(73, 3), "actionShowUpgradeBtn");
        actionMap.put("actionShowUpgradeBtn", (Action)((Object)this.actionShowImageBtn));
        this.actionShowImageBtn.setEnabled(true);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.solutionMgrActionUI.registImpBtn(38);
        this.solutionMgrActionUI.registExpBtn(39);
    }
}

