/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeInfo;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeWriteBackRuleCollection;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeWriteBackRuleInfo;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleInfo;
import com.kingdee.eas.scm.framework.bizflow.client.AbstractProcessReWriteSelectUI;
import com.kingdee.eas.scm.framework.bizflow.client.BizFlowNodeHelper;
import com.kingdee.eas.scm.framework.bizflow.client.util.BizFlowClientUtil;
import com.kingdee.eas.scm.framework.enums.BizActionEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ProcessReWriteSelectUI
extends AbstractProcessReWriteSelectUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ProcessReWriteSelectUI.class);
    private static final String DESTNODEALIAS = "destNodeAlias";
    private static final String DESTNODEBOSTYPE = "destNodeBOSType";
    private static final String SRCNODEID = "srcNodeID";
    private static final String SRCNODE = "srcNode";
    private static final String SRCNODEALIAS = "srcNodeAlias";
    private static final String SRCNODEBOSTYPE = "srcNodeBosType";
    private static final String ACTION = "action";
    private static final String WRITEBACKRULE = "writeBackRule";
    private ProcessNodeInfo processNode = null;
    private Object[] nodeList = null;
    private BizFlowNodeHelper bizFlowNodeHelper = null;
    private ProcessNodeWriteBackRuleCollection oldRule = null;
    private boolean cancel = false;
    private boolean confirm = false;
    private ProcessNodeWriteBackRuleCollection processNodeWriteBackRuleCollection = null;

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public ProcessNodeWriteBackRuleCollection getProcessNodeWriteBackRuleCollection() {
        return this.processNodeWriteBackRuleCollection;
    }

    public ProcessReWriteSelectUI() throws Exception {
        logger.info((Object)"ProcessReWriteSelectUI init");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().containsKey("processNode")) {
            this.processNode = (ProcessNodeInfo)this.getUIContext().get("processNode");
        }
        if (this.processNode == null) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"108_ProcessReWriteSelectUI"));
        }
        if (this.getUIContext().containsKey("BizFlowNodeHelper")) {
            this.bizFlowNodeHelper = (BizFlowNodeHelper)this.getUIContext().get("BizFlowNodeHelper");
        }
        if (this.bizFlowNodeHelper == null || this.bizFlowNodeHelper.getAllNodeItem() == null || this.bizFlowNodeHelper.getAllNodeItem().length == 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"109_ProcessReWriteSelectUI"));
        }
        this.nodeList = this.bizFlowNodeHelper.getAllNodeItem();
        if (this.getUIContext().containsKey("oldWriteBackRule")) {
            this.oldRule = (ProcessNodeWriteBackRuleCollection)((Object)this.getUIContext().get("oldWriteBackRule"));
        }
        this.init();
    }

    private KDBizPromptBox getPrmtWriteBackRule() {
        KDBizPromptBox prmtWriteBackRule = BizFlowClientUtil.createNoNormalSimpleF7("com.kingdee.eas.scm.framework.bizflow.app.F7WriteBackRuleQuery", null);
        prmtWriteBackRule.setDisplayFormat("$name$");
        prmtWriteBackRule.setEditFormat("$number$");
        prmtWriteBackRule.setCommitFormat("$number$");
        prmtWriteBackRule.setEnabledMultiSelection(false);
        prmtWriteBackRule.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (oldValue == null && newValue == null) {
                    return;
                }
                if (oldValue != null && !oldValue.equals(newValue) || oldValue == null) {
                    int index = ProcessReWriteSelectUI.this.kDtable.getSelectManager().getActiveRowIndex();
                    ProcessNodeWriteBackRuleCollection rbc = null;
                    if (ProcessReWriteSelectUI.this.processNode != null) {
                        rbc = ProcessReWriteSelectUI.this.processNode.getEntryWriteBack();
                    }
                    if (rbc != null && rbc.size() > 0 && rbc.get(index) != null) {
                        rbc.get(index).setWriteBackRule((WriteBackRuleInfo)newValue);
                    }
                }
            }
        });
        return prmtWriteBackRule;
    }

    protected void init() throws BOSException {
        this.kDtable.checkParsed();
        ObjectValueRender avrWriteBackRule = new ObjectValueRender();
        avrWriteBackRule.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDtable.getColumn(WRITEBACKRULE).setRenderer((IBasicRender)avrWriteBackRule);
        KDComboBox actionComboBox = new KDComboBox();
        actionComboBox.addItem((Object)BizActionEnum.SUBMIT);
        actionComboBox.addItem((Object)BizActionEnum.AUDIT);
        actionComboBox.addItem((Object)BizActionEnum.UNAUDIT);
        actionComboBox.addItem((Object)BizActionEnum.ALTER);
        this.kDtable.getColumn(ACTION).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)actionComboBox));
        KDComboBox srcComboBox = new KDComboBox();
        srcComboBox.addItems(this.nodeList);
        this.kDtable.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                int row = e.getRowIndex();
                if (ProcessReWriteSelectUI.this.kDtable.getColumnIndex(ProcessReWriteSelectUI.SRCNODE) == col) {
                    Object obj = e.getValue();
                    if (obj == null) {
                        return;
                    }
                    Map bosTypeMap = ProcessReWriteSelectUI.this.bizFlowNodeHelper.getAllNodesBOSType();
                    Map nameMap = ProcessReWriteSelectUI.this.bizFlowNodeHelper.getAllNodesName();
                    Map idMap = ProcessReWriteSelectUI.this.bizFlowNodeHelper.getAllNodesID();
                    String sub = "";
                    if (obj instanceof String) {
                        int end = obj.toString().indexOf("-");
                        sub = obj.toString().substring(0, end);
                        ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.SRCNODEALIAS).setValue(nameMap.get(Integer.valueOf(sub)));
                        ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.SRCNODEBOSTYPE).setValue((Object)bosTypeMap.get(Integer.valueOf(sub)).toString());
                        ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.SRCNODEID).setValue((Object)idMap.get(Integer.valueOf(sub)).toString());
                    }
                    if (ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.WRITEBACKRULE).getEditor() != null && ((KDTDefaultCellEditor)ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.WRITEBACKRULE).getEditor()).getComponent() != null) {
                        ((KDBizPromptBox)((KDTDefaultCellEditor)ProcessReWriteSelectUI.this.kDtable.getCell(row, ProcessReWriteSelectUI.WRITEBACKRULE).getEditor()).getComponent()).setEntityViewInfo(ProcessReWriteSelectUI.this.buildWriteBackEV(ProcessReWriteSelectUI.this.processNode.getNodeBillBosType(), bosTypeMap.get(Integer.valueOf(sub)).toString()));
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.kDtable.getColumn(SRCNODE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)srcComboBox));
        this.bindData2Com();
    }

    private void bindData2Com() throws BOSException {
        if (this.oldRule == null) {
            return;
        }
        for (int i = 0; i < this.oldRule.size(); ++i) {
            IRow row = this.addRowWriteBackRule();
            row.getCell(SRCNODE).setValue((Object)this.oldRule.get(i).getSrcNodeBillNumber());
            row.getCell(SRCNODEID).setValue((Object)this.oldRule.get(i).getSrcNodeID());
            row.getCell(SRCNODEALIAS).setValue((Object)this.oldRule.get(i).getSrcBillEntityAlias());
            row.getCell(SRCNODEBOSTYPE).setValue((Object)this.oldRule.get(i).getSrcBillBosType());
            row.getCell(DESTNODEALIAS).setValue((Object)this.oldRule.get(i).getDestBillEntityAlias());
            row.getCell(DESTNODEBOSTYPE).setValue((Object)this.oldRule.get(i).getDestBillBosType());
            row.getCell(ACTION).setValue((Object)this.oldRule.get(i).getAction());
            row.getCell(WRITEBACKRULE).setValue((Object)this.oldRule.get(i).getWriteBackRule());
        }
    }

    protected EntityViewInfo buildWriteBackEV(String destBosType, String srcBosType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (destBosType != null && !"".equals(destBosType.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("destBillBosType", (Object)destBosType, CompareType.EQUALS));
        }
        if (srcBosType != null && !"".equals(srcBosType.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("srcBillBosType", (Object)srcBosType, CompareType.EQUALS));
        }
        ev.setFilter(filter);
        return ev;
    }

    protected KDComboBox initPreNodeBillEditor(KDTable table) {
        KDComboBox f7Box = new KDComboBox();
        f7Box.removeAllItems();
        return f7Box;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.bindCom2Data();
        this.disposeUIWindow();
        this.confirm = true;
    }

    private void bindCom2Data() {
        if (this.kDtable.getRowCount() > 0) {
            this.processNodeWriteBackRuleCollection = new ProcessNodeWriteBackRuleCollection();
            for (int i = 0; i < this.kDtable.getRowCount(); ++i) {
                ProcessNodeWriteBackRuleInfo processNodeWriteBackRuleInfo = new ProcessNodeWriteBackRuleInfo();
                processNodeWriteBackRuleInfo.setSrcNodeID(this.kDtable.getCell(i, SRCNODEID).getValue().toString());
                processNodeWriteBackRuleInfo.setSrcBillEntityAlias(this.kDtable.getCell(i, SRCNODEALIAS).getValue().toString());
                processNodeWriteBackRuleInfo.setSrcBillBosType(this.kDtable.getCell(i, SRCNODEBOSTYPE).getValue().toString());
                processNodeWriteBackRuleInfo.setDestBillEntityAlias(this.processNode.getNodeBillName());
                processNodeWriteBackRuleInfo.setDestBillBosType(this.processNode.getNodeBillBosType());
                processNodeWriteBackRuleInfo.setAction((BizActionEnum)((Object)this.kDtable.getCell(i, ACTION).getValue()));
                processNodeWriteBackRuleInfo.setWriteBackRule((WriteBackRuleInfo)this.kDtable.getCell(i, WRITEBACKRULE).getValue());
                this.processNodeWriteBackRuleCollection.add(processNodeWriteBackRuleInfo);
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = true;
        this.disposeUIWindow();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addRowWriteBackRule();
    }

    private IRow addRowWriteBackRule() throws BOSException {
        int currentRowSize = this.kDtable.getRowCount();
        IRow row = this.kDtable.addRow(currentRowSize);
        this.setWriteBackRuleDefalutValue(currentRowSize);
        return row;
    }

    private void setWriteBackRuleDefalutValue(int selectRow) {
        KDBizPromptBox wbF7 = this.getPrmtWriteBackRule();
        this.kDtable.getRow(selectRow).getCell(WRITEBACKRULE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)wbF7));
        if (this.processNode == null) {
            return;
        }
        this.kDtable.getRow(selectRow).getCell(DESTNODEALIAS).setValue((Object)this.processNode.getNodeBillName());
        this.kDtable.getRow(selectRow).getCell(DESTNODEBOSTYPE).setValue((Object)this.processNode.getNodeBillBosType());
    }

    @Override
    public void actionInserLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        if (this.kDtable.getSelectManager().size() > 0) {
            int top = this.kDtable.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.kDtable) ? this.kDtable.addRow() : this.kDtable.addRow(top);
        } else {
            row = this.kDtable.addRow();
        }
        this.setWriteBackRuleDefalutValue(row.getRowIndex());
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kDtable);
        this.kDtable.getSelectManager().select(0, 0, 2);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }
}

