/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QuerySqlAccess;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.framework.condition.ConditionEngineFacadeFactory;
import com.kingdee.eas.scm.framework.condition.IConditionEngineFacade;
import com.kingdee.eas.scm.framework.condition.IProcedureTypeMapping;
import com.kingdee.eas.scm.framework.condition.ProDeterminationMappingInfo;
import com.kingdee.eas.scm.framework.condition.ProDeterminationMappingItemCollection;
import com.kingdee.eas.scm.framework.condition.ProDeterminationMappingItemInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemInfo;
import com.kingdee.eas.scm.framework.condition.model.ProConditionTableInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConditionUtil {
    public static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    public static Map<String, String> billEntryNameMap = new HashMap<String, String>();

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtil.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    public static List<ProConditionTableInfo> getConditionTableInfo(Context ctx, String sql) {
        ArrayList<ProConditionTableInfo> list = new ArrayList<ProConditionTableInfo>();
        try {
            IConditionEngineFacade iConditionEngineFacade = ctx == null ? ConditionEngineFacadeFactory.getRemoteInstance() : ConditionEngineFacadeFactory.getLocalInstance(ctx);
            IRowSet rs = iConditionEngineFacade.getProConditionTableData(sql);
            ProConditionTableInfo proConditionTableInfo = null;
            while (rs.next()) {
                proConditionTableInfo = new ProConditionTableInfo();
                proConditionTableInfo.setPtypeid(rs.getString("PTYPEID"));
                proConditionTableInfo.setPtypestatus(rs.getInt("PTYPESTATUS"));
                proConditionTableInfo.setPtypepriority(rs.getInt("PTYPEPRIORITY"));
                proConditionTableInfo.setPtypename(rs.getString("PTYPENAME_L2"));
                proConditionTableInfo.setPtypenumber(rs.getString("PTYPENUMBER"));
                proConditionTableInfo.setPtypesimplename(rs.getString("PTYPESIMPLENAME"));
                proConditionTableInfo.setPtypecuid(rs.getString("PTYPECUID"));
                proConditionTableInfo.setConditionid(rs.getString("CONDITIONID"));
                proConditionTableInfo.setConditionnumber(rs.getString("CONDITIONNUMBER"));
                proConditionTableInfo.setConditionfstatus(rs.getInt("CONDITIONFSTATUS"));
                proConditionTableInfo.setConditionname(rs.getString("CONDITIONNAME_L2"));
                proConditionTableInfo.setConditionsimplename(rs.getString("CONDITIONSIMPLENAME"));
                proConditionTableInfo.setConditioncuid(rs.getString("CONDITIONCUID"));
                proConditionTableInfo.setTablename(rs.getString("TABLENAME"));
                proConditionTableInfo.setTablealias(rs.getString("TABLEALIAS"));
                proConditionTableInfo.setConditiontype(rs.getInt("CONDITIONTYPE"));
                proConditionTableInfo.setSelectedid(rs.getString("SELECTEDID"));
                proConditionTableInfo.setSelectedseq(rs.getInt("SELECTEDSEQ"));
                proConditionTableInfo.setSelectedsysdef(rs.getInt("SELECTEDSYSDEF"));
                proConditionTableInfo.setMappingfromfield(rs.getString("FMAPPINGFROMFIELD"));
                proConditionTableInfo.setMappingfromfieldalias(rs.getString("FMAPPINGFROMFIELDALIAS"));
                proConditionTableInfo.setMappingtofield(rs.getString("FMAPPINGTOFIELD"));
                proConditionTableInfo.setMappingtofieldalias(rs.getString("FMAPPINGTOFIELDALIAS"));
                proConditionTableInfo.setFieldid(rs.getString("FIELDID"));
                proConditionTableInfo.setFieldname(rs.getString("FIELDNAME_L2"));
                proConditionTableInfo.setFieldnumber(rs.getString("FIELDNUMBER"));
                proConditionTableInfo.setFieldtype(rs.getInt("FIELDTYPE"));
                proConditionTableInfo.setFieldmeta(rs.getString("FIELDMETA"));
                proConditionTableInfo.setFieldprecision(rs.getInt("FIELDPRECISION"));
                proConditionTableInfo.setFieldfraction(rs.getInt("FIELDFRACTION"));
                proConditionTableInfo.setFieldseq(rs.getInt("FIELDSEQ"));
                proConditionTableInfo.setFieldsysdef(rs.getInt("FIELDSYSDEF"));
                proConditionTableInfo.setFieldiotype(rs.getInt("FIELDIOTYPE"));
                proConditionTableInfo.setRangematch(rs.getInt("FRANGEMATCH"));
                proConditionTableInfo.setDefaultf7query(rs.getString("FDEFAULTF7QUERY"));
                list.add(proConditionTableInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static final String query2TempView(Context ctx, String queryName) throws BOSException {
        MetaDataPK pk = MetaDataPK.create((String)queryName);
        QueryInfo queryInfo = MetaDataLoader.getQuery((Context)ctx, (IMetaDataPK)pk);
        QuerySqlAccess querySqlAccess = new QuerySqlAccess(ctx, queryInfo);
        return querySqlAccess.getSql();
    }

    public static String getResourceString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)key);
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static String getBillEntryPropertyName(String bosTypeID) {
        if (billEntryNameMap.containsKey(bosTypeID)) {
            return billEntryNameMap.get(bosTypeID);
        }
        EntityObjectInfo billEntity = null;
        billEntity = ConditionUtil.getEntityObjectInfo(bosTypeID);
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!ConditionUtil.isEntryProperty(billEntity, property)) continue;
            billEntryNameMap.put(bosTypeID, property.getName());
            return property.getName();
        }
        return entryPropertyName;
    }

    public static EntityObjectInfo getEntityObjectInfo(String bosTypeID) {
        return ConditionUtil.getEntityObjectInfo(null, bosTypeID);
    }

    public static boolean isDeterminContainsEntry(ProDeterminationMappingInfo info) {
        if (info == null) {
            return false;
        }
        String billBosType = info.getBillType();
        String entryPropertyName = ConditionUtil.getBillEntryPropertyName(billBosType);
        ProDeterminationMappingItemCollection items = info.getItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            ProDeterminationMappingItemInfo item = items.get(i);
            if (item.getFieldExpr().indexOf(entryPropertyName) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeterminContainsEntry(Context ctx, ProcedureDeterminationInfo info, String billType) {
        if (info == null) {
            return false;
        }
        String procedureTypeId = info.getProcedureType().getId().toString();
        ProcedureDeterminationItemCollection items = info.getItems();
        HashSet<String> set = new HashSet<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String fieldId = items.get(i).getConditionField().getId().toString();
            set.add(fieldId);
            map.put(fieldId, fieldId);
        }
        try {
            IProcedureTypeMapping iProcedure = ctx != null ? ProcedureTypeMappingFactory.getLocalInstance(ctx) : ProcedureTypeMappingFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("proceduretype.id", (Object)procedureTypeId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)billType, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("proceduretype.*"));
            sic.add(new SelectorItemInfo("items.*"));
            sic.add(new SelectorItemInfo("items.conditionField.*"));
            view.setSelector(sic);
            ProcedureTypeMappingCollection col = iProcedure.getProcedureTypeMappingCollection(view);
            if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                return false;
            }
            ProcedureTypeMappingInfo mapping = col.get(0);
            String entryPropertyName = ConditionUtil.getBillEntryPropertyName(billType);
            ProcedureTypeMappingItemCollection mappingItems = mapping.getItems();
            int size2 = mappingItems.size();
            for (int i = 0; i < size2; ++i) {
                ProcedureTypeMappingItemInfo mappingItem = mappingItems.get(i);
                String fieldId = mappingItem.getConditionField().getId().toString();
                if (!map.containsKey(fieldId) || mappingItem.getFieldExpr().indexOf(entryPropertyName) < 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static List cartesianProduct(List inputList) {
        ArrayList outputList = (ArrayList)inputList.get(0);
        for (int i = 1; i < inputList.size(); ++i) {
            List addList = (List)inputList.get(i);
            ArrayList temp = new ArrayList();
            for (int j = 0; j < outputList.size(); ++j) {
                for (int k = 0; k < addList.size(); ++k) {
                    ArrayList cut = new ArrayList();
                    if (outputList.get(j) instanceof List) {
                        cut.addAll((List)outputList.get(j));
                    } else {
                        cut.add(outputList.get(j));
                    }
                    if (addList.get(k) instanceof List) {
                        cut.addAll((List)addList.get(k));
                    } else {
                        cut.add(addList.get(k));
                    }
                    temp.add(cut);
                }
            }
            outputList = temp;
        }
        return outputList;
    }
}

