/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.alter.client.ShowEntityUIUtil;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.framework.client.SelectEntityUI;
import com.kingdee.eas.scm.framework.client.TreeNodeTypeEnum;
import com.kingdee.eas.scm.framework.log.LogConfigEntryCollection;
import com.kingdee.eas.scm.framework.log.LogConfigEntryInfo;
import com.kingdee.eas.scm.framework.log.LogConfigFactory;
import com.kingdee.eas.scm.framework.log.LogConfigInfo;
import com.kingdee.eas.scm.framework.log.client.AbstractLogConfigEditUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogConfigEditUI
extends AbstractLogConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LogConfigEditUI.class);
    public static final String BillTYPE_QUERY = "com.kingdee.eas.basedata.scm.common.app.BillTypeQuery";
    private String RESOURCE = "com.kingdee.eas.scm.framework.log.SCMLogResource";
    public static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    public static final String COL_BILLTYPE = "billType";
    public static final String COL_FIELDNAME = "filedName";
    public static final String COL_FIELD = "filed";
    public static final String COL_ISSYSTEM = "isSystem";
    public static final String COL_BOSTYPE = "bosType";
    private ItemListener logTypeListener = null;
    private KDTEditAdapter entryTableChange = null;

    public LogConfigEditUI() throws Exception {
        this.kDTable.checkParsed();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        LogConfigInfo logConfigInfo = (LogConfigInfo)newData;
        logConfigInfo.setStatus(UseStatusEnum.ADDNEW);
        logConfigInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        logConfigInfo.setNumber(null);
        logConfigInfo.setName(null);
        LogConfigEntryCollection coll = logConfigInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            LogConfigEntryInfo entryInfo = coll.get(i);
            entryInfo.setIsSystem(false);
        }
    }

    protected IObjectValue createNewData() {
        LogConfigInfo info = new LogConfigInfo();
        LogConfigEntryInfo entryInfo = this.createNewDetailData();
        info.getEntry().add(entryInfo);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setStatus(UseStatusEnum.ADDNEW);
        return info;
    }

    protected KDTable getDetailTable() {
        return this.kDTable;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCU;
    }

    @Override
    public void loadFields() {
        this.removeControlListener();
        if (this.getOprtState().equals("ADDNEW")) {
            this.kDTable.addRow();
        }
        super.loadFields();
        this.setField();
        this.isSystemEnableSet();
        this.addControlListener();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected void initDataStatus() {
        if ("EDIT".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.actionCopy.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.setButtonEnabled(true);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionCopy.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.setButtonEnabled(false);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.setButtonEnabled(true);
        }
    }

    private void setButtonEnabled(boolean isEnable) {
        this.actionAddLine.setEnabled(isEnable);
        this.actionInsertLine.setEnabled(isEnable);
        this.actionRemoveLine.setEnabled(isEnable);
    }

    private void removeControlListener() {
        if (this.logTypeListener != null) {
            this.comboLogType.removeItemListener(this.logTypeListener);
        }
        if (this.entryTableChange != null) {
            this.kDTable.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    private void addControlListener() {
        this.logTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    LogConfigEditUI.this.logTypeItemChanged();
                }
                catch (Exception e) {
                    LogConfigEditUI.this.handUIException(e);
                }
            }
        };
        this.entryTableChange = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    LogConfigEditUI.this.kdtEntrys_editStarting(e);
                }
                catch (Exception exc) {
                    LogConfigEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                LogConfigEditUI.this.kdtEntrys_editStopped(e);
            }
        };
        this.comboLogType.addItemListener(this.logTypeListener);
        this.kDTable.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void kdtEntrys_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        Boolean isSystem = (Boolean)this.kDTable.getRow(rowIndex).getCell(COL_ISSYSTEM).getValue();
        if (isSystem.booleanValue()) {
            e.setCancel(true);
        }
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        String colName = this.kDTable.getColumnKey(e.getColIndex());
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        if (COL_BILLTYPE.equals(colName)) {
            this.kDTable.getRow(rowIndex).getCell(COL_FIELDNAME).setValue(null);
        }
    }

    private void logTypeItemChanged() {
        this.setField();
    }

    private void setField() {
        int index = this.comboLogType.getSelectedIndex();
        if (index == 0) {
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                this.kDTable.getRow(i).getCell(COL_FIELDNAME).setValue(null);
            }
            this.kDTable.getColumn(COL_FIELDNAME).getStyleAttributes().setHided(true);
        } else {
            this.kDTable.getColumn(COL_FIELDNAME).getStyleAttributes().setHided(false);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        LogConfigEntryInfo detailData = this.createNewDetailData();
        if (detailData != null) {
            IRow row = this.kDTable.addRow();
            this.dataBinder.loadLineFields(this.kDTable, row, (IObjectValue)detailData);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        LogConfigEntryInfo detailData = this.createNewDetailData();
        if (this.kDTable.getSelectManager().size() > 0) {
            int rowIndex = this.kDTable.getSelectManager().get().getTop();
            IRow row = this.kDTable.addRow(rowIndex);
            this.dataBinder.loadLineFields(this.kDTable, row, (IObjectValue)detailData);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        Boolean isSystem = false;
        if (this.kDTable.getSelectManager().size() > 0) {
            ArrayList blocks = this.kDTable.getSelectManager().getBlocks();
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            int size = blocks.size();
            block0: for (int i = 0; i < size; ++i) {
                int begin = ((KDTSelectBlock)blocks.get(i)).getTop();
                int end = ((KDTSelectBlock)blocks.get(i)).getBottom();
                for (int j = begin; j <= end; ++j) {
                    isSystem = (Boolean)this.kDTable.getRow(j).getCell(COL_ISSYSTEM).getValue();
                    if (isSystem.booleanValue()) break block0;
                    removeList.add(j);
                }
            }
            if (isSystem.booleanValue()) {
                MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE, (String)"deleteLine_Not"));
                SysUtil.abort();
            }
            Object[] indexArr = removeList.toArray(new Integer[0]);
            Arrays.sort(indexArr);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                this.kDTable.removeRow(((Integer)indexArr[i]).intValue());
            }
        }
    }

    protected LogConfigEntryInfo createNewDetailData() {
        LogConfigEntryInfo logConfigEntryInfo = new LogConfigEntryInfo();
        logConfigEntryInfo.setIsSystem(false);
        return logConfigEntryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LogConfigFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPrmtEnabled();
        this.setBillTypeF7();
        this.setFileldF7();
        this.setLogType();
    }

    private void setLogType() {
        this.comboLogType.removeItemAt(2);
    }

    public void setFileldF7() {
        final KDBizPromptBox prmtFileldF7 = new KDBizPromptBox();
        prmtFileldF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int rowIndex = LogConfigEditUI.this.kDTable.getSelectManager().getActiveRowIndex();
                String bostype = null;
                if (rowIndex >= 0) {
                    bostype = (String)LogConfigEditUI.this.kDTable.getRow(rowIndex).getCell(LogConfigEditUI.COL_BOSTYPE).getValue();
                    if (bostype == null) {
                        MsgBox.showWarning((String)EASResource.getString((String)LogConfigEditUI.this.RESOURCE, (String)"billType_NotNull"));
                        return;
                    }
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put("Owner", this);
                    uiContext.put("entity", LogConfigEditUI.this.getEntityObjectInfo(bostype));
                    uiContext.put("selectBizType", EntitySelectorType.Property);
                    uiContext.put("TREENODETYPE", TreeNodeTypeEnum.normal);
                    IUIWindow uiWindow = null;
                    try {
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
                    }
                    catch (UIException e1) {
                        LogConfigEditUI.this.handleException((Exception)((Object)e1));
                    }
                    SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
                    uiWindow.show();
                    if (!ui.isCanceled()) {
                        PropertyInfo property = (PropertyInfo)ui.getReturnObject();
                        prmtFileldF7.setUserObject((Object)((String)property.get("fullName")));
                        prmtFileldF7.setValue((Object)((String)property.get("fullName")));
                        prmtFileldF7.setText((String)property.get("fullAlias"));
                        LogConfigEditUI.this.kDTable.getRow(rowIndex).getCell(LogConfigEditUI.COL_FIELD).setValue((Object)((String)property.get("fullName")));
                    }
                }
            }
        });
        this.kDTable.getColumn(COL_FIELDNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtFileldF7));
    }

    public void setBillTypeF7() {
        KDBizPromptBox prmtbillTypeF7 = new KDBizPromptBox();
        prmtbillTypeF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    int rowIndex = LogConfigEditUI.this.kDTable.getSelectManager().getActiveRowIndex();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"Owner", (Object)this);
                    EntityObjectInfo selectEntity = null;
                    try {
                        selectEntity = ShowEntityUIUtil.showEntityUIAndGetResult(uiContext);
                    }
                    catch (UIException e1) {
                        LogConfigEditUI.this.handleException((Exception)((Object)e1));
                    }
                    KDBizPromptBox source = (KDBizPromptBox)e.getSource();
                    if (selectEntity != null) {
                        source.setUserObject((Object)selectEntity);
                        source.setText(selectEntity.getAlias());
                        LogConfigEditUI.this.kDTable.getRow(rowIndex).getCell(LogConfigEditUI.COL_BOSTYPE).setValue((Object)selectEntity.getType().toString());
                    }
                }
                catch (Exception e1) {
                    LogConfigEditUI.this.handleException(e1);
                }
            }
        });
        this.kDTable.getColumn(COL_BILLTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtbillTypeF7));
    }

    public EntityObjectInfo getEntityObjectInfo(String bosTypeID) {
        return this.getEntityObjectInfo(null, bosTypeID);
    }

    public EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtil.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    private void setPrmtEnabled() {
        this.prmtCU.setEnabled(false);
        this.comboStatus.setEnabled(false);
    }

    private void isSystemEnableSet() {
        if (this.isSystem().booleanValue()) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.comboLogType.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
            this.txtName.setEnabled(true);
            this.comboLogType.setEnabled(true);
        }
    }

    private Boolean isSystem() {
        Boolean ISSYSTEM = false;
        for (int i = 0; i < this.kDTable.getRowCount() && !(ISSYSTEM = (Boolean)this.kDTable.getRow(i).getCell(COL_ISSYSTEM).getValue()).booleanValue(); ++i) {
        }
        return ISSYSTEM;
    }
}

