/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrCollection;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrFactory;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionSubTabCollection;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionSubTabInfo;
import com.kingdee.eas.scm.framework.solutionmgr.IExportSolutionMgr;
import com.kingdee.eas.scm.framework.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.scm.framework.solutionmgr.client.AbstractExportSolutionToolsUI;
import com.kingdee.eas.scm.framework.solutionmgr.client.SolutionMgrFilterPanel;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ExportSolutionToolsUI
extends AbstractExportSolutionToolsUI {
    private static final long serialVersionUID = 1L;
    SolutionMgrFilterPanel filterPanel = null;
    ExportSolutionMgrCollection expConn = null;
    Map<String, SolutionMgrFilterPanel> filterPanelMap = new HashMap<String, SolutionMgrFilterPanel>();
    private DataChangeListener bizPrmtBoxNumberDataChanged = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            try {
                ExportSolutionToolsUI.this.bizPrmtBoxNumber_dataChanged(e);
            }
            catch (Exception exc) {
                ExportSolutionToolsUI.this.handUIException(exc);
            }
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        String expSolutionNumber = (String)this.getUIContext().get("solutionNumber");
        String strWhere = (String)this.getUIContext().get("solutionStrWhere");
        if (!StringUtil.isEmpty((String)expSolutionNumber)) {
            this.expConn = this.getExpSolutionConnByNumber(expSolutionNumber);
            this.initUI(this.expConn, strWhere);
            this.bizPrmtBoxNumber.setEnabled(false);
        } else {
            List selectedIdList = (List)this.getUIContext().get("solutionIds");
            if (selectedIdList.size() > 0) {
                this.expConn = this.getExpSolutionConnByIds(selectedIdList);
                this.initUI(this.expConn, null);
            }
        }
    }

    private void initUI(ExportSolutionMgrCollection expConn, String strWhere) throws Exception {
        this.bizPrmtBoxNumber.setDisplayFormat("$number$");
        this.bizPrmtBoxNumber.setEditFormat("$number$");
        if (this.bizPrmtBoxNumberDataChanged != null) {
            this.bizPrmtBoxNumber.removeDataChangeListener(this.bizPrmtBoxNumberDataChanged);
        }
        Object[] expSolutionData = new Object[expConn.size()];
        ExportSolutionMgrInfo expSolutionInfo = null;
        StringBuffer solutionInfos = new StringBuffer();
        String expTableStr = null;
        this.kDTabbedPane1.removeAll();
        for (int i = 0; i < expConn.size(); ++i) {
            expSolutionInfo = expConn.get(i);
            solutionInfos.append(expSolutionInfo.getNumber()).append("(");
            solutionInfos.append(expSolutionInfo.getName()).append("):").append(" \r\n");
            expTableStr = this.getExpTableStr(expSolutionInfo);
            solutionInfos.append(expTableStr);
            solutionInfos.append(" \r\n ");
            this.addFilterPanel(expSolutionInfo, strWhere);
            expSolutionData[i] = expSolutionInfo;
        }
        this.bizPrmtBoxNumber.setValue((Object)expSolutionData);
        this.txtTableStr.setText(solutionInfos.toString());
        this.bizPrmtBoxNumber.addDataChangeListener(this.bizPrmtBoxNumberDataChanged);
    }

    private void addFilterPanel(ExportSolutionMgrInfo expSolutionInfo, String strWhere) {
        SolutionMgrFilterPanel tempFilterPanel = null;
        FilterInfo filterInfo = null;
        try {
            String mainTable = expSolutionInfo.getMainTable();
            String defualtCont = expSolutionInfo.getDefaultCondition();
            if (!StringUtil.isEmpty((String)mainTable) && !StringUtil.isEmpty((String)defualtCont)) {
                defualtCont = defualtCont.replaceAll(mainTable + ".", "");
            }
            if (!StringUtil.isEmpty((String)strWhere)) {
                defualtCont = !StringUtil.isEmpty((String)defualtCont) ? defualtCont + " and " + strWhere : strWhere;
            }
            if (!StringUtil.isEmpty((String)defualtCont)) {
                filterInfo = new FilterInfo(defualtCont);
            }
            tempFilterPanel = new SolutionMgrFilterPanel(filterInfo, mainTable, 555, 230, 10);
            String panelName = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"4_ExportSolutionToolsUI", (String[])new String[]{expSolutionInfo.getNumber()});
            tempFilterPanel.setPanelName(panelName);
            this.filterPanelMap.put(expSolutionInfo.getNumber(), tempFilterPanel);
            this.kDTabbedPane1.add((Component)((Object)tempFilterPanel), (Object)panelName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private String getExpTableStr(ExportSolutionMgrInfo expSolutionInfo) {
        StringBuffer tableBuf = new StringBuffer();
        tableBuf.append(EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"5_ExportSolutionToolsUI"));
        tableBuf.append(expSolutionInfo.getMainTable()).append(" \r\n");
        ExportSolutionSubTabCollection subTableConn = expSolutionInfo.getSolutionSubTab();
        ExportSolutionSubTabInfo subTableInfo = null;
        if (subTableConn.size() > 0) {
            tableBuf.append(EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"6_ExportSolutionToolsUI"));
        }
        for (int i = 0; i < subTableConn.size(); ++i) {
            subTableInfo = subTableConn.get(i);
            if (i > 0) {
                tableBuf.append(",");
            }
            tableBuf.append(subTableInfo.getSubTable());
        }
        return tableBuf.toString();
    }

    private ExportSolutionMgrCollection getExpSolutionConnByEntityView(EntityViewInfo entityView) throws BOSException, EASBizException {
        IExportSolutionMgr iExpSolutionMgr = ExportSolutionMgrFactory.getRemoteInstance();
        SelectorItemCollection sic = this.getExpSolutionSelectors();
        entityView.setSelector(sic);
        entityView.getSorter().add(new SorterItemInfo("solutionSubTab.seq"));
        return iExpSolutionMgr.getExportSolutionMgrCollection(entityView);
    }

    private ExportSolutionMgrCollection getExpSolutionConnByIds(List ids) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        for (int i = 0; i < ids.size(); ++i) {
            idSet.add(ids.get(i));
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entityView.setFilter(fi);
        return this.getExpSolutionConnByEntityView(entityView);
    }

    private ExportSolutionMgrCollection getExpSolutionConnByNumber(String strNumber) throws BOSException, EASBizException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)strNumber, CompareType.EQUALS));
        entityView.setFilter(fi);
        return this.getExpSolutionConnByEntityView(entityView);
    }

    private SelectorItemCollection getExpSolutionSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("mainTable"));
        sic.add(new SelectorItemInfo("defaultCondition"));
        sic.add(new SelectorItemInfo("solutionSubTab.seq"));
        sic.add(new SelectorItemInfo("solutionSubTab.subTable"));
        sic.add(new SelectorItemInfo("solutionSubTab.associalTable"));
        sic.add(new SelectorItemInfo("solutionSubTab.joinType"));
        sic.add(new SelectorItemInfo("solutionSubTab.relationStr"));
        return sic;
    }

    protected void bizPrmtBoxNumber_dataChanged(DataChangeEvent e) throws Exception {
        Object[] f7Info = (Object[])this.bizPrmtBoxNumber.getData();
        if (f7Info != null) {
            this.expConn = new ExportSolutionMgrCollection();
            for (int i = 0; i < f7Info.length; ++i) {
                this.expConn.add((ExportSolutionMgrInfo)f7Info[i]);
            }
            this.initUI(this.expConn, null);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnComfirm.setEnabled(true);
        this.kDWorkButton1.setEnabled(true);
        this.btnClose.setEnabled(true);
    }

    @Override
    public void actionExpSolutionData_actionPerformed(ActionEvent e) throws Exception {
        String strWhere = null;
        if (this.checkExportCondition()) {
            HashMap<String, String> conditionMap = new HashMap<String, String>(this.filterPanelMap.size());
            SolutionMgrFilterPanel filterPanel = null;
            String solutionMgrNumber = null;
            for (int i = 0; i < this.expConn.size(); ++i) {
                solutionMgrNumber = this.expConn.get(i).getNumber();
                filterPanel = this.filterPanelMap.get(solutionMgrNumber);
                if (!StringUtil.isEmpty((String)filterPanel.getFilterInfo().toString())) {
                    strWhere = " where " + filterPanel.getFilterInfo().toString();
                }
                conditionMap.put(solutionMgrNumber, strWhere);
            }
            List listOS = SolutionMgrFacadeFactory.getRemoteInstance().exportData(this.expConn, conditionMap);
            SolutionMgrUtil.writeExpFile(listOS, this.txtFilePath.getText());
            String tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"export_ok");
            MsgBox.showInfo((Component)((Object)this), (String)tipInfo);
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    public void actionOpenFile_actionPerformed(ActionEvent e) throws Exception {
        String path = System.getProperty("user.home");
        boolean isEncypt = SolutionMgrFacadeFactory.getRemoteInstance().checkIfEncrypt();
        MyFileChooser choose = new MyFileChooser(path, isEncypt);
        choose.setFileSelectionMode(0);
        choose.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter ff1 = new SimpleFileFilter("dat", EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"7_ExportSolutionToolsUI"));
        if (!isEncypt) {
            ff1 = new SimpleFileFilter("ksql", EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"ksql_file"));
        }
        choose.setFileFilter((FileFilter)ff1);
        int returnValue = choose.showSaveDialog((Component)((Object)this));
        if (returnValue == 0) {
            String extension = ((SimpleFileFilter)choose.getFileFilter()).getExtension(choose.getSelectedFile());
            if (StringUtil.isEmpty((String)extension)) {
                extension = this.getExtensionName(choose.getFileFilter().getDescription());
                this.txtFilePath.setText(choose.getSelectedFile().getPath() + extension);
            } else {
                this.txtFilePath.setText(choose.getSelectedFile().getPath());
            }
        }
    }

    private String getExtensionName(String description) {
        int index;
        String extensionName = ".dat";
        if (!StringUtil.isEmpty((String)description) && (index = description.indexOf("(")) != -1) {
            extensionName = description.substring(index + 1, description.length() - 1);
        }
        return extensionName;
    }

    private boolean checkExportCondition() {
        String tipInfo = null;
        if (this.bizPrmtBoxNumber.getValue() == null) {
            tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"choose_export_solution");
            MsgBox.showInfo((String)tipInfo);
            return false;
        }
        if (StringUtil.isEmpty((String)this.txtFilePath.getText())) {
            tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"choose_file_path");
            MsgBox.showInfo((String)tipInfo);
            return false;
        }
        if (this.filterPanelMap.size() > 0) {
            Set<Map.Entry<String, SolutionMgrFilterPanel>> filterPanelSet = this.filterPanelMap.entrySet();
            SolutionMgrFilterPanel tempFilterPanel = null;
            Iterator<Map.Entry<String, SolutionMgrFilterPanel>> it = filterPanelSet.iterator();
            while (it.hasNext()) {
                tempFilterPanel = it.next().getValue();
                if (tempFilterPanel == null || tempFilterPanel.verify()) continue;
                return false;
            }
        }
        return true;
    }

    private class MyFileChooser
    extends KDFileChooser {
        private static final long serialVersionUID = -3522543562966428046L;
        private boolean isEncrypt;

        public MyFileChooser(String path, boolean isEncrypt) {
            super(path);
            this.isEncrypt = isEncrypt;
        }

        public void approveSelection() {
            File file = this.getSelectedFile();
            SimpleFileFilter filter = (SimpleFileFilter)this.getFileFilter();
            String extension = filter.getExtension(file);
            if (!(extension == null || this.isEncrypt && extension.equals("dat") || !this.isEncrypt && extension.equals("ksql"))) {
                String tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"file_ext_error");
                MsgBox.showInfo((String)tipInfo);
            } else {
                super.approveSelection();
            }
        }
    }
}

