/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.scm.framework.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.scm.framework.solutionmgr.client.AbstractImportSolutionToolsUI;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class ImportSolutionToolsUI
extends AbstractImportSolutionToolsUI {
    private static final long serialVersionUID = 1L;
    private String schemaNumber;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnImport.setEnabled(true);
        this.btnSelectFile.setEnabled(true);
        this.btnClose.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.schemaNumber = (String)this.getUIContext().get("--SchemaNumber:");
    }

    @Override
    public void actionImpSolutionData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImpSolutionData_actionPerformed(e);
        String tipInfo = null;
        if (StringUtil.isEmpty((String)this.txtFilePath.getText())) {
            tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"choose_import_file");
            MsgBox.showInfo((String)tipInfo);
            return;
        }
        List<byte[]> listOS = SolutionMgrUtil.outFileToByteList(this.txtFilePath.getText());
        try {
            SolutionMgrFacadeFactory.getRemoteInstance().importData(this.schemaNumber, listOS, this.kDComBoxImpType.getSelectedIndex());
        }
        catch (BOSException e1) {
            MsgBox.showError((String)e1.getMessage());
            return;
        }
        tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"import_ok");
        MsgBox.showInfo((String)tipInfo);
        super.disposeUIWindow();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        super.disposeUIWindow();
    }

    @Override
    public void actionOpenFile_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpenFile_actionPerformed(e);
        try {
            String path = System.getProperty("user.home");
            MyFileChooser choose = new MyFileChooser(path);
            choose.setFileSelectionMode(0);
            choose.setAcceptAllFileFilterUsed(false);
            SimpleFileFilter ff1 = new SimpleFileFilter("dat", EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"11_ImportSolutionToolsUI"));
            choose.setFileFilter((FileFilter)ff1);
            int returnValue = choose.showOpenDialog((Component)((Object)this));
            if (returnValue == 0) {
                this.txtFilePath.setText(choose.getSelectedFile().getPath());
            }
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
        }
    }

    private class MyFileChooser
    extends KDFileChooser {
        private static final long serialVersionUID = -3522543562966428046L;

        public MyFileChooser(String path) {
            super(path);
        }

        public void approveSelection() {
            File file = this.getSelectedFile();
            if (!file.exists()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"12_ImportSolutionToolsUI"));
                return;
            }
            SimpleFileFilter filter = (SimpleFileFilter)this.getFileFilter();
            String extension = filter.getExtension(file);
            if (extension != null && !extension.equals("dat")) {
                String tipInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)"file_ext_error");
                MsgBox.showInfo((String)tipInfo);
            } else {
                super.approveSelection();
            }
        }
    }
}

