/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.framework.model.JoinCondition;
import com.kingdee.eas.scm.framework.model.JoinConditionCollection;
import com.kingdee.eas.scm.framework.solutionmgr.JoinTypeEnum;
import com.kingdee.eas.scm.framework.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.scm.framework.solutionmgr.client.AbstractRelationEditUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RelationEditUI
extends AbstractRelationEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(RelationEditUI.class);
    public static String RELATION_INFO = "relationInfo";
    private String relationStr = null;
    private Map<String, String> subTableInfo = null;
    private static final int COL_SUBTABLE_IDX = 0;
    private static final int COL_COMPARESIGN_IDX = 1;
    private static final int COL_MAINTABLE_IDX = 2;
    private static final int COL_LOGIC_IDX = 3;
    private static final String DOT = ".";
    private static final String COMPARE_SIGN = "=";
    private int defaultRows = 10;
    private KDComboBox cmbsubTableField;
    private KDComboBox cmbMainTableField;
    private static final String[] LOGIC_SIGN = new String[]{"AND", "OR"};
    private String join_type = null;
    private JoinConditionCollection conditionColl = null;
    private boolean isConfirm = false;

    public String getRelationStr() {
        return this.relationStr;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.subTableInfo = (Map)this.getUIContext().get(RELATION_INFO);
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.txtMainTable.setText(this.subTableInfo.get("associalTable"));
        this.txtSubTable.setText(this.subTableInfo.get("subTable"));
        this.initJoinType();
        this.initJoinCoditionTable();
    }

    private void initJoinType() {
        this.join_type = this.subTableInfo.get("joinType");
        if (this.join_type.equals(JoinTypeEnum.LEFT_JOIN.getName())) {
            this.cmbRelationType.setSelectedItem((Object)JoinTypeEnum.LEFT_JOIN);
        } else if (this.join_type.equals(JoinTypeEnum.RIGHT_JOIN.getName())) {
            this.cmbRelationType.setSelectedItem((Object)JoinTypeEnum.RIGHT_JOIN);
        } else {
            this.cmbRelationType.setSelectedItem((Object)JoinTypeEnum.Inner_JOIN);
        }
    }

    private void initJoinCoditionTable() {
        this.tblJoinCondition.checkParsed();
        Object[] subTablefields = null;
        Object[] mainTablefields = null;
        this.cmbsubTableField = new KDComboBox();
        this.cmbsubTableField.addItem((Object)"");
        if (!StringUtil.isEmpty((String)this.txtSubTable.getText())) {
            try {
                subTablefields = SolutionMgrFacadeFactory.getRemoteInstance().getColunmsByTable(this.txtSubTable.getText());
            }
            catch (BOSException e) {
                logger.info((Object)e.getMessage());
            }
            this.cmbsubTableField.addItems(subTablefields);
        }
        this.tblJoinCondition.getColumn("subTableField").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbsubTableField));
        this.cmbMainTableField = new KDComboBox();
        if (!StringUtil.isEmpty((String)this.txtMainTable.getText())) {
            try {
                mainTablefields = SolutionMgrFacadeFactory.getRemoteInstance().getColunmsByTable(this.txtMainTable.getText());
            }
            catch (BOSException e) {
                logger.info((Object)e.getMessage());
            }
            this.cmbMainTableField.addItems(mainTablefields);
        }
        this.tblJoinCondition.getColumn("mainTableField").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbMainTableField));
        KDComboBox cmbLogicSign = this.getFieldComboBoxField(LOGIC_SIGN);
        this.tblJoinCondition.getColumn("logicSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLogicSign));
        this.initJoinCondition(this.cmbsubTableField, this.cmbMainTableField, cmbLogicSign);
        this.fillLeftRows();
        this.tblJoinCondition.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                RelationEditUI.this.editedCellAfter(e);
            }
        });
    }

    private void initJoinCondition(KDComboBox subTablecomboBox, KDComboBox mainTabComboBox, KDComboBox logicSignComboBox) {
        String tempStr = this.subTableInfo.get("relationStr");
        if (!StringUtil.isEmpty((String)tempStr)) {
            this.conditionColl = new JoinConditionCollection(tempStr);
        }
        if (this.conditionColl != null) {
            JoinCondition condition = null;
            for (int i = 0; i < this.conditionColl.getConditionCount(); ++i) {
                condition = this.conditionColl.getJoinConditionAt(i);
                IRow row = this.addRow();
                this.setFieldComboBoxField(this.tblJoinCondition, subTablecomboBox, row.getRowIndex(), 0, condition.getChildField().getFieldName());
                row.getCell(1).setValue((Object)COMPARE_SIGN);
                this.setFieldComboBoxField(this.tblJoinCondition, mainTabComboBox, row.getRowIndex(), 2, condition.getParentField().getFieldName());
                this.setFieldComboBoxField(this.tblJoinCondition, logicSignComboBox, row.getRowIndex(), 3, condition.getLogicSign());
                row.setUserObject((Object)condition);
            }
        }
    }

    private void setFieldComboBoxField(KDTable table, KDComboBox comboBox, int rowIndex, int colIndex, String fieldValue) {
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            if (!obj.toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)fieldValue);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void editedCellAfter(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.tblJoinCondition.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null || StringUtil.isEmpty((String)object.toString())) {
            if (colIndex == 0) {
                this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(2).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(3).setValue(null);
            }
            return;
        }
        if (colIndex == 0) {
            this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue((Object)COMPARE_SIGN);
        }
    }

    private KDComboBox getFieldComboBoxField(Object[] valueArray) {
        KDComboBox kdComboBox = new KDComboBox(valueArray);
        kdComboBox.insertItemAt((Object)"", 0);
        return kdComboBox;
    }

    private void fillLeftRows() {
        int rowCount = this.tblJoinCondition.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.addRow();
            }
        }
    }

    private IRow addRow() {
        int currentRowSize = this.tblJoinCondition.getRowCount();
        return this.tblJoinCondition.addRow(currentRowSize);
    }

    @Override
    public void storeFields() {
        this.beforeStorFields();
        this.storeJoinCondition();
    }

    private void beforeStorFields() {
        if (this.isRelationTableEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"13_RelationEditUI"));
            SysUtil.abort();
        }
    }

    private void storeJoinCondition() {
        IRow row = null;
        boolean isFirst = true;
        String logicSign = "";
        StringBuffer joinString = new StringBuffer();
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(0).getValue() == null || StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) continue;
            if (!isFirst) {
                joinString.append(" ").append(StringUtil.isEmpty((String)logicSign) ? LOGIC_SIGN[0] : logicSign).append(" ");
            }
            joinString.append(this.txtSubTable.getText()).append(DOT).append(row.getCell(0).getValue());
            joinString.append(row.getCell(1).getValue());
            joinString.append(this.txtMainTable.getText()).append(DOT).append(row.getCell(2).getValue());
            logicSign = (String)row.getCell(3).getValue();
            isFirst = false;
        }
        this.relationStr = joinString.toString();
    }

    private boolean isRelationTableEmpty() {
        IRow row = null;
        boolean result = true;
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(0).getValue() != null && !StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) {
                if (row.getCell(2).getValue() == null || StringUtil.isEmpty((String)row.getCell(2).getValue().toString())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"14_RelationEditUI"));
                    SysUtil.abort();
                }
                result = false;
            }
            if (row.getCell(2).getValue() == null || StringUtil.isEmpty((String)row.getCell(2).getValue().toString())) continue;
            if (row.getCell(0).getValue() == null || StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"14_RelationEditUI"));
                SysUtil.abort();
            }
            result = false;
        }
        return result;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.storeFields();
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isConfirm = false;
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

