/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.ws.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CommonInfoUtil {
    public static final String RESOURCE = "com.kingdee.eas.scm.im.inv.ws.WebserviceResource";
    static final Logger logger = Logger.getLogger(CommonInfoUtil.class);

    public static ICoreBase getRemoteInstance(String bosType) {
        ICoreBase iCoreBase = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo eo = loader.getEntity(new BOSObjectType(bosType));
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getRemoteInstance", new Class[0]);
            iCoreBase = (ICoreBase)mtd.invoke(cls, (Object[])new Class[0]);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return iCoreBase;
    }

    public static ICoreBase getLocalInstance(String bosType, Context ctx) {
        ICoreBase iCoreBase = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(new BOSObjectType(bosType));
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return iCoreBase;
    }

    public static ICoreBase getLocalInstance(Context ctx, EntityObjectInfo eo) {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return iCoreBase;
    }

    public static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, CoreBaseInfo info, String linkProperty, String number, String cuId) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(info.getBOSType());
        LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)eo.getPropertyByName(linkProperty);
        EntityObjectInfo superEntityObjectInfo = null;
        ICoreBase iLinkCoreBase = null;
        CoreBaseInfo linkInfo = null;
        if (linkPropertyInfo != null && number != null) {
            superEntityObjectInfo = linkPropertyInfo.getRelationship().getSupplierObject();
            iLinkCoreBase = CommonInfoUtil.getLocalInstance(ctx, superEntityObjectInfo);
            linkInfo = cuId != null && cuId.trim().length() > 0 ? CommonInfoUtil.getCoreBaseInfo(iLinkCoreBase, number, cuId) : CommonInfoUtil.getCoreBaseInfo(iLinkCoreBase, number);
        }
        return linkInfo;
    }

    public static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, CoreBaseInfo info, String linkProperty, String number) throws BOSException {
        return CommonInfoUtil.getLinkPropCoreBaseInfo(ctx, info, linkProperty, number, null);
    }

    public static CoreBaseInfo getCoreBaseInfo(Context ctx, String bosType, BOSUuid uuid) throws BOSException, EASBizException {
        ICoreBase iDataBase = null;
        iDataBase = ctx == null ? CommonInfoUtil.getRemoteInstance(bosType) : CommonInfoUtil.getLocalInstance(bosType, ctx);
        return iDataBase.getValue((IObjectPK)new ObjectUuidPK(uuid));
    }

    public static CoreBaseInfo getCoreBaseInfo(Context ctx, String bosType, String number) throws BOSException, EASBizException {
        ICoreBase iDataBase = null;
        iDataBase = ctx == null ? CommonInfoUtil.getRemoteInstance(bosType) : CommonInfoUtil.getLocalInstance(bosType, ctx);
        return CommonInfoUtil.getCoreBaseInfo(iDataBase, number);
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number) throws BOSException {
        String[] fields = new String[]{"number"};
        String[] values = new String[]{number};
        EntityViewInfo view = CommonInfoUtil.getEntityViewInfo(fields, values, false);
        return CommonInfoUtil.getCoreBaseInfo(iDataBase, view);
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number, String cuId) throws BOSException {
        if (cuId == null || cuId.trim().length() == 0) {
            return CommonInfoUtil.getCoreBaseInfo(iDataBase, number);
        }
        String[] fields = new String[]{"number", "CU"};
        String[] values = new String[]{number, cuId};
        EntityViewInfo view = CommonInfoUtil.getEntityViewInfo(fields, values, false);
        return CommonInfoUtil.getCoreBaseInfo(iDataBase, view);
    }

    public static EntityViewInfo getEntityViewInfo(String[] fields, String[] fieldsValue, boolean isAllField) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        if (fields != null && fieldsValue != null && fields.length >= fieldsValue.length) {
            if (isAllField) {
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("entry.*"));
            } else {
                for (int i = 0; i < fields.length; ++i) {
                    sic.add(new SelectorItemInfo(fields[i]));
                }
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            for (int j = 0; j < fields.length && j < fieldsValue.length; ++j) {
                fic.add(new FilterItemInfo(fields[j], (Object)fieldsValue[j].trim(), CompareType.EQUALS));
            }
            view.setFilter(filter);
        } else {
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
        }
        return view;
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, EntityViewInfo view) throws BOSException {
        CoreBaseCollection coreBaseCollection;
        CoreBaseInfo coreBaseInfo = null;
        if (iDataBase != null && (coreBaseCollection = iDataBase.getCollection(view)) != null) {
            coreBaseInfo = coreBaseCollection.get(0);
        }
        return coreBaseInfo;
    }

    public static void setPropValue(CoreBaseInfo info, String key, Object value) {
        info.put(key, value);
    }

    public static CtrlUnitInfo getCtrolUnitInfo(Context ctx, String cnNumber) throws BOSException {
        ICtrlUnit iCtrolUnit = null;
        iCtrolUnit = ctx == null ? CtrlUnitFactory.getRemoteInstance() : CtrlUnitFactory.getLocalInstance((Context)ctx);
        String[] fields = new String[]{"number", "id"};
        String[] fieldsValues = new String[]{cnNumber};
        EntityViewInfo view = CommonInfoUtil.getEntityViewInfo(fields, fieldsValues, false);
        CtrlUnitCollection ctrolColl = iCtrolUnit.getCtrlUnitCollection(view);
        CtrlUnitInfo cuInfo = null;
        if (ctrolColl != null) {
            cuInfo = ctrolColl.get(0);
        }
        return cuInfo;
    }

    public static boolean validateProperty(HashMap infoMap, String prop) {
        if (infoMap == null || prop == null) {
            return false;
        }
        return infoMap.get(prop) != null;
    }

    public static Timestamp getTimeStampFromStr(String timeStr) throws Exception {
        if (timeStr != null) {
            return Timestamp.valueOf(timeStr);
        }
        return null;
    }

    public static int[] convertTimePartFromStr(String timePart) {
        int[] ret = null;
        if (timePart != null && timePart.trim().length() == 8) {
            String[] slpts = timePart.split(":");
            ret = new int[3];
            for (int i = 0; i < slpts.length && i < 3; ++i) {
                ret[i] = Integer.parseInt(slpts[i]);
            }
        }
        return ret;
    }

    public static String convertStrFromTimestamp(Timestamp time) {
        StringBuffer timestampBuf = new StringBuffer();
        if (time != null) {
            int year = time.getYear() + 1900;
            int month = time.getMonth() + 1;
            int day = time.getDate();
            int hour = time.getHours();
            int minute = time.getMinutes();
            int second = time.getSeconds();
            String yearString = "" + year;
            String monthString = "" + month;
            String dayString = "" + day;
            String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
            String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
            String secondString = second < 10 ? "0" + second : Integer.toString(second);
            timestampBuf.append(yearString);
            timestampBuf.append("-");
            timestampBuf.append(monthString);
            timestampBuf.append("-");
            timestampBuf.append(dayString);
            timestampBuf.append(" ");
            timestampBuf.append(hourString);
            timestampBuf.append(":");
            timestampBuf.append(minuteString);
            timestampBuf.append(":");
            timestampBuf.append(secondString);
        }
        return timestampBuf.toString();
    }

    public static Date convertStrToDate(String strDate, String parttern) throws EASBizException {
        try {
            if (strDate != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
                return dateFormat.parse(strDate);
            }
            return null;
        }
        catch (ParseException e) {
            throw new EASBizException(new NumericExceptionSubItem("3007", EASResource.getString((String)RESOURCE, (String)"CUERROR_3007")));
        }
    }

    public static String convertDateToStr(Date date, String parttern) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.format(date);
        }
        return null;
    }

    public static CoreBaseCollection getCoreBaseBillCollection(Context ctx, String bosType, String number) throws BOSException, EASBizException {
        ICoreBase iDataBase = null;
        CoreBaseCollection coll = null;
        iDataBase = ctx == null ? CommonInfoUtil.getRemoteInstance(bosType) : CommonInfoUtil.getLocalInstance(bosType, ctx);
        if (iDataBase == null) {
            throw new EASBizException(new NumericExceptionSubItem(bosType, " can not get Ejb instance"));
        }
        EntityViewInfo view = null;
        if (number != null && number.trim().length() > 0) {
            String[] fields = new String[]{"number"};
            String[] fieldValues = new String[]{number};
            view = CommonInfoUtil.getEntityViewInfo(fields, fieldValues, true);
            coll = iDataBase.getCollection(view);
        } else {
            view = CommonInfoUtil.getEntityViewInfo(null, null, true);
            coll = iDataBase.getCollection(view);
        }
        return coll;
    }
}

