/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.nsrm.FetchFacadeFactory;
import com.kingdee.eas.scm.nsrm.client.AbstractSrmFileReadUI;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

public class SrmFileReadUI
extends AbstractSrmFileReadUI {
    private static final long serialVersionUID = -5668615452674361225L;
    private static final Logger logger = CoreUIObject.getLogger(SrmFileReadUI.class);
    private String homePath = null;
    private String instancePath = null;
    private List<String> logsList = new ArrayList<String>();
    private List<String> instanceList = new ArrayList<String>();
    private List<String> showList = new ArrayList<String>();
    int currentPageIndex = 0;
    private String[] comomnKeys = new String[]{"scm_nsrm.log", "apusic.log.0", "apusic.log.0;apusic.log.1;apusic.log.2;apusic.log.3;apusic.log.4;apusic.log.5"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.initDefaultValue();
    }

    private void initDefaultValue() throws EASBizException, BOSException {
        Map pathMap = FetchFacadeFactory.getRemoteInstance().getSysFilePath();
        this.homePath = ConvertUtil.convertObj2Str(pathMap.get("EAS_HOME"));
        this.instancePath = ConvertUtil.convertObj2Str(pathMap.get("EAS_INSTANCE_HOME"));
        this.logsList = ConvertUtil.convertObj2StrArr(pathMap.get("logsList"));
        this.instanceList = ConvertUtil.convertObj2StrArr(pathMap.get("instanceList"));
        this.txtPath.setText("apusic.log.0");
        this.txtServerNum.setText("1");
        this.isMoreInstance.setSelected(true);
    }

    @Override
    public void actionSearchLogFile_actionPerformed(ActionEvent e) throws Exception {
        if (this.logsList == null || this.logsList.size() == 0) {
            MsgBox.showInfo((String)"\u65e5\u5fd7\u76ee\u5f55\u6ca1\u6709\u6587\u4ef6\u751f\u6210\uff01");
        }
        StringBuffer sbf = new StringBuffer();
        int size = this.logsList.size();
        for (int i = 0; i < size; ++i) {
            sbf.append(this.logsList.get(i)).append("\n");
        }
        this.txtAreaShow.setText(sbf.toString());
    }

    @Override
    public void actionCommonKeys_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer sbf = new StringBuffer();
        int size = this.comomnKeys.length;
        for (int i = 0; i < size; ++i) {
            sbf.append(this.comomnKeys[i]).append("\n");
        }
        this.txtAreaShow.setText(sbf.toString());
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        Map retMap;
        String errorMsg;
        String pathStr = this.txtPath.getText();
        boolean flex = this.checkPath(pathStr);
        if (!flex) {
            return;
        }
        String[] paths = pathStr.trim().split(";");
        String queryPath = paths != null && paths.length > 0 ? paths[0] : null;
        String originalPath = this.instancePath + "/logs/" + queryPath;
        String serverNum = this.txtServerNum.getText();
        if (serverNum == null || !serverNum.matches("^\\d+$")) {
            this.setTextNull();
            this.txtServerNum.setText("1");
            MsgBox.showInfo((String)"\u5b9e\u4f8b\u53ea\u5141\u8bb8\u586b\u5199\u6570\u5b57\uff01");
            return;
        }
        String path = originalPath;
        if (Integer.parseInt(serverNum) != 1) {
            String replaceStr = originalPath.substring(originalPath.indexOf("profiles/") + 9, originalPath.indexOf("/logs"));
            path = originalPath.replace(replaceStr, "server" + Integer.parseInt(serverNum));
        }
        if ((errorMsg = ConvertUtil.convertObj2Str((retMap = FetchFacadeFactory.getRemoteInstance().getFileContent(path)).get("errorMsg"))) != null) {
            this.setTextNull();
            MsgBox.showInfo((String)errorMsg);
            return;
        }
        List fileList = (List)retMap.get("fileList");
        String fileSize = ConvertUtil.convertObj2Str(retMap.get("fileSize"));
        if (!ConvertUtil.isEmpty(fileSize)) {
            this.txtTotalSize.setText(fileSize);
        }
        StringBuffer str = new StringBuffer();
        int size = fileList.size();
        this.showList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            str.append((String)fileList.get(i)).append("\n");
            if (i == 0 || i % 44 != 0) continue;
            this.showList.add(str.toString());
            str = new StringBuffer();
        }
        if (size > 0) {
            this.showList.add(str.toString());
        }
        if (this.showList != null && this.showList.size() > 0) {
            this.txtTotalPage.setText(String.valueOf(this.showList.size()));
            this.txtCurrentPage.setText("1");
            this.currentPageIndex = 0;
            this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
        } else {
            this.txtAreaShow.setText("\u67e5\u8be2\u8be5\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public void actionExportFile_actionPerformed(ActionEvent e) throws Exception {
        boolean isMoreIns = this.isMoreInstance.isSelected();
        String pathStr = this.txtPath.getText();
        boolean flex = this.checkPath(pathStr);
        if (!flex) {
            return;
        }
        String[] paths = pathStr.trim().split(";");
        if (!isMoreIns) {
            paths = new String[]{paths[0]};
        }
        String desktopPath = FileSystemView.getFileSystemView().getHomeDirectory().getAbsolutePath();
        long currentTime = System.currentTimeMillis();
        Date currentDate = new Date(currentTime);
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
        String currentTimeStr = sd.format(currentDate);
        ArrayList<String> queryPathList = new ArrayList<String>();
        ArrayList<String> writePathList = new ArrayList<String>();
        String fileName = "SRM" + currentTimeStr;
        int size = paths.length;
        for (int i = 0; i < size; ++i) {
            int length = this.instanceList.size();
            for (int j = 0; j < length; ++j) {
                queryPathList.add(this.homePath + File.separator + "server" + File.separator + "profiles" + File.separator + this.instanceList.get(j) + File.separator + "logs" + File.separator + paths[i]);
                writePathList.add(desktopPath + File.separator + "SRM" + File.separator + currentTimeStr + File.separator + this.instanceList.get(j) + File.separator + paths[i]);
            }
        }
        String queryPath = null;
        String writerPath = null;
        int size2 = queryPathList.size();
        for (int i = 0; i < size2; ++i) {
            queryPath = (String)queryPathList.get(i);
            writerPath = (String)writePathList.get(i);
            Map retMap = new HashMap();
            try {
                retMap = FetchFacadeFactory.getRemoteInstance().getFileContent(queryPath);
            }
            catch (EASBizException e1) {
                throw new Exception(e1.getMessage());
            }
            catch (BOSException e1) {
                throw new BOSException((Throwable)e1);
            }
            String errorMsg = ConvertUtil.convertObj2Str(retMap.get("errorMsg"));
            if (errorMsg != null) continue;
            List fileList = (List)retMap.get("fileList");
            File file = new File((String)writePathList.get(i));
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            FileOutputStream fos = null;
            OutputStreamWriter oStreamWriter = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fos = new FileOutputStream(writerPath, true);
                oStreamWriter = new OutputStreamWriter((OutputStream)fos, "utf-8");
                int length = fileList.size();
                for (int j = 0; j < length; ++j) {
                    oStreamWriter.write((String)fileList.get(j));
                    oStreamWriter.write("\r\n");
                }
                continue;
            }
            catch (IOException e1) {
                throw new BOSException((Throwable)e1);
            }
            finally {
                try {
                    if (oStreamWriter != null) {
                        oStreamWriter.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    throw new BOSException((Throwable)ex);
                }
            }
        }
        MsgBox.showInfo((String)("\u5bfc\u51fa\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u684c\u9762\u6587\u4ef6\u5939" + fileName + "!"));
    }

    @Override
    public void actionJump_actionPerformed(ActionEvent e) throws Exception {
        String currentPageStr = this.txtCurrentPage.getText();
        if (ConvertUtil.isEmpty(currentPageStr)) {
            return;
        }
        if (this.showList == null || this.showList.size() == 0) {
            MsgBox.showInfo((String)"\u67e5\u8be2\u6587\u4ef6\u4e3a\u7a7a\uff01");
            return;
        }
        if (!currentPageStr.matches("[0-9]+")) {
            MsgBox.showInfo((String)"\u8f93\u5165\u9875\u7801\u5fc5\u987b\u4e3a\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u6700\u5927\u9875\u7801\u7684\u6574\u6570\uff01");
            return;
        }
        int currentPage = Integer.parseInt(currentPageStr);
        if (currentPage > this.showList.size() || currentPage < 1) {
            MsgBox.showInfo((String)"\u8f93\u5165\u9875\u7801\u5fc5\u987b\u4e3a\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u6700\u5927\u9875\u7801\u7684\u6574\u6570\uff01");
            return;
        }
        this.currentPageIndex = currentPage - 1;
        this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        if (this.showList == null || this.showList.size() == 0) {
            MsgBox.showInfo((String)"\u67e5\u8be2\u6587\u4ef6\u4e3a\u7a7a\uff01");
            return;
        }
        this.currentPageIndex = 0;
        this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
        this.txtCurrentPage.setText(String.valueOf(this.currentPageIndex + 1));
    }

    @Override
    public void actionPrevious_actionPerformed(ActionEvent e) throws Exception {
        if (this.showList == null || this.showList.size() == 0) {
            MsgBox.showInfo((String)"\u67e5\u8be2\u6587\u4ef6\u4e3a\u7a7a\uff01");
            return;
        }
        --this.currentPageIndex;
        if (this.currentPageIndex < 0) {
            this.currentPageIndex = 0;
        }
        this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
        this.txtCurrentPage.setText(String.valueOf(this.currentPageIndex + 1));
    }

    @Override
    public void actionLatter_actionPerformed(ActionEvent e) throws Exception {
        if (this.showList == null || this.showList.size() == 0) {
            MsgBox.showInfo((String)"\u67e5\u8be2\u6587\u4ef6\u4e3a\u7a7a\uff01");
            return;
        }
        ++this.currentPageIndex;
        if (this.currentPageIndex >= this.showList.size()) {
            this.currentPageIndex = this.showList.size() - 1;
        }
        this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
        this.txtCurrentPage.setText(String.valueOf(this.currentPageIndex + 1));
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        if (this.showList == null || this.showList.size() == 0) {
            MsgBox.showInfo((String)"\u67e5\u8be2\u6587\u4ef6\u4e3a\u7a7a\uff01");
            return;
        }
        this.currentPageIndex = this.showList.size() - 1;
        this.txtAreaShow.setText(this.showList.get(this.currentPageIndex));
        this.txtCurrentPage.setText(String.valueOf(this.currentPageIndex + 1));
    }

    private void setTextNull() {
        this.txtTotalSize.setText(null);
        this.txtTotalPage.setText(null);
        this.txtCurrentPage.setText(null);
        this.txtAreaShow.setText(null);
        this.showList = null;
        this.currentPageIndex = 0;
    }

    private boolean checkPath(String pathStr) {
        String[] paths;
        String queryPath;
        String reg;
        boolean flag = true;
        if (ConvertUtil.isEmpty(pathStr)) {
            this.setTextNull();
            flag = false;
            MsgBox.showInfo((String)"\u67e5\u8be2\u7684\u6587\u4ef6\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        if (!pathStr.matches(reg = "^[a-zA-Z0-9_.;]+$")) {
            this.setTextNull();
            flag = false;
            MsgBox.showInfo((String)"\u8f93\u5165\u6587\u4ef6\u540d\u53ea\u5141\u8bb8\u662f\u6570\u5b57\u5927\u5c0f\u5199\u5b57\u6bcd\u4e0b\u5212\u7ebf\u4ee5\u53ca\u70b9\u7ec4\u5408\uff01");
        }
        String string = queryPath = (paths = pathStr.trim().split(";")) != null && paths.length > 0 ? paths[0] : null;
        if (queryPath == null) {
            this.setTextNull();
            flag = false;
            MsgBox.showInfo((String)"\u67e5\u8be2\u7684\u6587\u4ef6\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        return flag;
    }
}

