/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.nsrm.client.AbstractSrmOrderConditionUI;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SrmOrderConditionUI
extends AbstractSrmOrderConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(SrmOrderConditionUI.class);
    private DataChangeListener purOrgListener = null;

    public SrmOrderConditionUI() throws Exception {
        this.prmtOrg.setEnabledMultiSelection(true);
        this.purOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    SrmOrderConditionUI.this.purOrgChange(eventObj);
                }
                catch (EASBizException e) {
                    SrmOrderConditionUI.this.handUIException(e);
                }
                catch (BOSException e) {
                    SrmOrderConditionUI.this.handUIException(e);
                }
            }
        };
        this.prmtOrg.addDataChangeListener(this.purOrgListener);
    }

    private void purOrgChange(DataChangeEvent eventObj) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Purchase, null, "purorder_addnew");
        HashSet<String> idset = new HashSet<String>();
        FullOrgUnitInfo org = null;
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            org = fullCompanyColl.get(i);
            idset.add(org.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtOrg.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void srmProgress_actionPerformed(ActionEvent e) throws Exception {
        super.srmProgress_actionPerformed(e);
    }

    public void onInit(RptParams initParams) throws Exception {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = SysContext.getSysContext().getCurrentPurchaseUnit();
        if (null != purchaseOrgUnitInfo && purchaseOrgUnitInfo.isIsBizUnit()) {
            this.prmtOrg.setValue((Object)purchaseOrgUnitInfo);
        } else {
            IPermission iPerm = PermissionFactory.getRemoteInstance();
            FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Purchase, null, "purorder_addnew");
            if (fullCompanyColl != null && fullCompanyColl.size() > 0) {
                FullOrgUnitInfo orgInfo = fullCompanyColl.get(0);
                this.prmtOrg.setValue((Object)orgInfo);
            }
        }
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Calendar c = Calendar.getInstance();
        c.setTime((Date)this.startDate.getValue());
        params.setObject("prmtPurOrderUnit", this.prmtOrg.getData());
        params.setObject("startDate", (Object)c.getTime());
        c.setTime((Date)this.endDate.getValue());
        params.setObject("endDate", (Object)c.getTime());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtOrg.setValue(params.getObject("prmtPurOrderUnit"));
        this.startDate.setValue(params.getObject("startDate"));
        this.endDate.setValue(params.getObject("endDate"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Calendar c = Calendar.getInstance();
        c.setTime((Date)this.endDate.getValue());
        c.add(2, -1);
        this.startDate.setValue((Object)c.getTime());
    }
}

