/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.nsrm.BooleanDataTypeEnum;
import com.kingdee.eas.scm.nsrm.ISrmParam;
import com.kingdee.eas.scm.nsrm.SrmParamFactory;
import com.kingdee.eas.scm.nsrm.SrmParamInfo;
import com.kingdee.eas.scm.nsrm.SrmParamItemFactory;
import com.kingdee.eas.scm.nsrm.SrmParamItemInfo;
import com.kingdee.eas.scm.nsrm.client.AbstractSrmParamItemEditUI;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.awt.event.ActionEvent;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SrmParamItemEditUI
extends AbstractSrmParamItemEditUI {
    private static final long serialVersionUID = 6285576126037972628L;
    private static final Logger logger = CoreUIObject.getLogger(SrmParamItemEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButtonStatus();
        this.initUI();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Locale locale = SysContext.getSysContext().getLocale();
        this.txtName.addItem(new LanguageInfo(locale), (Object)this.editData.getKeyID().getName());
        this.txtDescription.addItem(new LanguageInfo(locale), (Object)this.editData.getKeyID().getDescription());
        this.editData.setSyncOldValue(true);
        this.initItemValue();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getKeyID().getDataType().getValue() == 3) {
            int itemValue = ((BooleanDataTypeEnum)((Object)this.comboItemValue.getSelectedItem())).getValue();
            this.editData.setItemValue(String.valueOf(itemValue));
        }
    }

    private void initItemValue() {
        String itemValue = this.editData.getItemValue();
        if (this.editData.getKeyID().getDataType().getValue() == 3) {
            this.comboItemValue.setSelectedItem((Object)BooleanDataTypeEnum.getEnumList());
            this.comboItemValue.setSelectedItem((Object)BooleanDataTypeEnum.getEnum(Integer.parseInt(itemValue)));
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getKeyID().getId();
        ISrmParam instance = SrmParamFactory.getRemoteInstance();
        SrmParamInfo srmParamInfo = instance.getSrmParamInfo((IObjectPK)new ObjectUuidPK(id));
        srmParamInfo.setIsControl(this.iscontrol.isSelected());
        instance.save((CoreBaseInfo)srmParamInfo);
        this.actionSave_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionCancel1_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected void showMessageForStatus() {
    }

    private void initUI() {
        if (this.getOprtState() != null && OprtStateConstant.VIEW.equals(this.getOprtState())) {
            this.contItemValue.setEnabled(false);
            this.comboItemValue.setEnabled(false);
            this.comboItemValue.setEditable(false);
        }
    }

    private void initButtonStatus() {
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
        this.menuBar.setEnabled(false);
        this.menuBar.setVisible(false);
        String ctxCuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String cuId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        if (this.getOprtState() != null && OprtStateConstant.VIEW.equals(this.getOprtState())) {
            this.actionOK.setEnabled(false);
            this.iscontrol.setEditable(false);
        } else if (ctxCuId.equals(cuId)) {
            this.iscontrol.setEditable(true);
            this.iscontrol.setEnabled(true);
            this.actionOK.setEnabled(true);
        } else {
            this.iscontrol.setEditable(false);
            this.iscontrol.setEnabled(false);
            if (this.editData.getKeyID().isIsControl()) {
                this.actionOK.setEnabled(false);
            } else {
                this.actionOK.setEnabled(true);
            }
        }
        this.actionCancel1.setEnabled(true);
    }

    protected IObjectValue createNewData() {
        SrmParamItemInfo info = new SrmParamItemInfo();
        SrmParamInfo paramInfo = new SrmParamInfo();
        info.setKeyID(paramInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SrmParamItemFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("itemValue"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("keyID.id"));
        sic.add(new SelectorItemInfo("keyID.number"));
        sic.add(new SelectorItemInfo("keyID.name"));
        sic.add(new SelectorItemInfo("keyID.name"));
        sic.add(new SelectorItemInfo("keyID.defaultValue"));
        sic.add(new SelectorItemInfo("keyID.dataType"));
        sic.add(new SelectorItemInfo("keyID.isShow"));
        sic.add(new SelectorItemInfo("keyID.description"));
        sic.add(new SelectorItemInfo("keyID.isControl"));
        return sic;
    }
}

