/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.nsrm.client.AbstractSrmSalStockConditionUI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SrmSalStockConditionUI
extends AbstractSrmSalStockConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(SrmSalStockConditionUI.class);
    private DataChangeListener comSupplierListener = null;
    private DataChangeListener purOrgListener = null;

    public SrmSalStockConditionUI() throws Exception {
        this.prmtPurOrderUnit.setEnabledMultiSelection(true);
        this.prmtSupplier.setEnabledMultiSelection(true);
        this.comSupplierListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                SrmSalStockConditionUI.this.comSupplierChange(eventObj);
            }
        };
        this.purOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    SrmSalStockConditionUI.this.purOrgChange(eventObj);
                }
                catch (EASBizException e) {
                    SrmSalStockConditionUI.this.handUIException(e);
                }
                catch (BOSException e) {
                    SrmSalStockConditionUI.this.handUIException(e);
                }
            }
        };
        this.prmtSupplier.addDataChangeListener(this.comSupplierListener);
        this.prmtPurOrderUnit.addDataChangeListener(this.purOrgListener);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSrm", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtSupplier.setEntityViewInfo(viewInfo);
    }

    private void comSupplierChange(DataChangeEvent eventObj) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSrm", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtSupplier.setEntityViewInfo(viewInfo);
    }

    private void purOrgChange(DataChangeEvent eventObj) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Purchase, null, "purorder_addnew");
        HashSet<String> idset = new HashSet<String>();
        FullOrgUnitInfo org = null;
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            org = fullCompanyColl.get(i);
            idset.add(org.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtPurOrderUnit.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtPurORG_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPurORG_dataChanged(e);
    }

    public void onInit(RptParams initParams) throws Exception {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = SysContext.getSysContext().getCurrentPurchaseUnit();
        if (null != purchaseOrgUnitInfo && purchaseOrgUnitInfo.isIsBizUnit()) {
            this.prmtPurOrderUnit.setValue((Object)purchaseOrgUnitInfo);
        } else {
            IPermission iPerm = PermissionFactory.getRemoteInstance();
            FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Purchase, null, "purorder_addnew");
            if (fullCompanyColl != null && fullCompanyColl.size() > 0) {
                FullOrgUnitInfo orgInfo = fullCompanyColl.get(0);
                this.prmtPurOrderUnit.setValue((Object)orgInfo);
            }
        }
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Calendar c = Calendar.getInstance();
        c.setTime((Date)this.endDate.getValue());
        params.setObject("prmtPurOrderUnit", this.prmtPurOrderUnit.getData());
        params.setObject("prmtSupplier", this.prmtSupplier.getData());
        params.setObject("endDate", (Object)c.getTime());
        c.setTime((Date)this.startdate.getValue());
        params.setObject("startdate", (Object)c.getTime());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtPurOrderUnit.setValue(params.getObject("prmtPurOrderUnit"));
        this.prmtSupplier.setValue(params.getObject("prmtSupplier"));
        this.endDate.setValue(params.getObject("endDate"));
        this.startdate.setValue(params.getObject("startdate"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Calendar c = Calendar.getInstance();
        c.setTime((Date)this.endDate.getValue());
        c.add(2, -1);
        this.startdate.setValue((Object)c.getTime());
    }
}

