/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.nsrm.FetchFacadeFactory;
import com.kingdee.eas.scm.nsrm.SrmSaloutStockFacadeFactory;
import com.kingdee.eas.scm.nsrm.client.AbstractSrmSaloutStockUI;
import com.kingdee.eas.scm.nsrm.client.SrmSalStockConditionUI;
import com.kingdee.eas.scm.nsrm.util.SelectorFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SrmSaloutStockUI
extends AbstractSrmSaloutStockUI {
    private static final Logger logger = CoreUIObject.getLogger(SrmSaloutStockUI.class);
    private DataChangeListener comSupplierListener = null;
    private DataChangeListener purOrgListener = null;

    public SrmSaloutStockUI() throws Exception {
        this.tblMain.checkParsed();
        this.prmtPurOrgUnit.setEnabledMultiSelection(true);
        this.prmtSupplier.setEnabledMultiSelection(true);
        this.comSupplierListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                SrmSaloutStockUI.this.comSupplierChange(eventObj);
            }
        };
        this.purOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    SrmSaloutStockUI.this.purOrgChange(eventObj);
                }
                catch (EASBizException e) {
                    SrmSaloutStockUI.this.handUIException(e);
                }
                catch (BOSException e) {
                    SrmSaloutStockUI.this.handUIException(e);
                }
            }
        };
        this.prmtSupplier.addDataChangeListener(this.comSupplierListener);
        this.prmtPurOrgUnit.addDataChangeListener(this.purOrgListener);
        this.initSupplierF7();
    }

    private void comSupplierChange(DataChangeEvent eventObj) {
        this.initSupplierF7();
    }

    private void purOrgChange(DataChangeEvent eventObj) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Purchase, null, "purorder_addnew");
        HashSet<String> idset = new HashSet<String>();
        FullOrgUnitInfo org = null;
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            org = fullCompanyColl.get(i);
            idset.add(org.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtPurOrgUnit.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return null;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new SrmSalStockConditionUI();
    }

    protected void query() {
        this.initTempFilter();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.removeRows();
    }

    private void initTempFilter() {
        this.prmtPurOrgUnit.setValue(this.params.getObject("prmtPurOrderUnit"));
        this.prmtSupplier.setValue(this.params.getObject("prmtSupplier"));
        this.endDate.setValue(this.params.getObject("endDate"));
        this.startDate.setValue(this.params.getObject("startdate"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSupplierF7();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            RptParams para = new RptParams();
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (from == 0) {
                para.setString("tempTable", this.getTempTable());
                para.putAll(this.params.toMap());
                rpt = SrmSaloutStockFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                this.tblMain.setRowCount(rpt.getInt("RowCount"));
                logger.info((Object)("\u7f51\u7edc\u8ba2\u5355\u6267\u884c\u60c5\u51b5\u8868--\u672c\u6b21\u67e5\u8be2\u4f7f\u7528\u7684\u4e34\u65f6\u8868\u540d\u4e3a: " + rpt.getString("tempTable")));
            }
            para.setString("tempTable", this.getTempTable());
            rpt = SrmSaloutStockFacadeFactory.getRemoteInstance().query(para);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowSet");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs){

                public void setTableRowData(IRow row, Object[] rowData) {
                    int n = rowData.length;
                    for (int i = 0; i < n; ++i) {
                        row.getCell(i).setValue(rowData[i]);
                    }
                }
            });
            if (rs.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
        catch (Exception ee) {
            this.handleException(ee);
        }
    }

    @Override
    public void actionSerach_actionPerformed(ActionEvent e) throws Exception {
        this.params.setObject("prmtPurOrderUnit", this.prmtPurOrgUnit.getData());
        this.params.setObject("prmtSupplier", this.prmtSupplier.getData());
        this.params.setObject("endDate", this.endDate.getValue());
        this.params.setObject("startdate", this.startDate.getValue());
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.removeRows();
    }

    @Override
    public void actionToData_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> orderIdSet = new HashSet<String>();
        HashSet<String> inwarehsIdSet = new HashSet<String>();
        HashSet<String> newInwarehsIdSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (null != this.tblMain.getRow(i).getCell("inwareshentryId").getValue()) {
                inwarehsIdSet.add(this.tblMain.getRow(i).getCell("inwareshentryId").getValue().toString());
                idSet.add(this.tblMain.getRow(i).getCell("inwareshentryId").getValue().toString());
            }
            if (null == this.tblMain.getRow(i).getCell("orderentryId").getValue()) continue;
            orderIdSet.add(this.tblMain.getRow(i).getCell("orderentryId").getValue().toString());
            idSet.add(this.tblMain.getRow(i).getCell("orderentryId").getValue().toString());
        }
        Date date = (Date)this.endDate.getValue();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = dateFormat.format(date);
        idSet.add("date_" + dateStr);
        inwarehsIdSet.add("date_" + dateStr);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", inwarehsIdSet, CompareType.INCLUDE));
        SelectorItemCollection inwarehsSic = SelectorFactory.getPurInWarehsEntryNoEntrySelector();
        inwarehsSic.addObjectCollection((IObjectCollection)SelectorFactory.getEntry2PurInWarehsBillSelector());
        evi.setFilter(filter);
        evi.setSelector(inwarehsSic);
        PurInWarehsEntryCollection col = PurInWarehsEntryFactory.getRemoteInstance().getPurInWarehsEntryCollection(evi);
        if (col.size() > 0 && col != null) {
            PurInWarehsEntryInfo entry = null;
            for (int i = 0; i < col.size(); ++i) {
                entry = (PurInWarehsEntryInfo)col.getObject(i);
                if (entry.getParent().getTransactionType().getRiType().getRI().getValue() == 1 && entry.getParent().getTransactionType().getRiType().getBizDirection().getValue() == 1) continue;
                newInwarehsIdSet.add(entry.getParent().getId().toString());
                inwarehsIdSet.remove(entry.getId().toString());
            }
        }
        FetchFacadeFactory.getRemoteInstance().httpSendService("EAS_SaloutStock_Sync_Send", inwarehsIdSet, false);
        FetchFacadeFactory.getRemoteInstance().httpSendService("EAS_SaloutStock_Sync_Send", idSet, false);
        FetchFacadeFactory.getRemoteInstance().httpSendService("EAS_IerpPurReturns_Sync_Send", newInwarehsIdSet, false);
        MsgBox.showInfo((String)"\u751f\u6210\u671f\u521d\u6570\u636e\u4efb\u52a1\u5df2\u4e0b\u8fbe");
    }

    private Map<String, IObjectValue> getOrderEntryMap(Set<String> orderIdSet) throws BOSException {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderIdSet.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        PurOrderEntryCollection entrys = PurOrderEntryFactory.getRemoteInstance().getPurOrderEntryCollection(evi);
        PurOrderEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            map.put(entry.get("id").toString(), (IObjectValue)entry);
        }
        return map;
    }

    private Map<String, IObjectValue> getInwarehsEntryMap(Set<String> inwarehsIdSet) throws BOSException {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)inwarehsIdSet.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        PurInWarehsEntryCollection entrys = PurInWarehsEntryFactory.getRemoteInstance().getPurInWarehsEntryCollection(evi);
        PurInWarehsEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            map.put(entry.get("id").toString(), (IObjectValue)entry);
        }
        return map;
    }

    public void initSupplierF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSrm", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtSupplier.setEntityViewInfo(viewInfo);
    }
}

