/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ConvertUtil {
    public static BigDecimal defaultBigDecimal(BigDecimal arg) {
        return arg == null ? BigDecimal.ZERO : arg;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String convertObj2Str(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static boolean convertObj2Boolean(Object obj, boolean defualt) {
        return obj == null ? defualt : Boolean.parseBoolean(obj.toString());
    }

    public static BigDecimal convertObj2BigDecimal(Object obj) {
        BigDecimal ret = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                ret = (BigDecimal)obj;
            } else if (obj instanceof String) {
                ret = new BigDecimal((String)obj);
            } else if (obj instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)obj);
            } else if (obj instanceof Number) {
                ret = new BigDecimal(obj.toString());
            } else {
                throw new ClassCastException("Not possible to coerce [" + obj + "] from class " + obj.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    public static String convertObjDouble2IntStr(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj != null && obj instanceof Double) {
            return String.valueOf(new Double(obj.toString()).intValue());
        }
        return String.valueOf(Integer.valueOf(obj.toString()));
    }

    public static String[] convertIObjectPK2StrArr(IObjectPK[] pks) {
        String[] arr = new String[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            arr[i] = pks[i].toString();
        }
        return arr;
    }

    public static List<String> convertObj2StrArr(Object obj) {
        List list = (List)obj;
        return list != null && list.size() > 0 ? list : null;
    }

    public static Map convertJsonToMap(Context ctx, Object data) throws BOSException {
        if (data instanceof Map) {
            return data == null ? null : (Map)data;
        }
        return data == null ? null : (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)data.toString(), Map.class);
    }

    public static String convertObjToJson(Context ctx, Object data) throws BOSException {
        return data == null ? null : JSONUtils.convertObjectToJson((Context)ctx, (Object)data);
    }

    public static EntityViewInfo convertPKSet2EVI(Set<String> pkSet) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo convertStrArray2EVI(String[] str) {
        HashSet<String> pkSet = new HashSet<String>();
        int size = str.length;
        for (int i = 0; i < size; ++i) {
            pkSet.add(str[i]);
        }
        return ConvertUtil.convertPKSet2EVI(pkSet);
    }

    public static EntityViewInfo convertNumSet2EVI(Set<String> pkSet) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", pkSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public static Set<String> objCol2Set(IObjectCollection billCol) {
        HashSet<String> pkSet = new HashSet<String>();
        if (billCol == null || billCol.size() == 0) {
            return null;
        }
        String billId = null;
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            billId = billCol.getObject(i).get("id").toString();
            pkSet.add(billId);
        }
        return pkSet;
    }

    public static StringBuffer objCol2StrBuf(IObjectCollection billCol) {
        if (billCol == null || billCol.size() == 0) {
            return new StringBuffer(" in ('')");
        }
        StringBuffer sbf = new StringBuffer();
        if (billCol.size() == 1) {
            return sbf.append(" = '").append(billCol.getObject(0).get("id").toString()).append("'");
        }
        String billId = null;
        sbf.setLength(0);
        sbf.append(" in (");
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            billId = billCol.getObject(i).get("id").toString();
            if (i == 0) {
                sbf.append("'").append(billId).append("'");
                continue;
            }
            sbf.append(",'").append(billId).append("'");
        }
        sbf.append(")");
        return sbf;
    }

    public static StringBuffer list2StrBuf(List<String> list) {
        if (list == null || list.size() == 0) {
            return new StringBuffer(" in ('')");
        }
        StringBuffer sbf = new StringBuffer();
        if (list.size() == 1) {
            return sbf.append(" = '").append(list.get(0)).append("' ");
        }
        sbf.setLength(0);
        sbf.append(" in (");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sbf.append("'").append(list.get(i)).append("'");
                continue;
            }
            sbf.append(",'").append(list.get(i)).append("'");
        }
        sbf.append(")");
        return sbf;
    }

    public static StringBuffer set2StrBuf(Set<String> idSet) {
        if (idSet == null || idSet.size() == 0) {
            return new StringBuffer(" in ('')");
        }
        StringBuffer sbf = new StringBuffer();
        sbf.append(" in (");
        int count = 0;
        for (String billId : idSet) {
            if (count == 0) {
                sbf.append("'").append(billId).append("'");
            } else {
                sbf.append(",'").append(billId).append("'");
            }
            ++count;
        }
        sbf.append(")");
        return sbf;
    }

    public static StringBuffer strArr2StrBuf(Object[] str) {
        if (str == null || str.length == 0) {
            return new StringBuffer(" in ('')");
        }
        StringBuffer sbf = new StringBuffer();
        if (str.length == 1) {
            return sbf.append(" = '").append(str[0]).append("' ");
        }
        sbf.setLength(0);
        sbf.append(" in (");
        int size = str.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sbf.append("'").append(str[i]).append("'");
                continue;
            }
            sbf.append(",'").append(str[i]).append("'");
        }
        sbf.append(")");
        return sbf;
    }

    public static String divide2Str(String[] str) {
        return str == null || str.length == 0 ? null : StringUtils.join((Object[])str, (String)"|");
    }

    public static String divide2Str(List<String> list) {
        return list == null || list.size() == 0 ? null : StringUtils.join((Object[])list.toArray(), (String)"|");
    }

    public static String[] merge2StrArr(String str) {
        return str == null ? null : str.split("\\|");
    }

    public static Set<String> strArr2Set(String[] str) {
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < str.length; ++i) {
            pkSet.add(str[i]);
        }
        return pkSet;
    }

    public static Set<String> objArr2Set(IObjectPK[] str) {
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < str.length; ++i) {
            pkSet.add(str[i].toString());
        }
        return pkSet;
    }

    public static IObjectPK[] strArr2ObjArr(String[] str) {
        IObjectPK[] strArr = new IObjectPK[str.length];
        for (int i = 0; i < str.length; ++i) {
            BOSUuid uuid = BOSUuid.read((String)str[i]);
            strArr[i] = new ObjectUuidPK(uuid);
        }
        return strArr;
    }

    public static String[] col2StrArr(IObjectCollection objCol) {
        int size = objCol.size();
        String[] str = new String[size];
        String pk = null;
        for (int i = 0; i < size; ++i) {
            str[i] = pk = objCol.getObject(i).get("id").toString();
        }
        return str;
    }

    public static String[] objArr2StrArr(IObjectPK[] objPKs) {
        int size = objPKs.length;
        String[] str = new String[size];
        String pk = null;
        for (int i = 0; i < size; ++i) {
            str[i] = pk = objPKs[i].toString();
        }
        return str;
    }

    public static String[] set2StrArr(Set<String> pkSet) {
        int size = pkSet.size();
        String[] str = new String[size];
        int i = 0;
        Iterator<String> iterator = pkSet.iterator();
        while (iterator.hasNext()) {
            String pk;
            str[i] = pk = iterator.next();
            ++i;
        }
        return str;
    }

    public static String[] list2StrArr(List<String> pkList) {
        int size = pkList.size();
        String[] str = new String[size];
        String pk = null;
        for (int i = 0; i < size; ++i) {
            str[i] = pk = pkList.get(i);
        }
        return str;
    }
}

