/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelpers;
import com.kingdee.eas.scm.nsrm.app.util.ISCHelper;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ISCWebServiceUtil {
    private static final Map<String, String> apiMap = new HashMap<String, String>(64);
    private static final Map<String, String> methodMap = new HashMap<String, String>(64);
    private static final Logger LOGGER = Logger.getLogger(ISCWebServiceUtil.class);

    public static Object httpSendService(Context ctx, String interfaceId, Object data, boolean sync) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        Object[] pks = null;
        String substring = data.toString().substring(data.toString().indexOf(":") + 1);
        pks = substring.split("\\|");
        String lcNumber = null;
        if (interfaceId.equals("EAS_BatchPurRequestForPurQuo_Send") || interfaceId.equals("EAS_PurRequestForPurQuo_Send")) {
            lcNumber = "1067295257546533888";
        } else if (interfaceId.equals("EAS_BatchPurReqToSouBid_Send") || interfaceId.equals("EAS_PurReqToSouBid_Send")) {
            lcNumber = "1072267248137209856";
        } else if (interfaceId.equals("EAS_PurReqToProject_Send")) {
            lcNumber = "1381377821481495552";
        }
        if (interfaceId.equals("EAS_BatchPurRequestForPurQuo_Send") || interfaceId.equals("EAS_BatchPurReqToSouBid_Send") || interfaceId.equals("EAS_PurReqToProject_Send")) {
            PurRequestInfo info = ISCWebServiceUtil.getPurRequestInfo(ctx, (String[])pks);
            Map<String, Object> infoMap = ISCWebServiceUtil.getMapForInfo(ctx, info);
            ISCWebServiceUtil.send2Isc(ctx, lcNumber, infoMap);
        } else if (interfaceId.equals("EAS_PurRequestForPurQuo_Send") || interfaceId.equals("EAS_PurReqToSouBid_Send")) {
            PurRequestCollection requestCollection = ISCWebServiceUtil.getRequestCollection(ctx, (String[])pks);
            int size = requestCollection.size();
            for (int i = 0; i < size; ++i) {
                PurRequestInfo purRequestInfo = requestCollection.get(i);
                Map<String, Object> infoMap = ISCWebServiceUtil.getMapForInfo(ctx, purRequestInfo);
                ISCWebServiceUtil.send2Isc(ctx, lcNumber, infoMap);
            }
        } else {
            if (null == apiMap.get(interfaceId)) {
                return null;
            }
            try {
                SrmLoggerHelpers.setBizRemark((String)("\u5f02\u6b65\u8c03\u7528\u82cd\u7a79\u7684\u63a5\u53e3,\u4f20\u51fa\u6570\u636e\uff1a" + Arrays.toString(pks)));
                SrmLoggerHelpers.setRelationBill((String)pks[0]);
                for (int i = 0; i < pks.length; ++i) {
                    ISCHelper.proxy((Context)ctx, (BOSObjectType)new BOSObjectType(apiMap.get(interfaceId)), (String)pks[i], (String)methodMap.get(interfaceId));
                }
            }
            catch (Throwable throwable) {
                SrmLoggerHelpers.setErrorMsg((String)throwable.getCause().toString());
            }
        }
        return null;
    }

    private static void send2Isc(Context ctx, String lcNumber, Map<String, Object> infoMap) {
        String dataCenter = ctx.getAIS();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowDef", lcNumber);
        params.put("data", infoMap);
        params.put("command", "CreateFlowInstService");
        String s = Kson.getGson().toJson(infoMap);
        SrmLoggerHelpers.setBizRemark((String)("\u8c03\u7528\u82cd\u7a79\u7684\u63a5\u53e3,\u4f20\u51fa\u6570\u636e\uff1a" + s.substring(0, 1200)));
        SrmLoggerHelpers.setRelationBill((String)infoMap.get("id").toString());
        try {
            String className = "kd.isc.iscb.util.connector.server.ConnectorCallback";
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("call", String.class, String.class, Map.class);
            Object invoke = method.invoke(null, dataCenter, "CreateFlowInstService", params);
            String res = Kson.getGson().toJson(invoke);
            SrmLoggerHelpers.setBizRemark((String)("\u6570\u636e\u5230\u8fbe\u82cd\u7a79\uff0c\u63a5\u53d7\u5230\u82cd\u7a79\u7684\u5f02\u6b65\u4efb\u52a1id\uff1a" + res));
        }
        catch (Exception e) {
            SrmLoggerHelpers.setErrorMsg((String)e.getCause().toString());
        }
    }

    private static PurRequestInfo getPurRequestInfo(Context ctx, String[] pks) throws BOSException {
        PurRequestCollection col = ISCWebServiceUtil.getRequestCollection(ctx, pks);
        PurRequestInfo info = (PurRequestInfo)col.get(0).clone();
        info.getEntries().clear();
        int index = 1;
        for (int i = 0; i < col.size(); ++i) {
            PurRequestInfo info1 = col.get(i);
            for (int j = 0; j < info1.getEntries().size(); ++j) {
                PurRequestEntryInfo entryInfo = info1.getEntries().get(j);
                if (!"1".equals(entryInfo.get("syncSta"))) continue;
                entryInfo.setSeq(index);
                info.getEntries().add(entryInfo);
                ++index;
            }
        }
        return info;
    }

    private static PurRequestCollection getRequestCollection(Context ctx, String[] pks) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(pks)), CompareType.INCLUDE));
        evi.setFilter(filter);
        PurRequestCollection col = PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestCollection(evi);
        return col;
    }

    private static Map<String, Object> getMapForInfo(Context ctx, PurRequestInfo info) {
        PropertyInfo property;
        int i;
        EntityObjectInfo en = CommonUtils.getEntityByBosType((Context)ctx, (String)"25428F2E");
        Enumeration s = info.keys();
        PropertyCollection prosCol = (PropertyCollection)en.get("properties");
        HashMap<String, String> headProMap = new HashMap<String, String>();
        HashMap<String, String> headEntryProMap = new HashMap<String, String>();
        for (i = 0; i < prosCol.size(); ++i) {
            property = prosCol.get(i);
            headProMap.put(property.getName().toLowerCase(), property.getName());
        }
        en = CommonUtils.getEntityByBosType((Context)ctx, (String)"2B7DD5E4");
        prosCol = (PropertyCollection)en.get("properties");
        for (i = 0; i < prosCol.size(); ++i) {
            property = prosCol.get(i);
            headEntryProMap.put(property.getName().toLowerCase(), property.getName());
        }
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        while (s.hasMoreElements()) {
            Object value;
            String pro = s.nextElement().toString();
            String pro1 = (String)headProMap.get(pro);
            if (pro1 != null) {
                pro = pro1;
            }
            if ((value = info.get(pro)) instanceof IObjectValue) {
                IObjectValue obj = (IObjectValue)value;
                infoMap.put(pro, obj.get("id"));
                continue;
            }
            if (value instanceof IObjectCollection) {
                PurRequestEntryCollection entryCol = (PurRequestEntryCollection)value;
                ArrayList entryList = new ArrayList();
                for (int i2 = 0; i2 < entryCol.size(); ++i2) {
                    PurRequestEntryInfo entry = entryCol.get(i2);
                    Enumeration entryEnum = entry.keys();
                    HashMap<String, Object> entryMap = new HashMap<String, Object>();
                    while (entryEnum.hasMoreElements()) {
                        String entrypro = entryEnum.nextElement().toString();
                        String entrypro1 = (String)headEntryProMap.get(entrypro);
                        if (entrypro1 != null) {
                            entrypro = entrypro1;
                        }
                        if (entry.get(entrypro) instanceof IObjectValue) {
                            IObjectValue entryobj = (IObjectValue)entry.get(entrypro);
                            entryMap.put(entrypro, entryobj.get("id"));
                            continue;
                        }
                        entryMap.put(entrypro, entry.get(entrypro));
                    }
                    entryList.add(entryMap);
                }
                infoMap.put(pro, entryList);
                continue;
            }
            infoMap.put(pro, value);
        }
        return infoMap;
    }

    static {
        apiMap.put("EAS_PurOrder_Sync_Send", "3171BFAD");
        apiMap.put("EAS_PurInWarehsBill_Sync_Send", "783061E3");
        apiMap.put("EAS_PaymentBill_Sync_Send", "40284E81");
        apiMap.put("EAS_IerpPurReturns_Sync_Send", "783061E3");
        apiMap.put("EAS_PurReceivalBill_Sync_Send", "15F2BD83");
        apiMap.put("EAS_PurReturns_Sync_Send", "256D05E2");
        apiMap.put("EAS_PurOrder_Alert_Sync_Send", "3171BFAD");
        apiMap.put("EAS_PayRequestBill_Sync_Send", "D001019A");
        apiMap.put("EAS_PurInWarehsBill_Del_Send", "783061E3");
        apiMap.put("EAS_PaymentBill_Del_Send", "40284E81");
        apiMap.put("EAS_IerpPurReturns_Del_Send", "783061E3");
        apiMap.put("EAS_PurReturns_Del_Send", "256D05E2");
        apiMap.put("EAS_PurReceivalBill_Del_Send", "15F2BD83");
        apiMap.put("EAS_PurOrder_Del_Send", "3171BFAD");
        apiMap.put("EAS_PayRequestBill_Del_Send", "D001019A");
        apiMap.put("EAS_PurOrderAlert_Del_Send", "3171BFAD");
        apiMap.put("EAS_OtherBill_Sync_Send", "48DA3A71");
        apiMap.put("EAS_PurRequestForPurQuo_Send", "25428F2E");
        apiMap.put("EAS_BatchPurRequestForPurQuo_Send", "25428F2E");
        apiMap.put("EAS_PurReqToSouBid_Send", "25428F2E");
        apiMap.put("EAS_BatchPurReqToSouBid_Send", "25428F2E");
        apiMap.put("EAS_OtherBill_Sync_Send", "48DA3A71");
        apiMap.put("EAS_OtherBill_Del_Send", "48DA3A71");
        apiMap.put("EAS_PurOrder_ClearSou_Send", "3171BFAD");
        apiMap.put("Sys_PurInwarehs_UnWriteOffQty", "783061E3");
        methodMap.put("EAS_OtherBill_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_OtherBill_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurOrder_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurInWarehsBill_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PaymentBill_Sync_Send", " pay2IERP(ObjectPK arg1)");
        methodMap.put("EAS_IerpPurReturns_Sync_Send", " auditReturn2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurReceivalBill_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurReturns_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurOrder_Alert_Sync_Send", " alert2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PayRequestBill_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurInWarehsBill_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PaymentBill_Del_Send", " cancelPay2IERP(ObjectPK arg1)");
        methodMap.put("EAS_IerpPurReturns_Del_Send", " unAuditReturn2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurReturns_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurReceivalBill_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurOrder_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PayRequestBill_Del_Send", " unAudit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurOrderAlert_Del_Send", " alert2DeleteIERP(ObjectPK arg1)");
        methodMap.put("EAS_OtherBill_Sync_Send", " audit2IERP(ObjectPK arg1)");
        methodMap.put("EAS_PurRequestForPurQuo_Send", " handSendInquiry(ObjectPK arg1)");
        methodMap.put("EAS_BatchPurRequestForPurQuo_Send", "handBatchSendInquiry(java.util.List arg1)");
        methodMap.put("EAS_PurReqToSouBid_Send", " handSendBid(ObjectPK arg1)");
        methodMap.put("EAS_BatchPurReqToSouBid_Send", "handBatchSendBid(java.util.List arg1)");
        methodMap.put("EAS_PurOrder_ClearSou_Send", " deleteClear(ObjectPK arg1)");
        methodMap.put("Sys_PurInwarehs_UnWriteOffQty", " synUnWriteOffQty(ObjectPK arg1)");
    }
}

