/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.calculate.AbstractCal;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import java.math.BigDecimal;

public class PurOrderCal
extends AbstractCal {
    public PurOrderCal() {
        this.initFiledValue();
    }

    @Override
    protected void initFiledValue() {
        this.setACTUALPRICE("actualPrice");
        this.setACTUALTAXPRICE("actualTaxPrice");
        this.setAMOUNT("amount");
        this.setCONTAINTAX("isInTax");
        this.setDISCOUNT("discountRate");
        this.setDISCOUNTAMOUNT("discountAmount");
        this.setHEAD_AMOUNT("totalAmount");
        this.setHEAD_LOCALAMOUNT("localTotalAmount");
        this.setHEAD_TAX("totalTax");
        this.setHEAD_TAXAMOUNT("totalTaxAmount");
        this.setHEAD_LOCALTAXAMOUNT("localTotalTaxAmount");
        this.setISPRICE_EXCLUDE_TAX("isPriceInTax");
        this.setPRICE("price");
        this.setQTY("qty");
        this.setTAX("tax");
        this.setTAXAMOUNT("taxAmount");
        this.setTAXPRICE("taxPrice");
        this.setTAXRATE("taxRate");
        this.setLOCALAMOUNT("localAmount");
        this.setLOCALTAXAMOUNT("localTaxAmount");
    }

    @Override
    protected AbstractObjectCollection getEntry(SCMBillBaseInfo info) {
        AbstractObjectCollection col = null;
        try {
            if (info.getClass().newInstance() instanceof PurOrderInfo || info.getClass().newInstance() instanceof SubContractOrderInfo) {
                col = (AbstractObjectCollection)info.get("entries");
            }
        }
        catch (InstantiationException e) {
            Logger.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logger.error((Throwable)e);
        }
        return col;
    }

    @Override
    public void calEntryPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        if (!containTax) {
            return;
        }
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE).scale();
        BigDecimal price = null;
        boolean is_price_exclude_tax = this.getHeadBooleanValue(info, this.ISPRICE_EXCLUDE_TAX);
        price = is_price_exclude_tax ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        entryInfo.put(this.PRICE, (Object)price);
    }

    @Override
    public void calEntryTaxPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal price = this.getEntryBigDecimalValue(entryInfo, this.PRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE).scale();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        entryInfo.put(this.TAXPRICE, (Object)taxPrice);
    }

    public void calPrepayment(PurOrderInfo info) {
        PurOrderEntryInfo poe = null;
        BigDecimal prepaymentRate = info.getPrepaymentRate();
        prepaymentRate = prepaymentRate == null ? SCMConstant.BIGDECIMAL_ZERO : prepaymentRate;
        BigDecimal taxAmount = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal prepayment = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal preReceived = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal unPreReceived = SCMConstant.BIGDECIMAL_ZERO;
        CurrencyInfo currencyInfo = null;
        if (info.getCurrency() != null) {
            currencyInfo = info.getCurrency();
        }
        int scale = 0;
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        BigDecimal HUNDRED = new BigDecimal("100.00");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            poe = info.getEntries().get(i);
            taxAmount = poe.getTaxAmount();
            taxAmount = taxAmount == null ? SCMConstant.BIGDECIMAL_ZERO : taxAmount;
            prepayment = taxAmount.multiply(prepaymentRate).divide(HUNDRED, scale, 4);
            preReceived = poe.getPreReceived();
            preReceived = preReceived == null ? SCMConstant.BIGDECIMAL_ZERO : preReceived;
            unPreReceived = prepayment.subtract(preReceived);
            poe.setPrepayment(prepayment);
            poe.setUnPrereceivedAm(unPreReceived);
            if (poe.getTotalReqPayAmt() == null) {
                poe.setTotalReqPayAmt(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (poe.getTotalPrePayAmt() == null) {
                poe.setTotalPrePayAmt(SCMConstant.BIGDECIMAL_ZERO);
            }
            poe.setIsReqPrePayGTprePay(1);
        }
        prepayment = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal entryPrepayment = SCMConstant.BIGDECIMAL_ZERO;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            poe = info.getEntries().get(i);
            entryPrepayment = poe.getPrepayment();
            if (entryPrepayment == null) continue;
            prepayment = prepayment.add(entryPrepayment);
        }
        info.setPrepayment(prepayment);
    }

    public static PurPriceParam getPriceParam(int seq, PurOrderInfo info, PurOrderEntryInfo entryInfo) {
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("510b6503-0105-1000-e000-010bc0a812fd463ED552");
        param.setSeq(seq);
        param.setPurOrgUnitId(info.getPurchaseOrgUnit() != null ? info.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(info.getSupplier() != null ? info.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        param.setMaterialPurchaseType(0);
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        param.setDeliveryDate(entryInfo.getDeliveryDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setBizTypeId(info.getBizType() != null ? info.getBizType().getId().toString() : null);
        param.setRecOrgUnitId(entryInfo.getStorageOrgUnit() != null ? entryInfo.getStorageOrgUnit().getId().toString() : null);
        return param;
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getRemoteInstance().getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    public void calcLocalAmount(PurOrderInfo info, CurrencyInfo baseCurrencyInfo) throws BOSException, EASBizException {
        BigDecimal ZERO = SysConstant.BIGZERO;
        CurrencyInfo currencyInfo = null;
        currencyInfo = info.getCurrency() != null ? info.getCurrency() : baseCurrencyInfo;
        ExchangeRateInfo exchangeRateInfo = PurOrderCal.getExchangeRate(info.getCompany(), (IObjectPK)new ObjectUuidPK(currencyInfo.getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
        BigDecimal exchangeRate = info.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = exchangeRateInfo.getExchangeAux();
        int localScale = baseCurrencyInfo.getPrecision();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurOrderEntryCollection collection = info.getEntries();
        PurOrderEntryInfo entryInfo = null;
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            BigDecimal amount = entryInfo.getAmount() != null ? entryInfo.getAmount() : ZERO;
            BigDecimal tax = entryInfo.getTax() != null ? entryInfo.getTax() : ZERO;
            BigDecimal taxAmount = entryInfo.getTaxAmount() != null ? entryInfo.getTaxAmount() : ZERO;
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            BigDecimal localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            BigDecimal localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            BigDecimal localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            entryInfo.setLocalAmount(localAmount);
            entryInfo.setLocalTax(localTax);
            entryInfo.setLocalTaxAmount(localTaxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }
}

