/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.PurOrderCal;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class purFetchPriceUtils {
    private Map<String, MaterialInfo> setMaterialCache(Context ctx, IObjectCollection collection) throws BOSException {
        HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
        HashSet<String> materialIdSet = new HashSet<String>();
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurOrderInfo)collection.getObject(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = info.getEntries().get(j);
                materialInfo = entryInfo.getMaterial();
                if (materialInfo == null) continue;
                materialIdSet.add(materialInfo.getId().toString());
            }
        }
        if (materialIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("pricePrecision"));
            view.setSelector(selector);
            MaterialCollection materials = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            for (int k = 0; k < materials.size(); ++k) {
                materialMap.put(materials.get(k).getId().toString(), materials.get(k));
            }
        }
        return materialMap;
    }

    public void fetchPrice(Context ctx, IObjectCollection collection, boolean isIgnorePlanOrder) throws BOSException, EASBizException {
        int i;
        PurEntryDataVO scmEntryDataVO = new PurEntryDataVO();
        SCMBizDataVO paramScmBizDataVO = null;
        SCMBizDataVO resultScmBizDataVO = null;
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        PurOrderInfo info = null;
        int n = collection.size();
        for (int i2 = 0; i2 < n; ++i2) {
            info = (PurOrderInfo)collection.getObject(i2);
            paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, info);
            resultScmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            scmEntryDataVO = this.getEntryDataVO(ctx, scmGroupFacade, info, scmEntryDataVO);
        }
        Map<String, MaterialInfo> materialMap = this.setMaterialCache(ctx, collection);
        PurOrderEntryInfo entryInfo = null;
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("510b6503-0105-1000-e000-010bc0a812fd463ED552");
        int orderBaseSeq = 10000;
        int calcPriceMode = 0;
        for (i = 0; i < collection.size(); ++i) {
            info = (PurOrderInfo)collection.getObject(i);
            if (this.isBotpBill(info, "9XXvbVGlRtym/0qtqeIXXrhE1B8=") && isIgnorePlanOrder || this.isBotpBill(info, "aErYRJ8ShO3gQKjACw4w8MtHWDQ=") || this.isBotpBill(info, "510b6503-0105-1000-e000-010bc0a814fd463ED552") || this.isBotpBill(info, "510b6503-0105-1000-e000-010bc0b814fd463ED552") || info.getSupplier() == null) continue;
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = info.getEntries().get(j);
                if (entryInfo.getMaterial() == null || entryInfo.isIsPresent()) continue;
                if (entryInfo.getPrice() != null || entryInfo.getTaxPrice() != null) {
                    this.calcByConfigPrice(info, entryInfo, calcPriceMode, materialMap);
                    continue;
                }
                paramCol.setBizTypeId(info.getBizType() != null ? info.getBizType().getId().toString() : null);
                int seq = orderBaseSeq * (i + 1) + j;
                PurPriceParam param = PurOrderCal.getPriceParam(seq, info, entryInfo);
                paramCol.addPurPriceParam(param);
            }
        }
        if (paramCol.size() > 0) {
            PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
            for (int i3 = 0; i3 < collection.size(); ++i3) {
                info = (PurOrderInfo)collection.getObject(i3);
                for (int j = 0; j < info.getEntries().size(); ++j) {
                    entryInfo = info.getEntries().get(j);
                    int seq = orderBaseSeq * (i3 + 1) + j;
                    PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
                    if (priceInfo == null || priceInfo.getPrice() == null) continue;
                    PurOrderCal purorderCal = new PurOrderCal();
                    purorderCal.setInTax(priceInfo.isInTaxPrice());
                    if (priceInfo.getTaxRate() != null) {
                        entryInfo.setTaxRate(priceInfo.getTaxRate().setScale(2));
                    }
                    if (priceInfo.getDiscountRate() != null) {
                        entryInfo.setDiscountRate(priceInfo.getDiscountRate());
                    }
                    this.setPrecision(materialMap, info, entryInfo);
                    if (priceInfo.isInTaxPrice()) {
                        entryInfo.setTaxPrice(priceInfo.getPrice());
                        purorderCal.calByEntryTaxPriceChange(info, entryInfo);
                        continue;
                    }
                    entryInfo.setPrice(priceInfo.getPrice());
                    purorderCal.calByEntryPriceChange(info, entryInfo);
                }
            }
        }
        for (i = 0; i < collection.size(); ++i) {
            info = (PurOrderInfo)collection.getObject(i);
            if (this.isBotpBill(info, "9XXvbVGlRtym/0qtqeIXXrhE1B8=")) continue;
            scmEntryDataVO = this.getEntryDataVO(ctx, scmGroupFacade, info, scmEntryDataVO);
            this.calcLocalAmount(ctx, info, (SCMEntryDataVO)scmEntryDataVO, scmEntryDataVO.getBaseCurrencyInfo(), materialMap);
        }
    }

    protected void calcLocalAmount(Context ctx, PurOrderInfo info, SCMEntryDataVO vo, CurrencyInfo baseCurrencyInfo, Map materialMap) throws BOSException, EASBizException {
        BigDecimal ZERO = SysConstant.BIGZERO;
        CurrencyInfo currencyInfo = null;
        currencyInfo = info.getCurrency() != null ? info.getCurrency() : baseCurrencyInfo;
        BigDecimal exchangeRate = info.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = vo.getExchangeAuxInfo();
        if (baseCurrencyInfo == null) {
            baseCurrencyInfo = currencyInfo;
        }
        int localScale = baseCurrencyInfo.getPrecision();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurOrderEntryCollection collection = info.getEntries();
        PurOrderEntryInfo entryInfo = null;
        Object materialInfo = null;
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            BigDecimal amount = entryInfo.getAmount() != null ? entryInfo.getAmount() : ZERO;
            BigDecimal tax = entryInfo.getTax() != null ? entryInfo.getTax() : ZERO;
            BigDecimal taxAmount = entryInfo.getTaxAmount() != null ? entryInfo.getTaxAmount() : ZERO;
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            BigDecimal localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            BigDecimal localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            BigDecimal localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            entryInfo.setLocalAmount(localAmount);
            entryInfo.setLocalTax(localTax);
            entryInfo.setLocalTaxAmount(localTaxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }

    private void calcByConfigPrice(PurOrderInfo info, PurOrderEntryInfo entryInfo, int calcPriceMode, Map materialMap) {
        PurOrderCal purorderCal = new PurOrderCal();
        MaterialInfo materialInfo = (MaterialInfo)materialMap.get(entryInfo.getMaterial().getId().toString());
        if (entryInfo.getPrice() == null && entryInfo.getTaxPrice() != null) {
            calcPriceMode = 1;
        }
        if (entryInfo.getPrice() != null && entryInfo.getTaxPrice() == null) {
            calcPriceMode = 0;
        }
        if (entryInfo.getPrice() != null && entryInfo.getTaxPrice() != null) {
            calcPriceMode = info.isIsInTax() ? 1 : 0;
        }
        BigDecimal zero = new BigDecimal("0.00000000");
        if (info.getCurrency() != null) {
            BigDecimal amountWithPrecision = zero.setScale(info.getCurrency().getPrecision(), 4);
            entryInfo.setTaxAmount(amountWithPrecision);
            entryInfo.setAmount(amountWithPrecision);
            entryInfo.setDiscountAmount(amountWithPrecision);
        }
        entryInfo.setActualPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        entryInfo.setActualTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        if (calcPriceMode == 1) {
            purorderCal.setInTax(true);
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(materialInfo.getPricePrecision(), 4));
            entryInfo.setPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
            purorderCal.calByEntryTaxPriceChange(info, entryInfo);
        } else {
            entryInfo.setPrice(entryInfo.getPrice().setScale(materialInfo.getPricePrecision(), 4));
            entryInfo.setTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
            purorderCal.calByEntryPriceChange(info, entryInfo);
        }
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (this.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    private void setPrecision(Map materialMap, PurOrderInfo info, PurOrderEntryInfo entryInfo) {
        BigDecimal zero = new BigDecimal("0.00000000");
        if (info.getCurrency() != null) {
            BigDecimal amountWithPrecision = zero.setScale(info.getCurrency().getPrecision(), 4);
            entryInfo.setTaxAmount(amountWithPrecision);
            entryInfo.setAmount(amountWithPrecision);
            entryInfo.setDiscountAmount(amountWithPrecision);
        }
        MaterialInfo materialInfo = (MaterialInfo)materialMap.get(entryInfo.getMaterial().getId().toString());
        entryInfo.setPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        entryInfo.setTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        entryInfo.setActualPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        entryInfo.setActualTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
    }

    private PurEntryDataVO getEntryDataVO(Context ctx, ISCMGroupFacade scmGroupFacade, PurOrderInfo info, PurEntryDataVO scmEntryDataVO) throws BOSException, EASBizException {
        scmEntryDataVO.setMainOrg(this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info));
        scmEntryDataVO.setMainOrgType(this.getMainBizOrgType());
        scmEntryDataVO = (PurEntryDataVO)this.loadScmEntryBizDate(scmGroupFacade, info, (SCMEntryDataVO)scmEntryDataVO);
        return scmEntryDataVO;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected SCMEntryDataVO loadScmEntryBizDate(ISCMGroupFacade scmGroupFacade, PurOrderInfo info, SCMEntryDataVO purEntryDataVO) throws BOSException, EASBizException {
        int m = info.getEntries().size();
        MaterialInfo[] materialInfos = new MaterialInfo[m];
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[m];
        MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[m];
        MeasureUnitInfo[] assistUnitInfos = new MeasureUnitInfo[m];
        for (int k = 0; k < m; ++k) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)info.getEntries().getObject(k);
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (materialInfo != null) {
                materialInfos[k] = materialInfo;
            }
            if (materialInfo != null && unitInfo != null) {
                unitInfos[k] = unitInfo;
            }
            if (materialInfo != null && baseunitInfo != null) {
                baseUnitInfos[k] = baseunitInfo;
            }
            if (materialInfo == null || assistUnitInfo == null) continue;
            assistUnitInfos[k] = assistUnitInfo;
        }
        purEntryDataVO.setIsLoadingCurrency(true);
        purEntryDataVO.setIsLoadingMou(true);
        purEntryDataVO.setIsLoadingMmuPrecision(true);
        purEntryDataVO.setMaterialInfos(materialInfos);
        purEntryDataVO.setMeasureUnitInfos(unitInfos);
        purEntryDataVO.setBaseMeasureUnitInfos(baseUnitInfos);
        purEntryDataVO.setAssistMeasureUnitInfos(assistUnitInfos);
        purEntryDataVO.setCurrencyInfo(info.getCurrency());
        purEntryDataVO.setCompanyOrgUnitInfo(info.getCompanyOrgUnit());
        purEntryDataVO = scmGroupFacade.loadComplexData(purEntryDataVO);
        return purEntryDataVO;
    }

    protected UserInfo getLoginUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, PurOrderInfo info) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(info.getBOSType().toString());
        scmBizDataVO.setDelegatedOrgTypes(this.getDelegatedOrgTypes());
        PurEntryDataVO scmEntryDataVO = new PurEntryDataVO();
        scmEntryDataVO.setCurrencyInfo(info.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmEntryDataVO.setIsLoadingMou(true);
        scmEntryDataVO.setIsLoadingMmuPrecision(true);
        scmEntryDataVO.setMainOrgType(this.getMainBizOrgType());
        scmEntryDataVO.setMainOrg(this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info));
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        scmBizDataVO.setParameters(new String[]{"PURSUP004", "PURSUP005", "PURORDER001", "PURSUP001", "PURORDER002", "PURORDER003", "PURSUP003", "PURORDER004", "PURSUP002", "PURORDER005", "PURORDERALTER3", "PURORDER006", "PURORDER007", "PURSUP008"});
        this.initSCMBizDataVO(ctx, scmBizDataVO, info.getEntries());
        return scmBizDataVO;
    }

    protected SCMBizDataVO initSCMBizDataVO(Context ctx, SCMBizDataVO scmBizDataVO, AbstractObjectCollection entries) {
        Object scmEntryDataVO = scmBizDataVO.getScmEntryDataVO();
        if (scmEntryDataVO == null) {
            OrgType orgType = this.getMainBizOrgType();
            scmEntryDataVO = orgType.getValue() == 2 ? new SaleOrderDataVO() : (orgType.getValue() == 3 ? new PurEntryDataVO() : new SCMEntryDataVO());
        }
        int n = entries.size();
        MaterialInfo[] materialInfos = new MaterialInfo[n];
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[n];
        MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[n];
        MeasureUnitInfo[] assistUnitInfos = new MeasureUnitInfo[n];
        for (int i = 0; i < n; ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (materialInfo != null) {
                materialInfos[i] = materialInfo;
            }
            if (materialInfo != null && unitInfo != null) {
                unitInfos[i] = unitInfo;
            }
            if (materialInfo != null && baseunitInfo != null) {
                baseUnitInfos[i] = baseunitInfo;
            }
            if (materialInfo == null || assistUnitInfo == null) continue;
            assistUnitInfos[i] = assistUnitInfo;
        }
        scmEntryDataVO.setMaterialInfos(materialInfos);
        scmEntryDataVO.setMeasureUnitInfos(unitInfos);
        scmEntryDataVO.setBaseMeasureUnitInfos(baseUnitInfos);
        scmEntryDataVO.setAssistMeasureUnitInfos(assistUnitInfos);
        scmBizDataVO.setScmEntryDataVO(scmEntryDataVO);
        return scmBizDataVO;
    }

    protected HashSet getDelegatedOrgTypes() {
        HashSet<OrgType> delegateOrgTypeSet = new HashSet<OrgType>();
        delegateOrgTypeSet.add(OrgType.Admin);
        delegateOrgTypeSet.add(OrgType.Company);
        delegateOrgTypeSet.add(OrgType.Storage);
        return delegateOrgTypeSet;
    }
}

