/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.client.AbstractManulAssign4QtyUI;
import com.kingdee.eas.scm.sm.pur.client.QuotaAllocationForProjectUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ManulAssign4QtyUI
extends AbstractManulAssign4QtyUI {
    private static final Logger logger = CoreUIObject.getLogger(ManulAssign4QtyUI.class);
    protected F7ContextManager f7Manager = null;
    Map<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
    private Map<String, ApprovedSupplierInfo> supplierQuotaCol = new HashMap<String, ApprovedSupplierInfo>();
    private Map<String, MaterialPurchasingInfo> materialPurInfoCol = new HashMap<String, MaterialPurchasingInfo>();

    public ManulAssign4QtyUI() throws Exception {
        this.tblmain.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        KDFormattedTextField qtyTxtField = new KDFormattedTextField();
        qtyTxtField.setDataType(1);
        qtyTxtField.setNegatived(false);
        qtyTxtField.setMaximumIntegerDigits(12);
        KDTDefaultCellEditor qty_CellEditor = new KDTDefaultCellEditor((JTextField)qtyTxtField);
        this.tblmain.getColumn("assignQty").setEditor((ICellEditor)qty_CellEditor);
        KDBizPromptBox prmtSupplier = this.getBizSupplierF7(this.tblmain.getColumn("supplier"));
        prmtSupplier.setDisplayFormat("$name$");
        prmtSupplier.setEditFormat("$name$");
        KDTDefaultCellEditor bizsupplierEditor = new KDTDefaultCellEditor((IKDEditor)prmtSupplier);
        ObjectValueRender avrSupplier = new ObjectValueRender();
        avrSupplier.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblmain.getColumn("supplier").setEditor((ICellEditor)bizsupplierEditor);
        PurchaseOrgUnitInfo purorg = (PurchaseOrgUnitInfo)this.getUIContext().get("purorg");
        this.prmtPurchaseOrgUnit.setValue((Object)purorg);
        this.initData();
        this.addListeners();
    }

    protected KDBizPromptBox getBizSupplierF7(IColumn col) {
        KDBizPromptBox bizSupplierBox = new KDBizPromptBox();
        bizSupplierBox.setEditable(true);
        bizSupplierBox.setEditFormat("$number$");
        bizSupplierBox.setDisplayFormat("$name$");
        bizSupplierBox.setCommitFormat("$number$;$mnemonicCode$;$name$;");
        OrgUnitInfo purOrg = (OrgUnitInfo)this.getUIContext().get(OrgType.Purchase);
        this.f7Manager.registerBizSupplierF7(bizSupplierBox, col, null, purOrg);
        return bizSupplierBox;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    private void addListeners() {
        KDTEditAdapter entryTableChange = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ManulAssign4QtyUI.this.tblmain_ChangedStarting(e);
                }
                catch (Exception ex) {
                    ManulAssign4QtyUI.this.handUIException(ex);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    ManulAssign4QtyUI.this.tblmain_ChangedStopped(e);
                }
                catch (Exception exc) {
                    ManulAssign4QtyUI.this.handUIException(exc);
                }
            }
        };
        this.tblmain.addKDTEditListener((KDTEditListener)entryTableChange);
    }

    protected void tblmain_ChangedStarting(KDTEditEvent e) throws Exception {
    }

    protected void tblmain_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        String fieldName = this.tblmain.getColumnKey(colIndex);
        if ("assignQty".equals(fieldName)) {
            if (e.getValue() == null) {
                this.tblmain.getCell(rowIndex, "assignQty").setValue(e.getOldValue());
                SysUtil.abort();
            }
            BigDecimal newQty = (BigDecimal)e.getValue();
            BigDecimal oldQty = (BigDecimal)e.getOldValue();
            BigDecimal totalQty = (BigDecimal)this.tblmain.getCell(rowIndex, "totalqty").getValue();
            String key = this.tblmain.getCell(rowIndex, "key").getValue().toString();
            BigDecimal totalAssignQty = this.qtyMap.get(key);
            if ((totalAssignQty = totalAssignQty.add(newQty).subtract(oldQty)).compareTo(totalQty) > 0 || newQty.compareTo(totalAssignQty) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ALLOCATIONQTY_CANT_GREATERTHAN_BILLHELDQTY"));
                this.tblmain.getCell(rowIndex, "assignQty").setValue(e.getOldValue());
                totalAssignQty = totalAssignQty.add(oldQty).subtract(newQty);
            }
            int precision = totalQty.scale();
            if (totalAssignQty.compareTo(totalQty) < 0) {
                IRow row = this.copyLine(rowIndex + 1, this.tblmain.getRow(rowIndex), precision);
                row.getCell("assignQty").setValue((Object)totalQty.subtract(totalAssignQty));
                totalAssignQty = totalQty;
            }
            this.qtyMap.put(key, totalAssignQty);
        }
    }

    private IRow copyLine(int rowindex, IRow oldRow, int precision) {
        IRow row = this.tblmain.addRow(rowindex);
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.tblmain, (String[])new String[]{"assignQty"}, (boolean)false);
        int qtyIndex = row.getCell("assignQty").getColumnIndex();
        for (int cellIndex = 0; cellIndex < this.tblmain.getColumnCount(); ++cellIndex) {
            ICell copyFromCell = oldRow.getCell(cellIndex);
            ICell copyToCell = row.getCell(cellIndex);
            if (cellIndex == qtyIndex) {
                copyToCell.setValue((Object)new BigDecimal("0.0"));
                continue;
            }
            if (copyFromCell == null || copyToCell == null) continue;
            Object orgValue = copyFromCell.getValue();
            copyToCell.setValue(orgValue);
        }
        return row;
    }

    private void initData() throws BOSException {
        QuotaVOCollection col = (QuotaVOCollection)this.getUIContext().get("quotaVOCollection");
        this.initMaterialPurchasing(col);
        this.initSupplierQuota(col);
        QuotaVO vo = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            vo = col.getQuotaVO(i);
            IRow quoRow = this.tblmain.addRow();
            SCMClientUtils.changeTableColPrecision((int)vo.getEntryQty().scale(), (KDTable)this.tblmain, (String[])new String[]{"assignQty"}, (boolean)false);
            this.setCellValue(i, quoRow, vo);
            this.qtyMap.put(vo.getSrcBillId() + vo.getMinseq() + vo.getMaxseq(), vo.getEntryQty());
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int beginBlockRow;
        KDTable table = this.tblmain;
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0 && table.getRowCount() > 0) {
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
        BigDecimal totalQty = (BigDecimal)this.tblmain.getCell(beginBlockRow, "totalqty").getValue();
        this.copyLine(beginBlockRow + 1, this.tblmain.getRow(beginBlockRow), totalQty.scale());
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblmain.getSelectManager();
        if (selectManager.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.tblmain.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                BigDecimal assignQty = (BigDecimal)this.tblmain.getCell(rowIndex, "assignQty").getValue();
                String key = this.tblmain.getCell(rowIndex, "key").getValue().toString();
                BigDecimal totalAssignQty = this.qtyMap.get(key);
                totalAssignQty = totalAssignQty.subtract(assignQty);
                this.qtyMap.put(key, totalAssignQty);
                this.tblmain.removeRow(rowIndex);
            }
            if (this.tblmain.getRow(0) != null) {
                this.tblmain.getSelectManager().select(0, 0);
            }
        }
    }

    private void setCellValue(int index, IRow quoRow, QuotaVO vo) {
        quoRow.getCell("material.number").setValue((Object)vo.getMaterialnumber());
        quoRow.getCell("material.name").setValue((Object)vo.getMaterialname());
        quoRow.getCell("material.model").setValue((Object)vo.getMaterialmodel());
        quoRow.getCell("unit").setValue((Object)vo.getUnitname());
        quoRow.getCell("assignQty").setValue((Object)vo.getEntryQty());
        quoRow.getCell("supplier").setValue((Object)vo.getSupplier());
        if (vo.getProjectid() != null) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(BOSUuid.read((String)vo.getProjectid()));
            projectInfo.setName(vo.getProjectname());
            quoRow.getCell("project").setValue((Object)projectInfo);
        }
        quoRow.getCell("billid").setValue((Object)vo.getSrcBillId());
        quoRow.getCell("totalqty").setValue((Object)vo.getEntryQty());
        quoRow.getCell("assignPriority").setValue((Object)new BigDecimal("100.0"));
        quoRow.getCell("minseq").setValue((Object)vo.getMinseq());
        quoRow.getCell("maxseq").setValue((Object)vo.getMaxseq());
        quoRow.getCell("key").setValue((Object)(vo.getSrcBillId() + vo.getMinseq() + vo.getMaxseq()));
    }

    @Override
    public void actionCheckData_actionPerformed(ActionEvent e) throws Exception {
    }

    private void checkData() {
        StringBuffer msg = new StringBuffer();
        int size = this.tblmain.getRowCount();
        for (int i = 0; i < size; ++i) {
            SupplierInfo supplier = (SupplierInfo)this.tblmain.getRow(i).getCell("supplier").getValue();
            if (supplier != null && supplier.getId() != null) continue;
            msg.append(i + 1).append(",");
        }
        if (msg.length() > 0) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"SOME_SUPPLIER_CANT_ENTER"), (String)(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ROW_SEQ") + msg.substring(0, msg.length() - 2)));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String materialname;
        this.checkData();
        QuotaVO vo = null;
        Map quotaMap = (Map)this.getUIContext().get("quotaMap");
        String key = null;
        String billid = null;
        SupplierInfo supplierInfo = null;
        ArrayList<QuotaVO> resultList = new ArrayList<QuotaVO>();
        HashMap resultMap = (HashMap)this.getUIContext().get("resultMap");
        String lastKey = null;
        MeasureUnitInfo unit = null;
        BigDecimal unassignQty = new BigDecimal("0.0");
        BigDecimal unassignentryQty = new BigDecimal("0.0");
        int j = 0;
        BigDecimal totalSplitQty = new BigDecimal("0.0");
        BigDecimal totalQty = new BigDecimal("0.0");
        int size = this.tblmain.getRowCount();
        for (int i = 0; i < size; ++i) {
            BigDecimal qty = new BigDecimal("0.0");
            int minseq = Integer.parseInt(this.tblmain.getRow(i).getCell("minseq").getValue().toString());
            int maxseq = Integer.parseInt(this.tblmain.getRow(i).getCell("maxseq").getValue().toString());
            billid = this.tblmain.getRow(i).getCell("billid").getValue().toString();
            String oldkey = billid + "_" + minseq + "_" + maxseq;
            if (lastKey == null || !lastKey.equals(oldkey)) {
                if (i > 0) {
                    resultMap.remove(oldkey);
                    resultMap.put(oldkey, resultList);
                }
                j = minseq;
                resultList = new ArrayList();
            }
            unit = new MeasureUnitInfo();
            unit.setName(this.tblmain.getRow(i).getCell("unit").getValue().toString());
            qty = (BigDecimal)this.tblmain.getRow(i).getCell("assignQty").getValue();
            unassignQty = (BigDecimal)this.tblmain.getRow(i).getCell("assignQty").getValue();
            supplierInfo = (SupplierInfo)this.tblmain.getRow(i).getCell("supplier").getValue();
            totalQty = totalQty.add(qty);
            while (j <= maxseq && unassignQty.compareTo(BigDecimal.ZERO) > 0) {
                key = billid + "_" + j;
                vo = (QuotaVO)((QuotaVO)quotaMap.get(key)).clone();
                vo.setSupplier(supplierInfo);
                if (unassignentryQty.compareTo(BigDecimal.ZERO) <= 0) {
                    unassignentryQty = vo.getEntryQty();
                }
                if (qty.compareTo(unassignentryQty) >= 0) {
                    vo.setSplitQty(unassignentryQty);
                    vo.setSplitBaseQty(unassignentryQty);
                    unassignQty = qty.subtract(unassignentryQty);
                    unassignentryQty = BigDecimal.ZERO;
                    ++j;
                } else {
                    vo.setSplitQty(qty);
                    vo.setSplitBaseQty(qty);
                    unassignentryQty = unassignentryQty.subtract(qty);
                    unassignQty = BigDecimal.ZERO;
                }
                totalSplitQty = totalSplitQty.add(vo.getSplitQty());
                unit.setId(BOSUuid.read((String)vo.getUnitId()));
                vo.setUnit(unit);
                this.getRelatedData(vo);
                resultList.add(vo);
            }
            lastKey = oldkey;
        }
        resultMap.remove(lastKey);
        resultMap.put(lastKey, resultList);
        int isOK = 0;
        int isOK2 = 0;
        if (unassignentryQty.compareTo(BigDecimal.ZERO) > 0) {
            materialname = (String)this.tblmain.getRow(this.tblmain.getRowCount() - 1).getCell("material.name").getValue();
            isOK = MsgBox.showConfirm2((String)(materialname + EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"RESOURCE001")));
        }
        if (totalQty.compareTo(totalSplitQty) > 0) {
            materialname = (String)this.tblmain.getRow(this.tblmain.getRowCount() - 1).getCell("material.name").getValue();
            isOK2 = MsgBox.showConfirm2((String)(materialname + EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"RESOURCE002")));
        }
        if (isOK == 0 && isOK2 == 0) {
            QuotaAllocationForProjectUI quotaAllocationForProjectUI = (QuotaAllocationForProjectUI)((Object)this.getUIContext().get("Owner"));
            quotaAllocationForProjectUI.setResultMap(resultMap);
            quotaAllocationForProjectUI.getQuoTable().refresh();
            quotaAllocationForProjectUI.kdtEntriesSelected();
            this.getUIWindow().close();
        }
    }

    private void assignQty() {
    }

    protected void initSupplierQuota(QuotaVOCollection quotaVOCol) throws BOSException {
        String key;
        StringBuffer oql = new StringBuffer();
        String materialPurchaseType = "0";
        oql.append("select purMeasureUnit.id,purMeasureUnit.name,purMeasureUnit.number, purchaseOrg.id, materialItem.id, minPackingQty, \n");
        oql.append(" qtyOrderBottom, qtyOrderTop, supplyScope, supplier.number, supplier.name,project.id, \n");
        oql.append(" quotaRate, supplyPriority \n");
        oql.append(" where materialAttr = ").append(materialPurchaseType).append("  \n");
        oql.append("  and isUseable = ").append(1).append("  \n");
        oql.append("  and (id is null \n");
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String purOrgUnitId = quotaVO.getPurOrgUnitId();
            String materialId = quotaVO.getMaterialId();
            key = materialId + purOrgUnitId;
            LinkedList<String> keys = new LinkedList<String>();
            if (keys.contains(materialId + purOrgUnitId)) continue;
            keys.add(key);
            oql.append(" or (materialItem.id='").append(materialId);
            oql.append("' and purchaseOrg.id='").append(purOrgUnitId).append("')\n");
        }
        oql.append(") order by materialItem.id, purchaseOrg.id ,project.id ");
        ApprovedSupplierCollection supplierCol = ApprovedSupplierFactory.getRemoteInstance().getApprovedSupplierCollection(oql.toString());
        ProjectInfo project = null;
        for (int i = 0; i < supplierCol.size(); ++i) {
            ApprovedSupplierInfo supplierQuota = supplierCol.get(i);
            key = supplierQuota.getSupplier().getId().toString() + supplierQuota.getMaterialItem().getId().toString() + supplierQuota.getPurchaseOrg().getId().toString();
            project = supplierQuota.getProject();
            if (project != null) {
                key = key + project.getId().toString();
            }
            this.supplierQuotaCol.put(key, supplierQuota);
        }
    }

    public ApprovedSupplierInfo getSupplierQuotas(QuotaVO voAssign) {
        String materialId = voAssign.getMaterialId();
        String purOrgUnitId = ((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue()).getId().toString();
        ApprovedSupplierInfo supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        String projectid = voAssign.getProjectid();
        String supplierid = voAssign.getSupplier().getId().toString();
        supplierQuotas = StringUtil.isEmpty((String)projectid) ? this.supplierQuotaCol.get(supplierid + materialId + purOrgUnitId) : this.supplierQuotaCol.get(supplierid + materialId + purOrgUnitId + projectid);
        if (supplierQuotas == null) {
            supplierQuotas = this.supplierQuotaCol.get(supplierid + materialId + purOrgUnitId);
        }
        return supplierQuotas != null ? supplierQuotas : new ApprovedSupplierInfo();
    }

    protected void getRelatedData(QuotaVO voAssign) {
        ApprovedSupplierInfo supplierQuota = this.getSupplierQuotas(voAssign);
        MaterialPurchasingInfo materialPurchasingInfo = this.getMaterialPurInfo(voAssign.getMaterialId(), voAssign.getPurOrgUnitId());
        voAssign.setPriority(supplierQuota.getSupplyPriority());
        if (materialPurchasingInfo != null) {
            voAssign.setQuotaPolicyname(materialPurchasingInfo.getQuotaPolicy().getName());
        }
    }

    private void initMaterialPurchasing(QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select material.id, unit.id,unit.name,unit.number, orgUnit.id, minDivisionQty, quotaPeriod, ");
        oql.append(" quotaPolicy.id,quotaPolicy.name,useSupplyList where \n").append(" id is  null \n");
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String purOrgUnitId = quotaVO.getPurOrgUnitId();
            LinkedList<String> keys = new LinkedList<String>();
            String materialId = quotaVO.getMaterialId();
            if (keys.contains(materialId + purOrgUnitId)) continue;
            keys.add(materialId + purOrgUnitId);
            oql.append(" or (material.id='").append(materialId).append("' and orgUnit.id='").append(purOrgUnitId).append("')\n");
        }
        MaterialPurchasingCollection purCol = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(oql.toString());
        for (int i = 0; i < purCol.size(); ++i) {
            MaterialPurchasingInfo purInfo = purCol.get(i);
            String key = purInfo.getMaterial().getId().toString() + purInfo.getOrgUnit().getId().toString();
            this.materialPurInfoCol.put(key, purInfo);
        }
    }

    public MaterialPurchasingInfo getMaterialPurInfo(String materialId, String purOrgUnitId) {
        return this.materialPurInfoCol.get(materialId + purOrgUnitId);
    }
}

