/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.client.AbstractManulAssign4TrunckNumberUI;
import com.kingdee.eas.scm.sm.pur.client.QuotaAllocationForProjectUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ManulAssign4TrunckNumberUI
extends AbstractManulAssign4TrunckNumberUI {
    private static final Logger logger = CoreUIObject.getLogger(ManulAssign4TrunckNumberUI.class);
    protected F7ContextManager f7Manager = null;
    Map<String, Object> trackMap = new HashMap<String, Object>();
    private Map<String, ApprovedSupplierInfo> supplierQuotaCol = new HashMap<String, ApprovedSupplierInfo>();
    private Map<String, MaterialPurchasingInfo> materialPurInfoCol = new HashMap<String, MaterialPurchasingInfo>();

    public ManulAssign4TrunckNumberUI() throws Exception {
        this.tblmain.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setTrckNumberF7();
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        KDBizPromptBox prmtSupplier = this.getBizSupplierF7(this.tblmain.getColumn("supplier"));
        prmtSupplier.setDisplayFormat("$name$");
        prmtSupplier.setEditFormat("$name$");
        KDTDefaultCellEditor bizsupplierEditor = new KDTDefaultCellEditor((IKDEditor)prmtSupplier);
        ObjectValueRender avrSupplier = new ObjectValueRender();
        avrSupplier.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblmain.getColumn("supplier").setEditor((ICellEditor)bizsupplierEditor);
        PurchaseOrgUnitInfo purorg = (PurchaseOrgUnitInfo)this.getUIContext().get("purorg");
        this.prmtPurchaseOrgUnit.setValue((Object)purorg);
        this.tblmain.getColumn("mintrunknumber").getStyleAttributes().setLocked(true);
        this.initData();
        this.addListeners();
        this.actioncheckData.setVisible(false);
        this.actionCopyline.setVisible(false);
        this.actiondeleteLine.setVisible(false);
    }

    private void addListeners() {
        KDTEditAdapter entryTableChange = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ManulAssign4TrunckNumberUI.this.tblmain_ChangedStarting(e);
                }
                catch (Exception ex) {
                    ManulAssign4TrunckNumberUI.this.handUIException(ex);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    ManulAssign4TrunckNumberUI.this.tblmain_ChangedStopped(e);
                }
                catch (Exception exc) {
                    ManulAssign4TrunckNumberUI.this.handUIException(exc);
                }
            }
        };
        this.tblmain.addKDTEditListener((KDTEditListener)entryTableChange);
    }

    protected void tblmain_ChangedStarting(KDTEditEvent e) throws Exception {
    }

    protected void tblmain_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        String fieldName = this.tblmain.getColumnKey(colIndex);
        if ("mintrunknumber".equals(fieldName)) {
            if (e.getValue() == null) {
                this.tblmain.getCell(rowIndex, "mintrunknumber").setValue(e.getOldValue());
                SysUtil.abort();
            }
            TrackNumberInfo mintrackNumberInfo = (TrackNumberInfo)e.getOldValue();
            TrackNumberInfo maxtrackNumberInfo = (TrackNumberInfo)this.tblmain.getCell(rowIndex, "maxtrunknumber").getValue();
            int oldMinseq = mintrackNumberInfo.getSeq();
            int oldmaxseq = maxtrackNumberInfo.getSeq();
            int minrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldminseq").getValue().toString());
            int maxrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldmaxseq").getValue().toString());
            String billid = this.tblmain.getCell(rowIndex, "key").getValue().toString();
            TrackNumberInfo trackNumberInfo = (TrackNumberInfo)e.getValue();
            Map rowreqMap = (Map)this.trackMap.get("rowseq" + billid + minrowseq + maxrowseq);
            Map trackNumberMap = (Map)this.trackMap.get(billid + minrowseq + maxrowseq);
            int rowseq = (Integer)rowreqMap.get(billid + trackNumberInfo.getId().toString());
            TrackNumberInfo lastTrackNumberInfo = (TrackNumberInfo)trackNumberMap.get(rowseq - 1);
            this.tblmain.getCell(rowIndex, "minseq").setValue((Object)rowseq);
            BigDecimal qty = this.getAssignQuotaQty(this.tblmain.getRow(rowIndex));
            this.tblmain.getCell(rowIndex, "assignQty").setValue((Object)qty);
            if (trackNumberInfo.getSeq() < mintrackNumberInfo.getSeq()) {
                int precision = qty.scale();
                IRow row = this.copyLine(rowIndex, this.tblmain.getRow(rowIndex), precision);
                row.getCell("mintrunknumber").setValue(e.getOldValue());
                row.getCell("minseq").setValue((Object)minrowseq);
                row.getCell("maxtrunknumber").setValue((Object)lastTrackNumberInfo);
                row.getCell("maxseq").setValue((Object)(rowseq - 1));
                BigDecimal qty2 = this.getAssignQuotaQty(row);
                this.tblmain.getCell(row.getRowIndex(), "assignQty").setValue((Object)qty2);
            }
        } else if ("maxtrunknumber".equals(fieldName)) {
            if (e.getValue() == null) {
                this.tblmain.getCell(rowIndex, "maxtrunknumber").setValue(e.getOldValue());
                SysUtil.abort();
            }
            TrackNumberInfo mintrackNumberInfo = (TrackNumberInfo)this.tblmain.getCell(rowIndex, "mintrunknumber").getValue();
            TrackNumberInfo maxtrackNumberInfo = (TrackNumberInfo)e.getOldValue();
            TrackNumberInfo trackNumberInfo = (TrackNumberInfo)e.getValue();
            if (mintrackNumberInfo.getSeq() > trackNumberInfo.getSeq()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"MAXTRACKNUM_MUST_GREATERTHAN_MINTRACKNUM"));
                this.tblmain.getCell(rowIndex, "maxtrunknumber").setValue(e.getOldValue());
                SysUtil.abort();
            }
            int maxseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "maxseq").getValue().toString());
            int minrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldminseq").getValue().toString());
            int maxrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldmaxseq").getValue().toString());
            String billid = this.tblmain.getCell(rowIndex, "key").getValue().toString();
            Map rowreqMap = (Map)this.trackMap.get("rowseq" + billid + minrowseq + maxrowseq);
            Map trackNumberMap = (Map)this.trackMap.get(billid + minrowseq + maxrowseq);
            int rowseq = (Integer)rowreqMap.get(billid + trackNumberInfo.getId().toString());
            TrackNumberInfo nextTrackNumberInfo = (TrackNumberInfo)trackNumberMap.get(rowseq + 1);
            this.tblmain.getCell(rowIndex, "maxseq").setValue((Object)rowseq);
            BigDecimal qty = this.getAssignQuotaQty(this.tblmain.getRow(rowIndex));
            this.tblmain.getCell(rowIndex, "assignQty").setValue((Object)qty);
            if (trackNumberInfo.getSeq() < maxtrackNumberInfo.getSeq()) {
                int precision = qty.scale();
                IRow row = this.copyLine(rowIndex + 1, this.tblmain.getRow(rowIndex), precision);
                row.getCell("maxtrunknumber").setValue(e.getOldValue());
                row.getCell("maxseq").setValue((Object)maxseq);
                row.getCell("mintrunknumber").setValue((Object)nextTrackNumberInfo);
                row.getCell("minseq").setValue((Object)(rowseq + 1));
                BigDecimal qty2 = this.getAssignQuotaQty(row);
                this.tblmain.getCell(row.getRowIndex(), "assignQty").setValue((Object)qty2);
            } else {
                this.dealNextRow(rowIndex, rowseq, trackNumberMap);
            }
        }
    }

    private void dealNextRow(int rowIndex, int rowseq, Map<Integer, TrackNumberInfo> trackNumberMap) {
        IRow row = this.tblmain.getRow(rowIndex + 1);
        if (row == null) {
            return;
        }
        int minrowseq = Integer.parseInt(row.getCell("minseq").getValue().toString());
        int maxrowseq = Integer.parseInt(row.getCell("maxseq").getValue().toString());
        if (rowseq >= maxrowseq) {
            this.tblmain.removeRow(rowIndex + 1);
            this.dealNextRow(rowIndex, rowseq, trackNumberMap);
        } else if (rowseq >= minrowseq && rowseq < maxrowseq) {
            TrackNumberInfo nextTrackNumberInfo = trackNumberMap.get(rowseq + 1);
            row.getCell("mintrunknumber").setValue((Object)nextTrackNumberInfo);
            row.getCell("minseq").setValue((Object)(rowseq + 1));
            BigDecimal qty = this.getAssignQuotaQty(row);
            row.getCell("assignQty").setValue((Object)qty);
        }
    }

    private BigDecimal getAssignQuotaQty(IRow row) {
        BigDecimal qty = new BigDecimal("0.0");
        String billid = row.getCell("key").getValue().toString();
        int minseq = Integer.parseInt(row.getCell("minseq").getValue().toString());
        int maxseq = Integer.parseInt(row.getCell("maxseq").getValue().toString());
        String key = null;
        Map quotaMap = (Map)this.getUIContext().get("quotaMap");
        for (int i = minseq; i <= maxseq; ++i) {
            key = billid + "_" + i;
            QuotaVO vo = (QuotaVO)quotaMap.get(key);
            qty = qty.add(vo.getEntryQty());
        }
        return qty;
    }

    protected KDBizPromptBox getBizSupplierF7(IColumn col) {
        KDBizPromptBox bizSupplierBox = new KDBizPromptBox();
        bizSupplierBox.setEditable(true);
        bizSupplierBox.setEditFormat("$number$");
        bizSupplierBox.setDisplayFormat("$name$");
        bizSupplierBox.setCommitFormat("$number$;$mnemonicCode$;$name$;");
        OrgUnitInfo purOrg = (OrgUnitInfo)this.getUIContext().get(OrgType.Purchase);
        this.f7Manager.registerBizSupplierF7(bizSupplierBox, col, null, purOrg);
        return bizSupplierBox;
    }

    protected void setTrckNumberF7() {
        KDBizPromptBox bizTrackBox = new KDBizPromptBox();
        bizTrackBox.setEditable(true);
        bizTrackBox.setEditFormat("$number$");
        bizTrackBox.setDisplayFormat("$number$");
        bizTrackBox.setCommitFormat("$number$");
        bizTrackBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblmain.getColumn("maxtrunknumber").setRenderer((IBasicRender)avr);
        this.tblmain.getColumn("mintrunknumber").setRenderer((IBasicRender)avr);
        this.tblmain.getColumn("mintrunknumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizTrackBox));
        this.tblmain.getColumn("maxtrunknumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizTrackBox));
        bizTrackBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ManulAssign4TrunckNumberUI.this.setTrunknumberFilter();
            }
        });
        bizTrackBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManulAssign4TrunckNumberUI.this.setTrunknumberFilter();
            }
        });
    }

    private void setTrunknumberFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int rowIndex = this.tblmain.getSelectManager().getActiveRowIndex();
        int columnIndex = this.tblmain.getSelectManager().getActiveColumnIndex();
        int minrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldminseq").getValue().toString());
        int maxrowseq = Integer.parseInt(this.tblmain.getCell(rowIndex, "oldmaxseq").getValue().toString());
        String billid = this.tblmain.getCell(rowIndex, "key").getValue().toString();
        ICellEditor cellGEditor = this.tblmain.getColumn(columnIndex).getEditor();
        KDBizPromptBox bizTrackBox = null;
        if (cellGEditor != null) {
            bizTrackBox = (KDBizPromptBox)cellGEditor.getComponent();
        }
        Set idSet = (Set)this.trackMap.get("ids" + billid + minrowseq + maxrowseq);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (bizTrackBox != null) {
            bizTrackBox.setEntityViewInfo(view);
            bizTrackBox.getQueryAgent().resetRuntimeEntityView();
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    private void initData() throws BOSException {
        QuotaVOCollection col = (QuotaVOCollection)this.getUIContext().get("quotaVOCollection");
        this.initMaterialPurchasing(col);
        this.initSupplierQuota(col);
        QuotaVO vo = null;
        String key = null;
        String billid = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            vo = col.getQuotaVO(i);
            IRow quoRow = this.tblmain.addRow();
            SCMClientUtils.setTableColumnsFormat((KDTable)this.tblmain, (String[])new String[]{"assignQty"}, (String)SCMClientUtils.getFormatPattern((int)vo.getEntryQty().scale(), (boolean)true));
            this.setCellValue(i, quoRow, vo);
            billid = vo.getSrcBillId();
        }
        Map quotaMap = (Map)this.getUIContext().get("quotaMap");
        HashMap<String, Integer> rowreqMap = new HashMap<String, Integer>();
        HashMap<Integer, TrackNumberInfo> trackNumberMap = new HashMap<Integer, TrackNumberInfo>();
        TrackNumberInfo info = null;
        HashSet<String> ids = null;
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            vo = col.getQuotaVO(i);
            ids = new HashSet<String>();
            int minseq = vo.getMinseq();
            int maxseq = vo.getMaxseq();
            billid = vo.getSrcBillId();
            for (int j = minseq; j <= maxseq; ++j) {
                key = billid + "_" + j;
                vo = (QuotaVO)quotaMap.get(key);
                info = vo.getMinTrackNumber();
                trackNumberMap.put(j, info);
                rowreqMap.put(billid + info.getId().toString(), j);
                ids.add(info.getId().toString());
            }
            this.trackMap.put("rowseq" + billid + minseq + maxseq, rowreqMap);
            this.trackMap.put(billid + minseq + maxseq, trackNumberMap);
            this.trackMap.put("ids" + billid + minseq + maxseq, ids);
        }
    }

    @Override
    public void actionCopyline_actionPerformed(ActionEvent e) throws Exception {
        int beginBlockRow;
        KDTable table = this.tblmain;
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0 && table.getRowCount() > 0) {
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
        BigDecimal qty = (BigDecimal)this.tblmain.getCell(beginBlockRow, "assignQty").getValue();
        this.copyLine(beginBlockRow, this.tblmain.getRow(beginBlockRow), qty.scale());
    }

    private IRow copyLine(int rowindex, IRow oldRow, int precision) {
        IRow row = this.tblmain.addRow(rowindex);
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblmain, (String[])new String[]{"assignQty"}, (String)SCMClientUtils.getFormatPattern((int)precision, (boolean)true));
        int supplierindex = row.getCell("supplier").getColumnIndex();
        for (int cellIndex = 0; cellIndex < this.tblmain.getColumnCount(); ++cellIndex) {
            ICell copyFromCell = oldRow.getCell(cellIndex);
            ICell copyToCell = row.getCell(cellIndex);
            if (cellIndex == supplierindex) {
                copyToCell.setValue(null);
                continue;
            }
            if (copyFromCell == null || copyToCell == null) continue;
            Object orgValue = copyFromCell.getValue();
            copyToCell.setValue(orgValue);
        }
        return row;
    }

    @Override
    public void actiondeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actiondeleteLine_actionPerformed(e);
    }

    @Override
    public void actioncheckData_actionPerformed(ActionEvent e) throws Exception {
        this.checkData();
    }

    private void checkData() {
        StringBuffer msg = new StringBuffer();
        int size = this.tblmain.getRowCount();
        for (int i = 0; i < size; ++i) {
            SupplierInfo supplier = (SupplierInfo)this.tblmain.getRow(i).getCell("supplier").getValue();
            if (supplier != null && supplier.getId() != null) continue;
            msg.append(i + 1).append(",");
        }
        if (msg.length() > 0) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"SOME_SUPPLIER_CANT_ENTER"), (String)(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ROW_SEQ") + msg.substring(0, msg.length() - 1)));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSaveData_actionPerformed(ActionEvent e) throws Exception {
        this.checkData();
        QuotaVO vo = null;
        Map quotaMap = (Map)this.getUIContext().get("quotaMap");
        String key = null;
        String billid = null;
        SupplierInfo supplierInfo = null;
        ArrayList<QuotaVO> resultList = new ArrayList<QuotaVO>();
        HashMap resultMap = (HashMap)this.getUIContext().get("quotaMap");
        String lastKey = null;
        MeasureUnitInfo unit = null;
        BigDecimal totalQty = new BigDecimal("0.0");
        int size = this.tblmain.getRowCount();
        for (int i = 0; i < size; ++i) {
            billid = this.tblmain.getRow(i).getCell("key").getValue().toString();
            totalQty = (BigDecimal)this.tblmain.getRow(i).getCell("totalQty").getValue();
            int minseq = Integer.parseInt(this.tblmain.getRow(i).getCell("minseq").getValue().toString());
            int maxseq = Integer.parseInt(this.tblmain.getRow(i).getCell("maxseq").getValue().toString());
            supplierInfo = (SupplierInfo)this.tblmain.getRow(i).getCell("supplier").getValue();
            int oldminseq = Integer.parseInt(this.tblmain.getRow(i).getCell("oldminseq").getValue().toString());
            int oldmaxseq = Integer.parseInt(this.tblmain.getRow(i).getCell("oldmaxseq").getValue().toString());
            String oldkey = billid + "_" + oldminseq + "_" + oldmaxseq;
            if (lastKey == null || !lastKey.equals(oldkey)) {
                if (i > 0) {
                    resultMap.remove(lastKey);
                    resultMap.put(lastKey, resultList);
                }
                resultList = new ArrayList();
            }
            unit = new MeasureUnitInfo();
            unit.setName(this.tblmain.getRow(i).getCell("unit").getValue().toString());
            for (int j = minseq; j <= maxseq; ++j) {
                key = billid + "_" + j;
                vo = (QuotaVO)quotaMap.get(key);
                vo.setSupplier(supplierInfo);
                vo.setSplitQty(vo.getEntryQty());
                vo.setSplitBaseQty(vo.getUnAssBaseOrderQty());
                vo.setUnAssBaseOrderQty(totalQty);
                unit.setId(BOSUuid.read((String)vo.getUnitId()));
                vo.setUnit(unit);
                vo.setSplitRatio(vo.getEntryQty().divide(totalQty, vo.getEntryQty().scale() + 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100.0")));
                this.getRelatedData(vo);
                resultList.add(vo);
            }
            lastKey = oldkey;
        }
        resultMap.remove(lastKey);
        resultMap.put(lastKey, resultList);
        QuotaAllocationForProjectUI quotaAllocationForProjectUI = (QuotaAllocationForProjectUI)((Object)this.getUIContext().get("Owner"));
        quotaAllocationForProjectUI.setResultMap(resultMap);
        quotaAllocationForProjectUI.getQuoTable().refresh();
        quotaAllocationForProjectUI.kdtEntriesSelected();
        this.getUIWindow().close();
    }

    private void setCellValue(int index, IRow quoRow, QuotaVO vo) {
        quoRow.getCell("material.number").setValue((Object)vo.getMaterialnumber());
        quoRow.getCell("material.name").setValue((Object)vo.getMaterialname());
        quoRow.getCell("material.model").setValue((Object)vo.getMaterialmodel());
        quoRow.getCell("unit").setValue((Object)vo.getUnitname());
        quoRow.getCell("assignQty").setValue((Object)vo.getEntryQty());
        quoRow.getCell("totalQty").setValue((Object)vo.getUnAssBaseOrderQty());
        quoRow.getCell("supplier").setValue((Object)vo.getSupplier());
        if (vo.getProjectid() != null) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(BOSUuid.read((String)vo.getProjectid()));
            projectInfo.setName(vo.getProjectname());
            quoRow.getCell("project").setValue((Object)projectInfo);
        }
        quoRow.getCell("mintrunknumber").setValue((Object)vo.getMinTrackNumber());
        quoRow.getCell("maxtrunknumber").setValue((Object)vo.getMaxTrackNumber());
        quoRow.getCell("oldminseq").setValue((Object)vo.getMinseq());
        quoRow.getCell("oldmaxseq").setValue((Object)vo.getMaxseq());
        quoRow.getCell("minseq").setValue((Object)vo.getMinseq());
        quoRow.getCell("maxseq").setValue((Object)vo.getMaxseq());
        quoRow.getCell("key").setValue((Object)vo.getSrcBillId());
    }

    protected void initSupplierQuota(QuotaVOCollection quotaVOCol) throws BOSException {
        String key;
        StringBuffer oql = new StringBuffer();
        String materialPurchaseType = "0";
        oql.append("select purMeasureUnit.id,purMeasureUnit.name,purMeasureUnit.number, purchaseOrg.id, materialItem.id, minPackingQty, \n");
        oql.append(" qtyOrderBottom, qtyOrderTop, supplyScope, supplier.number, supplier.name,project.id, \n");
        oql.append(" quotaRate, supplyPriority \n");
        oql.append(" where materialAttr = ").append(materialPurchaseType).append("  \n");
        oql.append("  and isUseable = ").append(1).append("  \n");
        oql.append("  and (id is null \n");
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String purOrgUnitId = quotaVO.getPurOrgUnitId();
            String materialId = quotaVO.getMaterialId();
            key = materialId + purOrgUnitId;
            LinkedList<String> keys = new LinkedList<String>();
            if (keys.contains(materialId + purOrgUnitId)) continue;
            keys.add(key);
            oql.append(" or (materialItem.id='").append(materialId);
            oql.append("' and purchaseOrg.id='").append(purOrgUnitId).append("')\n");
        }
        oql.append(") order by materialItem.id, purchaseOrg.id ,project.id ");
        ApprovedSupplierCollection supplierCol = ApprovedSupplierFactory.getRemoteInstance().getApprovedSupplierCollection(oql.toString());
        ProjectInfo project = null;
        for (int i = 0; i < supplierCol.size(); ++i) {
            ApprovedSupplierInfo supplierQuota = supplierCol.get(i);
            key = supplierQuota.getSupplier().getId().toString() + supplierQuota.getMaterialItem().getId().toString() + supplierQuota.getPurchaseOrg().getId().toString();
            project = supplierQuota.getProject();
            if (project != null) {
                key = key + project.getId().toString();
            }
            this.supplierQuotaCol.put(key, supplierQuota);
        }
    }

    public ApprovedSupplierInfo getSupplierQuotas(QuotaVO voAssign) {
        String materialId = voAssign.getMaterialId();
        String purOrgUnitId = ((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue()).getId().toString();
        ApprovedSupplierInfo supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        String projectid = voAssign.getProjectid();
        supplierQuotas = StringUtil.isEmpty((String)projectid) ? this.supplierQuotaCol.get(materialId + purOrgUnitId) : this.supplierQuotaCol.get(materialId + purOrgUnitId + projectid);
        if (supplierQuotas == null) {
            supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        }
        return supplierQuotas != null ? supplierQuotas : new ApprovedSupplierInfo();
    }

    protected void getRelatedData(QuotaVO voAssign) {
        ApprovedSupplierInfo supplierQuota = this.getSupplierQuotas(voAssign);
        MaterialPurchasingInfo materialPurchasingInfo = this.getMaterialPurInfo(voAssign.getMaterialId(), voAssign.getPurOrgUnitId());
        voAssign.setPriority(supplierQuota.getSupplyPriority());
        voAssign.setQuotaPolicyname(materialPurchasingInfo.getQuotaPolicy().getName());
        BigDecimal splitQty = voAssign.getSplitQty();
        voAssign.setSplitQty(splitQty);
        voAssign.setEnableSupplyList(materialPurchasingInfo.isUseSupplyList());
    }

    private void initMaterialPurchasing(QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select material.id, unit.id,unit.name,unit.number, orgUnit.id, minDivisionQty, quotaPeriod, ");
        oql.append(" quotaPolicy.id,quotaPolicy.name,useSupplyList where \n").append(" id is  null \n");
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String purOrgUnitId = quotaVO.getPurOrgUnitId();
            LinkedList<String> keys = new LinkedList<String>();
            String materialId = quotaVO.getMaterialId();
            if (keys.contains(materialId + purOrgUnitId)) continue;
            keys.add(materialId + purOrgUnitId);
            oql.append(" or (material.id='").append(materialId).append("' and orgUnit.id='").append(purOrgUnitId).append("')\n");
        }
        MaterialPurchasingCollection purCol = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(oql.toString());
        for (int i = 0; i < purCol.size(); ++i) {
            MaterialPurchasingInfo purInfo = purCol.get(i);
            String key = purInfo.getMaterial().getId().toString() + purInfo.getOrgUnit().getId().toString();
            this.materialPurInfoCol.put(key, purInfo);
        }
    }

    public MaterialPurchasingInfo getMaterialPurInfo(String materialId, String purOrgUnitId) {
        return this.materialPurInfoCol.get(materialId + purOrgUnitId);
    }
}

