/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CSOptionFactory;
import com.kingdee.eas.basedata.master.cssp.CSOptionInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.EditCtrlStrategyEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillEntryBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurBatchEditUI;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class PurBatchEditUI
extends AbstractPurBatchEditUI {
    private static final long serialVersionUID = -1118061630918518994L;
    private static final Logger logger = CoreUIObject.getLogger(PurBatchEditUI.class);
    public static final BigDecimal BIGZERO = BigDecimal.ZERO;
    public static final int minusOne = -1;
    public static final int PRECISION_DEFAUL_DB = 10;
    public static final Color necessaryColor = new Color(252, 251, 223);
    protected String BILLTYPE_ID = "510b6503-0105-1000-e000-0107c0a812fd463ED552";
    protected Set<String> billIdSet = new HashSet<String>();
    protected Set<String> billEntryIdSet = new HashSet<String>();
    protected Map<String, String> tableToBillRelation = new HashMap<String, String>();
    protected Map<String, String> tableToEntryRelation = new HashMap<String, String>();
    protected List<String> previousQueryIdList = new ArrayList<String>();
    protected List<String> currentQueryIdList = new ArrayList<String>();
    Map<String, Integer> tableEntryIDMap = null;
    private Map<String, Boolean> parametersMap = new HashMap<String, Boolean>();
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    public static final String TB_ID = "id";
    public static final String TB_NUMBER = "number";
    public static final String TB_BASESTATUS = "baseStatus";
    public static final String TB_ENTRYID = "entries.id";
    public static final String TB_SEQ = "seq";
    public static final String TB_INFO = "info";

    protected abstract ICoreBase getBizInterface() throws Exception;

    protected abstract ICoreBillEntryBase getBizEntryInterface() throws Exception;

    protected abstract String getEntryIDName();

    protected abstract String getEntryIDColumnName();

    protected abstract List<String> getLockColumn();

    protected abstract List<String> getHideColumn();

    protected abstract List<String> getRequiredColumn();

    protected abstract void initEntryPrecisionForEdit() throws EASBizException, BOSException;

    protected abstract void initEntryPrecisionForRow(int var1) throws EASBizException, BOSException;

    protected abstract IObjectCollection getCollection(Set<String> var1, Set<String> var2) throws Exception;

    protected void registerTableRelation() {
        this.registerTableRelationEx();
    }

    protected void registerTableRelationEx() {
    }

    protected void doQuery() throws Exception {
        if (this.billIdSet == null || this.billIdSet.size() == 0 || this.billEntryIdSet == null || this.billEntryIdSet.size() == 0) {
            return;
        }
    }

    protected SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_ID));
        SelectorItemCollection sicEx = this.getBillSelectorsEx();
        int size = sicEx.size();
        for (int i = 0; i < size; ++i) {
            sic.add(sicEx.get(i));
        }
        return sic;
    }

    protected SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo(TB_SEQ));
        sic.add(new SelectorItemInfo("parent.id"));
        SelectorItemCollection sicEx = this.getEntrySelectorsEx();
        int size = sicEx.size();
        for (int i = 0; i < size; ++i) {
            sic.add(sicEx.get(i));
        }
        return sic;
    }

    protected SelectorItemCollection getBillSelectorsEx() {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }

    protected SelectorItemCollection getEntrySelectorsEx() {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }

    @Override
    public void actionPosition_actionPerformed(ActionEvent e) throws Exception {
        this.doQuery();
    }

    @Override
    public void actionSure_actionPerformed(ActionEvent e) throws Exception {
        this.runSure(null);
    }

    protected void runSure(IObjectCollection batchCollection) throws Exception {
        this.beforeSureAction(batchCollection);
        this.doBizSure(batchCollection);
        this.afterSureAction(batchCollection);
    }

    protected void doBizSure(IObjectCollection batchCollection) throws Exception {
    }

    protected void beforeSureAction(IObjectCollection batchCollection) {
    }

    private void afterSureAction(IObjectCollection batchCollection) {
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.getDetailTable().checkParsed();
    }

    public void onLoad() throws Exception {
        this.loadDataFromPurBill();
        this.registerTableRelation();
        super.onLoad();
        this.requestMutex(this.billIdSet);
        this.initUIControl();
        this.loadDataToTable();
        this.initTableEntryIDMap();
        this.initEntryPrecisionForEdit();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initUIControl() throws Exception {
        this.actionSure.setEnabled(true);
        this.actionPosition.setEnabled(true);
    }

    protected void setF7RangeChange(Component from, Component to) {
        PurUtil.setF7RangeChange(from, to);
    }

    public StringBuffer convertSet2Sql(Set<String> set) {
        StringBuffer sql = new StringBuffer();
        if (set == null && set.size() == 0) {
            return sql.append("('EAS-XXXXXX')");
        }
        sql.append(" (");
        Iterator<String> it = set.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            if (isFirst) {
                sql.append("'").append(it.next()).append("'");
                isFirst = false;
                continue;
            }
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(") ");
        return sql;
    }

    protected void formatBillStatus(KDComboBox combox) {
        Object[] delItems;
        if (combox.getItemCount() == 0) {
            return;
        }
        Object[] addItems = this.getAdditiveBillStatus();
        if (addItems != null) {
            combox.addItems(addItems);
        }
        if ((delItems = this.getUnVisibleBillStatus()) != null) {
            int count = delItems.length;
            for (int i = 0; i < count; ++i) {
                combox.removeItem(delItems[i]);
            }
        }
    }

    protected Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.DELETED, BillBaseStatusEnum.AUDITED, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.FINISH, BillBaseStatusEnum.PUBLISHED, BillBaseStatusEnum.FINCLOSED, BillBaseStatusEnum.ALTERING, BillBaseStatusEnum.VERSION};
    }

    protected Object[] getAdditiveBillStatus() {
        return null;
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public boolean isControllByPurOrgUnit(String orgUnitPK, String paramNumber, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        if (orgUnitPK == null || paramNumber == null) {
            return isPurParam;
        }
        String key = orgUnitPK + paramNumber;
        if (this.parametersMap.containsKey(key)) {
            isPurParam = this.parametersMap.get(key);
        } else {
            ObjectUuidPK orgUnitID;
            IParamControl paramControl = ParamControlFactory.getRemoteInstance();
            String strPurParam = paramControl.getParamValue((IObjectPK)(orgUnitID = new ObjectUuidPK(orgUnitPK)), paramNumber);
            if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("0")) {
                isPurParam = true;
            }
            if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("1")) {
                isPurParam = false;
            }
            this.parametersMap.put(key, isPurParam);
        }
        return isPurParam;
    }

    public boolean isPurParamPUR(String orgUnitPK, String paramNumber, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        if (orgUnitPK == null || paramNumber == null) {
            return isPurParam;
        }
        String key = orgUnitPK + paramNumber;
        if (this.parametersMap.containsKey(key)) {
            isPurParam = this.parametersMap.get(key);
        } else {
            ObjectUuidPK orgUnitID;
            IParamControl paramControl = ParamControlFactory.getRemoteInstance();
            String strPurParam = paramControl.getParamValue((IObjectPK)(orgUnitID = new ObjectUuidPK(orgUnitPK)), paramNumber);
            if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
                isPurParam = true;
            }
            if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
                isPurParam = false;
            }
            this.parametersMap.put(key, isPurParam);
        }
        return isPurParam;
    }

    protected void registerProjectF7ForFilter(final KDBizPromptBox projectBox) {
        projectBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                PurBatchEditUI.this.resetProjectF7(projectBox);
            }
        });
        projectBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PurBatchEditUI.this.resetProjectF7(projectBox);
            }
        });
    }

    private void resetProjectF7(KDBizPromptBox projectBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(7));
        filterInfo.getFilterItems().add(new FilterItemInfo(TB_BASESTATUS, status, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        projectBox.setEntityViewInfo(viewInfo);
        projectBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected void registerTrackNumberF7ForFilter(final KDBizPromptBox trackNumberBox) {
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                PurBatchEditUI.this.registerTrackNumberF7(trackNumberBox);
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PurBatchEditUI.this.registerTrackNumberF7(trackNumberBox);
            }
        });
    }

    private void registerTrackNumberF7(KDBizPromptBox trackNumberBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        } else {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber2Query");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        trackNumberBox.setEntityViewInfo(viewInfo);
        trackNumberBox.getQueryAgent().resetRuntimeEntityView();
    }

    public Set<String> getKeyIdList(ObjectBaseInfo[] vos) {
        if (vos == null || vos.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < vos.length; ++i) {
            set.add(vos[i].getId().toString());
        }
        return set;
    }

    protected void loadDataFromPurBill() {
        Object idSet = this.getUIContext().get("billIdSet");
        Object entryIdSet = this.getUIContext().get("billEntryIdSet");
        if (idSet != null) {
            this.billIdSet = (Set)idSet;
        }
        if (entryIdSet != null) {
            this.billEntryIdSet = (Set)entryIdSet;
        }
    }

    protected void loadDataToTable() throws Exception {
    }

    public void editCtrl(int startRowIndex, int length) throws EASBizException, BOSException {
        if (length <= 0) {
            return;
        }
        PurPriceParamCollection paramCol = this.getParamCol4FetchStrategy(startRowIndex, length);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchCtrlStrategy(paramCol);
        ArrayList<String> editCtrlFields = new ArrayList<String>();
        editCtrlFields.add("taxPrice");
        editCtrlFields.add("price");
        PurPriceInfo priceInfo = null;
        EditCtrlStrategyEnum editCtrl = EditCtrlStrategyEnum.NOT_CTRL;
        ICell cell = null;
        IRow row = null;
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            boolean isLock;
            row = this.getDetailTable().getRow(i);
            priceInfo = priceInfoCol.getPurPriceInfoBySeq(i);
            if (priceInfo != null) {
                editCtrl = priceInfo.getEditCtrl();
            }
            if (!(isLock = EditCtrlStrategyEnum.EDIT_FORBIDDEN.equals((Object)editCtrl))) continue;
            for (int j = 0; j < editCtrlFields.size(); ++j) {
                cell = row.getCell((String)editCtrlFields.get(j));
                if (cell == null) continue;
                cell.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public PurPriceParamCollection getParamCol4FetchStrategy(int startRowIndex, int length) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        SCMBillBaseInfo info = (SCMBillBaseInfo)this.getDetailTable().getRow(startRowIndex).getCell(TB_INFO).getValue();
        SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)info.getEntries().getObject(0);
        String billTypeId = null;
        if (info.getBillType() == null) {
            billTypeId = this.BILLTYPE_ID;
            logger.error((Object)("@@@@errorMsg@@billnumber:" + info.getNumber() + ",it's billtypeId is null.........."));
        } else {
            billTypeId = info.getBillType().getId().toString();
        }
        String bizTypeId = null;
        if (info.getBizType() == null) {
            bizTypeId = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
            logger.error((Object)("@@@@errorMsg@@billnumber:" + info.getNumber() + ",it's biztypeId is null.........."));
        } else {
            info.getBizType().getId().toString();
        }
        paramCol.setBillTypeId(billTypeId);
        paramCol.setBizTypeId(bizTypeId);
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            if (!this.isHasParam(entryInfo)) continue;
            PurPriceParam param = this.getParam4FetchStrategy(i);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    public PurPriceParam getParam4FetchStrategy(int rowIndex) {
        SCMBillBaseInfo info = (SCMBillBaseInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_INFO).getValue();
        SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)info.getEntries().getObject(0);
        PurPriceParam param = new PurPriceParam();
        param.setMaterialPurchaseType(PurchaseTypeEnum.PURCHASE.getValue());
        String billTypeId = info.getBillType() == null ? this.BILLTYPE_ID : info.getBillType().getId().toString();
        String bizTypeId = info.getBizType() == null ? "d8e80652-0106-1000-e000-04c5c0a812202407435C" : info.getBizType().getId().toString();
        param.setBillTypeId(billTypeId);
        param.setBizTypeId(bizTypeId);
        param.setSeq(rowIndex);
        OrgUnitInfo purchaseOrgUnit = null;
        purchaseOrgUnit = "510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billTypeId) ? (OrgUnitInfo)entryInfo.get("purchaseOrgUnit") : (OrgUnitInfo)info.get("purchaseOrgUnit");
        param.setPurOrgUnitId(purchaseOrgUnit != null ? purchaseOrgUnit.getId().toString() : null);
        MaterialInfo material = entryInfo.getMaterial();
        param.setMaterialId(material != null ? material.getId().toString() : null);
        return param;
    }

    protected boolean isHasParam(SCMBillEntryBaseInfo entryInfo) {
        Boolean isPresent;
        if (entryInfo.getMaterial() == null) {
            return false;
        }
        return entryInfo.get("isPresent") == null || (isPresent = (Boolean)entryInfo.get("isPresent")) == false;
    }

    private void initTableEntryIDMap() {
        this.tableEntryIDMap = new HashMap<String, Integer>();
        int rowCount = this.getDetailTable().getRowCount();
        Object entryIDObj = null;
        String entryID = null;
        for (int i = 0; i < rowCount; ++i) {
            entryIDObj = this.getDetailTable().getCell(i, this.getEntryIDColumnName()).getValue();
            if (entryIDObj == null) continue;
            entryID = entryIDObj.toString();
            this.tableEntryIDMap.put(entryID, i);
        }
    }

    protected void setTableCellValue(KDTable table, int row, String colName, Object colValue) {
        table.getRow(row).getCell(colName).setValue(colValue);
    }

    protected void setTableColumnAttr(KDTable table, List<String> lockCol, List<String> hideCol, List<String> requireCol) {
        int i;
        int size;
        if (lockCol != null && lockCol.size() > 0) {
            size = lockCol.size();
            for (i = 0; i < size; ++i) {
                table.getColumn(lockCol.get(i)).getStyleAttributes().setLocked(true);
            }
        }
        if (hideCol != null && hideCol.size() > 0) {
            size = hideCol.size();
            for (i = 0; i < size; ++i) {
                table.getColumn(hideCol.get(i)).getStyleAttributes().setHided(true);
                table.getColumn(hideCol.get(i)).setWidth(-1);
            }
        }
        if (requireCol != null && requireCol.size() > 0) {
            size = requireCol.size();
            for (i = 0; i < size; ++i) {
                table.getColumn(requireCol.get(i)).setRequired(true);
            }
        }
    }

    protected void setPositionForRow(List<String> entryIDList, boolean isCancel) {
        int rowIndex = 0;
        String entryId = null;
        Color color = isCancel ? Color.WHITE : necessaryColor;
        int minIndex = -1;
        int size = entryIDList.size();
        for (int i = 0; i < size; ++i) {
            entryId = entryIDList.get(i);
            if (!this.tableEntryIDMap.containsKey(entryId)) continue;
            rowIndex = this.tableEntryIDMap.get(entryId);
            this.getDetailTable().getRow(rowIndex).getStyleAttributes().setBackground(color);
            if (minIndex == -1) {
                minIndex = rowIndex;
            }
            minIndex = rowIndex < minIndex ? rowIndex : minIndex;
        }
        if (minIndex > -1) {
            this.getDetailTable().scrollToVisible(minIndex, 0);
        }
    }

    protected void updateRowDataByNewInfo(int rowIndex, SCMBillBaseInfo newInfo, SCMBillEntryBaseInfo newEntryInfo) throws EASBizException, BOSException {
        for (Map.Entry<String, String> entry : this.tableToBillRelation.entrySet()) {
            if (!TB_BASESTATUS.equals(entry.getKey())) {
                this.setTableCellValue(this.getDetailTable(), rowIndex, entry.getKey(), newInfo.get(entry.getValue()));
                continue;
            }
            BillBaseStatusEnum billStatus = BillBaseStatusEnum.getEnum((int)Integer.valueOf(newInfo.get(entry.getValue()).toString()));
            this.setTableCellValue(this.getDetailTable(), rowIndex, entry.getKey(), billStatus);
        }
        for (Map.Entry<String, String> entry : this.tableToEntryRelation.entrySet()) {
            this.setTableCellValue(this.getDetailTable(), rowIndex, entry.getKey(), newEntryInfo.get(entry.getValue()));
        }
        this.initEntryPrecisionForRow(rowIndex);
    }

    public String getCSCommitFormat(int csType) {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            CSOptionInfo csOptioninfo = CSOptionFactory.getRemoteInstance().getCSOptionInfo("select * where userID = '" + userId + "' AND csType = " + csType);
            if (csOptioninfo.isCsName()) {
                return "$name$";
            }
            if (csOptioninfo.isCsAssistNumber()) {
                return "$mnemonicCode$";
            }
            if (csOptioninfo.isCsNumber()) {
                return "$number$";
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "$number$";
    }

    protected void setBizMaterialF7(KDBizPromptBox bizMaterialBox, boolean isMulSelect, String queryInfo) throws BOSException {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        this.f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, null, isMulSelect);
        bizMaterialBox.setCurrentCtrlUnit(cuInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        EntityViewInfo oldView = bizMaterialBox.getEntityViewInfo();
        if (oldView == null) {
            view.setFilter(filterInfo);
            bizMaterialBox.setEntityViewInfo(view);
        } else {
            FilterInfo oldFilter = bizMaterialBox.getEntityViewInfo().getFilter();
            if (oldFilter != null) {
                filterInfo.mergeFilter(oldFilter, "and");
            }
            bizMaterialBox.getEntityViewInfo().setFilter(filterInfo);
        }
    }

    protected void setBizSupplierF7(KDBizPromptBox bizSupplierBox, String queryInfo) throws BOSException {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        this.f7Manager.registerBizSupplierF7(bizSupplierBox, null, queryInfo, null);
        bizSupplierBox.setCurrentCtrlUnit(cuInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        EntityViewInfo oldView = bizSupplierBox.getEntityViewInfo();
        if (oldView == null) {
            view.setFilter(filterInfo);
            bizSupplierBox.setEntityViewInfo(view);
        } else {
            FilterInfo oldFilter = bizSupplierBox.getEntityViewInfo().getFilter();
            if (oldFilter != null) {
                filterInfo.mergeFilter(oldFilter, "and");
            }
            bizSupplierBox.getEntityViewInfo().setFilter(filterInfo);
        }
    }

    public BigDecimal getExchangeQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = imultiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = imultiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = SCMUtils.effectualNumeric((BigDecimal)baseQty).divide(SCMUtils.effectualExchangeRate((BigDecimal)baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    protected boolean isBotpBill(String billTypeID, SCMBillBaseInfo bill) {
        if (this.isBotpBill(bill)) {
            return bill.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }

    protected boolean isBotpBill(SCMBillBaseInfo bill) {
        if (bill == null) {
            return false;
        }
        BillTypeInfo billType = bill.getSourceBillType();
        return billType != null;
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(PurUtil.getUIResource(msgResource));
        this.showMessage();
    }

    protected void showMsgBoxInfo(String msgResource) {
        MsgBox.showInfo((String)PurUtil.getUIResource(msgResource));
    }

    public boolean destroyWindow() {
        this.releaseMutex(this.billIdSet);
        return super.destroyWindow();
    }

    protected void requestMutex(Set<String> billIdSet) {
        if (billIdSet != null && billIdSet.size() > 0) {
            try {
                this.setOprtState("REMOVE");
                Iterator<String> it = billIdSet.iterator();
                String id = null;
                while (it.hasNext()) {
                    id = it.next();
                    this.pubFireVOChangeListener(id);
                }
            }
            catch (Throwable e) {
                billIdSet = new HashSet<String>();
                this.billEntryIdSet = new HashSet<String>();
                this.handUIException(e);
            }
        }
    }

    protected void releaseMutex(Set<String> billIdSet) {
        if (billIdSet != null && billIdSet.size() > 0) {
            try {
                this.setOprtState("RELEASEALL");
                Iterator<String> it = billIdSet.iterator();
                String id = null;
                while (it.hasNext()) {
                    id = it.next();
                    this.pubFireVOChangeListener(id);
                }
            }
            catch (Throwable e) {
                this.handUIException(e);
            }
        }
    }

    private void fireVOChangeListener1(IObjectValue newObject) throws Throwable {
        IVOChangeListener listener = this.getVOChangeListener();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            if ((IObjectValue)this.getUIContext().get("CURRENT.VO") != null) {
                e.setCurrentObject((IObjectValue)this.getUIContext().get("CURRENT.VO"));
            }
            e.setNewObject(newObject);
            e.setState(this.getOprtState());
            listener.change(e);
        }
    }

    protected String getKeyFieldName() {
        return TB_ID;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }
}

