/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.InvoicePrintDataSource;
import com.kingdee.eas.scm.sm.pur.IPurExpenseInvoice;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceAgent;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceCollection;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryAgent;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceException;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurExpenseInvoiceEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.swing.SwingUtilities;

public class PurExpenseInvoiceEditUI
extends AbstractPurExpenseInvoiceEditUI {
    private static final long serialVersionUID = 1L;
    public static final String RES_PROMPT = "com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceResource";
    public static final BigDecimal MAX_VALUE = new BigDecimal("1000000000000");
    public static final BigDecimal MIN_VALUE = new BigDecimal("0.00001");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String TB_FEENUMBER = "feeNumber";
    private static final int TB_INT_FEENUMBER = 1;
    private static final String TB_FEENAME = "feeName";
    private static final String TB_FEEUNIT = "measureUnit";
    private static final String TB_EXPENSETYPE = "expenseType";
    private static final String TB_PRICE = "price";
    private static final int TB_INT_PRICE = 6;
    private static final String TB_QUANTITY = "quantity";
    private static final int TB_INT_QUANTITY = 8;
    private static final String TB_AMOUNT = "amount";
    private static final int TB_INT_AMOUNT = 9;
    private static final String TB_AMOUNTHOME = "amountHome";
    private static final String TB_TAXRATIO = "taxRatio";
    private static final int TB_INT_TAXRATIO = 7;
    private static final String TB_AMOUNTTAX = "amountTax";
    private static final String TB_AMOUNTTAXHOME = "amountTaxHome";
    private static final String TB_AMOUNTWITHOUTTAX = "amountWithoutTa";
    private static final String TB_AMOUNTHOMENOTAX = "amountHomeNoTax";
    private KDFormattedTextField[] allAmount;
    private static final String[] allEntryAmount = new String[]{"quantity", "amount", "amountHome", "amountTax", "amountHome", "amountTaxHome", "amountWithoutTa", "amountHomeNoTax"};
    private static final String[] entryAmountHome = new String[]{"amountHome", "amountTaxHome", "amountHomeNoTax"};
    private static final String[] entryAmount = new String[]{"price", "amount", "amountTax", "amountWithoutTa"};
    private static final String[] allQty = new String[]{"quantity"};
    CompanyOrgUnitInfo companyOrgInfo;
    ExchangeRateInfo exchangeRateInfo;
    ExchangeAuxInfo exchangeAuxInfo;
    CurrencyInfo currencyHomeInfo;
    CurrencyInfo currencyCalInfo;
    SupplierCompanyInfoInfo supplierCompanyInfo;
    TaxDataInfo taxDataInfo;
    private static final String BUYONTALLY = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
    UserInfo user;
    private DataChangeListener prmtPurchaseOrgListener;
    private DataChangeListener prmtSupplierListener;
    private DataChangeListener prmtCurrencyListener;
    private DataChangeListener prmtCompanyOrgListener;
    private DataChangeListener txtexchangeRateListener;
    private static final String[] ENTRY_NEED = new String[]{"feeNumber", "price", "quantity"};
    SCMClientHelper clientHelper;

    public PurExpenseInvoiceEditUI() throws Exception {
        this.allAmount = new KDFormattedTextField[]{this.txttotalAmount, this.txttotalTax, this.txttotalWithoutTax};
        this.companyOrgInfo = null;
        this.exchangeRateInfo = null;
        this.exchangeAuxInfo = null;
        this.currencyHomeInfo = null;
        this.currencyCalInfo = null;
        this.supplierCompanyInfo = null;
        this.taxDataInfo = null;
        this.user = SysContext.getSysContext().getCurrentUserInfo();
        this.clientHelper = new SCMClientHelper((SCMBillEditUI)this);
        this.initDefaultData(SysContext.getSysContext().getCurrentFIUnit());
        if (this.exchangeRateInfo == null) {
            this.exchangeRateInfo = this.getDefaultExchangeRateInfo();
            this.exchangeAuxInfo = this.getDefaultExchangeAuxInfo();
        } else {
            this.exchangeAuxInfo = this.exchangeRateInfo.getExchangeAux();
        }
    }

    private ExchangeRateInfo getDefaultExchangeRateInfo() {
        ExchangeRateInfo tempExchangeRateinfo = new ExchangeRateInfo();
        tempExchangeRateinfo.setConvertRate(new BigDecimal("1.00"));
        tempExchangeRateinfo.setExchangeAux(this.getDefaultExchangeAuxInfo());
        return tempExchangeRateinfo;
    }

    private ExchangeAuxInfo getDefaultExchangeAuxInfo() {
        ExchangeAuxInfo exAux = new ExchangeAuxInfo();
        exAux.setPrecision(2);
        exAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        return exAux;
    }

    private void initDefaultData(CompanyOrgUnitInfo companyOrgInfo1) throws Exception {
        this.companyOrgInfo = companyOrgInfo1;
        if (this.companyOrgInfo == null || this.companyOrgInfo.getBaseCurrency() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_BASECURRENCY);
        }
        this.currencyHomeInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.companyOrgInfo.getBaseCurrency().getId()));
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        ExchangeTableInfo exchangeTableInfo = this.companyOrgInfo.getBaseExchangeTable();
        if (exchangeTableInfo == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_EXCHANGETABLE);
        }
        excTablepk = new ObjectUuidPK(this.companyOrgInfo.getBaseExchangeTable().getId());
        sourceCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        this.exchangeRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
        if (this.oprtState != null && this.oprtState.equalsIgnoreCase("ADDNEW")) {
            this.prmtCurrency.setData((Object)this.currencyHomeInfo);
            this.changePrecision(this.currencyHomeInfo);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtInvoiceNo.requestFocusInWindow();
    }

    public void onLoad() throws Exception {
        this.updateDate.setSupportedEmpty(true);
        this.updateDate.setValue(null);
        this.dpAuditDate.setSupportedEmpty(true);
        this.dpAuditDate.setValue(null);
        super.onLoad();
        SCMClientUtils.setCompanyOrgF7((KDBizPromptBox)this.prmtCompanyOrgUnit);
        SCMClientUtils.setPurchaseOrgF7((KDBizPromptBox)this.prmtPurchaseOrgUnit);
        this.txtInvoiceNo.requestFocus(true);
        this.txtBrif.setMaxLength(80);
        this.txtInvoiceNo.setMaxLength(80);
        this.txtVoucherNo.setMaxLength(80);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntrys, (String[])new String[]{"remark"}, (int)200);
        this.initF7();
        this.initBtn();
        this.setPaymentType();
        this.kdtEntrys.getColumn(TB_FEENAME).getStyleAttributes().setBackground(new Color(255, 255, 255));
        this.initHeadNumber();
        if (this.prmtSupplier.getData() == null) {
            this.prmtPurchaseOrgUnit.setEnabled(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initBtn() {
        if (this.oprtState.equals("ADDNEW")) {
            this.btnVerification.setEnabled(false);
            this.btnDeleted.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnPrintPreview.setEnabled(false);
        }
        if (this.isFromMsgCenterToEditUI(this)) {
            this.btnAudit.setEnabled(false);
            this.btnVerification.setEnabled(false);
            this.btnDeleted.setEnabled(false);
            this.btnBlock.setEnabled(false);
            this.btnUnBlock.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnPrintPreview.setEnabled(false);
        }
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnDeleted.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnVerification.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.kDMenuItemBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.kDMenuItemUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.kDMenuItemDelete.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.kDMenuItemReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.btnQueryGeneralInventory.setVisible(false);
    }

    private void initHeadNumber() {
        this.txtExchange.setHorizontalAlignment(4);
        this.txttotalAmount.setHorizontalAlignment(4);
        this.txttotalWithoutTax.setHorizontalAlignment(4);
        this.txttotalTax.setHorizontalAlignment(4);
        this.txtExchange.setSupportedEmpty(true);
        this.txttotalAmount.setSupportedEmpty(true);
        this.txttotalWithoutTax.setSupportedEmpty(true);
        this.txttotalTax.setSupportedEmpty(true);
        this.txtExchange.setRemoveingZeroInDispaly(false);
        this.txttotalAmount.setRemoveingZeroInDispaly(false);
        this.txttotalWithoutTax.setRemoveingZeroInDispaly(false);
        this.txttotalTax.setRemoveingZeroInDispaly(false);
    }

    private void disPlayDataToRed() {
        if (this.editData != null && this.editData.isIsReversed() && this.editData.getTotalAmount().compareTo(ZERO) <= 0) {
            for (int i = 0; i < this.allAmount.length; ++i) {
                this.allAmount[i].setForeground(Color.RED);
                BigDecimal amount = (BigDecimal)this.allAmount[i].getNumberValue();
                if (amount == null) continue;
                this.allAmount[i].setValue((Object)amount.abs());
            }
            int num = this.kdtEntrys.getRowCount();
            for (int row = 0; row < num; ++row) {
                ICell cell = null;
                for (int i = 0; i < allEntryAmount.length; ++i) {
                    cell = this.kdtEntrys.getCell(row, allEntryAmount[i]);
                    cell.getStyleAttributes().setFontColor(Color.RED);
                    BigDecimal amount = (BigDecimal)cell.getValue();
                    if (amount == null) continue;
                    cell.setValue((Object)amount.abs());
                }
            }
        }
    }

    private void initF7() {
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompanyOrgUnit);
        try {
            GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
            selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtSupplier, (Component)new F7SupplierTreeDetailListUI(), (Object)this, "7A2569A2", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard", "browseGroup.id");
            this.assignSelector((KDPromptBox)this.prmtSupplier, (KDPromptSelector)selectorLisenterSupplier);
            selectorLisenterSupplier.setQueryProperty("mnemonicCode", "or");
            this.prmtSupplier.addSelectorListener((SelectorListener)selectorLisenterSupplier);
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.initEntrysF7Fields();
    }

    private void initControlListener() {
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new TableValueListener());
        this.prmtCompanyOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurExpenseInvoiceEditUI.this.prmtCompanyOrgUnit_dataChange(e);
                }
                catch (Exception exc) {
                    PurExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCompanyOrgUnit.addDataChangeListener(this.prmtCompanyOrgListener);
        this.prmtSupplierListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurExpenseInvoiceEditUI.this.prmtSupplier_dataChanged(e);
                }
                catch (Exception exc) {
                    PurExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtSupplier.addDataChangeListener(this.prmtSupplierListener);
        this.prmtCurrencyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurExpenseInvoiceEditUI.this.prmtCurrency_dataChanged(e);
                }
                catch (Exception exc) {
                    PurExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCurrency.addDataChangeListener(this.prmtCurrencyListener);
        if (this.txtexchangeRateListener == null) {
            this.txtexchangeRateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PurExpenseInvoiceEditUI.this.txtExchangeRate_dataChanged(e);
                    }
                    catch (Exception exc) {
                        PurExpenseInvoiceEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.txtExchange.addDataChangeListener(this.txtexchangeRateListener);
        this.prmtPurchaseOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (PurExpenseInvoiceEditUI.this.prmtPurchaseOrgUnit.getData() != null && PurExpenseInvoiceEditUI.this.prmtSupplier.getData() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)PurExpenseInvoiceEditUI.RES_PROMPT, (String)"prompt_purorgunit_need_supplier"));
                    PurExpenseInvoiceEditUI.this.prmtPurchaseOrgUnit.setValue(null);
                    PurExpenseInvoiceEditUI.this.prmtSupplier.requestFocus();
                    SysUtil.abort();
                }
            }
        };
        this.prmtPurchaseOrgUnit.addDataChangeListener(this.prmtPurchaseOrgListener);
    }

    private void txtExchangeRate_dataChanged(DataChangeEvent e) {
        int num = this.kdtEntrys.getRowCount();
        for (int i = 0; i < num; ++i) {
            this.calEntryAmount(i);
            this.calEntryAmountTax(i);
            this.calEntryAmountWithoutTax(i);
            if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                this.calEntryAmountHomeInd(i);
                this.calEntryAmountTaxHomeInd(i);
                this.calEntryAmountWithoutTaxHomeInd(i);
                continue;
            }
            this.calEntryAmountHome(i);
            this.calEntryAmountWithoutTaxHome(i);
            this.calEntryAmountTaxHome(i);
        }
    }

    private void initEntrysF7Fields() {
        KDBizPromptBox prmtFeeNumber = new KDBizPromptBox();
        prmtFeeNumber.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7ExpenseItemQuery");
        prmtFeeNumber.setEditable(true);
        prmtFeeNumber.setEditFormat("$name$");
        prmtFeeNumber.setDisplayFormat("$number$");
        prmtFeeNumber.setCommitFormat("$number$");
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtFeeNumber);
        this.kdtEntrys.getColumn(TB_FEENUMBER).setEditor((ICellEditor)itemEditor);
        KDBizPromptBox prmtExpenseType = new KDBizPromptBox();
        prmtExpenseType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7ExpenseTypeQuery");
        prmtExpenseType.setEditable(true);
        prmtExpenseType.setEditFormat("$name$");
        prmtExpenseType.setDisplayFormat("$number$");
        prmtExpenseType.setCommitFormat("$number$");
        itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtExpenseType);
        this.kdtEntrys.getColumn(TB_EXPENSETYPE).setEditor((ICellEditor)itemEditor);
        KDBizPromptBox prmtFeeUnit = new KDBizPromptBox();
        prmtFeeUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtFeeUnit.setEditable(true);
        prmtFeeUnit.setEditFormat("$name$");
        prmtFeeUnit.setDisplayFormat("$name$");
        itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtFeeUnit);
        this.kdtEntrys.getColumn(TB_FEEUNIT).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn(TB_FEENUMBER).setRenderer((IBasicRender)avr);
    }

    private void prmtCompanyOrgUnit_dataChange(DataChangeEvent e) throws Exception {
        Object vo = this.prmtCompanyOrgUnit.getData();
        CompanyOrgUnitInfo cInfo = null;
        if (vo != null && !e.getNewValue().equals(e.getOldValue())) {
            cInfo = (CompanyOrgUnitInfo)vo;
            if (e.getOldValue() != null) {
                MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_clear_comorg"));
            }
            PurExpenseInvoiceInfo tempInfo = (PurExpenseInvoiceInfo)this.createNewData();
            tempInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue());
            this.setDataObject((IObjectValue)tempInfo);
            try {
                this.isAutoNumber = this.isAutoNumber(cInfo.getId().toString());
                if (this.isAutoNumber) {
                    this.isAddView = this.isAddView(cInfo.getId().toString());
                    if (this.isAddView && this.isAutoNumber) {
                        this.getNumTextField().setText(null);
                        String newNum = this.getNewNumberByUnit(cInfo.getId().toString());
                        this.editData.setNumber(newNum);
                    }
                } else {
                    super.setEditable(true);
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.setEditable(true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            this.loadFields();
        }
        this.setSupplierF7();
        this.initDefaultData(cInfo);
        if (cInfo != null) {
            this.exchangeRateInfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)cInfo, (IObjectPK)new ObjectUuidPK(this.currencyHomeInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(((CurrencyInfo)this.prmtCurrency.getData()).getId().toString()));
        }
    }

    private void setSupplierF7() {
        CompanyOrgUnitInfo comOrgInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        if (comOrgInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)comOrgInfo.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            this.prmtSupplier.setEntityViewInfo(ev);
        }
    }

    private void prmtSupplier_dataChanged(DataChangeEvent e) throws Exception {
        Object vo = this.prmtSupplier.getData();
        if (vo != null && vo instanceof SupplierInfo) {
            if (this.prmtCompanyOrgUnit.getData() == null) {
                this.prmtSupplier.setValue(null);
                this.prmtCompanyOrgUnit.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_supplier_need_orgunit"));
                SysUtil.abort();
            }
            SupplierInfo supplierInfo = (SupplierInfo)vo;
            this.supplierChange(supplierInfo, this.companyOrgInfo);
            this.prmtPurchaseOrgUnit.setEnabled(true);
        }
        this.setPurchaseOrgUnitF7();
    }

    private void setPurchaseOrgUnitF7() {
        SupplierInfo supplierInfo = (SupplierInfo)this.prmtSupplier.getData();
        if (supplierInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("Supplier.id", (Object)supplierInfo.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
            ev.setFilter(filter);
            this.prmtPurchaseOrgUnit.setEntityViewInfo(ev);
        }
    }

    private void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo couInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        CurrencyInfo currencyInfo = (CurrencyInfo)e.getNewValue();
        CurrencyInfo oldCurrencyInfo = (CurrencyInfo)e.getOldValue();
        if (currencyInfo != null) {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
            oldCurrencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(oldCurrencyInfo.getId()));
            this.currencyCalInfo = currencyInfo;
            this.currencyChange(couInfo, currencyInfo, oldCurrencyInfo);
        }
    }

    private void currencyChange(CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo sourcecurrencyInfo, CurrencyInfo oldCurrencyInfo) throws BOSException, EASBizException {
        SCMClientUtils.calPriceByCurrencyChange((CompanyOrgUnitInfo)ficompanyOrgInfo, (CurrencyInfo)sourcecurrencyInfo, (CurrencyInfo)oldCurrencyInfo, (KDTable)this.kdtEntrys, (String)TB_PRICE);
        this.currencyChange(sourcecurrencyInfo);
    }

    private void currencyChange(CurrencyInfo sourcecurrencyInfo) throws BOSException, EASBizException {
        BigDecimal exchangeRate = null;
        if (this.currencyHomeInfo.getId().equals((Object)sourcecurrencyInfo.getId())) {
            exchangeRate = new BigDecimal("1.00");
            this.txtExchange.setValue((Object)exchangeRate);
            this.txtExchange.setPrecision(2);
        } else {
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo exchangeTableInfo = this.companyOrgInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                excTablepk = new ObjectUuidPK(this.companyOrgInfo.getBaseExchangeTable().getId());
            }
            sourceCurrPK = new ObjectUuidPK(sourcecurrencyInfo.getId());
            destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            if (tempexrateinfo != null) {
                this.exchangeRateInfo = tempexrateinfo;
                exchangeRate = this.exchangeRateInfo.getConvertRate();
                this.txtExchange.setPrecision(this.exchangeRateInfo.getPrecision());
                this.txtExchange.setValue((Object)exchangeRate);
            }
        }
        int num = this.kdtEntrys.getRowCount();
        for (int i = 0; i < num; ++i) {
            this.calEntryAmount(i);
            this.calEntryAmountTax(i);
            this.calEntryAmountWithoutTax(i);
            if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                this.calEntryAmountHomeInd(i);
                this.calEntryAmountTaxHomeInd(i);
                this.calEntryAmountWithoutTaxHomeInd(i);
                continue;
            }
            this.calEntryAmountHome(i);
            this.calEntryAmountWithoutTaxHome(i);
            this.calEntryAmountTaxHome(i);
        }
        this.changePrecision(sourcecurrencyInfo);
    }

    private void changePrecision(CurrencyInfo currencyInfo) {
        if (currencyInfo != null) {
            this.txttotalWithoutTax.setPrecision(currencyInfo.getPrecision());
            this.txttotalTax.setPrecision(currencyInfo.getPrecision());
            this.txttotalAmount.setPrecision(currencyInfo.getPrecision());
        }
        if (this.currencyHomeInfo != null) {
            SCMClientUtils.changeTableColPrecision((int)this.currencyHomeInfo.getPrecision(), (KDTable)this.kdtEntrys, (String[])entryAmountHome);
        }
        SCMClientUtils.changeTableColPrecision((int)(currencyInfo == null ? 2 : currencyInfo.getPrecision()), (KDTable)this.getDetailTable(), (String[])entryAmount);
    }

    private void supplierChange(SupplierInfo supplierInfo, CompanyOrgUnitInfo companyOrgUnitInfo) throws BOSException, EASBizException {
        if (supplierInfo == null) {
            throw new IllegalArgumentException();
        }
        if (supplierInfo.getTaxRegisterNo() != null && supplierInfo.getTaxRegisterNo().length() > 0) {
            this.txtTaxNumber.setText(supplierInfo.getTaxRegisterNo());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("bankName"));
        sic.add(new SelectorItemInfo("bankAccount"));
        sic.add(new SelectorItemInfo("settlementCurrency.id"));
        sic.add(new SelectorItemInfo("settlementCurrency.name"));
        sic.add(new SelectorItemInfo("settlementCurrency.number"));
        this.supplierCompanyInfo = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(this.companyOrgInfo.getId()), sic);
        if (this.supplierCompanyInfo != null) {
            if (this.supplierCompanyInfo.getBankAccount() != null) {
                this.txtBank.setText(this.supplierCompanyInfo.getBankName());
                this.txtAccountNumber.setText(this.supplierCompanyInfo.getBankAccount());
            }
            if (this.supplierCompanyInfo.getSettlementCurrency() != null) {
                this.prmtCurrency.setValue((Object)this.supplierCompanyInfo.getSettlementCurrency());
            }
            if (this.supplierCompanyInfo.getPaymentType() != null) {
                this.prmtPaymentType.setValue((Object)this.supplierCompanyInfo.getPaymentType());
            }
            if (this.supplierCompanyInfo.getSettlementType() != null) {
                this.prmtSettlementType.setValue((Object)this.supplierCompanyInfo.getSettlementType());
            }
        }
    }

    @Override
    public void loadFields() {
        if (this.prmtCompanyOrgListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.prmtCompanyOrgListener);
        }
        if (this.prmtSupplierListener != null) {
            this.prmtSupplier.removeDataChangeListener(this.prmtSupplierListener);
        }
        if (this.prmtPurchaseOrgListener != null) {
            this.prmtPurchaseOrgUnit.removeDataChangeListener(this.prmtPurchaseOrgListener);
        }
        if (this.prmtCurrencyListener != null) {
            this.prmtCurrency.removeDataChangeListener(this.prmtCurrencyListener);
        }
        if (this.txtexchangeRateListener != null) {
            this.txtExchange.removeDataChangeListener(this.txtexchangeRateListener);
        }
        this.clearField();
        if (this.editData.getCompanyOrgUnit() != null && this.oprtState.equals(OprtState.ADDNEW)) {
            CompanyOrgUnitInfo org = this.editData.getCompanyOrgUnit();
            try {
                this.isAutoNumber = this.isAutoNumber(org.getId().toString());
                if (this.isAutoNumber) {
                    this.isAddView = this.isAddView(org.getId().toString());
                    if (this.isAddView && this.isAutoNumber && (this.editData.getNumber() == null || this.editData.getNumber().toString().trim().length() == 0)) {
                        this.getNumTextField().setText(null);
                        String newNum = this.getNewNumberByUnit(org.getId().toString());
                        this.editData.setNumber(newNum);
                    }
                } else {
                    super.setEditable(true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        super.loadFields();
        this.clientHelper.registerRequireColumns(ENTRY_NEED);
        this.initControlListener();
        this.initButtonStatus();
        this.initPrecision();
        this.setSupplierF7();
        this.setPurchaseOrgUnitF7();
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            // empty if block
        }
        this.disPlayDataToRed();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.prmtCompanyOrgUnit.setEnabled(false);
        }
    }

    private void initButtonStatus() {
        boolean isDeletable = false;
        if (this.editData.getBaseStatus() == BillBaseStatusEnum.NULL || this.editData.getBaseStatus() == BillBaseStatusEnum.ADD || this.editData.getBaseStatus() == BillBaseStatusEnum.TEMPORARILYSAVED || this.editData.getBaseStatus() == BillBaseStatusEnum.SUBMITED) {
            isDeletable = true;
        }
        this.btnRemove.setEnabled(isDeletable);
        if (this.editData.isIsReversed()) {
            this.btnEdit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnSave.setEnabled(false);
        }
    }

    private void initPrecision() {
        this.initPurPrecision();
        this.initEntryPrecision();
    }

    private void initPurPrecision() {
        CurrencyInfo currencyInfo = this.prmtCurrency.getValue() == null ? null : (CurrencyInfo)this.prmtCurrency.getValue();
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDFormattedTextField[])this.allAmount);
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        sourceCurrPK = currencyInfo == null ? destCurrPK : new ObjectUuidPK(currencyInfo.getId());
        ExchangeRateInfo tempexrateinfo = null;
        try {
            tempexrateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)this.companyOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (tempexrateinfo != null) {
            this.exchangeRateInfo = tempexrateinfo;
            this.txtExchange.setPrecision(this.exchangeRateInfo.getPrecision());
        } else {
            this.txtExchange.setPrecision(2);
        }
    }

    private void initEntryPrecision() {
        SCMClientUtils.changeTableColPrecision((int)this.currencyHomeInfo.getPrecision(), (KDTable)this.kdtEntrys, (String[])entryAmountHome);
        SCMClientUtils.changeTableColPrecision((int)(this.prmtCurrency.getValue() != null ? ((CurrencyInfo)this.prmtCurrency.getValue()).getPrecision() : 2), (KDTable)this.getDetailTable(), (String[])entryAmount);
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.kdtEntrys, (String[])allQty);
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.kdtEntrys, (String[])new String[]{TB_TAXRATIO});
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompanyOrgUnit;
    }

    @Override
    public void storeFields() {
        try {
            this.editData.setAdminOrgUnit(this.getAdminOrgUnitInfo());
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return PurExpenseInvoiceEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurExpenseInvoiceFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        PurExpenseInvoiceEntryInfo pEntryInfo = null;
        try {
            pEntryInfo = this.isUseAgent() ? PurExpenseInvoiceEntryAgent.create() : new PurExpenseInvoiceEntryInfo();
            pEntryInfo.setTaxRate(new BigDecimal("0.00"));
            if (table == null) {
                pEntryInfo.setSeq(1);
            } else {
                pEntryInfo.setSeq(this.getMaxRowNum(table) + 1);
            }
            pEntryInfo.setSettlementStatus(SettlementStateEnum.UNSETTLED);
            if (this.kdtEntrys.getRowCount() >= 1 && this.kdtEntrys.getCell(this.kdtEntrys.getRowCount() - 1, TB_TAXRATIO).getValue() != null) {
                pEntryInfo.setTaxRate(new BigDecimal(this.kdtEntrys.getCell(this.kdtEntrys.getRowCount() - 1, TB_TAXRATIO).getValue().toString()));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return pEntryInfo;
    }

    private int getMaxRowNum(KDTable table) {
        int max = 0;
        int temp = 0;
        int num = table.getRowCount();
        for (int i = 0; i < num; ++i) {
            if (table.getCell(i, 0).getValue() == null || (temp = ((Integer)table.getCell(i, 0).getValue()).intValue()) <= max) continue;
            max = temp;
        }
        return max;
    }

    @Override
    protected IObjectValue createNewData() {
        PurExpenseInvoiceInfo objectValue = null;
        try {
            objectValue = this.isUseAgent() ? PurExpenseInvoiceAgent.create() : new PurExpenseInvoiceInfo();
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            objectValue.setBillType(billTypeInfo);
            objectValue.setCreator(this.user);
            objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            objectValue.setIsReversed(false);
            objectValue.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
            objectValue.setAdminOrgUnit(SysContext.getSysContext().getCurrentAdminUnit());
            if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                objectValue.setCompanyOrgUnit(this.companyOrgInfo);
            } else {
                objectValue.setCompanyOrgUnit(null);
            }
            objectValue.setCurrency(this.currencyHomeInfo);
            objectValue.setExchangeRate(new BigDecimal("1.00"));
            objectValue.setBizDate(new Timestamp(System.currentTimeMillis()));
            objectValue.setAccountDate(new Timestamp(System.currentTimeMillis()));
            try {
                IPaymentType iPaymentType = PaymentTypeFactory.getRemoteInstance();
                PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(BUYONTALLY));
                if (paymentTypeInfo != null) {
                    objectValue.setPaymentType(paymentTypeInfo);
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            try {
                this.setDefaultSettl(objectValue);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            objectValue.getEntries().add((PurExpenseInvoiceEntryInfo)this.createNewDetailData(null));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        return objectValue;
    }

    public void setPaymentType() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)BUYONTALLY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 ");
        viewInfo.setFilter(filter);
        this.prmtPaymentType.setEntityViewInfo(viewInfo);
    }

    private void setDefaultSettl(PurExpenseInvoiceInfo info) throws EASBizException, BOSException {
        ISettlementType isettlementType = SettlementTypeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        SettlementTypeCollection settlementCollection = isettlementType.getSettlementTypeCollection(viewInfo);
        if (settlementCollection != null && settlementCollection.size() > 0) {
            info.setSettlementType(settlementCollection.get(0));
        }
    }

    private void calEntryAmount(int rowIndex) {
        int scale;
        BigDecimal quantity = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_QUANTITY).getValue();
        BigDecimal price = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_PRICE).getValue();
        int n = scale = this.currencyCalInfo == null ? 2 : this.currencyCalInfo.getPrecision();
        if (quantity != null && price != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).setValue((Object)quantity.multiply(price).setScale(scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).setValue(null);
        }
        if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode() != null) {
            if (this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                this.calEntryAmountHomeInd(rowIndex);
            } else {
                this.calEntryAmountHome(rowIndex);
            }
        } else {
            this.calEntryAmountHome(rowIndex);
        }
        this.totalAmount();
    }

    private void calEntryAmountHome(int rowIndex) {
        int scale;
        BigDecimal amount = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amount != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOME).setValue((Object)amount.multiply(exchange).setScale(scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOME).setValue(null);
        }
    }

    private void calEntryAmountHomeInd(int rowIndex) {
        int scale;
        BigDecimal amount = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amount != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOME).setValue((Object)amount.divide(exchange, scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOME).setValue(null);
        }
    }

    private void calEntryAmountTax(int rowIndex) {
        int scale;
        BigDecimal hundrud = new BigDecimal("100.00");
        BigDecimal amount = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).getValue();
        BigDecimal taxRate = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_TAXRATIO).getValue();
        int n = scale = this.currencyCalInfo == null ? 2 : this.currencyCalInfo.getPrecision();
        if (amount != null && taxRate != null) {
            taxRate = taxRate.divide(hundrud, 10, 4);
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAX).setValue((Object)amount.multiply(taxRate).setScale(scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAX).setValue(null);
        }
        if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
            this.calEntryAmountTaxHomeInd(rowIndex);
        } else {
            this.calEntryAmountTaxHome(rowIndex);
        }
        this.totalTax();
    }

    private void calEntryAmountTaxHome(int rowIndex) {
        int scale;
        BigDecimal amountTax = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAX).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amountTax != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAXHOME).setValue((Object)amountTax.multiply(exchange).setScale(scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAXHOME).setValue(null);
        }
    }

    private void calEntryAmountTaxHomeInd(int rowIndex) {
        int scale;
        BigDecimal amountTax = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAX).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amountTax != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAXHOME).setValue((Object)amountTax.divide(exchange, scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAXHOME).setValue(null);
        }
    }

    private void calEntryAmountWithoutTax(int rowIndex) {
        BigDecimal amount = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).getValue();
        BigDecimal amountTax = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTTAX).getValue();
        if (amount != null && amountTax != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTWITHOUTTAX).setValue((Object)amount.subtract(amountTax));
        } else if (amount != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTWITHOUTTAX).setValue((Object)amount);
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTWITHOUTTAX).setValue(null);
        }
        this.totalWithoutTax();
        if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
            this.calEntryAmountWithoutTaxHomeInd(rowIndex);
        } else {
            this.calEntryAmountWithoutTaxHome(rowIndex);
        }
    }

    private void calEntryAmountWithoutTaxHome(int rowIndex) {
        int scale;
        BigDecimal amountWithoutTax = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTWITHOUTTAX).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amountWithoutTax != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOMENOTAX).setValue((Object)amountWithoutTax.multiply(exchange).setScale(scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOMENOTAX).setValue(null);
        }
    }

    private void calEntryAmountWithoutTaxHomeInd(int rowIndex) {
        int scale;
        BigDecimal amountWithoutTax = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTWITHOUTTAX).getValue();
        BigDecimal exchange = this.txtExchange.getBigDecimalValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (amountWithoutTax != null && exchange != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOMENOTAX).setValue((Object)amountWithoutTax.divide(exchange, scale, 4));
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNTHOMENOTAX).setValue(null);
        }
    }

    private void totalAmount() {
        this.txttotalAmount.setValue((Object)this.calculateSum(this.kdtEntrys, TB_AMOUNT).setScale(this.txttotalAmount.getPrecision(), 4));
    }

    private void totalTax() {
        this.txttotalTax.setValue((Object)this.calculateSum(this.kdtEntrys, TB_AMOUNTTAX).setScale(this.txttotalTax.getPrecision(), 4));
    }

    private void totalWithoutTax() {
        this.txttotalWithoutTax.setValue((Object)this.calculateSum(this.kdtEntrys, TB_AMOUNTWITHOUTTAX).setScale(this.txttotalWithoutTax.getPrecision(), 4));
    }

    private void calEntryPrice(int rowIndex) {
        int scale;
        BigDecimal quantity = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_QUANTITY).getValue();
        BigDecimal amount = (BigDecimal)this.kdtEntrys.getRow(rowIndex).getCell(TB_AMOUNT).getValue();
        int n = scale = this.kdtEntrys.getRow(rowIndex).getCell(TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntrys.getRow(rowIndex).getCell(TB_PRICE).getEditor().getComponent()).getPrecision();
        if (quantity != null && amount != null) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_PRICE).setValue((Object)amount.divide(quantity, scale, 4));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    private void checkValid2() throws Exception {
        int entryRow;
        if (this.pkInvoiceDate.getValue() == null) {
            this.pkInvoiceDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_INVOICEDATE"));
            SysUtil.abort();
        }
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            this.prmtCompanyOrgUnit.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_COMPANYORGUIT"));
            SysUtil.abort();
        }
        if (this.prmtSupplier.getValue() == null) {
            this.prmtSupplier.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_SUPPLIER"));
            SysUtil.abort();
        }
        if (this.prmtPurchaseOrgUnit.getValue() == null) {
            this.prmtPurchaseOrgUnit.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_PURCHASEORGUNIT"));
            SysUtil.abort();
        }
        if (this.prmtCurrency.getValue() == null) {
            this.prmtCurrency.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_CURRENCY"));
            SysUtil.abort();
        }
        if (this.txtExchange.getText() == null) {
            this.txtExchange.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_EXCHANGE"));
            SysUtil.abort();
        }
        if (this.prmtSettlementType.getValue() == null) {
            this.prmtSettlementType.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_SETTELMENT"));
            SysUtil.abort();
        }
        if (this.prmtPaymentType.getValue() == null) {
            this.prmtPaymentType.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_PAYMENT"));
            SysUtil.abort();
        }
        if (this.txtBaseStatus.getSelectedItem() == null) {
            this.txtBaseStatus.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_BASESTATE"));
            SysUtil.abort();
        }
        if ((entryRow = this.kdtEntrys.getRowCount()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"NULL_ENTRY"));
            SysUtil.abort();
        }
        this.clientHelper.checkEntryRquiredColumns();
        for (int row = 0; row < entryRow; ++row) {
            IRow arow = this.kdtEntrys.getRow(row);
            if (new BigDecimal(arow.getCell(TB_QUANTITY).getValue().toString()).compareTo(ZERO) != 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"QUANTITY_ZERO"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionVerification_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"addnew_cannot_verify"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || this.editData.isIsReversed()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"check_verify_edit"));
            return;
        }
        IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(this.editData.getId())};
        IObjectPK[] newpks = null;
        IPurExpenseInvoice iPurExpenseInvoice = (IPurExpenseInvoice)this.getBizInterface();
        try {
            newpks = iPurExpenseInvoice.createReverse(pks);
            this.showSuccessMsg("prompt_verify_success");
            this.refreshCurPage();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        SelectorItemCollection sic = this.getBOTPSelectors();
        this.setDataObject((IObjectValue)iPurExpenseInvoice.getPurExpenseInvoiceInfo(newpks[0], sic));
        this.loadFields();
    }

    public void actionSave_performed(ActionEvent e) throws Exception {
        if (this.editData.getBillType() == null) {
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            this.editData.setBillType(billTypeInfo);
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.editData.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 1) {
            SCMClientUtils.delEmptyEntry((KDTable)this.kdtEntrys, (String)TB_FEENUMBER, (SCMBillEditUI)this);
        }
        this.checkValid2();
        if (this.editData.getBillType() == null) {
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            this.editData.setBillType(billTypeInfo);
        }
        this.editData.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"addnew_cannot_audit"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"check_audit_edit"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IPurExpenseInvoice iPurExpenseInvoice = (IPurExpenseInvoice)this.getBizInterface();
        try {
            iPurExpenseInvoice.audit((IObjectPK)pk);
            this.showSuccessMsg("prompt_audit_success");
            this.refreshCurPage();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    @Override
    public void actionDeleted_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"addnew_cannot_cancel"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"check_cancel_edit"));
            return;
        }
        super.actionDeleted_actionPerformed(e);
        IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(this.editData.getId())};
        IPurExpenseInvoice iPurExpenseInvoice = (IPurExpenseInvoice)this.getBizInterface();
        ReasonCodeInfo reasonCodeInfo = ReasonF7Until.getReasonCode((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        if (reasonCodeInfo == null) {
            SysUtil.abort();
        } else {
            ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                reasonCodeInfos[i] = reasonCodeInfo;
            }
            try {
                iPurExpenseInvoice.cancelWithReason(pks, (IObjectValue[])reasonCodeInfos);
                this.showSuccessMsg("prompt_cancel_success");
                this.refreshCurPage();
            }
            catch (EASBizException ex) {
                this.handleException((Exception)((Object)ex));
            }
        }
    }

    @Override
    public void actionBlock_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"addnew_cannot_block"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"check_block_edit"));
            return;
        }
        super.actionBlock_actionPerformed(e);
        IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(this.editData.getId())};
        ReasonCodeInfo reasonCodeInfo = ReasonF7Until.getReasonCode((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        IPurExpenseInvoice iPurExpenseInvoice = (IPurExpenseInvoice)this.getBizInterface();
        if (reasonCodeInfo == null) {
            SysUtil.abort();
        } else {
            ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                reasonCodeInfos[i] = reasonCodeInfo;
            }
            try {
                iPurExpenseInvoice.freezeWithReason(pks, (IObjectValue[])reasonCodeInfos);
                this.showSuccessMsg("prompt_freeze_success");
                this.refreshCurPage();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    @Override
    public void actionUnBlock_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"addnew_cannot_unblock"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES_PROMPT, (String)"check_unblock_edit"));
            return;
        }
        super.actionUnBlock_actionPerformed(e);
        IPurExpenseInvoice iPurExpenseInvoice = (IPurExpenseInvoice)this.getBizInterface();
        IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(this.editData.getId())};
        try {
            iPurExpenseInvoice.unFreeze(pks);
            this.showSuccessMsg("prompt_unfreeze_success");
            this.refreshCurPage();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof String || obj instanceof StringBuffer) {
                String str = obj.toString().trim();
                if (str.matches("-?\\d+\\.?\\d*")) {
                    return new BigDecimal(str);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.totalAmount();
        this.totalTax();
        this.totalWithoutTax();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            this.editData = ((IPurExpenseInvoice)this.getBizInterface()).getPurExpenseInvoiceInfo((IObjectPK)iObjectPk, this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)msgResource));
        this.showMessage();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, true);
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurExpenseInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, false);
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("reasonCode.id"));
        sic.add(new SelectorItemInfo("reasonCode.name"));
        sic.add(new SelectorItemInfo("reasonCode.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        return sic;
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        PurExpenseInvoiceCollection billCol = new PurExpenseInvoiceCollection();
        billCol.add(this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        InvoicePrintDataSource rsprv = new InvoicePrintDataSource(billCol){

            public InvoicePrintDataSource.ColDesc[] getColDesc() {
                return new InvoicePrintDataSource.ColDesc[]{new InvoicePrintDataSource.ColDesc("number", "number"), new InvoicePrintDataSource.ColDesc("companyOrgUnitNum", "companyOrgUnit.number"), new InvoicePrintDataSource.ColDesc("companyOrgUnitName", "companyOrgUnit.name"), new InvoicePrintDataSource.ColDesc("purchaseOrgUnitNum", "purchaseOrgUnit.number"), new InvoicePrintDataSource.ColDesc("purchaseOrgUnitName", "purchaseOrgUnit.name"), new InvoicePrintDataSource.ColDesc("supplierNum", "supplier.number"), new InvoicePrintDataSource.ColDesc("supplierName", "supplier.name"), new InvoicePrintDataSource.ColDesc("supplierNum", "supplier.taxRegisterNo"), new InvoicePrintDataSource.ColDesc("paymentType", "paymentType.name"), new InvoicePrintDataSource.ColDesc("settlementTypeNum", "settlementType.number"), new InvoicePrintDataSource.ColDesc("settlementTypeName", "settlementType.name"), new InvoicePrintDataSource.ColDesc("currency", "currency.name"), new InvoicePrintDataSource.ColDesc("invoiceNo", "invoiceNumber"), new InvoicePrintDataSource.ColDesc("exchange", "exchange", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("invoiceDate", "invoiceDate", 2), new InvoicePrintDataSource.ColDesc("summary", "summary"), new InvoicePrintDataSource.ColDesc("reversingState", "reversingState"), new InvoicePrintDataSource.ColDesc("creator", "creator.name"), new InvoicePrintDataSource.ColDesc("createTime", "createTime", 2), new InvoicePrintDataSource.ColDesc("lastupdateUser", "modifier.name"), new InvoicePrintDataSource.ColDesc("lastupdateTime", "modificationTime", 2), new InvoicePrintDataSource.ColDesc("audit", "auditor.name"), new InvoicePrintDataSource.ColDesc("auditTime", "auditTime", 2), new InvoicePrintDataSource.ColDesc("totalAmount", "totalAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("totalTax", "totalTax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("totalWithoutTax", "totalWithoutTax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_seq", "entries.seq"), new InvoicePrintDataSource.ColDesc("e_expenseItemNum", "entries.expenseItem.number"), new InvoicePrintDataSource.ColDesc("e_expenseItemName", "entries.expenseItem.name"), new InvoicePrintDataSource.ColDesc("e_expenseItemClass", "entries.expenseItem.expenseType"), new InvoicePrintDataSource.ColDesc("e_measureUnit", "entries.measureUnit.name"), new InvoicePrintDataSource.ColDesc("e_taxRatio", "entries.taxRate"), new InvoicePrintDataSource.ColDesc("e_amountTax", "entries.tax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_amountWithoutTa", "entries.nonTaxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_qty", "entries.qty", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_price", "entries.price", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_isPresent", "entries.isPresent"), new InvoicePrintDataSource.ColDesc("e_assistQuantity", "entries.assistQuantity"), new InvoicePrintDataSource.ColDesc("e_returnsQty", "entries.returnsQty", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_unit", "entries.unit.name"), new InvoicePrintDataSource.ColDesc("e_taxRate", "entries.taxRate", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_basePrice", "entries.basePrice", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_taxPrice", "entries.taxPrice", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_amount", "entries.amount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_totalTaxAmount", "entries.totalTaxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_taxAmount", "entries.taxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_returnsDate", "entries.returnsDate", 2), new InvoicePrintDataSource.ColDesc("e_storageOrgUnitNum", "entries.storageOrgUnit.number"), new InvoicePrintDataSource.ColDesc("e_storageOrgUnitName", "entries.storageOrgUnit.name"), new InvoicePrintDataSource.ColDesc("e_warehouse", "entries.warehouse.name"), new InvoicePrintDataSource.ColDesc("e_warehousePosition", "entries.location"), new InvoicePrintDataSource.ColDesc("e_batchNumber", "entries.batchNumber"), new InvoicePrintDataSource.ColDesc("e_companyOrgUnit", "entries.companyOrgUnit.number"), new InvoicePrintDataSource.ColDesc("e_companyOrgUnit", "entries.companyOrgUnit.name"), new InvoicePrintDataSource.ColDesc("e_returnsReasonNum", "entries.returnsReason.number"), new InvoicePrintDataSource.ColDesc("e_returnsReasonName", "entries.returnsReason.name")};
            }
        };
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListner());
        if (noPreview) {
            appHlp.print("/SCM/SM/PurExpenseInvoice", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/SCM/SM/PurExpenseInvoice", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public boolean isFromMsgCenterToEditUI(SCMBillEditUI ui) {
        Map ctx = ui.getUIContext();
        boolean isFromMsgCenter = Boolean.TRUE.equals(ctx.get("isFromWorkflow"));
        return isFromMsgCenter;
    }

    protected void checkCanEdit() throws Exception {
        String id = this.editData.getId().toString();
        if (id != null) {
            PurExpenseInvoiceInfo pinfo;
            ObjectStringPK pk = new ObjectStringPK(id);
            PurExpenseInvoiceInfo billInfo = this.editData;
            if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                MsgBox.showError((Component)((Object)this), (String)(SCMClientUtils.getResource((String)"BillAt") + billInfo.getBaseStatus().getAlias() + SCMClientUtils.getResource((String)"CantBeEdited")));
                SysUtil.abort();
            }
            if ((pinfo = PurExpenseInvoiceFactory.getRemoteInstance().getPurExpenseInvoiceInfo((IObjectPK)pk)).isIsReversed()) {
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"reverse_cannot_edit"));
                SysUtil.abort();
            }
        }
    }

    protected void clearField() {
        this.txttotalAmount.setText(null);
        this.txttotalTax.setText(null);
        this.txttotalWithoutTax.setText(null);
        if (this.oprtState.equalsIgnoreCase("ADDNEW")) {
            this.editData.setIsCost(true);
            this.cbIsCost.setSelected(true);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        PurExpenseInvoiceInfo pinfo = (PurExpenseInvoiceInfo)newData;
        pinfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
        pinfo.setVoucherNumber(null);
        pinfo.setFiVouchered(false);
        pinfo.setAuditTime(null);
        pinfo.setAuditor(null);
        pinfo.setModifier(null);
        pinfo.setModificationTime(null);
        pinfo.setLastUpdateTime(null);
        pinfo.setLastUpdateUser(null);
        pinfo.setIsReversed(false);
        pinfo.setReverseInvNumber(null);
        pinfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
        pinfo.setSourceBillId(null);
        pinfo.setSourceBillType(null);
        PurExpenseInvoiceEntryCollection collection = pinfo.getEntries();
        if (collection != null) {
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                PurExpenseInvoiceEntryInfo entryinfo = collection.get(i);
                entryinfo.setSettlementStatus(SettlementStateEnum.UNSETTLED);
            }
        }
    }

    public void setNumWhereCopy() throws Exception {
    }

    protected String getOnloadPermItemName() {
        if ("ADDNEW".equals(this.getOprtState())) {
            return "purexpInv_addnew";
        }
        return null;
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo() throws EASBizException, BOSException {
        PurchaseOrgUnitInfo purchaseInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        AdminOrgUnitInfo adminInfo = null;
        if (purchaseInfo != null) {
            IOrgUnitRelation iour = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection ioc = iour.getToUnit(purchaseInfo.getId().toString(), 3, 0);
            OrgUnitInfo ouInfo = null;
            int size = ioc.size();
            for (int i = 0; i < size; ++i) {
                ouInfo = ioc.get(i);
                if (ouInfo == null) continue;
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(ouInfo.getId());
                adminInfo.setName(ouInfo.getName());
                adminInfo.setNumber(ouInfo.getNumber());
                return adminInfo;
            }
        }
        return adminInfo;
    }

    class PrintListner
    implements IPrintActionListener {
        PrintListner() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            PurExpenseInvoiceEditUI.this.logUIOperation("LOG_PRINT");
        }

        public void closePreview() {
        }
    }

    class TableValueListener
    implements KDTEditListener {
        TableValueListener() {
        }

        public void editStarting(KDTEditEvent arg0) {
        }

        public void editStarted(KDTEditEvent arg0) {
        }

        public void editValueChanged(KDTEditEvent arg0) {
        }

        public void editStopping(KDTEditEvent arg0) {
        }

        public void editStopped(KDTEditEvent e) {
            int selectedRow = e.getRowIndex();
            int selectedCol = e.getColIndex();
            KDTable kdtEntry = (KDTable)e.getSource();
            if (selectedCol == 1) {
                if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                    BOSUuid unitInfoID;
                    MeasureUnitInfo unitInfo;
                    BOSUuid typeInfoID;
                    ExpenseItemInfo info = (ExpenseItemInfo)e.getValue();
                    kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEENAME).setValue((Object)info.getName());
                    kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEENUMBER).setUserObject((Object)info);
                    ExpenseTypeInfo typeInfo = info.getExpenseType();
                    if (typeInfo != null && (typeInfoID = info.getExpenseType().getId()) != null) {
                        try {
                            typeInfo = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(typeInfoID));
                            kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_EXPENSETYPE).setValue((Object)typeInfo);
                            kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_EXPENSETYPE).setUserObject((Object)typeInfo);
                        }
                        catch (Exception e1) {
                            PurExpenseInvoiceEditUI.this.handleException(e1);
                        }
                    }
                    if ((unitInfo = info.getDefaultUnit()) != null && (unitInfoID = info.getDefaultUnit().getId()) != null) {
                        try {
                            unitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfoID));
                            kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEEUNIT).setValue((Object)unitInfo);
                            kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEEUNIT).setUserObject((Object)unitInfo);
                        }
                        catch (Exception e1) {
                            PurExpenseInvoiceEditUI.this.handleException(e1);
                        }
                    }
                } else if (e.getValue() == null) {
                    kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEENAME).setValue(null);
                    kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_EXPENSETYPE).setValue(null);
                    kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_FEEUNIT).setValue(null);
                }
            } else if (selectedCol == 6 || selectedCol == 8) {
                if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                    BigDecimal quantity = PurExpenseInvoiceEditUI.toBigDecimal(kdtEntry.getRow(selectedRow).getCell(8).getValue());
                    BigDecimal price = PurExpenseInvoiceEditUI.toBigDecimal(kdtEntry.getRow(selectedRow).getCell(6).getValue());
                    if (quantity != null && (quantity.compareTo(MAX_VALUE) == 1 || quantity.compareTo(MIN_VALUE) == -1)) {
                        kdtEntry.getRow(selectedRow).getCell(8).setValue(null);
                        kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_AMOUNT).setValue(null);
                        MsgBox.showError((String)EASResource.getString((String)PurExpenseInvoiceEditUI.RES_PROMPT, (String)"prompt_digit_outofrange"));
                        kdtEntry.getSelectManager().select(selectedRow, 8);
                        return;
                    }
                    if (price != null && (price.compareTo(MAX_VALUE) == 1 || price.compareTo(MIN_VALUE) == -1)) {
                        kdtEntry.getRow(selectedRow).getCell(6).setValue(null);
                        kdtEntry.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_AMOUNT).setValue(null);
                        MsgBox.showError((String)EASResource.getString((String)PurExpenseInvoiceEditUI.RES_PROMPT, (String)"prompt_digit_outofrange"));
                        kdtEntry.getSelectManager().select(selectedRow, 6);
                        return;
                    }
                    if (quantity != null && price != null) {
                        PurExpenseInvoiceEditUI.this.calEntryAmount(selectedRow);
                        PurExpenseInvoiceEditUI.this.calEntryAmountTax(selectedRow);
                        PurExpenseInvoiceEditUI.this.calEntryAmountWithoutTax(selectedRow);
                    }
                }
            } else if (selectedCol == 9) {
                if (e.getValue() != null && e.getOldValue() != e.getValue()) {
                    PurExpenseInvoiceEditUI.this.totalAmount();
                    PurExpenseInvoiceEditUI.this.calEntryPrice(selectedRow);
                    PurExpenseInvoiceEditUI.this.calEntryAmountTax(selectedRow);
                    PurExpenseInvoiceEditUI.this.calEntryAmountWithoutTax(selectedRow);
                    if (PurExpenseInvoiceEditUI.this.exchangeRateInfo != null && PurExpenseInvoiceEditUI.this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        PurExpenseInvoiceEditUI.this.calEntryAmountHomeInd(selectedRow);
                    } else {
                        PurExpenseInvoiceEditUI.this.calEntryAmountHome(selectedRow);
                    }
                }
            } else if (selectedCol == 7 && e.getValue() != null && e.getOldValue() != e.getValue()) {
                BigDecimal taxRate = (BigDecimal)PurExpenseInvoiceEditUI.this.kdtEntrys.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_TAXRATIO).getValue();
                if (taxRate.compareTo(new BigDecimal("100.00")) == 1) {
                    MsgBox.showInfo((String)EASResource.getString((String)PurExpenseInvoiceEditUI.RES_PROMPT, (String)"taxRateThan100"));
                    PurExpenseInvoiceEditUI.this.kdtEntrys.getRow(selectedRow).getCell(PurExpenseInvoiceEditUI.TB_TAXRATIO).setValue((Object)new BigDecimal("0.00"));
                    SysUtil.abort();
                }
                PurExpenseInvoiceEditUI.this.calEntryAmountTax(selectedRow);
                PurExpenseInvoiceEditUI.this.calEntryAmountWithoutTax(selectedRow);
                PurExpenseInvoiceEditUI.this.totalTax();
                PurExpenseInvoiceEditUI.this.totalWithoutTax();
            }
        }

        public void editCanceled(KDTEditEvent arg0) {
        }
    }
}

