/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurInnerDealPriceEditUI;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PurInnerDealPriceEditUI
extends AbstractPurInnerDealPriceEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(PurInnerDealPriceEditUI.class);
    KDTEditAdapter entryTableChange = null;
    private static final String TB_ID = "id";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_PRICE = "price";
    private static final String TB_TAXPRICE = "taxPrice";
    private static final String TB_DISCOUNT = "discount";
    private static final String TB_PURORDERENTRYID = "purOrderEntry.id";
    private static final String TB_PURORDERID = "purOrder.id";
    private static final String TB_NUMBER = "number";
    private static final String TB_PRECISION = "pricePrecision";
    private static final String TB_BASESTATUS = "baseStatus";
    private static final String TB_SUPSTORAGE = "supStorageOrg.name";
    private static final String TB_SUPWAREHOUSE = "supWareHouse.name";
    private static final String TB_RECSTORAGE = "recStorageOrg.name";
    private static final String TB_RECWAREHOUSE = "recWareHouse.name";
    private static final String TB_SUPCOMPANYID = "supCompanyOrg.id";
    private static final String TB_SUPSTORAGEID = "supStorageOrg.id";
    private static final String TB_SUPWAREHOUSEID = "supWareHouse.id";
    private static final String TB_RECCOMPANYID = "recCompanyOrg.id";
    private static final String TB_RECSTORAGEID = "recStorageOrg.id";
    private static final String TB_RECWAREHOUSEID = "recWareHouse.id";
    private static final String TB_EXCHANGERATE = "exchangeRate";
    private static String[] QTYAMOUNTCOLUMNS = new String[]{"price", "taxPrice"};
    private static String[] EDITCOLUMNS = new String[]{"price", "taxRate", "taxPrice", "discount"};
    private static String[] F7COLUMNS = new String[]{"recStorageOrg.name", "recWareHouse.name"};
    private int discountScale = 2;
    private FilterInfo filter = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.setOprtState(OprtState.VIEW);
        this.tblMain.getGroupManager().setGroup(true);
        this.getUIContext().put("RequestModel", 0);
        super.onLoad();
        this.initBtn();
        String rateScale = ParamManager.getParamByNumber(null, (String)"DISCOUNTRATEPRECISION").getDefaultValue();
        this.discountScale = Integer.parseInt(rateScale);
        this.initTableListener();
    }

    private void initTableF7Field(String column, String query, boolean isEditable) {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setEditable(isEditable);
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setCommitFormat("$number$");
        prmtBox.setQueryInfo(query);
        this.tblMain.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBox));
    }

    private void initBtn() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.setEditable(false);
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.tblMain.setEditable(true);
            this.btnSave.setEnabled(true);
            this.btnEdit.setEnabled(false);
        }
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    private void initTableListener() {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PurInnerDealPriceEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    PurInnerDealPriceEditUI.this.handUIException(exc);
                }
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    PurInnerDealPriceEditUI.this.kdtEntrys_editStarting(e);
                }
                catch (Exception exc) {
                    PurInnerDealPriceEditUI.this.handUIException(exc);
                }
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                PurInnerDealPriceEditUI.this.tbl_afterDataFill(e);
            }
        });
    }

    protected void tbl_afterDataFill(KDTDataRequestEvent e) {
        this.initTableCellEditor();
    }

    private void initTableCellEditor() {
        int count = this.tblMain.getRowCount();
        int status = 4;
        BizEnumValueDTO bizEnumValue = null;
        for (int r = 0; r < count; ++r) {
            IRow row = this.tblMain.getRow(r);
            this.formatCell(2, TB_TAXRATE, row, true);
            this.formatCell(this.discountScale, TB_DISCOUNT, row, true);
            int n = QTYAMOUNTCOLUMNS.length;
            for (int i = 0; i < n; ++i) {
                int precision = 4;
                if (row.getCell(TB_PRECISION) != null) {
                    Object precisionInteger = row.getCell(TB_PRECISION).getValue();
                    precision = Integer.parseInt(String.valueOf(precisionInteger));
                }
                this.formatCell(precision, QTYAMOUNTCOLUMNS[i], row, true);
            }
            if (row.getCell(TB_BASESTATUS).getValue() instanceof BizEnumValueDTO) {
                bizEnumValue = (BizEnumValueDTO)row.getCell(TB_BASESTATUS).getValue();
                status = Integer.parseInt(bizEnumValue.getValue().toString());
            }
            if (status == 4) {
                SCMClientUtils.lockCells((IRow)row, (String[])F7COLUMNS, (boolean)false);
            }
            if (row.getCell(TB_EXCHANGERATE).getValue() == null) continue;
            BigDecimal exchangeRate = (BigDecimal)row.getCell(TB_EXCHANGERATE).getValue();
            if (exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                this.formatCell(2, TB_EXCHANGERATE, row, false);
                continue;
            }
            this.formatCell(4, TB_EXCHANGERATE, row, true);
        }
    }

    private void formatCell(int precision, String columnName, IRow row, boolean takeOutZero) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setNegatived(false);
        String colPrecision = SCMClientUtils.getFormatPattern((int)precision, (boolean)takeOutZero);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        if (row.getCell(columnName) != null) {
            row.getCell(columnName).setEditor((ICellEditor)col_CellEditor);
        }
        row.getCell(columnName).getStyleAttributes().setNumberFormat(colPrecision);
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    protected void kdtEntrys_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (TB_RECWAREHOUSE.equals(fieldName)) {
            if (this.tblMain.getRow(rowIndex).getCell(TB_RECSTORAGE).getValue() == null) {
                e.setCancel(true);
            }
            this.registerWarehouseF7(rowIndex, TB_RECSTORAGE, TB_RECWAREHOUSE, TB_RECSTORAGEID);
        } else if (TB_RECSTORAGE.equals(fieldName)) {
            if (this.tblMain.getRow(rowIndex).getCell(TB_RECCOMPANYID).getValue() == null) {
                e.setCancel(true);
            }
            this.registerStorageF7(rowIndex, TB_RECSTORAGE, TB_RECCOMPANYID);
        }
    }

    protected void kdtEntries_Changed(KDTEditEvent e) {
        WarehouseInfo info;
        BigDecimal newBigValue;
        BigDecimal oldBigValue;
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (oldValue != null && newValue != null && (oldValue instanceof BigDecimal && newValue instanceof BigDecimal ? (oldBigValue = (BigDecimal)oldValue).compareTo(newBigValue = (BigDecimal)newValue) == 0 : oldValue.equals(newValue))) {
            return;
        }
        if (TB_DISCOUNT.equals(fieldName)) {
            BigDecimal discount = BigDecimal.ZERO;
            if (newValue != null) {
                discount = (BigDecimal)newValue;
            }
            if (discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                this.tblMain.getCell(rowIndex, colIndex).setValue((Object)SCMConstant.BIGDECIMAL_ONEHUNDRED);
                return;
            }
        } else if (TB_TAXRATE.equals(fieldName)) {
            BigDecimal taxRate = (BigDecimal)newValue;
            if (taxRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                taxRate = (BigDecimal)oldValue;
                this.tblMain.getCell(rowIndex, colIndex).setValue((Object)taxRate);
                return;
            }
            this.calTaxPriceByPrice(rowIndex);
        } else if (TB_PRICE.equals(fieldName)) {
            this.calTaxPriceByPrice(rowIndex);
        } else if (TB_TAXPRICE.equals(fieldName)) {
            this.calPriceByTaxPrice(rowIndex);
        } else if (TB_RECSTORAGE.equals(fieldName)) {
            this.tblMain.getCell(rowIndex, TB_RECWAREHOUSE).setValue(null);
            this.tblMain.getCell(rowIndex, TB_RECWAREHOUSEID).setValue(null);
            if (e.getValue() != null) {
                info = (StorageOrgUnitInfo)e.getValue();
                this.tblMain.getCell(rowIndex, TB_RECSTORAGEID).setValue((Object)info.getId().toString());
            } else {
                this.tblMain.getCell(rowIndex, TB_RECSTORAGEID).setValue(null);
            }
            this.dealWithSupStorageOrWare(rowIndex, e.getValue(), fieldName);
        } else if (TB_RECWAREHOUSE.equals(fieldName)) {
            if (e.getValue() != null) {
                info = (WarehouseInfo)e.getValue();
                this.tblMain.getCell(rowIndex, TB_RECWAREHOUSEID).setValue((Object)info.getId().toString());
            } else {
                this.tblMain.getCell(rowIndex, TB_RECWAREHOUSEID).setValue(null);
            }
            this.dealWithSupStorageOrWare(rowIndex, e.getValue(), fieldName);
        }
    }

    private void dealWithSupStorageOrWare(int rowIndex, Object obj, String fieldName) {
        String recCompanyId = this.tblMain.getCell(rowIndex, TB_RECCOMPANYID).getValue().toString();
        String curEntryId = this.tblMain.getCell(rowIndex, TB_PURORDERENTRYID).getValue().toString();
        if (StringUtils.isEmpty((String)recCompanyId) || StringUtils.isEmpty((String)curEntryId)) {
            return;
        }
        String coreEntryId = "";
        String supCompanyId = "";
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            WarehouseInfo info;
            if (i == rowIndex) continue;
            coreEntryId = this.tblMain.getCell(i, TB_PURORDERENTRYID).getValue().toString();
            supCompanyId = this.tblMain.getCell(i, TB_SUPCOMPANYID).getValue().toString();
            if (StringUtils.isEmpty((String)coreEntryId) || StringUtils.isEmpty((String)supCompanyId) || !curEntryId.equals(coreEntryId) || !recCompanyId.equals(supCompanyId)) continue;
            if (TB_RECSTORAGE.equals(fieldName)) {
                this.tblMain.getCell(i, TB_SUPWAREHOUSE).setValue(null);
                this.tblMain.getCell(i, TB_SUPWAREHOUSEID).setValue(null);
                if (obj != null) {
                    info = (StorageOrgUnitInfo)obj;
                    this.tblMain.getCell(i, TB_SUPSTORAGEID).setValue((Object)info.getId().toString());
                    this.tblMain.getCell(i, TB_SUPSTORAGE).setValue((Object)info);
                    continue;
                }
                this.tblMain.getCell(i, TB_SUPSTORAGEID).setValue(null);
                this.tblMain.getCell(i, TB_SUPSTORAGE).setValue(null);
                continue;
            }
            if (!TB_RECWAREHOUSE.equals(fieldName)) continue;
            if (obj != null) {
                info = (WarehouseInfo)obj;
                this.tblMain.getCell(i, TB_SUPWAREHOUSEID).setValue((Object)info.getId().toString());
                this.tblMain.getCell(i, TB_SUPWAREHOUSE).setValue((Object)info);
                continue;
            }
            this.tblMain.getCell(i, TB_SUPWAREHOUSEID).setValue(null);
            this.tblMain.getCell(i, TB_SUPWAREHOUSE).setValue(null);
        }
    }

    private void calTaxPriceByPrice(int rowIndex) {
        int precision = 4;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        if (this.tblMain.getCell(rowIndex, TB_TAXRATE).getValue() != null) {
            taxRate = (BigDecimal)this.tblMain.getCell(rowIndex, TB_TAXRATE).getValue();
        }
        if (this.tblMain.getCell(rowIndex, TB_PRICE).getValue() != null) {
            price = (BigDecimal)this.tblMain.getCell(rowIndex, TB_PRICE).getValue();
        }
        if (this.tblMain.getCell(rowIndex, TB_PRECISION).getValue() != null) {
            precision = Integer.parseInt(this.tblMain.getCell(rowIndex, TB_PRECISION).getValue().toString());
        }
        if (price.compareTo(BigDecimal.ZERO) != 0) {
            taxPrice = price.multiply(BigDecimal.ONE.add(taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4))).setScale(precision, 4);
        }
        this.tblMain.getCell(rowIndex, TB_TAXPRICE).setValue((Object)taxPrice);
    }

    private void calPriceByTaxPrice(int rowIndex) {
        int precision = 4;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        if (this.tblMain.getCell(rowIndex, TB_TAXRATE).getValue() != null) {
            taxRate = (BigDecimal)this.tblMain.getCell(rowIndex, TB_TAXRATE).getValue();
        }
        if (this.tblMain.getCell(rowIndex, TB_TAXPRICE).getValue() != null) {
            taxPrice = (BigDecimal)this.tblMain.getCell(rowIndex, TB_TAXPRICE).getValue();
        }
        if (this.tblMain.getCell(rowIndex, TB_PRECISION).getValue() != null) {
            precision = Integer.parseInt(this.tblMain.getCell(rowIndex, TB_PRECISION).getValue().toString());
        }
        if (taxPrice.compareTo(BigDecimal.ZERO) != 0) {
            price = taxPrice.divide(BigDecimal.ONE.add(taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4)), precision, 4);
        }
        this.tblMain.getCell(rowIndex, TB_PRICE).setValue((Object)price);
    }

    private void setQueryFilter() {
        Object[] tempIds = (String[])this.getUIContext().get("purOrderEntryIds");
        Object[] id = null;
        id = this.getUIContext().get("ID") != null ? new String[]{(String)this.getUIContext().get("ID")} : (String[])this.getUIContext().get("purOrderIds");
        this.filter = new FilterInfo();
        if (tempIds != null) {
            this.filter.getFilterItems().add(new FilterItemInfo(TB_PURORDERENTRYID, (Object)StringUtil.getKeyIdList((Object[])tempIds).replaceAll("'", ""), CompareType.INCLUDE));
        } else if (id != null) {
            this.filter.getFilterItems().add(new FilterItemInfo(TB_PURORDERID, (Object)StringUtil.getKeyIdList((Object[])id).replaceAll("'", ""), CompareType.INCLUDE));
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        this.setQueryFilter();
        viewInfo.setFilter(this.filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("purOrder.number");
        itemInfo.setSortType(SortType.ASCEND);
        sic.add(itemInfo);
        SorterItemInfo itemInfo1 = new SorterItemInfo("purOrderEntry.seq");
        itemInfo1.setSortType(SortType.ASCEND);
        sic.add(itemInfo1);
        viewInfo.setSorter(sic);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.EDIT);
        this.initBtn();
        int count = this.tblMain.getRowCount();
        int status = 4;
        BizEnumValueDTO bizEnumValue = null;
        for (int r = 0; r < count; ++r) {
            IRow row = this.tblMain.getRow(r);
            if (row.getCell(TB_BASESTATUS).getValue() instanceof BizEnumValueDTO) {
                bizEnumValue = (BizEnumValueDTO)row.getCell(TB_BASESTATUS).getValue();
                status = Integer.parseInt(bizEnumValue.getValue().toString());
            }
            if (status != 4) {
                SCMClientUtils.setNecessColorInTable((KDTable)this.tblMain, (int)r, (String[])EDITCOLUMNS, (boolean)false);
                continue;
            }
            SCMClientUtils.lockCells((IRow)row, (String[])EDITCOLUMNS, (boolean)false);
            SCMClientUtils.setNecessColorInTable((KDTable)this.tblMain, (int)r, (String[])EDITCOLUMNS, (boolean)true);
        }
        this.initTableF7Field(TB_SUPSTORAGE, "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery", false);
        this.initTableF7Field(TB_SUPWAREHOUSE, "com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery", false);
        this.initTableF7Field(TB_RECSTORAGE, "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery", true);
        this.initTableF7Field(TB_RECWAREHOUSE, "com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery", true);
    }

    private void registerWarehouseF7(int rowIndex, String colStorageOrg, String colWareHouse, String colStorageOrgID) {
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        if (this.tblMain.getRow(rowIndex).getCell(colStorageOrg).getValue() instanceof StorageOrgUnitInfo) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)this.tblMain.getRow(rowIndex).getCell(colStorageOrg).getValue();
        } else if (this.tblMain.getRow(rowIndex).getCell(colStorageOrg).getValue() instanceof String) {
            String id = this.tblMain.getRow(rowIndex).getCell(colStorageOrgID).getValue().toString();
            storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setId(BOSUuid.read((String)id));
        }
        if (storageOrgUnitInfo != null) {
            KDBizPromptBox prmtWarehouse = (KDBizPromptBox)this.tblMain.getColumn(colWareHouse).getEditor().getComponent();
            try {
                EntityViewInfo viewInfo = SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgUnitInfo, (int)-1);
                prmtWarehouse.setEntityViewInfo(viewInfo);
                prmtWarehouse.getQueryAgent().resetRuntimeEntityView();
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void registerStorageF7(int rowIndex, String colStorageOrg, String colCompanyOrgID) {
        try {
            if (this.tblMain.getRow(rowIndex).getCell(colCompanyOrgID).getValue() != null) {
                FilterInfo filter = new FilterInfo();
                String id = this.tblMain.getRow(rowIndex).getCell(colCompanyOrgID).getValue().toString();
                OrgUnitCollection collection = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(id, 1, 4);
                if (collection != null && collection.size() > 0) {
                    HashSet<String> idSet = new HashSet<String>();
                    int size = collection.size();
                    for (int i = 0; i < size; ++i) {
                        idSet.add(collection.get(i).getId().toString());
                    }
                    filter.getFilterItems().add(new FilterItemInfo(TB_ID, idSet, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)"88888888"));
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                KDBizPromptBox prmtStorageOrg = (KDBizPromptBox)this.tblMain.getColumn(colStorageOrg).getEditor().getComponent();
                prmtStorageOrg.setEntityViewInfo(view);
                prmtStorageOrg.getQueryAgent().resetRuntimeEntityView();
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        if (count == 0) {
            return;
        }
        PurInnerDealPriceFactory.getRemoteInstance().batchSave((IObjectCollection)this.getDataBySave());
        this.setOprtState(OprtState.VIEW);
        this.initBtn();
        SCMClientUtils.setNecessColorInTable((KDTable)this.tblMain, (String[])EDITCOLUMNS, (boolean)false);
    }

    private PurInnerDealPriceCollection getDataBySave() {
        PurInnerDealPriceInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderInfo orderInfo = null;
        StorageOrgUnitInfo supStorageOrg = null;
        StorageOrgUnitInfo recStorageOrg = null;
        WarehouseInfo supWareHouse = null;
        WarehouseInfo recWareHouse = null;
        IRow row = null;
        int count = this.tblMain.getRowCount();
        int status = 4;
        PurInnerDealPriceCollection coll = new PurInnerDealPriceCollection();
        BizEnumValueDTO bizEnumValue = null;
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(TB_BASESTATUS).getValue() instanceof BizEnumValueDTO) {
                bizEnumValue = (BizEnumValueDTO)row.getCell(TB_BASESTATUS).getValue();
                status = Integer.parseInt(bizEnumValue.getValue().toString());
            }
            if (status != 4) continue;
            info = new PurInnerDealPriceInfo();
            String id = (String)row.getCell(TB_ID).getValue();
            if (id != null) {
                info.setId(BOSUuid.read((String)id));
            }
            info.setTaxRate(this.nullToZero(row.getCell(TB_TAXRATE).getValue()));
            info.setPrice(this.nullToZero(row.getCell(TB_PRICE).getValue()));
            info.setTaxPrice(this.nullToZero(row.getCell(TB_TAXPRICE).getValue()));
            info.setDiscount(this.nullToZero(row.getCell(TB_DISCOUNT).getValue()));
            entryInfo = new PurOrderEntryInfo();
            entryInfo.setId(BOSUuid.read((String)((String)row.getCell(TB_PURORDERENTRYID).getValue())));
            info.setPurOrderEntry(entryInfo);
            orderInfo = new PurOrderInfo();
            orderInfo.setId(BOSUuid.read((String)((String)row.getCell(TB_PURORDERID).getValue())));
            orderInfo.setNumber(row.getCell(TB_NUMBER).getValue().toString());
            info.setPurOrder(orderInfo);
            if (row.getCell(TB_SUPSTORAGEID).getValue() != null && !"".equals(row.getCell(TB_SUPSTORAGEID).getValue())) {
                supStorageOrg = new StorageOrgUnitInfo();
                supStorageOrg.setId(BOSUuid.read((String)row.getCell(TB_SUPSTORAGEID).getValue().toString()));
                info.setSupStorageOrg(supStorageOrg);
            }
            if (row.getCell(TB_SUPWAREHOUSEID).getValue() != null && !"".equals(row.getCell(TB_SUPWAREHOUSEID).getValue())) {
                supWareHouse = new WarehouseInfo();
                supWareHouse.setId(BOSUuid.read((String)row.getCell(TB_SUPWAREHOUSEID).getValue().toString()));
                info.setSupWareHouse(supWareHouse);
            }
            if (row.getCell(TB_RECSTORAGEID).getValue() != null && !"".equals(row.getCell(TB_RECSTORAGEID).getValue())) {
                recStorageOrg = new StorageOrgUnitInfo();
                recStorageOrg.setId(BOSUuid.read((String)row.getCell(TB_RECSTORAGEID).getValue().toString()));
                info.setRecStorageOrg(recStorageOrg);
            }
            if (row.getCell(TB_RECWAREHOUSEID).getValue() != null && !"".equals(row.getCell(TB_RECWAREHOUSEID).getValue())) {
                recWareHouse = new WarehouseInfo();
                recWareHouse.setId(BOSUuid.read((String)row.getCell(TB_RECWAREHOUSEID).getValue().toString()));
                info.setRecWareHouse(recWareHouse);
            }
            coll.add(info);
        }
        return coll;
    }

    private BigDecimal nullToZero(Object obj) {
        BigDecimal value = BigDecimal.ZERO;
        if (obj != null) {
            value = (BigDecimal)obj;
        }
        return value;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

