/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgInnerUtils;
import com.kingdee.eas.basedata.scm.common.InitializeInvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.CCRelationBillListImpl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.UserQueryFilterProcessor;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurInvoice;
import com.kingdee.eas.scm.sm.pur.PurInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurInvoiceListUI;
import com.kingdee.eas.scm.sm.pur.client.PurInvoiceEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurInvoiceQueryUI;
import com.kingdee.eas.scm.sm.pur.client.PurInvoiceUIUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurInvoiceListUI
extends AbstractPurInvoiceListUI {
    static final String TB_ID = "id";
    static final String TB_PURORGNAME = "purchaseOrgUnit.name";
    static final String TB_NUMBER = "number";
    static final String TB_INVOICEDATE = "invoiceDate";
    static final String TB_SUPPLIERNAME = "supplier.name";
    static final String TB_INVOICETYPE = "invoiceType";
    static final String TB_BIZTYPE = "bizType";
    static final String TB_SOURCEBILLTYPE = "sourceBillType";
    static final String TB_PAYMENTTYPE = "paymentType";
    static final String TB_SETTLEMENTTYPE = "settlementType";
    static final String TB_QTY = "entries.quantity";
    static final String TB_ASSISTQTY = "entries.assistQuantity";
    static final String TB_PRICE = "entries.price";
    static final String TB_DISCOUNTRATE = "entires.discountRate";
    static final String TB_DISCOUNTAMOUNT = "entries.discountAmount";
    static final String TB_DEALPRICE = "entries.dealPrice";
    static final String TB_AMOUNT = "entries.amount";
    static final String TB_EXCHANGERATE = "exchangeRate";
    static final String TB_LOCALAMOUNT = "entries.localAmount";
    static final String TB_TAXRATE = "entries.taxRate";
    static final String TB_TAXPRICE = "entries.taxPrice";
    static final String TB_TAX = "entries.tax";
    static final String TB_LOCALTAX = "entries.localTax";
    static final String TB_TAXAMOUNT = "entries.taxAmount";
    static final String TB_LOCALTAXAMOUNT = "entries.localTaxAmount";
    static final String TB_BASESTATUS = "baseStatus";
    static final String TB_INITINVTYPE = "InitInvType";
    static final String TB_VOUCHERNUM = "voucherNum";
    static final String TB_NONCHECKOFFQTY = "nonCheckoffQty";
    static final String TB_NONCHECKOFFAMOUNT = "nonCheckoffAmount";
    static final String TB_CHECKOFFQTY = "checkoffQty";
    static final String TB_CHECKOFFAMOUNT = "checkoffAmount";
    static final String TB_UNWRITEOFFBASEQTY = "unWriteOffBaseQty";
    static final String TB_UNWRITEOFFLOCALAMOUNT = "unWriteOffLocalAmount";
    static final String TB_WRITEOFFBASEQTY = "writeOffBaseQty";
    static final String TB_WRITEOFFLOCALAMOUNT = "writeOffLocalAmount";
    static final String TB_ISREVERSEINV = "isReverseInv";
    static final String TB_BIZTYPEID = "bizTypeID";
    static final String TB_COREBILLNUMBER = "coreBillNumber";
    static final String TB_COREBILLENTRYSEQ = "coreBillEntrySeq";
    static final String TB_REMARK = "remark";
    public static final String[] AMOUT_QTY_COLS = new String[]{"entries.quantity", "entries.assistQuantity", "entries.discountAmount", "entries.amount", "entries.localAmount", "entries.tax", "entries.taxAmount", "nonCheckoffQty", "nonCheckoffAmount", "checkoffQty", "checkoffAmount", "unWriteOffBaseQty", "unWriteOffLocalAmount", "writeOffBaseQty", "writeOffLocalAmount", "entries.localTax", "entries.localTaxAmount"};
    private static final Logger logger = CoreUIObject.getLogger(PurInvoiceListUI.class);
    CommonQueryDialog queryDialog = null;
    String UIParam = null;
    Map companyOrgisArScmRelateMap = new HashMap();
    private PurInvoiceQueryUI conditionQueryUI = null;

    public PurInvoiceListUI() throws Exception {
        boolean isArScmRelate = false;
        isArScmRelate = SCMClientUtils.isAPRelationSCM((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        this.companyOrgisArScmRelateMap.put(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), new Boolean(isArScmRelate));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return PurInvoiceEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurInvoiceFactory.getRemoteInstance();
    }

    public String getStringRes(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key);
    }

    protected EntityViewInfo getInitDefaultSolution() {
        Timestamp startTime = SCMUtils.getSCMQueryTime(null, (String)"startDate");
        Timestamp endTime = SCMUtils.getSCMQueryTime(null, (String)"endDate");
        FilterItemInfo itemFromInfo = new FilterItemInfo(TB_INVOICEDATE, (Object)startTime, CompareType.GREATER_EQUALS);
        FilterItemInfo itemToInfo = new FilterItemInfo(TB_INVOICEDATE, (Object)endTime, CompareType.LESS_EQUALS);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(itemFromInfo);
        filterInfo.getFilterItems().add(itemToInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private String[] getSelectedListId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        HashMap<String, String> mapId = new HashMap<String, String>();
        if (selectBlock != null) {
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.getKeyFieldName());
                Object keyValue = cell.getValue();
                if (keyValue == null || mapId.containsKey(keyValue.toString())) continue;
                mapId.put(keyValue.toString(), keyValue.toString());
            }
        }
        String[] listId = null;
        if (mapId != null && mapId.size() > 0) {
            Iterator iterat = mapId.keySet().iterator();
            listId = new String[mapId.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanAudit();
        IPurInvoice purInvoice = PurInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)this.getStringRes("PURINV_IFAUDIT"));
        if (i == 0) {
            try {
                purInvoice.audit(billIdlist);
                MsgBox.showInfo((String)this.getStringRes("PURINV_AUDITSUCCESS"));
                this.refresh(e);
            }
            catch (EASBizException exp) {
                this.handUIException(exp);
            }
        }
    }

    public void checkCanAudit() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String initType = row.getCell(TB_INITINVTYPE).getValue().toString();
                if (initType.trim().equals(InitializeInvoiceTypeEnum.GENERAL.getAlias())) continue;
                MsgBox.showError((Component)((Object)this), (String)this.getStringRes("PURINV_INITINVCANNOTAUDIT"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        Object reasonCodeInfo;
        this.checkSelected();
        this.checkCanCancel();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)this.getStringRes("PURINV_IFCANCEL"));
        if (i == 0 && (reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()))) != null) {
            PurInvoiceInfo purinvInfo;
            ObjectStringPK pk;
            String[] billIdlist;
            IPurInvoice purInvoice;
            if (reasonCodeInfo instanceof IObjectValue) {
                purInvoice = PurInvoiceFactory.getRemoteInstance();
                billIdlist = this.getSelectedListId();
                pk = new ObjectStringPK(billIdlist[0]);
                purinvInfo = purInvoice.getPurInvoiceInfo((IObjectPK)pk);
                purinvInfo.setReason(((ReasonCodeInfo)reasonCodeInfo).getName());
                try {
                    purInvoice.cancel((IObjectPK)pk, (CoreBaseInfo)purinvInfo);
                    this.setMessageText(this.getStringRes("PURINV_CANCELSUCCESS"));
                    this.showMessage();
                    this.refresh(e);
                }
                catch (EASBizException exp) {
                    this.handUIException(exp);
                }
            }
            if (reasonCodeInfo instanceof String) {
                purInvoice = PurInvoiceFactory.getRemoteInstance();
                billIdlist = this.getSelectedListId();
                pk = new ObjectStringPK(billIdlist[0]);
                purinvInfo = purInvoice.getPurInvoiceInfo((IObjectPK)pk);
                purinvInfo.setReason((String)reasonCodeInfo);
                try {
                    purInvoice.cancel((IObjectPK)pk, (CoreBaseInfo)purinvInfo);
                    this.setMessageText(this.getStringRes("PURINV_CANCELSUCCESS"));
                    this.showMessage();
                    this.refresh(e);
                }
                catch (EASBizException exp) {
                    this.handUIException(exp);
                }
            }
        }
    }

    private void checkCanCancel() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo invStatus;
                String statuStr;
                String msg;
                IRow row = this.tblMain.getRow(i);
                String initType = row.getCell(TB_INITINVTYPE).getValue().toString();
                if (!initType.trim().equals(InitializeInvoiceTypeEnum.GENERAL.getAlias())) {
                    MsgBox.showError((Component)((Object)this), (String)this.getStringRes("PURINV_INITINVCANNOTCANCEL"));
                    SysUtil.abort();
                }
                if ((msg = PurInvoiceUIUtil.checkCanCancel(statuStr = (String)(invStatus = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue())) == null) continue;
                String number = row.getCell(TB_NUMBER).getValue().toString();
                MsgBox.showError((String)(PurInvoiceUIUtil.getPurInvResource("Invoice") + number + msg));
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        this.UIParam = (String)this.getUIContext().get("UIClassParam");
        if (this.UIParam != null) {
            this.UIParam = this.UIParam.trim();
        }
        super.onLoad();
        this.setMainTableFormat();
        this.initToolBar();
        this.initTitle();
        this.initMenuBar();
        this.setButtonEnabledBySelectInfo();
    }

    private void MainTableDataFilled(KDTDataRequestEvent e) {
        int r1 = e.getFirstRow();
        int r2 = e.getLastRow();
        for (int i = r1; i <= r2; ++i) {
            BigDecimal value;
            int j;
            if (this.tblMain.getCell(i, TB_ISREVERSEINV).getValue() == null || !(this.tblMain.getCell(i, TB_ISREVERSEINV).getValue() instanceof Boolean)) continue;
            if (((Boolean)this.tblMain.getCell(i, TB_ISREVERSEINV).getValue()).booleanValue()) {
                for (j = 0; j < AMOUT_QTY_COLS.length; ++j) {
                    value = (BigDecimal)this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getValue();
                    if (value == null) continue;
                    this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).setValue((Object)value.abs());
                    this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getStyleAttributes().setFontColor(Color.RED);
                }
                continue;
            }
            if (this.tblMain.getCell(i, TB_BIZTYPEID).getValue() == null || !this.tblMain.getCell(i, TB_BIZTYPEID).getValue().toString().equals("d8e80652-0107-1000-e000-04c5c0a812202407435C")) continue;
            for (j = 0; j < AMOUT_QTY_COLS.length; ++j) {
                value = (BigDecimal)this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getValue();
                if (value == null) continue;
                this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).setValue((Object)value.abs());
            }
        }
    }

    private void initIcon() {
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuCacel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAuditResult.setVisible(false);
        this.btnViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.menuViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
    }

    private void initTitle() {
        if (this.UIParam != null && this.UIParam.equals("PAYMENT")) {
            this.setUITitle(this.getStringRes("PURINV_APLISTTITLE"));
        }
    }

    private void initToolBar() throws Exception {
        this.btnReverse.setEnabled(true);
        this.btnAudit.setVisible(false);
        this.btnCancel.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnAuditResult.setEnabled(true);
        this.initIcon();
    }

    private void initMenuBar() {
        this.menuItemAuditResult.setEnabled(true);
        this.menuCacel.setEnabled(true);
        this.menuReverse.setEnabled(true);
        this.menuItemAudit.setVisible(false);
    }

    private void setMainTableFormat() {
        this.setMainTablePrecision();
        this.setMainTableAlign();
        this.setMainTableFreeze();
    }

    private void setMainTablePrecision() {
    }

    private void setMainTableAlign() {
        for (int i = 0; i < AMOUT_QTY_COLS.length; ++i) {
            this.tblMain.getColumn(AMOUT_QTY_COLS[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.tblMain.getColumn(TB_PRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_DISCOUNTRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_DEALPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_EXCHANGERATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_TAXRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_TAXPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_COREBILLNUMBER).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn(TB_COREBILLENTRYSEQ).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex(TB_PURORGNAME));
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{TB_PURORGNAME, TB_NUMBER, TB_BASESTATUS, TB_INVOICEDATE, TB_SUPPLIERNAME, TB_INVOICETYPE, TB_BIZTYPE, TB_SOURCEBILLTYPE, TB_ISREVERSEINV, TB_PAYMENTTYPE, TB_SETTLEMENTTYPE, TB_VOUCHERNUM};
        return columns;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = this.UIParam != null ? (this.UIParam.equals("bizInitInv") ? new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(0), CompareType.EQUALS) : (this.UIParam.equals("PAYMENT") ? new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.EQUALS) : new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.NOTEQUALS))) : new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.NOTEQUALS);
        filterInfo.getFilterItems().add(filterItem);
        FilterInfo companyOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id");
        try {
            filter.mergeFilter(companyOrgFilter, "AND");
            filter.mergeFilter(filterInfo, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"UIClassParam", (Object)this.UIParam);
    }

    public CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        dialog.setTitle(SCMClientUtils.getStandardFilterTitle((String)this.getUITitle()));
        dialog.setWidth(430);
        dialog.setHeight(310);
        if (this.conditionQueryUI == null) {
            try {
                this.conditionQueryUI = new PurInvoiceQueryUI();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        if (this.UIParam != null && this.UIParam.equals("PAYMENT")) {
            this.conditionQueryUI.setIsApInitInvoiceQuery(true);
        }
        dialog.addUserPanel((KDPanel)this.conditionQueryUI);
        UserQueryFilterProcessor userFilter = new UserQueryFilterProcessor();
        userFilter.setOwner((IUIObject)this.conditionQueryUI);
        dialog.setProcessor((IProcessor)userFilter);
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setParentUIClassName(PurInvoiceListUI.class.getName());
        return dialog;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.canCreateVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void canCreateVoucher() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo value;
                IRow row = this.tblMain.getRow(i);
                BizEnumValueInfo initTypeInfo = (BizEnumValueInfo)row.getCell(TB_INITINVTYPE).getValue();
                if (!initTypeInfo.getValue().equals(String.valueOf(InitializeInvoiceTypeEnum.GENERAL.getValue()))) {
                    MsgBox.showError((Component)((Object)this), (String)this.getStringRes("PURINV_INITINVCANNOTVOUCHER"));
                    SysUtil.abort();
                }
                if ((value = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue().equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) continue;
                MsgBox.showError((Component)((Object)this), (String)this.getResString("PURINV_CANNOTVOUCHER"));
                SysUtil.abort();
            }
        }
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.initToolBar();
    }

    public void actionImportData_actionPerformed(ActionEvent arg0) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(arg0);
        this.tblMain.removeRows();
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.purinvoice";
        param.alias = PurInvoiceUIUtil.getPurInvResource("PurInvoice");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionReverse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanReverse();
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("MSG_ConfirmReverse"))) {
            String[] ids = this.getSelectedListId();
            IObjectPK[] pks = new IObjectPK[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                pks[i] = new ObjectStringPK(ids[i]);
            }
            IObjectPK[] newPKs = PurInvoiceFactory.getRemoteInstance().createReverseInv(pks);
            if (newPKs != null) {
                PurInvoiceUIUtil.showSuccessMsg((ListUI)this, "MSG_ReverseSucces");
                this.actionRefresh_actionPerformed(null);
            }
            super.actionReverse_actionPerformed(e);
        }
    }

    private void checkCanReverse() throws Exception {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        IPurInvoice ipurInvoice = PurInvoiceFactory.getRemoteInstance();
        HashSet<BOSUuid> infoedIds = new HashSet<BOSUuid>();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo invStatus;
                String statuStr;
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                PurInvoiceInfo purInvoiceInfo = ipurInvoice.getPurInvoiceInfo((IObjectPK)pk);
                if (purInvoiceInfo.getReverseInvNumber() != null) {
                    MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CantReverse_Reverseded"));
                    SysUtil.abort();
                }
                if (purInvoiceInfo.isIsReversed()) {
                    MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CantReverse_ReverseInv"));
                    SysUtil.abort();
                }
                if (!(statuStr = (String)(invStatus = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue()).equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) {
                    MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CantReverse_NotAudited"));
                    SysUtil.abort();
                }
                if (PurUtil.isInvoiceCheckOffed(purInvoiceInfo)) {
                    MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CantReverse_Checkoffed"));
                    SysUtil.abort();
                }
                if (!purInvoiceInfo.getBizType().getId().toString().equals("d8e80652-010b-1001-e000-04c5c0a812202407435C") || infoedIds.contains(purInvoiceInfo.getId())) continue;
                MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("MSG_ReverseDirectSaleInv"));
                infoedIds.add(purInvoiceInfo.getId());
            }
        }
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo(TB_NUMBER));
        sic.add(new SelectorItemInfo(TB_EXCHANGERATE));
        sic.add(new SelectorItemInfo("totalTax"));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("localTotalTaxAmount"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo(TB_TAXAMOUNT));
        sic.add(new SelectorItemInfo(TB_LOCALTAXAMOUNT));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.coreBillType.id"));
        sic.add(new SelectorItemInfo("entries.coreBillType.name"));
        sic.add(new SelectorItemInfo("entries.coreBillType.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo(TB_SUPPLIERNAME));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo(TB_PURORGNAME));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purGroup.id"));
        sic.add(new SelectorItemInfo("purGroup.name"));
        sic.add(new SelectorItemInfo("purGroup.number"));
        sic.add(new SelectorItemInfo("purPerson.id"));
        sic.add(new SelectorItemInfo("purPerson.person.name"));
        sic.add(new SelectorItemInfo("purPerson.person.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("cashDiscount.id"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("cashDiscount.name"));
        return sic;
    }

    public void checkCanFreeze() {
        int rownum;
        IRow row;
        String status;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && !(status = (row = this.tblMain.getRow(rownum = selectBlock.getTop())).getCell(TB_BASESTATUS).getValue().toString()).trim().equals(BillBaseStatusEnum.AUDITED.getAlias())) {
            MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CannotFreeze"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanFreeze();
        Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        if (reasonCodeInfo == null) {
            return;
        }
        if (reasonCodeInfo != null) {
            IPurInvoice ipurInvoice = PurInvoiceFactory.getRemoteInstance();
            String[] billIdlist = this.getSelectedListId();
            ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
            if (reasonCodeInfo instanceof IObjectValue) {
                ipurInvoice.freeze((IObjectPK)pk, (ReasonCodeInfo)reasonCodeInfo);
            }
            if (reasonCodeInfo instanceof String) {
                ipurInvoice.freeze((IObjectPK)pk, (String)reasonCodeInfo);
            }
            PurInvoiceUIUtil.showSuccessMsg((ListUI)this, "MSG_FreezeSuccess");
            this.refresh(e);
        }
    }

    public void checkCanUnFreeze() {
        int rownum;
        IRow row;
        String status;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && !(status = (row = this.tblMain.getRow(rownum = selectBlock.getTop())).getCell(TB_BASESTATUS).getValue().toString()).trim().equals(BillBaseStatusEnum.BLOCKED.getAlias())) {
            MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Error_CannotUnFreeze"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionUnFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanUnFreeze();
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("Msg_ConfirmUnFreeze"))) {
            IPurInvoice ipurInvoice = PurInvoiceFactory.getRemoteInstance();
            String[] billIdlist = this.getSelectedListId();
            ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
            ipurInvoice.unFreeze((IObjectPK)pk);
            PurInvoiceUIUtil.showSuccessMsg((ListUI)this, "MSG_UnFreezeSuccess");
            this.refresh(e);
        }
    }

    protected void checkCanEdit(SCMBillBaseInfo billInfo) throws Exception {
        super.checkCanEdit(billInfo);
        PurInvoiceInfo invInfo = (PurInvoiceInfo)billInfo;
        if (invInfo != null && invInfo.isIsReversed()) {
            MsgBox.showError((Component)((Object)this), (String)PurInvoiceUIUtil.getPurInvResource("ReverseInv_CantBeEdited"));
            SysUtil.abort();
        }
    }

    protected boolean isCodeRuleEnable(IObjectValue objValue) throws EASBizException, BOSException, UuidException {
        String companyId = OrgInnerUtils.getCurCompany();
        ICodingRuleManager codeRuleMgr = CodingRuleManagerFactory.getRemoteInstance();
        return codeRuleMgr.isExist(objValue, companyId);
    }

    protected String getAutoCode(IObjectValue objValue) throws EASBizException, BOSException, UuidException {
        String companyId = OrgInnerUtils.getCurCompany();
        ICodingRuleManager codeRuleMgr = CodingRuleManagerFactory.getRemoteInstance();
        if (codeRuleMgr.isUseIntermitNumber(objValue, companyId)) {
            return codeRuleMgr.readNumber(objValue, companyId);
        }
        return codeRuleMgr.getNumber(objValue, companyId);
    }

    @Override
    public void actionCreditLornTrans_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        this.initColPrecision(rowSet);
    }

    private void initColPrecision(IRowSet rowSet) {
        int assPre = 2;
        int unitPre = 2;
        int pricePre = 2;
        int amountPre = 2;
        int baseQtyPre = 2;
        int localAmountPre = 2;
        String[] QTY_COLUMNS = new String[]{TB_QTY};
        String[] PRICE_COLUMNS = new String[]{TB_PRICE, TB_DEALPRICE, TB_TAXPRICE};
        String[] BASEQTY_COLUMNS = new String[]{"entries.unwriteOffBaseQty", "entries.wittenOffBaseQty"};
        String[] ASSISQTY_COLUMNS = new String[]{TB_ASSISTQTY};
        String[] AMOUNT_COLUMNS = new String[]{TB_AMOUNT, TB_TAX, TB_TAXAMOUNT, TB_DISCOUNTAMOUNT, "entries.checkOffAmount", "entries.nonCheckOffAmount"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{TB_LOCALTAX, TB_LOCALAMOUNT, TB_LOCALTAXAMOUNT, "entries.localWrittenOffAmount", "entries.localUnwriteOffAmount"};
        try {
            while (rowSet.next()) {
                unitPre = rowSet.getInt("multiUnit.qtyPrecision");
                assPre = rowSet.getInt("assistMultiUnit.qtyPrecision");
                pricePre = rowSet.getInt("material.pricePrecision");
                amountPre = rowSet.getInt("currency.precision");
                baseQtyPre = rowSet.getInt("baseMultiUnit.qtyPrecision");
                localAmountPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)unitPre, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)assPre, (String[])ASSISQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)pricePre, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])AMOUNT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)baseQtyPre, (String[])BASEQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)localAmountPre, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        IPurInvoice purInvoice = PurInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
        PurInvoiceInfo purinvInfo = purInvoice.getPurInvoiceInfo((IObjectPK)pk);
        return purinvInfo.getCompanyOrgUnit();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.setButtonEnabledBySelectInfo();
    }

    private void setButtonEnabledBySelectInfo() throws Exception {
        this.setVoucherButtonEnabled();
        this.setCreateToButtonEnabled();
    }

    private void setVoucherButtonEnabled() throws Exception {
        PurInvoiceInfo info = this.getSelectedPurInvInfo();
        this.btnVoucher.setEnabled(false);
        this.btnDelVoucher.setEnabled(false);
        this.menuItemVoucher.setEnabled(false);
        this.menuItemDelVoucher.setEnabled(false);
        if (info != null && !SCMClientUtils.isBillInWf((SCMBillBaseInfo)info)) {
            if (this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString()) == null) {
                boolean isArScmRelate = false;
                isArScmRelate = SCMClientUtils.isAPRelationSCM((CompanyOrgUnitInfo)info.getCompanyOrgUnit());
                this.companyOrgisArScmRelateMap.put(info.getCompanyOrgUnit().getId().toString(), new Boolean(isArScmRelate));
            }
            if (!((Boolean)this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString())).booleanValue()) {
                this.btnVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
        }
    }

    private void setCreateToButtonEnabled() throws Exception {
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        this.menuItemCreateTo.setEnabled(false);
        this.menuItemCreateTo.setVisible(false);
    }

    private PurInvoiceInfo getSelectedPurInvInfo() throws Exception {
        PurInvoiceInfo purInvoiceInfo = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        IPurInvoice isaleInvoice = PurInvoiceFactory.getRemoteInstance();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                purInvoiceInfo = isaleInvoice.getPurInvoiceInfo((IObjectPK)pk);
            }
        }
        return purInvoiceInfo;
    }

    @Override
    public void actionViewWriteOffRecord_actionPerformed(ActionEvent e) throws Exception {
        CoreBillBaseCollection bills = this.getBillList();
        CCRelationBillListImpl billList = new CCRelationBillListImpl((CoreBillListUI)this);
        billList.traceDown(bills, this.getEntriesPKName());
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AP);
        super.actionTraceDown_actionPerformed(e);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }
}

