/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillEntryBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderBatchEditFacade;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderBatchEditFacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurSubOrderFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.PurOrderBatchEditCal;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurOrderBatchEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurSubOrderHandler;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PurOrderBatchEditUI
extends AbstractPurOrderBatchEditUI {
    private static final long serialVersionUID = -5713793538537597756L;
    private static final Logger logger = CoreUIObject.getLogger(PurOrderBatchEditUI.class);
    public static final String TB_MATERIAL_NUMBER = "material.number";
    public static final String TB_MATERIAL_NAME = "material.name";
    public static final String TB_MATERIAL_MODEL = "material.model";
    public static final String TB_UNIT = "unit";
    public static final String TB_QTY = "qty";
    public static final String TB_CURRENCY = "currency";
    public static final String TB_PRICE = "price";
    public static final String TB_TAXPRICE = "taxPrice";
    public static final String TB_AMOUNT = "amount";
    public static final String TB_PROJECT = "project";
    public static final String TB_TRACKNO = "trackNo";
    public static final String TB_SUPPLIER = "supplier";
    public static final String TB_DELIVERYDATE = "deliveryDate";
    public static final String TB_PURCHASEORGUNIT = "purchaseOrgUnit";
    public static final String TB_REQUESTORGUNIT = "requestOrgUnit";
    public static final String TB_STORAGEORGUNIT = "storageOrgUnit";
    public static final String TB_PURCHASEGROUP = "purchaseGroup";
    public static final String TB_PURCHASEPERSON = "purchasePerson";
    public static final String TB_ISINTAX = "isintax";
    public static final String TB_TAXRATE = "taxRate";
    private static final String[] MATERIALUNITTAB = new String[]{"unit"};
    private List<String> NEDD_FETCHPRICE_COLUMN = new ArrayList<String>(){
        {
            this.add(PurOrderBatchEditUI.TB_UNIT);
            this.add(PurOrderBatchEditUI.TB_QTY);
        }
    };
    private List<String> NEDD_CALPRICE_COLUMN = new ArrayList<String>(){
        {
            this.add(PurOrderBatchEditUI.TB_UNIT);
            this.add(PurOrderBatchEditUI.TB_QTY);
            this.add(PurOrderBatchEditUI.TB_PRICE);
            this.add(PurOrderBatchEditUI.TB_TAXPRICE);
        }
    };
    private static final String[] QTYPRECISION_QTY = new String[]{"qty"};
    private static final String[] PRICEPRECISIONTAB = new String[]{"price", "taxPrice"};
    private static final String[] CURRENCYPRECISIONTAB = new String[]{"amount"};
    Map<String, PurOrderInfo> rowData = new HashMap<String, PurOrderInfo>();
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener prmtPurchasePersonListener;
    protected PurSubOrderHandler purSubOrderHandler = null;
    private PurEntryDataVO purEntryVO = new PurEntryDataVO();

    @Override
    public void onLoad() throws Exception {
        this.BILLTYPE_ID = "510b6503-0105-1000-e000-010bc0a812fd463ED552";
        super.onLoad();
    }

    protected void initListener() {
        super.initListener();
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    try {
                        PurOrderBatchEditUI.this.kdtEntries_editStarting(e);
                    }
                    catch (Exception exc) {
                        PurOrderBatchEditUI.this.handUIException(exc);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        PurOrderBatchEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception exc) {
                        PurOrderBatchEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtPurchasePersonListener == null) {
            this.prmtPurchasePersonListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        SCMClientHelper scmClientHelper = new SCMClientHelper(null);
                        scmClientHelper.initPurPersonDisplay(PurOrderBatchEditUI.this.prmtPurchasePerson);
                    }
                    catch (Exception e) {
                        PurOrderBatchEditUI.this.handleException(e);
                    }
                }
            };
        }
        this.prmtPurchasePerson.addDataChangeListener(this.prmtPurchasePersonListener);
    }

    protected void removeListener() {
        if (this.entryTableChange != null) {
            this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    @Override
    protected void doBizSure(IObjectCollection batchCollection) throws Exception {
        super.doBizSure(batchCollection);
        this.loadTableToData();
        if (this.rowData != null && this.rowData.size() > 0) {
            this.getPurOrderFacadeInterface().batchUpdate(this.rowData);
            this.showSuccessMsg("PUR_BATCH_SUCCESS");
        } else {
            logger.error((Object)"@@@@PurOrderBatchEditUI.doBizSure(),\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u683c\u6570\u636e");
        }
    }

    public void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(collIndex);
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        IRow row = this.getDetailTable().getRow(rowIndex);
        PurOrderInfo info = (PurOrderInfo)row.getCell("info").getValue();
        PurOrderEntryInfo entryInfo = info.getEntries().get(0);
        if (info.getPurchaseOrgUnit() == null) {
            e.setCancel(true);
            SysUtil.abort();
        }
        boolean isIntax = info.isIsInTax();
        boolean isPresent = entryInfo.isIsPresent();
        if (TB_PRICE.equalsIgnoreCase(fieldName) && (isIntax || isPresent)) {
            e.setCancel(true);
            SysUtil.abort();
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName) && (!isIntax || isPresent)) {
            e.setCancel(true);
            SysUtil.abort();
        }
    }

    public void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        MaterialInfo materialInfo;
        StorageOrgUnitInfo storageOrgUnit;
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(collIndex);
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (oldValue != null && newValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
            return;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
            return;
        }
        List<String> requiredColumn = this.getRequiredColumn();
        if (requiredColumn.contains(fieldName) && oldValue != null && newValue == null) {
            row.getCell(fieldName).setValue(oldValue);
            return;
        }
        boolean isNeedUpdateOther = false;
        ArrayList<String> headUpdateFieldList = new ArrayList<String>();
        headUpdateFieldList.add(fieldName);
        ArrayList<String> entryUpdateFieldList = new ArrayList<String>();
        entryUpdateFieldList.add(fieldName);
        PurOrderInfo info = (PurOrderInfo)row.getCell("info").getValue();
        PurOrderEntryInfo entryInfo = info.getEntries().get(0);
        entryInfo.setDiscountRate(entryInfo.getDiscountRate().setScale(2, 4));
        RowTypeInfo rowTypeInfo = entryInfo.getRowType();
        if (TB_PURCHASEGROUP.equalsIgnoreCase(fieldName)) {
            isNeedUpdateOther = true;
            PurchaseGroupInfo purchaseGroupInfo = (PurchaseGroupInfo)newValue;
            Object objG = this.getDetailTable().getCell(rowIndex, TB_PURCHASEGROUP).getValue();
            Object objP = this.getDetailTable().getCell(rowIndex, TB_PURCHASEPERSON).getValue();
            PurchaseGroupInfo gInfo = null;
            PersonInfo pInfo = null;
            if (objP != null) {
                if (objG instanceof PurchaseGroupInfo && objP instanceof PersonInfo && !this.isInGroup(gInfo = (PurchaseGroupInfo)objG, pInfo = (PersonInfo)objP)) {
                    this.getDetailTable().getCell(rowIndex, TB_PURCHASEPERSON).setValue(null);
                }
                if (objG == null) {
                    this.getDetailTable().getCell(rowIndex, TB_PURCHASEPERSON).setValue(null);
                    info.setPurchasePerson(null);
                    headUpdateFieldList.add(TB_PURCHASEPERSON);
                }
            }
            info.setPurchaseGroup(purchaseGroupInfo);
        }
        if (TB_PURCHASEPERSON.equalsIgnoreCase(fieldName)) {
            PurchasePersonInfo purchasePersonInfo;
            isNeedUpdateOther = true;
            PersonInfo personInfo = (PersonInfo)newValue;
            info.setPurchasePerson(personInfo);
            if (personInfo != null && (purchasePersonInfo = this.getPurchasePersonByPerson(personInfo)) != null) {
                PurchaseGroupInfo purchaseGroupInfo = purchasePersonInfo.getPurGroup();
                this.getDetailTable().getCell(rowIndex, TB_PURCHASEGROUP).setValue((Object)purchaseGroupInfo);
                info.setPurchaseGroup(purchaseGroupInfo);
                headUpdateFieldList.add(TB_PURCHASEGROUP);
            }
        }
        if (TB_DELIVERYDATE.equalsIgnoreCase(fieldName)) {
            Date deliveryDate = (Date)newValue;
            entryInfo.setDeliveryDate(deliveryDate);
        }
        if (TB_PROJECT.equalsIgnoreCase(fieldName)) {
            ProjectInfo project = (ProjectInfo)newValue;
            entryInfo.setProject(project);
        }
        if (TB_TRACKNO.equalsIgnoreCase(fieldName)) {
            TrackNumberInfo trackNo = (TrackNumberInfo)newValue;
            entryInfo.setTrackNo(trackNo);
        }
        if (TB_UNIT.equalsIgnoreCase(fieldName)) {
            MeasureUnitInfo oldUnitInfo;
            MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)newValue;
            entryInfo.setUnit(newUnitInfo);
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = null;
            MaterialInfo materialInfo2 = (MaterialInfo)this.getDetailTable().getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
            if (materialInfo2 != null && newUnitInfo != null) {
                multiUnitInfo = imultiUnit.getMultiUnit(materialInfo2.getId().toString(), newUnitInfo.getId().toString());
            }
            if (oldValue instanceof MeasureUnitInfo && newValue instanceof MeasureUnitInfo && !oldValue.equals(newValue)) {
                oldUnitInfo = (MeasureUnitInfo)oldValue;
                this.calEntryQtyForUnit(entryInfo, rowIndex, oldUnitInfo, multiUnitInfo);
            }
            if (materialInfo2 != null && newUnitInfo != null) {
                BigDecimal baseUnitPrice;
                oldUnitInfo = (MeasureUnitInfo)oldValue;
                if (info.isIsInTax()) {
                    BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).getValue();
                    baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (MaterialInfo)materialInfo2, (BigDecimal)taxPrice);
                    if (baseUnitPrice != null) {
                        baseUnitPrice = baseUnitPrice.setScale(materialInfo2.getPricePrecision(), 4);
                        this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).setValue((Object)baseUnitPrice);
                        entryInfo.setTaxPrice(baseUnitPrice);
                    }
                } else {
                    BigDecimal price = (BigDecimal)this.getDetailTable().getCell(rowIndex, TB_PRICE).getValue();
                    baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (MaterialInfo)materialInfo2, (BigDecimal)price);
                    if (baseUnitPrice != null) {
                        baseUnitPrice = baseUnitPrice.setScale(materialInfo2.getPricePrecision(), 4);
                        this.getDetailTable().getCell(rowIndex, TB_PRICE).setValue((Object)baseUnitPrice);
                        entryInfo.setPrice(baseUnitPrice);
                    }
                }
                PurOrderBatchEditCal purOrderBatchEditCal = new PurOrderBatchEditCal();
                purOrderBatchEditCal.setInTax(info.isIsInTax());
                purOrderBatchEditCal.setAmoutscale(info.getCurrency().getPrecision());
                if (!info.isIsInTax()) {
                    purOrderBatchEditCal.calEntryTaxPrice(info, entryInfo);
                } else {
                    purOrderBatchEditCal.calEntryPrice(info, entryInfo);
                }
            } else {
                entryInfo.setBaseUnit(newUnitInfo);
            }
        }
        if (TB_QTY.equalsIgnoreCase(fieldName)) {
            BigDecimal qty = BIGZERO;
            if (newValue != null) {
                qty = (BigDecimal)newValue;
            }
            entryInfo.setQty(qty);
            entryInfo.setAssociateQty(qty);
            this.calEntryBaseQty(entryInfo, rowIndex);
        }
        if (TB_PRICE.equalsIgnoreCase(fieldName)) {
            BigDecimal price = BIGZERO;
            if (newValue != null) {
                price = (BigDecimal)newValue;
            }
            entryInfo.setPrice(price);
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            BigDecimal taxPrice = BIGZERO;
            if (newValue != null) {
                taxPrice = (BigDecimal)newValue;
            }
            entryInfo.setTaxPrice(taxPrice);
        }
        if (TB_REQUESTORGUNIT.equalsIgnoreCase(fieldName)) {
            storageOrgUnit = (StorageOrgUnitInfo)newValue;
            boolean isSuccess = true;
            if (rowTypeInfo.isIsHasMaterialNumber() && storageOrgUnit != null) {
                materialInfo = entryInfo.getMaterial();
                isSuccess = this.checkForMaterialAndStorageOrgUnit(rowIndex, materialInfo.getId().toString(), storageOrgUnit.getId().toString(), true);
            }
            if (isSuccess) {
                entryInfo.setRequestOrgUnit(storageOrgUnit);
            } else {
                this.getDetailTable().getCell(rowIndex, TB_REQUESTORGUNIT).setValue(oldValue);
            }
        }
        if (TB_STORAGEORGUNIT.equalsIgnoreCase(fieldName)) {
            storageOrgUnit = (StorageOrgUnitInfo)newValue;
            boolean isSuccess = true;
            if (rowTypeInfo.isIsHasMaterialNumber() && storageOrgUnit != null) {
                materialInfo = entryInfo.getMaterial();
                isSuccess = this.checkForMaterialAndStorageOrgUnit(rowIndex, materialInfo.getId().toString(), storageOrgUnit.getId().toString(), true);
            }
            if (isSuccess) {
                entryInfo.setStorageOrgUnit(storageOrgUnit);
            } else {
                this.getDetailTable().getCell(rowIndex, TB_STORAGEORGUNIT).setValue(oldValue);
            }
        }
        if (this.NEDD_FETCHPRICE_COLUMN.contains(fieldName) || this.NEDD_CALPRICE_COLUMN.contains(fieldName)) {
            entryInfo.put("oldAmount", entryInfo.getAmount() == null ? BIGZERO : entryInfo.getAmount());
            entryInfo.put("oldLocalAmount", entryInfo.getLocalAmount() == null ? BIGZERO : entryInfo.getLocalAmount());
            entryInfo.put("oldTaxAmount", entryInfo.getTaxAmount() == null ? BIGZERO : entryInfo.getTaxAmount());
            entryInfo.put("oldLocalTaxAmount", entryInfo.getLocalTaxAmount() == null ? BIGZERO : entryInfo.getLocalTaxAmount());
            entryInfo.put("oldTax", entryInfo.getTax() == null ? BIGZERO : entryInfo.getTax());
            if (this.NEDD_CALPRICE_COLUMN.contains(fieldName)) {
                this.tableChange_Cal(info, entryInfo, fieldName);
            }
            if (!(!this.NEDD_FETCHPRICE_COLUMN.contains(fieldName) || info.getSupplier() == null || entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null || this.isBotpBill(info, "aErYRJ8ShO3gQKjACw4w8MtHWDQ=") || this.isBotpBill(info, "510b6503-0105-1000-e000-010bc0a814fd463ED552") || this.isBotpBill(info, "510b6503-0105-1000-e000-010bc0b814fd463ED552") || entryInfo.isIsPresent())) {
                int seq = entryInfo.getSeq();
                PurPriceParamCollection paramCol = new PurPriceParamCollection();
                paramCol.setBillTypeId("510b6503-0105-1000-e000-010bc0a812fd463ED552");
                paramCol.setBizTypeId(info.getBillType() != null ? info.getBizType().getId().toString() : null);
                PurPriceParam param = PurOrderBatchEditCal.getPriceParam(seq, info, entryInfo);
                paramCol.addPurPriceParam(param);
                this.fetchPrice(info, entryInfo, seq, paramCol);
            }
            this.getDetailTable().getCell(rowIndex, TB_PRICE).setValue((Object)entryInfo.getPrice());
            this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).setValue((Object)entryInfo.getTaxPrice());
            this.getDetailTable().getCell(rowIndex, TB_AMOUNT).setValue((Object)entryInfo.getAmount());
            this.getDetailTable().getCell(rowIndex, TB_TAXRATE).setValue((Object)entryInfo.getTaxRate());
        }
        this.getDetailTable().setRefresh(false);
        this.getDetailTable().enableRepaint(false);
        this.setTableCellValue(this.getDetailTable(), rowIndex, "info", info);
        if (isNeedUpdateOther) {
            PurOrderInfo fromInfo = null;
            PurOrderInfo toInfo = null;
            PurOrderEntryInfo toEntryInfo = null;
            String id = info.getId().toString();
            String otherID = null;
            String uptField = null;
            int rowCount = this.getDetailTable().getRowCount();
            PurOrderInfo otherInfo = (PurOrderInfo)info.clone();
            otherInfo.getEntries().clear();
            for (int i = 0; i < rowCount; ++i) {
                otherID = this.getDetailTable().getCell(i, "id").getValue().toString();
                if (id == null || otherID == null || !id.equals(otherID)) continue;
                toInfo = (PurOrderInfo)this.getDetailTable().getCell(i, "info").getValue();
                toEntryInfo = (PurOrderEntryInfo)toInfo.getEntries().get(0).clone();
                fromInfo = (PurOrderInfo)otherInfo.clone();
                fromInfo.getEntries().add(toEntryInfo);
                this.getDetailTable().getCell(i, "info").setValue((Object)fromInfo);
                if (headUpdateFieldList.size() == 1) {
                    this.getDetailTable().getCell(i, fieldName).setValue(newValue);
                    continue;
                }
                if (headUpdateFieldList.size() <= 1) continue;
                int len = headUpdateFieldList.size();
                for (int j = 0; j < len; ++j) {
                    uptField = (String)headUpdateFieldList.get(j);
                    this.getDetailTable().getCell(i, uptField).setValue(fromInfo.get(uptField));
                }
            }
        }
        this.updateRowDataByNewInfo(rowIndex, info, entryInfo);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
    }

    private void fetchPrice(PurOrderInfo info, PurOrderEntryInfo entryInfo, int seq, PurPriceParamCollection paramCol) throws EASBizException, BOSException {
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        CurrencyInfo currencyInfo = info.getCurrency();
        if (paramCol.size() > 0) {
            PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
            if (entryInfo.getTaxRate() == null || BIGZERO.compareTo(entryInfo.getTaxRate()) == 0) {
                if (priceInfo != null && priceInfo.getTaxRate() != null) {
                    entryInfo.setTaxRate(priceInfo.getTaxRate().setScale(2));
                } else {
                    entryInfo.setTaxRate(BIGZERO);
                }
            }
            if (priceInfo != null && priceInfo.getPrice() != null) {
                PurOrderBatchEditCal purOrderBatchEditCal = new PurOrderBatchEditCal();
                purOrderBatchEditCal.setInTax(priceInfo.isInTaxPrice());
                if (priceInfo.getDiscountRate() != null) {
                    entryInfo.setDiscountRate(priceInfo.getDiscountRate());
                }
                if (currencyInfo != null) {
                    purOrderBatchEditCal.setAmoutscale(currencyInfo.getPrecision());
                }
                if (priceInfo.isInTaxPrice()) {
                    entryInfo.setTaxPrice(priceInfo.getPrice());
                    purOrderBatchEditCal.calByEntryTaxPriceChange(info, entryInfo);
                } else {
                    entryInfo.setPrice(priceInfo.getPrice());
                    purOrderBatchEditCal.calByEntryPriceChange(info, entryInfo);
                }
            }
        }
    }

    private void tableChange_Cal(PurOrderInfo info, PurOrderEntryInfo entryInfo, String fieldName) throws EASBizException, BOSException {
        PurOrderBatchEditCal purOrderBatchEditCal = new PurOrderBatchEditCal();
        purOrderBatchEditCal.setInTax(info.isIsInTax());
        purOrderBatchEditCal.setAmoutscale(info.getCurrency().getPrecision());
        if (TB_QTY.equalsIgnoreCase(fieldName) || TB_UNIT.equalsIgnoreCase(fieldName)) {
            purOrderBatchEditCal.calByEntryQtyChange(info, entryInfo);
        }
        if (TB_PRICE.equalsIgnoreCase(fieldName)) {
            purOrderBatchEditCal.calByEntryPriceChange(info, entryInfo, info.getCompanyOrgUnit().getBaseCurrency());
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            purOrderBatchEditCal.calByEntryTaxPriceChange(info, entryInfo, info.getCompanyOrgUnit().getBaseCurrency());
        }
    }

    public void calEntryQtyForUnit(PurOrderEntryInfo entryInfo, int rowIndex, MeasureUnitInfo oldUnitInfo, MultiMeasureUnitInfo newMultiUnitInfo) throws EASBizException, BOSException {
        if (newMultiUnitInfo != null) {
            KDFormattedTextField qtyformatedTxtField = new KDFormattedTextField();
            qtyformatedTxtField.setDataType(1);
            qtyformatedTxtField.setNegatived(false);
            qtyformatedTxtField.setPrecision(newMultiUnitInfo.getQtyPrecision());
            KDTDefaultCellEditor qtynumber_CellEditor = new KDTDefaultCellEditor((JTextField)qtyformatedTxtField);
            String qtyPrecisionString = PrecisionUtil.getFormatString((int)newMultiUnitInfo.getQtyPrecision());
            this.getDetailTable().getCell(rowIndex, TB_QTY).setEditor((ICellEditor)qtynumber_CellEditor);
            this.getDetailTable().getCell(rowIndex, TB_QTY).getStyleAttributes().setNumberFormat(qtyPrecisionString);
        }
        BigDecimal newQty = null;
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
        MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_UNIT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(TB_QTY).getValue();
        int scale = 2;
        if (qty != null && oldUnitInfo != null && newUnitInfo != null) {
            if (materialInfo != null) {
                newQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (BigDecimal)qty.setScale(10));
                scale = newMultiUnitInfo.getQtyPrecision();
            } else {
                newQty = qty;
                scale = newUnitInfo.getQtyPrecision();
            }
            BigDecimal newQty2 = newQty.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(TB_QTY).setValue((Object)newQty2);
            entryInfo.setQty(newQty2);
        }
    }

    public void calEntryBaseQty(PurOrderEntryInfo entryInfo, int rowIndex) throws EASBizException, BOSException {
        MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
        MeasureUnitInfo unitInfo = entryInfo.getUnit();
        MaterialInfo materialInfo = entryInfo.getMaterial();
        BigDecimal qty = entryInfo.getQty();
        if (baseUnitInfo == null || unitInfo == null || materialInfo == null || qty == null) {
            return;
        }
        BigDecimal baseUnitQty = this.getExchangeQty(materialInfo.getId().toString(), unitInfo, baseUnitInfo, qty);
        entryInfo.setBaseQty(baseUnitQty);
    }

    @Override
    protected void doQuery() throws Exception {
        super.doQuery();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
        PurchaseGroupInfo purchaseGroup = (PurchaseGroupInfo)this.prmtPurchaseGroup.getValue();
        PersonInfo purchasePerson = (PersonInfo)this.prmtPurchasePerson.getValue();
        SupplierInfo supplier = (SupplierInfo)this.prmtSupplier.getValue();
        BillBaseStatusEnum baseStaus = (BillBaseStatusEnum)this.cobbaseStatus.getSelectedItem();
        PurOrderInfo numFrom = (PurOrderInfo)this.prmtNumberFrom.getValue();
        PurOrderInfo numTo = (PurOrderInfo)this.prmtNumberTo.getValue();
        String numberFrom = null;
        String numberTo = null;
        if (numFrom != null) {
            numberFrom = numFrom.getNumber();
        }
        if (numTo != null) {
            numberTo = numTo.getNumber();
        }
        MaterialInfo materialFrom = (MaterialInfo)this.prmtMaterialNumFrom.getValue();
        MaterialInfo materialTo = (MaterialInfo)this.prmtMaterialNumTo.getValue();
        ProjectInfo projectFrom = (ProjectInfo)this.prmtProjectFrom.getValue();
        ProjectInfo projectTo = (ProjectInfo)this.prmtProjectTo.getValue();
        TrackNumberInfo trackNumberFrom = (TrackNumberInfo)this.prmtTrackNumberFrom.getValue();
        TrackNumberInfo trackNumberTo = (TrackNumberInfo)this.prmtTrackNumberTo.getValue();
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        sql1.append("select entry.FID id from T_SM_PurOrderEntry entry left join T_SM_PurOrder bill on  bill.FID = entry.FParentID ");
        if (baseStaus != null && baseStaus != BillBaseStatusEnum.NULL) {
            sql2.append(" where bill.FBaseStatus = ").append(baseStaus.getValue());
        } else {
            sql2.append(" where (bill.FBaseStatus = 1 or bill.FBaseStatus = 2) ");
        }
        if (purchaseOrgUnitInfo != null && purchaseOrgUnitInfo.getId() != null) {
            sql1.append(" left join T_ORG_Purchase AS PURCHASEORGUNIT on bill.FPurchaseOrgUnitID = PURCHASEORGUNIT.FID ");
            sql2.append(" and bill.FPurchaseOrgUnitID = '").append(purchaseOrgUnitInfo.getId().toString()).append("' ");
        }
        if (purchaseGroup != null && purchaseGroup.getId() != null) {
            sql1.append(" left join T_BD_PurchaseGroup AS PURCHASEGROUP on bill.FPurchaseGroupID = PURCHASEGROUP.FID ");
            sql2.append(" and bill.FPurchaseGroupID = '").append(purchaseGroup.getId().toString()).append("' ");
        }
        if (purchasePerson != null && purchasePerson.getId() != null) {
            sql1.append(" left join T_BD_Person AS PURCHASEPERSON on bill.FPurchasePersonID = PURCHASEPERSON.FID ");
            sql2.append(" and bill.FPurchasePersonID = '").append(purchasePerson.getId().toString()).append("' ");
        }
        if (supplier != null && supplier.getId() != null) {
            sql1.append(" left join T_BD_Supplier AS SUPPLIER on bill.FSupplierID = SUPPLIER.FID ");
            sql2.append(" and bill.FSupplierID = '").append(supplier.getId().toString()).append("' ");
        }
        if (numberFrom != null) {
            sql2.append(" and bill.FNumber >= '").append(numberFrom).append("' ");
        }
        if (numberTo != null) {
            sql2.append(" and bill.FNumber <= '").append(numberTo).append("' ");
        }
        if (materialFrom != null || materialTo != null) {
            sql1.append(" left join T_BD_Material AS MATERIAL on entry.FMaterialID = MATERIAL.FID ");
        }
        if (materialFrom != null) {
            sql2.append(" and MATERIAL.FNumber >= '").append(materialFrom.getNumber()).append("' ");
        }
        if (materialTo != null) {
            sql2.append(" and MATERIAL.FNumber <= '").append(materialTo.getNumber()).append("' ");
        }
        if (projectFrom != null || projectTo != null) {
            sql1.append(" left join T_MM_Project AS PROJECT on entry.FProjectID = PROJECT.FID ");
        }
        if (projectFrom != null) {
            sql2.append(" and PROJECT.FNumber >= '").append(projectFrom.getNumber()).append("' ");
        }
        if (projectTo != null) {
            sql2.append(" and PROJECT.FNumber <= '").append(projectTo.getNumber()).append("' ");
        }
        if (trackNumberFrom != null || trackNumberTo != null) {
            sql1.append(" left join T_MM_TrackNumber AS TRACKNO on entry.FTrackNoID = TRACKNO.FID ");
        }
        if (trackNumberFrom != null) {
            sql2.append(" and TRACKNO.FNumber >= '").append(trackNumberFrom.getNumber()).append("' ");
        }
        if (trackNumberTo != null) {
            sql2.append(" and TRACKNO.FNumber <= '").append(trackNumberTo.getNumber()).append("' ");
        }
        sql1.append(sql2.toString());
        sql1.append(" and bill.FID in ").append(this.convertSet2Sql(this.billIdSet));
        sql1.append(" and entry.FID in ").append(this.convertSet2Sql(this.billEntryIdSet));
        Map map = PurOrderBatchEditFacadeFactory.getRemoteInstance().excuteQuery(sql1.toString());
        List entryIdList = null;
        if (map.get("entryIdList") != null) {
            entryIdList = (List)map.get("entryIdList");
        }
        this.currentQueryIdList = entryIdList;
        this.getDetailTable().setRefresh(false);
        this.getDetailTable().enableRepaint(false);
        this.setPositionForRow(this.previousQueryIdList, true);
        this.setPositionForRow(this.currentQueryIdList, false);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
        this.previousQueryIdList = this.currentQueryIdList;
        if (this.currentQueryIdList == null || this.currentQueryIdList.size() == 0) {
            this.showMsgBoxInfo("PUR_BATCH_QUERYNULLDATA");
        }
        this.currentQueryIdList = new ArrayList();
    }

    @Override
    protected IObjectCollection getCollection(Set<String> idSet, Set<String> entryIdSet) throws Exception {
        EntityViewInfo ev = null;
        FilterInfo filter = null;
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderCollection col = new PurOrderCollection();
        PurOrderEntryCollection entryCol = new PurOrderEntryCollection();
        PurOrderCollection newCol = new PurOrderCollection();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo(this.getKeyFieldName(), idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo((String)this.tableToBillRelation.get("baseStatus"), (Object)-8, CompareType.EQUALS));
        }
        SorterItemCollection sortcol = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo((String)this.tableToBillRelation.get("number"));
        sorterItemInfo.setSortType(SortType.DESCEND);
        sortcol.add(sorterItemInfo);
        ev.setSorter(sortcol);
        ev.setFilter(filter);
        ev.setSelector(this.getBillSelectors());
        col = ((IPurOrder)this.getBizInterface()).getPurOrderCollection(ev);
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo(this.getKeyFieldName(), entryIdSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo((String)this.tableToBillRelation.get("baseStatus"), (Object)-8, CompareType.EQUALS));
        }
        sortcol = new SorterItemCollection();
        SorterItemInfo parentnumbersort = new SorterItemInfo("parent.number");
        parentnumbersort.setSortType(SortType.DESCEND);
        sortcol.add(parentnumbersort);
        sortcol.add(new SorterItemInfo((String)this.tableToEntryRelation.get("seq")));
        ev.setSorter(sortcol);
        ev.setFilter(filter);
        ev.setSelector(this.getEntrySelectors());
        entryCol = ((IPurOrderEntry)this.getBizEntryInterface()).getPurOrderEntryCollection(ev);
        LinkedHashMap<String, PurOrderInfo> billMap = new LinkedHashMap<String, PurOrderInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            info.getEntries().clear();
            col.set(i, info);
            billMap.put(info.getId().toString(), info);
        }
        String parentId = null;
        int pricePrecision = 4;
        int size2 = entryCol.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = entryCol.get(i);
            parentId = entryInfo.getParent().getId().toString();
            if (!billMap.containsKey(parentId)) continue;
            info = (PurOrderInfo)billMap.get(parentId);
            int currencyPrecision = info.getCurrency().getPrecision();
            pricePrecision = entryInfo.getMaterial() != null ? entryInfo.getMaterial().getPricePrecision() : entryInfo.getRowType().getPrecision();
            entryInfo.setAmount(entryInfo.getAmount().setScale(currencyPrecision));
            entryInfo.setTaxAmount(entryInfo.getTaxAmount().setScale(currencyPrecision));
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrecision, 4));
            entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrecision, 4));
            if (entryInfo.getMaterial() != null && StringUtil.isEmpty((String)entryInfo.getMaterialName())) {
                entryInfo.setMaterialName(entryInfo.getMaterial().getName());
            }
            info.getEntries().add(entryInfo);
            billMap.put(parentId, info);
        }
        for (Map.Entry entry : billMap.entrySet()) {
            info = (PurOrderInfo)entry.getValue();
            newCol.add(info);
        }
        return newCol;
    }

    @Override
    protected void loadDataToTable() throws Exception {
        PurOrderCollection purOrderCol = (PurOrderCollection)this.getCollection(this.billIdSet, this.billEntryIdSet);
        if (purOrderCol == null || purOrderCol.size() == 0) {
            return;
        }
        this.getDetailTable().setRefresh(false);
        this.getDetailTable().enableRepaint(false);
        PurOrderInfo info = null;
        PurOrderInfo newInfo = null;
        PurOrderEntryCollection entryCol = null;
        PurOrderEntryInfo entryInfo = null;
        int columnCount = this.getDetailTable().getColumnCount();
        int rowCount = 0;
        int billCount = 0;
        int size = purOrderCol.size();
        for (int i = 0; i < size; ++i) {
            info = purOrderCol.get(i);
            rowCount += info.getEntries().size();
            ++billCount;
        }
        String colName = null;
        Object value = null;
        IRow row = null;
        this.getDetailTable().removeRows();
        long time1 = System.currentTimeMillis();
        logger.debug((Object)"@@@@PurOrderBatchEditUI.loadTableData()\u5c06\u96c6\u5408\u5bf9\u8c61\u89e3\u6790\u6210\u8868\u683c\u6570\u7ec4\u5f00\u59cb.................");
        int size2 = purOrderCol.size();
        for (int i = 0; i < size2; ++i) {
            info = purOrderCol.get(i);
            entryCol = info.getEntries();
            int lengh = entryCol.size();
            for (int j = 0; j < lengh; ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo == null) continue;
                row = this.getDetailTable().addRow();
                if (entryInfo.getMaterial() != null) {
                    SCMClientUtils.changeTableColPrecision((int)entryInfo.getMaterial().getPricePrecision(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)row.getRowIndex());
                }
                SCMClientUtils.changeTableRowColPrecisionByCurrency((CurrencyInfo)info.getCurrency(), (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB, (int)row.getRowIndex());
                for (int k = 0; k < columnCount; ++k) {
                    colName = this.getDetailTable().getColumn(k).getKey();
                    if ("info".equals(colName)) {
                        newInfo = (PurOrderInfo)info.clone();
                        newInfo.getEntries().clear();
                        newInfo.getEntries().add(entryInfo);
                        value = newInfo;
                    } else {
                        value = this.tableToEntryRelation.containsKey(colName) ? entryInfo.get((String)this.tableToEntryRelation.get(colName)) : (this.tableToBillRelation.containsKey(colName) ? info.get((String)this.tableToBillRelation.get(colName)) : null);
                    }
                    if ("baseStatus".equals(colName)) {
                        int enumValue = 0;
                        if (value != null) {
                            enumValue = Integer.parseInt(value.toString());
                        }
                        value = BillBaseStatusEnum.getEnum((int)enumValue);
                    }
                    this.setTableCellValue(this.getDetailTable(), row.getRowIndex(), colName, value);
                }
            }
        }
        long time2 = System.currentTimeMillis();
        logger.debug((Object)("@@@@PurOrderBatchEditUI.loadTableData()\u89e3\u6790\u6210\u8868\u683c\u5bf9\u8c61\u5355\u636e\u6570\uff1a" + billCount + "\u5206\u5f55\u6570\uff1a" + rowCount));
        logger.debug((Object)("@@@@PurOrderBatchEditUI.loadTableData()\u5c06\u96c6\u5408\u5bf9\u8c61\u89e3\u6790\u6210\u8868\u683c\u6570\u7ec4\u8017\u65f6\uff1a" + (time2 - time1)));
        this.setTableColumnAttr(this.getDetailTable(), this.getLockColumn(), this.getHideColumn(), null);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
        this.editCtrl(0, this.getDetailTable().getRowCount());
    }

    protected void loadTableToData() {
        PurOrderInfo info = null;
        String entryId = null;
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            info = (PurOrderInfo)this.getDetailTable().getCell(i, "info").getValue();
            entryId = info.getEntries().get(0).getId().toString();
            this.rowData.put(entryId, info);
        }
    }

    protected void cacheMmuPrecision(String materialId, String unitId) throws BOSException, EASBizException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(materialId, unitId);
        if (multiUnitInfo != null) {
            this.purEntryVO.getMmuPrecisions().put(materialId + unitId, multiUnitInfo.getQtyPrecision());
        }
    }

    @Override
    protected void initEntryPrecisionForEdit() throws EASBizException, BOSException {
        int i;
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        RowTypeInfo rowTypeInfo = null;
        int num = this.getDetailTable().getRowCount();
        CurrencyInfo currencyInfo = null;
        MaterialInfo[] materialInfos = new MaterialInfo[num];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[num];
        MeasureUnitInfo[] baseMeasureUnitInfos = new MeasureUnitInfo[num];
        for (int i2 = 0; i2 < num; ++i2) {
            info = (PurOrderInfo)this.getDetailTable().getRow(i2).getCell("info").getValue();
            entryInfo = info.getEntries().get(0);
            materialInfos[i2] = entryInfo.getMaterial();
            measureUnitInfos[i2] = entryInfo.getUnit();
            baseMeasureUnitInfos[i2] = entryInfo.getBaseUnit();
        }
        this.purEntryVO = new PurEntryDataVO();
        this.purEntryVO.setMaterialInfos(materialInfos);
        this.purEntryVO.setMeasureUnitInfos(measureUnitInfos);
        this.purEntryVO.setBaseMeasureUnitInfos(baseMeasureUnitInfos);
        this.purEntryVO.setIsLoadingMmuPrecision(true);
        this.purEntryVO.setIsLoadingMou(true);
        try {
            this.purEntryVO = (PurEntryDataVO)this.getPurOrderFacadeInterface().batchMmuData((SCMEntryDataVO)this.purEntryVO);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        int qtycision = 2;
        if (materialInfos == null || measureUnitInfos == null && baseMeasureUnitInfos == null) {
            int size = this.getDetailTable().getRowCount();
            for (i = 0; i < size; ++i) {
                info = (PurOrderInfo)this.getDetailTable().getRow(i).getCell("info").getValue();
                entryInfo = info.getEntries().get(0);
                rowTypeInfo = entryInfo.getRowType();
                if (!rowTypeInfo.isIsHasMaterialNumber() && measureUnitInfos != null && measureUnitInfos[i] != null) {
                    qtycision = measureUnitInfos[i].getQtyPrecision();
                }
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i);
            }
        } else {
            if (this.purEntryVO == null) {
                return;
            }
            Map mulUnitMap = this.purEntryVO.getMmuPrecisions();
            int size = materialInfos.length;
            for (int i3 = 0; i3 < size; ++i3) {
                info = (PurOrderInfo)this.getDetailTable().getRow(i3).getCell("info").getValue();
                entryInfo = info.getEntries().get(0);
                rowTypeInfo = entryInfo.getRowType();
                if (rowTypeInfo == null) continue;
                if (rowTypeInfo.isIsHasMaterialNumber()) {
                    SCMClientUtils.changeTableColPrecision((Map)mulUnitMap, (MaterialInfo)materialInfos[i3], (MeasureUnitInfo)measureUnitInfos[i3], (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i3);
                    continue;
                }
                qtycision = measureUnitInfos[i3] != null ? measureUnitInfos[i3].getQtyPrecision() : 2;
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i3);
            }
        }
        for (i = 0; i < num; ++i) {
            info = (PurOrderInfo)this.getDetailTable().getRow(i).getCell("info").getValue();
            entryInfo = info.getEntries().get(0);
            rowTypeInfo = entryInfo.getRowType();
            currencyInfo = info.getCurrency();
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
            if (rowTypeInfo == null) continue;
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfos[i], (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)i);
                continue;
            }
            SCMClientUtils.changeTableColPrecision((int)rowTypeInfo.getPrecision(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)i);
        }
    }

    @Override
    protected void initEntryPrecisionForRow(int rowIndex) throws EASBizException, BOSException {
        if (this.purEntryVO == null) {
            this.initEntryPrecisionForEdit();
            return;
        }
        PurOrderInfo info = (PurOrderInfo)this.getDetailTable().getRow(rowIndex).getCell("info").getValue();
        PurOrderEntryInfo entryInfo = info.getEntries().get(0);
        CurrencyInfo currencyInfo = info.getCurrency();
        RowTypeInfo rowTypeInfo = entryInfo.getRowType();
        MaterialInfo materialInfo = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseUnit = entryInfo.getBaseUnit();
        if (rowTypeInfo == null) {
            return;
        }
        int qtycision = 2;
        if (materialInfo == null || unit == null && baseUnit == null) {
            if (!rowTypeInfo.isIsHasMaterialNumber()) {
                qtycision = unit.getQtyPrecision();
            }
            SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
        } else {
            Map mulUnitMap = this.purEntryVO.getMmuPrecisions();
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                String key = materialInfo.getId().toString() + unit.getId().toString();
                if (!mulUnitMap.containsKey(key)) {
                    this.cacheMmuPrecision(materialInfo.getId().toString(), unit.getId().toString());
                }
                SCMClientUtils.changeTableColPrecision((Map)mulUnitMap, (MaterialInfo)materialInfo, (MeasureUnitInfo)unit, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
            } else {
                qtycision = unit != null ? unit.getQtyPrecision() : 2;
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
            }
        }
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
        if (rowTypeInfo.isIsHasMaterialNumber()) {
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfo, (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)rowIndex);
        } else {
            SCMClientUtils.changeTableColPrecision((int)rowTypeInfo.getPrecision(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)rowIndex);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void initUIControl() throws Exception {
        super.initUIControl();
        EntityViewInfo view = null;
        FilterInfo filterInfo = null;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        this.prmtPurchaseOrgUnit.setEntityViewInfo(view);
        this.initQueryPurchaseGroupF7();
        this.prmtPurchasePerson.setHistoryRecordEnabled(false);
        this.setBizSupplierF7(this.prmtSupplier, null);
        this.formatBillStatus(this.cobbaseStatus);
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        FilterInfo userFilterInfo = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id");
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(1));
        status.add(new Integer(2));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSysBill", (Object)0, CompareType.EQUALS));
        userFilterInfo.mergeFilter(filterInfo, "and");
        view.setFilter(userFilterInfo);
        this.prmtNumberFrom.setEntityViewInfo(view);
        this.prmtNumberTo.setEntityViewInfo(view);
        this.setBizMaterialF7(this.prmtMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialNumTo, false, null);
        this.registerProjectF7ForFilter(this.prmtProjectFrom);
        this.registerProjectF7ForFilter(this.prmtProjectTo);
        this.registerTrackNumberF7ForFilter(this.prmtTrackNumberFrom);
        this.registerTrackNumberF7ForFilter(this.prmtTrackNumberTo);
        this.setF7RangeChange((Component)this.prmtNumberFrom, (Component)this.prmtNumberTo);
        this.setF7RangeChange((Component)this.prmtMaterialNumFrom, (Component)this.prmtMaterialNumTo);
        this.setF7RangeChange((Component)this.prmtProjectFrom, (Component)this.prmtProjectTo);
        this.setF7RangeChange((Component)this.prmtTrackNumberFrom, (Component)this.prmtTrackNumberTo);
        KDComboBox baseStatusComboBox = new KDComboBox();
        baseStatusComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.scm.common.BillBaseStatusEnum").toArray());
        KDTDefaultCellEditor baseStatusCellEditor = new KDTDefaultCellEditor((JComboBox)baseStatusComboBox);
        this.getDetailTable().getColumn("baseStatus").setEditor((ICellEditor)baseStatusCellEditor);
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Company));
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        KDTDefaultCellEditor bizMaterialCellEditor = new KDTDefaultCellEditor((IKDEditor)bizMaterialBox);
        this.getDetailTable().getColumn(TB_MATERIAL_NUMBER).setEditor((ICellEditor)bizMaterialCellEditor);
        ObjectValueRender bizMaterialOVR = new ObjectValueRender();
        bizMaterialOVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.getDetailTable().getColumn(TB_MATERIAL_NUMBER).setRenderer((IBasicRender)bizMaterialOVR);
        this.initEntryUnitF7();
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainBizOrg(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainBizOrg(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT, (String)TB_TRACKNO, (boolean)false);
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setEditable(false);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)prmtCurrency);
        this.getDetailTable().getColumn(TB_CURRENCY).setEditor((ICellEditor)currencyEditor);
        KDFormattedTextField qtyTxtField = new KDFormattedTextField();
        qtyTxtField.setDataType(1);
        qtyTxtField.setNegatived(false);
        qtyTxtField.setMaximumIntegerDigits(12);
        KDTDefaultCellEditor qtyCellEditor = new KDTDefaultCellEditor((JTextField)qtyTxtField);
        this.getDetailTable().getColumn(TB_QTY).setEditor((ICellEditor)qtyCellEditor);
        KDFormattedTextField amountTxtField = new KDFormattedTextField();
        amountTxtField.setDataType(1);
        amountTxtField.setSupportedEmpty(true);
        KDTDefaultCellEditor amountCellEditor = new KDTDefaultCellEditor((JTextField)amountTxtField);
        this.getDetailTable().getColumn(TB_PRICE).setEditor((ICellEditor)amountCellEditor);
        this.getDetailTable().getColumn(TB_TAXPRICE).setEditor((ICellEditor)amountCellEditor);
        this.getDetailTable().getColumn(TB_AMOUNT).setEditor((ICellEditor)amountCellEditor);
        KDBizPromptBox prmtPurchaseOrgUnit = new KDBizPromptBox();
        prmtPurchaseOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
        prmtPurchaseOrgUnit.setDisplayFormat("$name$");
        prmtPurchaseOrgUnit.setEditFormat("$number$");
        prmtPurchaseOrgUnit.setCommitFormat("number");
        KDTDefaultCellEditor prmtPurOrgCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPurchaseOrgUnit);
        this.getDetailTable().getColumn(TB_PURCHASEORGUNIT).setEditor((ICellEditor)prmtPurOrgCellEditor);
        KDDatePicker datePicker = new KDDatePicker();
        this.getDetailTable().getColumn(TB_DELIVERYDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        this.getDetailTable().getColumn(TB_DELIVERYDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.initEntryRequestOrgUnitF7();
        this.initEntryStorageOrgUnitF7();
        this.initEntryPurchaseGroupF7();
        this.initEntryPurchasePersonF7();
    }

    private void initQueryPurchaseGroupF7() {
        this.prmtPurchaseGroup.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    PurchaseGroupInfo purGroupInfo = null;
                    String purGroupNumber = null;
                    if (PurOrderBatchEditUI.this.prmtPurchaseGroup.getValue() != null) {
                        purGroupInfo = (PurchaseGroupInfo)PurOrderBatchEditUI.this.prmtPurchaseGroup.getData();
                        purGroupNumber = purGroupInfo.getNumber().toString();
                        filter.getFilterItems().add(new FilterItemInfo("purGroup.number", (Object)purGroupNumber, CompareType.EQUALS));
                        viewInfo.setFilter(filter);
                        PurOrderBatchEditUI.this.prmtPurchasePerson.setEntityViewInfo(viewInfo);
                    } else {
                        PurOrderBatchEditUI.this.prmtPurchasePerson.setEntityViewInfo(null);
                    }
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initEntryStorageOrgUnitF7() {
        KDBizPromptBox bizStorageOrgUnitBox = new KDBizPromptBox();
        bizStorageOrgUnitBox.setDisplayFormat("$number$");
        bizStorageOrgUnitBox.setEditFormat("$number$");
        bizStorageOrgUnitBox.setCommitFormat("$number$;$code$");
        bizStorageOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        KDTDefaultCellEditor bizStorageOrgCellEditor = new KDTDefaultCellEditor((IKDEditor)bizStorageOrgUnitBox);
        this.getDetailTable().getColumn(TB_STORAGEORGUNIT).setEditor((ICellEditor)bizStorageOrgCellEditor);
        bizStorageOrgUnitBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerStorageOrgUnit();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
        bizStorageOrgUnitBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerStorageOrgUnit();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initEntryRequestOrgUnitF7() {
        KDBizPromptBox bizRequestOrgUnitBox = new KDBizPromptBox();
        bizRequestOrgUnitBox.setDisplayFormat("$number$");
        bizRequestOrgUnitBox.setEditFormat("$number$");
        bizRequestOrgUnitBox.setCommitFormat("$number$;$code$");
        bizRequestOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        KDTDefaultCellEditor bizRequestOrgCellEditor = new KDTDefaultCellEditor((IKDEditor)bizRequestOrgUnitBox);
        this.getDetailTable().getColumn(TB_REQUESTORGUNIT).setEditor((ICellEditor)bizRequestOrgCellEditor);
        bizRequestOrgUnitBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerRequestOrgUnit();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
        bizRequestOrgUnitBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerRequestOrgUnit();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void registerRequestOrgUnit() throws EASBizException, BOSException, ParserException {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            KDBizPromptBox orgUnitBox = (KDBizPromptBox)this.getDetailTable().getColumn(TB_REQUESTORGUNIT).getEditor().getComponent();
            MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
            String materialName = (String)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NAME).getValue();
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_PURCHASEORGUNIT).getValue();
            if (materialInfo == null && materialName == null) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            PurOrderInfo info = (PurOrderInfo)this.getDetailTable().getRow(rowIndex).getCell("info").getValue();
            PurOrderEntryInfo entryInfo = info.getEntries().get(0);
            RowTypeInfo rowType = entryInfo.getRowType();
            if (materialInfo != null) {
                MaterialInfo[] materialInfos = new MaterialInfo[]{materialInfo};
                ArrayList<String> materialIds = new ArrayList<String>();
                materialIds.add(materialInfo.getId().toString());
                paramMap.put("materialIds", materialIds);
                paramMap.put("materialName", null);
            } else {
                paramMap.put("materialIds", null);
                paramMap.put("materialName", materialName);
            }
            paramMap.put("rowType", rowType);
            paramMap.put("purOrgId", purchaseOrgUnitInfo.getId().toString());
            paramMap.put("isSubBill", false);
            Map mapResult = PurSubOrderFacadeFactory.getRemoteInstance().handleEntryReqOrg(paramMap);
            Map defaultResult = (Map)mapResult.get("reqOrgDefault");
            Map filterResult = (Map)mapResult.get("reqOrgFilter");
            if (materialInfo != null) {
                String materialId = materialInfo.getId().toString();
                if (filterResult.get(materialId) != null) {
                    String filter = "where id in (" + filterResult.get(materialId).toString() + ") and isSealUp = 0 and isBizUnit = 1";
                    EntityViewInfo view = new EntityViewInfo(filter);
                    orgUnitBox.setEntityViewInfo(view);
                }
            } else if (filterResult.get(materialName) != null) {
                String filter = "where id in (" + filterResult.get(materialName).toString() + ") and isSealUp = 0 and isBizUnit = 1";
                EntityViewInfo view = new EntityViewInfo(filter);
                orgUnitBox.setEntityViewInfo(view);
            }
            orgUnitBox.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void registerStorageOrgUnit() {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            KDBizPromptBox orgUnitBox = (KDBizPromptBox)this.getDetailTable().getColumn(TB_STORAGEORGUNIT).getEditor().getComponent();
            OrgUnitDelegationF7 oudf7 = new OrgUnitDelegationF7(orgUnitBox, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Storage);
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.getDetailTable().getCell(rowIndex, TB_PURCHASEORGUNIT).getValue();
            oudf7.setTheGivenOrgUnit(purchaseOrgUnitInfo.getId().toString(), OrgType.Purchase);
            orgUnitBox.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void initEntryPurchaseGroupF7() {
        KDBizPromptBox prmtPurchaseGroup_EntryBox = new KDBizPromptBox();
        prmtPurchaseGroup_EntryBox.setDisplayFormat("$name$");
        prmtPurchaseGroup_EntryBox.setEditFormat("$number$");
        prmtPurchaseGroup_EntryBox.setCommitFormat("$number$");
        prmtPurchaseGroup_EntryBox.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.F7PurGroupQuery");
        KDTDefaultCellEditor prmtPurchaseGroupCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPurchaseGroup_EntryBox);
        this.getDetailTable().getColumn(TB_PURCHASEGROUP).setEditor((ICellEditor)prmtPurchaseGroupCellEditor);
        prmtPurchaseGroup_EntryBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerPurchaseGroup();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
        prmtPurchaseGroup_EntryBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerPurchaseGroup();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void registerPurchaseGroup() throws EASBizException, BOSException {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.getDetailTable().getCell(rowIndex, TB_PURCHASEORGUNIT).getValue();
            PersonInfo personInfo = (PersonInfo)this.getDetailTable().getCell(rowIndex, TB_PURCHASEPERSON).getValue();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            boolean isControllByPurOrgUnit = this.isControllByPurOrgUnit(purchaseOrgUnitInfo.getId().toString(), "PURJICHU001", false);
            if (isControllByPurOrgUnit) {
                filter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            }
            if (personInfo != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FPurGroupID from T_BD_PurchasePerson where FPersonID ='" + personInfo.getId().toString() + "' and fdeletedStatus=1");
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            }
            viewInfo.setFilter(filter);
            ICellEditor cellGEditor = this.getDetailTable().getColumn(TB_PURCHASEGROUP).getEditor();
            KDBizPromptBox prmtPurchaseGroup_EntryBox = null;
            if (cellGEditor != null) {
                prmtPurchaseGroup_EntryBox = (KDBizPromptBox)cellGEditor.getComponent();
                prmtPurchaseGroup_EntryBox.setEntityViewInfo(viewInfo);
                prmtPurchaseGroup_EntryBox.getQueryAgent().resetRuntimeEntityView();
            }
        }
    }

    private void initEntryPurchasePersonF7() {
        KDBizPromptBox prmtPurchasePerson_EntryBox = new KDBizPromptBox();
        prmtPurchasePerson_EntryBox.setDisplayFormat("$person.name$");
        prmtPurchasePerson_EntryBox.setEditFormat("$person.number$");
        prmtPurchasePerson_EntryBox.setCommitFormat("$person.number$");
        prmtPurchasePerson_EntryBox.setHistoryRecordEnabled(false);
        prmtPurchasePerson_EntryBox.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.F7PurPersonQuery");
        KDTDefaultCellEditor prmtPurchasePersonCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPurchasePerson_EntryBox);
        this.getDetailTable().getColumn(TB_PURCHASEPERSON).setEditor((ICellEditor)prmtPurchasePersonCellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$person.name$"));
        this.getDetailTable().getColumn(TB_PURCHASEPERSON).setRenderer((IBasicRender)avr);
        prmtPurchasePerson_EntryBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int rowIndex = PurOrderBatchEditUI.this.getDetailTable().getSelectManager().getActiveRowIndex();
                    if (rowIndex >= 0) {
                        KDBizPromptBox prmtBox = (KDBizPromptBox)PurOrderBatchEditUI.this.getDetailTable().getColumn(PurOrderBatchEditUI.TB_PURCHASEPERSON).getEditor().getComponent();
                        SCMClientHelper scmClientHelper = new SCMClientHelper(null);
                        scmClientHelper.initPurPersonDisplay(prmtBox);
                    }
                }
                catch (Exception ex) {
                    PurOrderBatchEditUI.this.handUIException(ex);
                }
            }
        });
        prmtPurchasePerson_EntryBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerPurchasePerson();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
        prmtPurchasePerson_EntryBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    PurOrderBatchEditUI.this.registerPurchasePerson();
                }
                catch (Exception exc) {
                    PurOrderBatchEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void registerPurchasePerson() throws EASBizException, BOSException {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.getDetailTable().getCell(rowIndex, TB_PURCHASEORGUNIT).getValue();
            PurchaseGroupInfo purGroupInfo = (PurchaseGroupInfo)this.getDetailTable().getCell(rowIndex, TB_PURCHASEGROUP).getValue();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            boolean isControllByPurOrgUnit = this.isControllByPurOrgUnit(purchaseOrgUnitInfo.getId().toString(), "PURJICHU001", false);
            if (isControllByPurOrgUnit) {
                filter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            }
            if (purGroupInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)purGroupInfo.getId().toString(), CompareType.EQUALS));
            }
            viewInfo.setFilter(filter);
            ICellEditor cellGEditor = this.getDetailTable().getColumn(TB_PURCHASEPERSON).getEditor();
            KDBizPromptBox prmtPurchasePerson_EntryBox = null;
            if (cellGEditor != null) {
                prmtPurchasePerson_EntryBox = (KDBizPromptBox)cellGEditor.getComponent();
                prmtPurchasePerson_EntryBox.setEntityViewInfo(viewInfo);
                prmtPurchasePerson_EntryBox.getQueryAgent().resetRuntimeEntityView();
            }
        }
    }

    private void initEntryUnitF7() {
        KDBizPromptBox bizUnitBox = null;
        int num = MATERIALUNITTAB.length;
        for (int i = 0; i < num; ++i) {
            bizUnitBox = new KDBizPromptBox();
            bizUnitBox.setEditFormat("$number$");
            bizUnitBox.setDisplayFormat("$name$");
            bizUnitBox.setCommitFormat("$number$");
            this.getDetailTable().getColumn(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
            bizUnitBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
                    }
                    catch (Exception ex) {
                        PurOrderBatchEditUI.this.handUIException(ex);
                    }
                }
            });
            bizUnitBox.addCommitListener(new CommitListener(){

                public void willCommit(CommitEvent e) {
                    try {
                        PurOrderBatchEditUI.this.registerUnit();
                    }
                    catch (Exception exc) {
                        PurOrderBatchEditUI.this.handUIException(exc);
                    }
                }
            });
            bizUnitBox.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        PurOrderBatchEditUI.this.registerUnit();
                    }
                    catch (Exception exc) {
                        PurOrderBatchEditUI.this.handUIException(exc);
                    }
                }
            });
        }
    }

    private void registerUnit() {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
            ICellEditor cellGEditor = this.getDetailTable().getColumn(TB_UNIT).getEditor();
            KDBizPromptBox bizUnitBox = null;
            if (cellGEditor != null) {
                bizUnitBox = (KDBizPromptBox)cellGEditor.getComponent();
                if (materialInfo != null) {
                    bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
                    SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialInfo.getId().toString());
                    bizUnitBox.getQueryAgent().resetRuntimeEntityView();
                } else {
                    bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
                    bizUnitBox.getQueryAgent().resetRuntimeEntityView();
                }
            }
        }
    }

    private boolean isInGroup(PurchaseGroupInfo info, PersonInfo info2) {
        boolean flag = false;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)info.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info2.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            IPurchasePerson ip = null;
            ip = PurchasePersonFactory.getRemoteInstance();
            PurchasePersonCollection ppc = ip.getPurchasePersonCollection(viewInfo);
            if (ppc.size() > 0) {
                flag = true;
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return flag;
    }

    protected boolean checkForMaterialAndStorageOrgUnit(int rowIndex, String materialId, String orgId, boolean isMaterial) {
        boolean isSuccess = true;
        try {
            MaterialInventoryInfo info;
            if (materialId != null && orgId != null && ((info = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialId, orgId)) == null || info.getStatus().getValue() != 1)) {
                isSuccess = false;
                throw new PurOrderException(PurOrderException.ORDERENTRY_STORAGEORGNOTINMATERIAL, new String[]{""});
            }
        }
        catch (BOSException bex) {
            this.handleException((Exception)((Object)bex));
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        return isSuccess;
    }

    private PurchasePersonInfo getPurchasePersonByPerson(PersonInfo personInfo) throws BOSException {
        PurchaseGroupInfo groupInfo;
        if (personInfo == null) {
            return null;
        }
        KDBizPromptBox bizprmt = (KDBizPromptBox)this.getDetailTable().getColumn(TB_PURCHASEPERSON).getEditor().getComponent();
        String groupId = null;
        if (bizprmt != null && (groupInfo = (PurchaseGroupInfo)bizprmt.getUserData()) != null) {
            groupId = groupInfo.getId().toString();
        }
        IPurchasePerson iPurchasePerson = PurchasePersonFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        if (groupId != null) {
            filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)groupId, CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("purGroup.id"));
        sic.add(new SelectorItemInfo("purGroup.number"));
        sic.add(new SelectorItemInfo("purGroup.name"));
        viewInfo.setSelector(sic);
        PurchasePersonCollection purchasePersonCollection = iPurchasePerson.getPurchasePersonCollection(viewInfo);
        return purchasePersonCollection.get(0);
    }

    @Override
    protected List<String> getLockColumn() {
        ArrayList<String> lockColumn = new ArrayList<String>();
        lockColumn.add("number");
        lockColumn.add("baseStatus");
        lockColumn.add("seq");
        lockColumn.add(TB_MATERIAL_NUMBER);
        lockColumn.add(TB_MATERIAL_NAME);
        lockColumn.add(TB_MATERIAL_MODEL);
        lockColumn.add("id");
        lockColumn.add("entries.id");
        lockColumn.add(TB_TAXRATE);
        lockColumn.add(TB_SUPPLIER);
        lockColumn.add(TB_CURRENCY);
        return lockColumn;
    }

    @Override
    protected List<String> getHideColumn() {
        ArrayList<String> hideColumn = new ArrayList<String>();
        hideColumn.add("id");
        hideColumn.add("entries.id");
        return hideColumn;
    }

    @Override
    protected List<String> getRequiredColumn() {
        ArrayList<String> requiredColumn = new ArrayList<String>();
        requiredColumn.add(TB_UNIT);
        requiredColumn.add(TB_PURCHASEORGUNIT);
        requiredColumn.add(TB_DELIVERYDATE);
        return requiredColumn;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected ICoreBillEntryBase getBizEntryInterface() throws Exception {
        return PurOrderEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IPurOrderBatchEditFacade getPurOrderFacadeInterface() throws Exception {
        return PurOrderBatchEditFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected String getEntryIDName() {
        return "entries.id";
    }

    @Override
    protected String getEntryIDColumnName() {
        return "entries.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    @Override
    protected void registerTableRelation() {
        super.registerTableRelation();
        this.tableToBillRelation.put("id", "id");
        this.tableToBillRelation.put("number", "number");
        this.tableToBillRelation.put("baseStatus", "baseStatus");
        this.tableToBillRelation.put(TB_PURCHASEORGUNIT, TB_PURCHASEORGUNIT);
        this.tableToBillRelation.put(TB_CURRENCY, TB_CURRENCY);
        this.tableToBillRelation.put(TB_SUPPLIER, TB_SUPPLIER);
        this.tableToBillRelation.put(TB_PURCHASEGROUP, TB_PURCHASEGROUP);
        this.tableToBillRelation.put(TB_PURCHASEPERSON, TB_PURCHASEPERSON);
        this.tableToBillRelation.put(TB_ISINTAX, TB_ISINTAX);
        this.tableToEntryRelation.put("entries.id", "id");
        this.tableToEntryRelation.put("seq", "seq");
        this.tableToEntryRelation.put(TB_MATERIAL_NUMBER, "material");
        this.tableToEntryRelation.put(TB_MATERIAL_NAME, "materialName");
        this.tableToEntryRelation.put(TB_MATERIAL_MODEL, "noNumMaterialModel");
        this.tableToEntryRelation.put(TB_UNIT, TB_UNIT);
        this.tableToEntryRelation.put(TB_QTY, TB_QTY);
        this.tableToEntryRelation.put(TB_PRICE, TB_PRICE);
        this.tableToEntryRelation.put(TB_TAXPRICE, TB_TAXPRICE);
        this.tableToEntryRelation.put(TB_AMOUNT, TB_AMOUNT);
        this.tableToEntryRelation.put(TB_PROJECT, TB_PROJECT);
        this.tableToEntryRelation.put(TB_TRACKNO, TB_TRACKNO);
        this.tableToEntryRelation.put(TB_DELIVERYDATE, TB_DELIVERYDATE);
        this.tableToEntryRelation.put(TB_REQUESTORGUNIT, TB_REQUESTORGUNIT);
        this.tableToEntryRelation.put(TB_STORAGEORGUNIT, TB_STORAGEORGUNIT);
        this.tableToEntryRelation.put(TB_TAXRATE, TB_TAXRATE);
    }

    @Override
    protected SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = super.getBillSelectors();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("purchasePerson.id"));
        sic.add(new SelectorItemInfo("purchasePerson.number"));
        sic.add(new SelectorItemInfo("purchasePerson.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("isPriceInTax"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("localTotalAmount"));
        sic.add(new SelectorItemInfo("totalTax"));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("localTotalTaxAmount"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        return sic;
    }

    @Override
    protected SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = super.getEntrySelectors();
        sic.add(new SelectorItemInfo("requestOrgUnit.id"));
        sic.add(new SelectorItemInfo("requestOrgUnit.number"));
        sic.add(new SelectorItemInfo("requestOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo(TB_MATERIAL_NUMBER));
        sic.add(new SelectorItemInfo(TB_MATERIAL_NAME));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        sic.add(new SelectorItemInfo("materialName"));
        sic.add(new SelectorItemInfo("noNumMaterialModel"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo(TB_QTY));
        sic.add(new SelectorItemInfo(TB_PRICE));
        sic.add(new SelectorItemInfo(TB_TAXPRICE));
        sic.add(new SelectorItemInfo(TB_AMOUNT));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("trackNo.number"));
        sic.add(new SelectorItemInfo("trackNo.name"));
        sic.add(new SelectorItemInfo(TB_DELIVERYDATE));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("assistQty"));
        sic.add(new SelectorItemInfo("associateQty"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo(TB_TAXRATE));
        sic.add(new SelectorItemInfo(TB_TAXPRICE));
        sic.add(new SelectorItemInfo("taxAmount"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("discountAmount"));
        sic.add(new SelectorItemInfo(TB_AMOUNT));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("actualTaxPrice"));
        sic.add(new SelectorItemInfo("assistProperty.id"));
        sic.add(new SelectorItemInfo("assistProperty.number"));
        sic.add(new SelectorItemInfo("assistProperty.name"));
        return sic;
    }
}

