/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.scm.common.client.EventResource.EventContext;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI;
import com.kingdee.eas.scm.sm.pur.client.eventresource.ExpenseExpenseAmountChange;
import com.kingdee.eas.scm.sm.pur.client.eventresource.ExpenseTaxRateChange;
import com.kingdee.eas.scm.sm.pur.client.eventresource.ExpenseUnitExpenseChange;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PurOrderExpenseEditUIHandleResource {
    private PurOrderEditUI purOrderEditUI;

    public PurOrderExpenseEditUIHandleResource(PurOrderEditUI ui) {
        this.purOrderEditUI = ui;
    }

    public void init() {
        this.purOrderEditUI.kdtExpenseEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PurOrderExpenseEditUIHandleResource.this.kdtExpenseEntries_Changed(e);
                }
                catch (Exception exc) {
                    PurOrderExpenseEditUIHandleResource.this.purOrderEditUI.handUIException(exc);
                }
            }
        });
    }

    protected void kdtExpenseEntries_Changed(KDTEditEvent e) throws Exception {
        BigDecimal expenseAmount;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        ICell cell = this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell(colIndex);
        Object value = cell.getValue();
        String fieldName = this.purOrderEditUI.kdtExpenseEntries.getColumnKey(colIndex);
        int activeEntryIndex = this.purOrderEditUI.kdtEntries.getSelectManager().getActiveRowIndex();
        if ("expenseNum".equalsIgnoreCase(fieldName)) {
            if (value instanceof ExpenseTypeInfo) {
                ExpenseTypeInfo ExpenseTypeInfo2 = (ExpenseTypeInfo)value;
                IExpenseType iExpenseType = ExpenseTypeFactory.getRemoteInstance();
                ExpenseTypeInfo expenseTypeInfo = iExpenseType.getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(ExpenseTypeInfo2.getId()));
                IMeasureUnit iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo unitInfo = expenseTypeInfo.getDefaultUnit();
                MeasureUnitInfo measureUnitInfo = null;
                if (unitInfo != null) {
                    measureUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
                }
                this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseType").setValue((Object)expenseTypeInfo);
                this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseUnit").setValue((Object)measureUnitInfo);
            } else if (value == null) {
                this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseType").setValue(null);
                this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseUnit").setValue(null);
            }
        } else if ("unitExpense".equalsIgnoreCase(fieldName)) {
            ExpenseUnitExpenseChange eventResource = new ExpenseUnitExpenseChange();
            eventResource.handle(this.getEventContext(e, activeEntryIndex));
        } else if ("expenseAmount".equalsIgnoreCase(fieldName)) {
            ExpenseExpenseAmountChange eventResource = new ExpenseExpenseAmountChange();
            eventResource.handle(this.getEventContext(e, activeEntryIndex));
        } else if ("taxRate".equalsIgnoreCase(fieldName)) {
            ExpenseTaxRateChange eventResource = new ExpenseTaxRateChange();
            eventResource.handle(this.getEventContext(e, activeEntryIndex));
        } else if ("tax".equalsIgnoreCase(fieldName) && !(expenseAmount = (BigDecimal)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseAmount").getValue()).equals(new BigDecimal("0.0").setScale(expenseAmount.scale()))) {
            BigDecimal taxRate = new BigDecimal(value.toString()).divide(expenseAmount, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            if (taxRate.compareTo(new BigDecimal("100.0")) > 0) {
                this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("tax").setValue(e.getOldValue());
                return;
            }
            this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("taxRate").setValue((Object)taxRate);
        }
    }

    protected EventContext getEventContext(KDTEditEvent e, int activeEntryIndex) {
        EventContext eventContext = new EventContext((Object)this.purOrderEditUI, (Object)e);
        eventContext.addParam("expenseRowIndex", (Object)("" + activeEntryIndex));
        return eventContext;
    }

    public void calExpEntryTax(int rowIndex) {
        if (this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex) != null && this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("taxRate") != null) {
            BigDecimal expenseAmount;
            BigDecimal taxRate = (BigDecimal)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("taxRate").getValue();
            if (taxRate == null) {
                taxRate = new BigDecimal("0.00");
            }
            if ((expenseAmount = (BigDecimal)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseAmount").getValue()) == null) {
                expenseAmount = new BigDecimal("0.00");
            }
            int scale = this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("tax").getEditor() == null ? 2 : ((KDFormattedTextField)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("tax").getEditor().getComponent()).getPrecision();
            this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("tax").setValue((Object)CalculateUtils.calTax((BigDecimal)expenseAmount, (BigDecimal)taxRate, (int)scale));
        }
    }

    public void calExpEntryUnitExpByExpAmount(int activeEntryIndex, int expenseIndex) {
        BigDecimal expenseAmount = (BigDecimal)this.purOrderEditUI.kdtExpenseEntries.getRow(expenseIndex).getCell("expenseAmount").getValue();
        BigDecimal orderQty = (BigDecimal)this.purOrderEditUI.kdtEntries.getRow(activeEntryIndex).getCell("qty").getValue();
        BigDecimal unitExpenseAmount = null;
        if (expenseAmount != null && orderQty != null && orderQty.compareTo(SysConstant.BIGZERO) != 0) {
            unitExpenseAmount = expenseAmount.divide(orderQty, 6, 4);
        }
        if (((PurOrderInfo)this.purOrderEditUI.getDataObject()).getEntries().get(activeEntryIndex) != null) {
            ((PurOrderInfo)this.purOrderEditUI.getDataObject()).getEntries().get(activeEntryIndex).getEntries().get(expenseIndex).setUnitExpense(unitExpenseAmount);
        }
        this.purOrderEditUI.kdtExpenseEntries.getRow(expenseIndex).getCell("unitExpense").setValue((Object)unitExpenseAmount);
    }

    public void calExpEntryUnitExpByExpAmount(int activeEntryIndex) {
        int num = this.purOrderEditUI.kdtExpenseEntries.getRowCount();
        for (int i = 0; i < num; ++i) {
            this.calExpEntryUnitExpByExpAmount(activeEntryIndex, i);
        }
    }

    public void calExpEntryAmount(int activeEntryIndex) {
        int num = this.purOrderEditUI.kdtExpenseEntries.getRowCount();
        for (int i = 0; i < num; ++i) {
            this.calExpEntryAmount(activeEntryIndex, i);
        }
    }

    public void calExpEntryAmount(int activeEntryIndex, int rowIndex) {
        BigDecimal orderQty = (BigDecimal)this.purOrderEditUI.kdtEntries.getRow(activeEntryIndex).getCell("qty").getValue();
        BigDecimal unitExpense = (BigDecimal)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("unitExpense").getValue();
        int scale = this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseAmount").getEditor() == null ? 2 : ((KDFormattedTextField)this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseAmount").getEditor().getComponent()).getPrecision();
        this.purOrderEditUI.kdtExpenseEntries.getRow(rowIndex).getCell("expenseAmount").setValue((Object)CalculateUtils.calExpenseAmount((BigDecimal)orderQty, (BigDecimal)unitExpense, (int)scale));
    }
}

