/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurPriceQueryUI;
import com.kingdee.eas.scm.sm.pur.client.PurPriceCtrlStrategy;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PurPriceQueryUI
extends AbstractPurPriceQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(PurPriceQueryUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private BigDecimal hundrud = new BigDecimal("100.00");
    private BigDecimal one = new BigDecimal("1.00");
    private PurPriceCtrlStrategy purPriceCtrlStrategy = null;
    private PurchaseOrgUnitInfo purOrgInfo = null;
    private MaterialInfo materialInfo = null;
    private MaterialPurchasingInfo materialPurchasingInfo = null;
    private CurrencyInfo baseCurrencyInfo = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private String currencyID = null;
    private PurPriceParamCollection paramCols = new PurPriceParamCollection();
    private int selectRow = 0;
    private Boolean isTaxPrice = null;
    private ICell currentCell = null;
    private ICell discountCell = null;
    private ICell supplierCell = null;
    private ICell taxRateCell = null;
    private SpinnerNumberModel latestPrice = new SpinnerNumberModel(1, 0, 999, 1);
    private SpinnerNumberModel queryPrice = new SpinnerNumberModel(1, 0, 999, 1);
    private SpinnerNumberModel supplierPrice = new SpinnerNumberModel(1, 0, 999, 1);
    private ChangeListener changeListener = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.kdtEntry.checkParsed();
        this.kdsLatestPrice.setModel((SpinnerModel)this.latestPrice);
        this.kdsQueryPrice.setModel((SpinnerModel)this.queryPrice);
        this.kdsSupplierPrice.setModel((SpinnerModel)this.supplierPrice);
        this.initParam();
        this.initHeaderData(this.purOrgInfo.getId().toString(), this.materialInfo);
        PurPriceParamCollection paramCols = this.initQueryParam();
        this.kdtEntry.getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("qty").getStyleAttributes().setNumberFormat("%{0.########}f");
        PurPriceInfoCollection purInfoCols = this.purPriceCtrlStrategy.getPurPriceInfoCollection(this.selectRow, paramCols);
        this.fillQueryPurPrice(purInfoCols);
        if (this.currentCell == null) {
            this.btnReturn.setEnabled(false);
        } else {
            this.btnReturn.setEnabled(true);
        }
        this.btnClose.setEnabled(true);
        this.initPressEvent();
        this.addListener();
    }

    private void addListener() {
        if (this.changeListener == null) {
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PurPriceParamCollection paramCols = PurPriceQueryUI.this.initQueryParam();
                    PurPriceQueryUI.this.kdtEntry.getStyleAttributes().setLocked(true);
                    PurPriceInfoCollection purInfoCols = null;
                    try {
                        purInfoCols = PurPriceQueryUI.this.purPriceCtrlStrategy.getPurPriceInfoCollection(PurPriceQueryUI.this.selectRow, paramCols);
                    }
                    catch (EASBizException e1) {
                        PurPriceQueryUI.this.handleException((Exception)((Object)e1));
                    }
                    catch (BOSException e1) {
                        PurPriceQueryUI.this.handleException((Exception)((Object)e1));
                    }
                    try {
                        PurPriceQueryUI.this.fillQueryPurPrice(purInfoCols);
                    }
                    catch (BOSException e1) {
                        PurPriceQueryUI.this.handleException((Exception)((Object)e1));
                    }
                }
            };
        }
        this.kdsLatestPrice.addChangeListener(this.changeListener);
        this.kdsQueryPrice.addChangeListener(this.changeListener);
        this.kdsSupplierPrice.addChangeListener(this.changeListener);
    }

    private void initParam() {
        Map uiContext = this.getUIContext();
        this.materialInfo = (MaterialInfo)uiContext.get("material");
        this.purOrgInfo = (PurchaseOrgUnitInfo)uiContext.get("purOrgUnit");
        this.purPriceCtrlStrategy = (PurPriceCtrlStrategy)uiContext.get("purPriceCtrlStrategy");
        this.selectRow = (Integer)uiContext.get("selectRow");
        this.isTaxPrice = (Boolean)uiContext.get("isTaxPrice");
        this.currentCell = (ICell)uiContext.get("editCell");
        this.discountCell = (ICell)uiContext.get("discountCell");
        this.supplierCell = (ICell)uiContext.get("supplierCell");
        this.taxRateCell = (ICell)uiContext.get("taxRateCell");
    }

    private PurPriceParamCollection initQueryParam() {
        PurPriceParamCollection paramCols = new PurPriceParamCollection();
        paramCols.put("queryPriceDate", this.kdsQueryPrice.getValue());
        paramCols.put("SupplierPriceQty", this.kdsSupplierPrice.getValue());
        paramCols.put("latestPriceQty", this.kdsLatestPrice.getValue());
        paramCols.put("isByBillType", new Boolean(true));
        paramCols.put("isTaxPrice", this.isTaxPrice);
        return paramCols;
    }

    private void initHeaderData(String purOrgID, MaterialInfo materialInfo) throws BOSException, EASBizException {
        this.prmtMaterial.setValue((Object)materialInfo);
        this.txtModel.setText(materialInfo.getModel());
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(purOrgID, 3, 1);
        if (orgUnitCollection.size() > 0) {
            this.companyInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
            if (this.companyInfo != null && this.companyInfo.getBaseCurrency() != null) {
                this.baseCurrencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.companyInfo.getBaseCurrency().getId()));
                this.txtCurrency.setText(this.baseCurrencyInfo.getName());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)purOrgID, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("price"));
        selector.add(new SelectorItemInfo("priceTop"));
        selector.add(new SelectorItemInfo("unit.id"));
        selector.add(new SelectorItemInfo("unit.number"));
        selector.add(new SelectorItemInfo("unit.name"));
        view.setFilter(filter);
        view.setSelector(selector);
        MaterialPurchasingCollection cols = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(view);
        String colPrecision = SCMClientUtils.getFormatPattern((int)materialInfo.getPricePrecision());
        if (cols.size() > 0) {
            this.materialPurchasingInfo = cols.get(0);
            if (this.materialPurchasingInfo.getPriceTop() != null && this.materialPurchasingInfo.getPriceTop().compareTo(ZERO) != 0) {
                BigDecimal priceTop = this.materialPurchasingInfo.getPriceTop();
                priceTop = priceTop.setScale(materialInfo.getPricePrecision(), 4);
                this.txtHightPrice.setText(String.valueOf(priceTop));
            } else {
                this.txtHightPrice.setText(ZERO.setScale(materialInfo.getPricePrecision(), 4).toPlainString());
            }
            if (this.materialPurchasingInfo.getPrice() != null && this.materialPurchasingInfo.getPrice().compareTo(ZERO) != 0) {
                BigDecimal price = this.materialPurchasingInfo.getPrice();
                price = price.setScale(materialInfo.getPricePrecision(), 4);
                this.txtPreferencePrice.setText(String.valueOf(price));
            } else {
                this.txtPreferencePrice.setText(ZERO.setScale(materialInfo.getPricePrecision(), 4).toPlainString());
            }
            this.txtUnit.setText(this.materialPurchasingInfo.getUnit().getName());
        } else {
            this.txtHightPrice.setText(ZERO.setScale(materialInfo.getPricePrecision(), 4).toPlainString());
            this.txtPreferencePrice.setText(ZERO.setScale(materialInfo.getPricePrecision(), 4).toPlainString());
            this.txtUnit.setText(null);
        }
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String queryPrice = ConfigServiceUtils.getUserConfigData((String)("kdsQueryPrice" + userID), (CoreUI)this);
        String latestPrice = ConfigServiceUtils.getUserConfigData((String)("kdsLatestPrice" + userID), (CoreUI)this);
        String supplierPrice = ConfigServiceUtils.getUserConfigData((String)("kdsSupplierPrice" + userID), (CoreUI)this);
        if (queryPrice != null) {
            this.kdsQueryPrice.setValue((Object)new Integer(queryPrice));
        } else {
            this.kdsQueryPrice.setValue((Object)new Integer(12));
        }
        if (latestPrice != null) {
            this.kdsLatestPrice.setValue((Object)new Integer(latestPrice));
        } else {
            this.kdsLatestPrice.setValue((Object)new Integer(1));
        }
        if (supplierPrice != null) {
            this.kdsSupplierPrice.setValue((Object)new Integer(supplierPrice));
        } else {
            this.kdsSupplierPrice.setValue((Object)new Integer(3));
        }
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntry.getRowCount() == 0 || this.kdtEntry.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int rowIndex = this.kdtEntry.getSelectManager().getActiveRowIndex();
        this.setCellValue(rowIndex);
        this.getUIWindow().close();
    }

    private void setCellValue(int rowIndex) {
        BigDecimal discountRate;
        if (this.discountCell != null) {
            BigDecimal discount = (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("discount").getValue();
            this.discountCell.setValue((Object)discount);
        }
        BigDecimal price = null;
        BigDecimal taxRate = (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("taxRate").getValue();
        if (this.taxRateCell != null) {
            this.taxRateCell.setValue((Object)taxRate);
        }
        if (this.isTaxPrice != null) {
            price = this.isTaxPrice.booleanValue() ? (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("compareTaxPrice").getValue() : (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("comparePrice").getValue();
        } else {
            price = (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("comparePrice").getValue();
            if (price == null) {
                price = (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("compareTaxPrice").getValue();
            }
        }
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(this.purPriceCtrlStrategy.getBillTypeId()) && (discountRate = (BigDecimal)this.kdtEntry.getRow(rowIndex).getCell("discount").getValue()).compareTo(ZERO) > 0) {
            discountRate = discountRate.divide(this.hundrud, 4, 4);
            price = price.multiply(this.one.subtract(discountRate));
        }
        if (this.discountCell != null) {
            this.discountCell.setValue(this.kdtEntry.getRow(rowIndex).getCell("discount").getValue());
        }
        KDTable table = this.purPriceCtrlStrategy.table;
        BigDecimal bigDecimal = price = price != null ? price : ZERO;
        if (this.isEditting(this.currentCell, table)) {
            this.currentCell.getEditor().setValue((Object)price);
        } else {
            this.currentCell.setValue((Object)price);
            KDTEditEvent e = new KDTEditEvent((Object)table, null, this.currentCell.getValue(), this.currentCell.getRowIndex(), this.currentCell.getColumnIndex(), false, 1);
            try {
                for (int loopListeners = 0; loopListeners < ((KDTEditListener[])table.getListeners(KDTEditListener.class)).length; ++loopListeners) {
                    ((KDTEditListener[])table.getListeners(KDTEditListener.class))[loopListeners].editStopped(e);
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.purPriceCtrlStrategy.getBillTypeId())) {
            String supplierID = (String)this.kdtEntry.getRow(rowIndex).getCell("supplierID").getValue();
            try {
                this.supplierCell.setValue((Object)SupplierFactory.getRemoteInstance().getSupplierInfo("where id = '" + supplierID + "'"));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private boolean isEditting(ICell cell, KDTable table) {
        boolean isEditting = false;
        ICell cellEditting = table.getEditManager().getEditCell();
        if (cellEditting != null && table.getEditManager().getEditColIndex() != -1 && cell.getRowIndex() == table.getEditManager().getEditRowIndex() && cell.getColumnIndex() == table.getEditManager().getEditColIndex()) {
            isEditting = true;
        }
        return isEditting;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ConfigServiceUtils.saveUserConfigData((String)("kdsQueryPrice" + userID), (CoreUI)this, (String)this.kdsQueryPrice.getValue().toString());
        ConfigServiceUtils.saveUserConfigData((String)("kdsLatestPrice" + userID), (CoreUI)this, (String)this.kdsLatestPrice.getValue().toString());
        ConfigServiceUtils.saveUserConfigData((String)("kdsSupplierPrice" + userID), (CoreUI)this, (String)this.kdsSupplierPrice.getValue().toString());
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean checkBeforeWindowClosing() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ConfigServiceUtils.saveUserConfigData((String)("kdsQueryPrice" + userID), (CoreUI)this, (String)this.kdsQueryPrice.getValue().toString());
        ConfigServiceUtils.saveUserConfigData((String)("kdsLatestPrice" + userID), (CoreUI)this, (String)this.kdsLatestPrice.getValue().toString());
        ConfigServiceUtils.saveUserConfigData((String)("kdsSupplierPrice" + userID), (CoreUI)this, (String)this.kdsSupplierPrice.getValue().toString());
        return true;
    }

    private void registerColumn(PurPriceCtrlStrategy purPriceCtrlStrategy) {
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("priceType", "priceType");
        columns.put("supplier", "supplier");
        columns.put("unit", "unit");
        columns.put("assistProperty", "assistProperty");
        columns.put("currency", "currency");
        columns.put("price", "price");
        columns.put("discountRate", "discount");
        columns.put("taxPrice", "taxPrice");
        columns.put("qty", "qty");
        columns.put("recOrgUnit", "reqOrg");
        columns.put("effectDate", "effectDate");
        columns.put("unEffectDate", "unEffectDate");
        columns.put("billDate", "billDate");
        columns.put("comparePrice", "comparePrice");
        purPriceCtrlStrategy.registerColumn(columns);
    }

    private void initPressEvent() {
        this.kdtEntry.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (PurPriceQueryUI.this.currentCell != null && e.getClickCount() == 2 && e.getType() == 1) {
                    int rowIndex = e.getRowIndex();
                    PurPriceQueryUI.this.setCellValue(rowIndex);
                    PurPriceQueryUI.this.getUIWindow().close();
                }
            }
        });
    }

    private void fillQueryPurPrice(PurPriceInfoCollection priceInfoCol) throws BOSException {
        this.kdtEntry.removeRows();
        this.kdtEntry.repaint();
        Object bigDecimal = null;
        BigDecimal hTaxPrice = ZERO;
        BigDecimal lTaxPrice = BigDecimal.valueOf(Double.MAX_VALUE);
        IRow row = null;
        for (int i = 0; i < priceInfoCol.size(); ++i) {
            PurPriceInfo priceInfo = priceInfoCol.getPurPriceInfo(i);
            row = this.kdtEntry.addRow();
            row.getCell("priceType").setValue(priceInfo.get("priceType"));
            row.getCell("supplier").setValue(priceInfo.get("supplier"));
            row.getCell("supplierID").setValue(priceInfo.get("supplierID"));
            row.getCell("unit").setValue(priceInfo.get("unit"));
            row.getCell("assistProperty").setValue(priceInfo.get("assistProperty"));
            row.getCell("currency").setValue(priceInfo.get("currency"));
            row.getCell("taxRate").setValue((Object)priceInfo.getTaxRate());
            BigDecimal taxRate = BigDecimal.ZERO;
            if (priceInfo.getTaxRate() != null) {
                taxRate = priceInfo.getTaxRate();
            }
            int discountPrecision = 4;
            try {
                discountPrecision = PurUtil.getDiscountRatePrecision(null);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            if (priceInfo.getDiscountRate() != null && priceInfo.getDiscountRate().compareTo(ZERO) != 0) {
                row.getCell("discount").setValue((Object)priceInfo.getDiscountRate().setScale(discountPrecision, 4));
            } else {
                row.getCell("discount").setValue((Object)ZERO.setScale(discountPrecision, 4));
            }
            Integer isTax = (Integer)priceInfo.get("taxAmount");
            BigDecimal comparePrice = (BigDecimal)priceInfo.get("comparePrice");
            if (priceInfo.get("isSupplierPrice") != null) {
                if (priceInfo.getPrice() == null) {
                    BigDecimal taxPrice = (BigDecimal)priceInfo.get("taxPrice");
                    row.getCell("taxPrice").setValue((Object)taxPrice);
                    if (taxRate != null) {
                        taxPrice = this.purPriceCtrlStrategy.calEntryPriceByTaxPrice(taxPrice, taxRate, priceInfo);
                        row.getCell("price").setValue((Object)taxPrice);
                    } else {
                        row.getCell("price").setValue((Object)taxPrice);
                    }
                } else {
                    BigDecimal price = priceInfo.getPrice();
                    row.getCell("price").setValue((Object)price);
                    if (taxRate != null) {
                        price = this.purPriceCtrlStrategy.calEntryTaxPricebyPrice(price, taxRate, priceInfo);
                        row.getCell("taxPrice").setValue((Object)price);
                    } else {
                        row.getCell("taxPrice").setValue((Object)price);
                    }
                }
                Boolean isTaxPrice = (Boolean)priceInfo.get("isSupplierPrice");
                if (isTaxPrice.booleanValue()) {
                    row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    if (comparePrice.compareTo(hTaxPrice) > 0) {
                        hTaxPrice = comparePrice;
                    }
                    if (comparePrice.compareTo(lTaxPrice) < 0) {
                        lTaxPrice = comparePrice;
                    }
                    if (taxRate != null) {
                        comparePrice = this.purPriceCtrlStrategy.calEntryPriceByTaxPrice(comparePrice, taxRate, priceInfo);
                        row.getCell("comparePrice").setValue((Object)comparePrice);
                    } else {
                        row.getCell("comparePrice").setValue((Object)comparePrice);
                    }
                } else {
                    row.getCell("comparePrice").setValue((Object)comparePrice);
                    if (taxRate != null) {
                        comparePrice = this.purPriceCtrlStrategy.calEntryTaxPricebyPrice(comparePrice, taxRate, priceInfo);
                        row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    } else {
                        row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    }
                    if (comparePrice.compareTo(hTaxPrice) > 0) {
                        hTaxPrice = comparePrice;
                    }
                    if (comparePrice.compareTo(lTaxPrice) < 0) {
                        lTaxPrice = comparePrice;
                    }
                }
            } else {
                row.getCell("price").setValue((Object)priceInfo.getPrice());
                row.getCell("taxPrice").setValue(priceInfo.get("taxPrice"));
                if (((Boolean)priceInfo.get("isTaxPrice")).booleanValue()) {
                    row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    if (comparePrice.compareTo(hTaxPrice) > 0) {
                        hTaxPrice = comparePrice;
                    }
                    if (comparePrice.compareTo(lTaxPrice) < 0) {
                        lTaxPrice = comparePrice;
                    }
                    if (taxRate != null) {
                        comparePrice = this.purPriceCtrlStrategy.calEntryPriceByTaxPrice(comparePrice, taxRate, priceInfo);
                        row.getCell("comparePrice").setValue((Object)comparePrice);
                    } else {
                        row.getCell("comparePrice").setValue((Object)comparePrice);
                    }
                } else {
                    row.getCell("comparePrice").setValue((Object)comparePrice);
                    if (taxRate != null) {
                        comparePrice = this.purPriceCtrlStrategy.calEntryTaxPricebyPrice(comparePrice, taxRate, priceInfo);
                        row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    } else {
                        row.getCell("compareTaxPrice").setValue((Object)comparePrice);
                    }
                    if (comparePrice.compareTo(hTaxPrice) > 0) {
                        hTaxPrice = comparePrice;
                    }
                    if (comparePrice.compareTo(lTaxPrice) < 0) {
                        lTaxPrice = comparePrice;
                    }
                }
            }
            row.getCell("price").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)priceInfo.getPricePrecision()));
            row.getCell("taxPrice").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)priceInfo.getPricePrecision()));
            row.getCell("comparePrice").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)priceInfo.getPricePrecision()));
            row.getCell("compareTaxPrice").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)priceInfo.getPricePrecision()));
            row.getCell("qty").setValue(priceInfo.get("qty"));
            row.getCell("reqOrg").setValue(priceInfo.get("recOrgUnit"));
            row.getCell("effectDate").setValue(priceInfo.get("effectDate"));
            row.getCell("unEffectDate").setValue(priceInfo.get("unEffectDate"));
            row.getCell("billDate").setValue(priceInfo.get("billDate"));
        }
        BigDecimal compareVal = null;
        int size = this.kdtEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntry.getRow(i);
            compareVal = (BigDecimal)row.getCell("compareTaxPrice").getValue();
            if (compareVal.compareTo(lTaxPrice) == 0) {
                row.getCell("compareTaxPrice").getStyleAttributes().setBackground(SHOW_MESSAGE_BG_OK);
                continue;
            }
            if (compareVal.compareTo(hTaxPrice) != 0) continue;
            row.getCell("compareTaxPrice").getStyleAttributes().setBackground(SHOW_MESSAGE_FG_DEFAULT);
        }
        int columnCount = this.kdtEntry.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            KDTableHelper.autoFitColumnWidth((KDTable)this.kdtEntry, (int)i);
        }
    }
}

