/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.QuotationException;
import com.kingdee.eas.scm.sm.pur.IPurQuotation;
import com.kingdee.eas.scm.sm.pur.IPurQuotationEntry;
import com.kingdee.eas.scm.sm.pur.MakeBillFlagEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.QuoteStyleEnum;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurQuotationListUI;
import com.kingdee.eas.scm.sm.pur.client.PurQuotationEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurQuotationQueryUI;
import com.kingdee.eas.scm.sm.pur.client.PurSynProcessor;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class PurQuotationListUI
extends AbstractPurQuotationListUI {
    private static final long serialVersionUID = 326657202892261754L;
    PurQuotationQueryUI conditionPanel = null;
    private static final String TB_ENTQTYFROM = "entries.qtyFrom";
    private static final String TB_ENTQTYTO = "entries.qtyTo";
    private static final String TB_ENTPRICE = "entries.price";
    private static final String TB_ENTTAXRATE = "entries.taxRate";
    private static final String TB_ENTTAXPRICE = "entries.taxPrice";
    private static final String TB_QTY = "qty";
    private static final String TB_BASEQTY = "entries.baseQty";
    private static final String TB_ENTACTUALTAXPRICE = "entries.actualTaxPrice";
    private static String[] NUMBERTAB = new String[]{"exchangeRate", "entries.qtyFrom", "entries.qtyTo", "entries.price", "entries.taxRate", "entries.taxRate", "entries.taxPrice", "entries.actualTaxPrice"};
    public static final String RES_PROMPT = "com.kingdee.eas.scm.sm.pur.PurUIResource";
    private static String[] SECRECY_STRFIELDS = new String[]{"purQuotationPlanID", "supplier.name", "supplier.id", "currency.name", "purchasePerson.name"};
    private static String[] SECRECY_NOSTRFIELDS = new String[]{"entries.price", "entries.taxPrice", "exchangeRate", "disibleDate", "entries.amount", "entries.qtyFrom", "entries.qtyTo", "entries.price", "entries.taxRate", "entries.taxPrice", "entries.actualTaxPrice"};
    private static final BatchActionEnum issueBill = new BatchActionEnum("issueBill");
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurQuotationFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        this.btnIssue.setIcon(EASResource.getIcon((String)"imgTbtn_workremove"));
        if (!PurUtil.isPurSyn()) {
            this.tblMain.getColumn("issuer").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("issueTime").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("isSupplierView").getStyleAttributes().setHided(true);
            this.actionIssue.setEnabled(false);
            this.btnIssue.setVisible(false);
        } else {
            this.actionIssue.setEnabled(true);
            this.btnIssue.setVisible(true);
            this.tblMain.getColumn("issuer").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("issueTime").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("isSupplierView").getStyleAttributes().setHided(false);
        }
        super.onLoad();
        this.btnAddNew.setEnabled(true);
        this.btnAddNew.setVisible(true);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.btnAlter.setEnabled(true);
        this.btnAlter.setVisible(true);
        this.actionReservationQuery.setVisible(false);
        this.setMainTableAlign();
        this.setMainTableFreeze();
        this.btnVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
        this.btnCopyTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemCancelBill.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnCancelBill.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnWorkFlowG.setVisible(true);
        this.btnWorkFlowG.setEnabled(true);
        String format = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("disibleDate").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(format);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.menuItemImportData.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setEnabled(true);
        this.menuItemExportData.setVisible(true);
        this.btnCancelBill.setVisible(true);
        this.btnCancelBill.setEnabled(true);
        this.btnViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.menuItemViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.btnAlter.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.actionAudit.setVisible(true);
        this.actionUnAudit.setVisible(true);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        FilterInfo addFilterInfo = new FilterInfo();
        addFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(-3), CompareType.NOTEQUALS));
        if (ev.getFilter() != null) {
            try {
                ev.getFilter().mergeFilter(addFilterInfo, "AND");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, 4);
    }

    @Override
    protected String getEditUIName() {
        return PurQuotationEditUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "baseStatus", "bizDate", "supplier.name", "currency.name", "exchangeRate", "disibleDate", "purchaseOrgUnit.name", "purchaseGroup.name", "purchasePerson.name", "totalTaxAmount", "totalAmount", "processNode"};
        return columns;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected void checkCanEdit(SCMBillBaseInfo billInfo) throws Exception {
        super.checkCanEdit(billInfo);
        PurQuotationInfo purQuoInfo = (PurQuotationInfo)billInfo;
        if (purQuoInfo != null && MakeBillFlagEnum.SUPPLIER.equals((Object)purQuoInfo.getMakeBillFlag())) {
            MsgBox.showWarning((String)PurUtil.getPurQuotationResource("QUO_SUPPLIER_BILL"));
            SysUtil.abort();
        }
        if (purQuoInfo != null && BillBaseStatusEnum.SUBMITED.equals((Object)purQuoInfo.getBaseStatus()) && purQuoInfo.getSupplier() != null && purQuoInfo.getPurchaseOrgUnit() != null) {
            boolean isSupplierPurSyn = PurUtil.isSupplierPurSyn(purQuoInfo.getSupplier().getId().toString(), purQuoInfo.getPurchaseOrgUnit().getId().toString());
            if (PurUtil.isPurSyn() && isSupplierPurSyn && QuoteStyleEnum.WEB.equals((Object)purQuoInfo.getQuoteType())) {
                MsgBox.showWarning((String)PurUtil.getPurQuotationResource("QUO_SUPPLIER_BILL"));
                SysUtil.abort();
            }
        }
    }

    private void setMainTableAlign() {
        int num = NUMBERTAB.length;
        for (int i = 0; i < num; ++i) {
            this.tblMain.getColumn(NUMBERTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int ratePre = 2;
        String[] QTY_COLUMNS = new String[]{TB_ENTQTYFROM, TB_ENTQTYTO};
        String[] PRICE_COLUMNS = new String[]{TB_ENTPRICE, TB_ENTACTUALTAXPRICE, TB_ENTTAXPRICE};
        String[] RATE_COLUMNS = new String[]{TB_ENTTAXRATE};
        try {
            while (rowSet.next()) {
                BillBaseStatusEnum billStatus;
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)ratePre, (String[])RATE_COLUMNS, (IRowSet)rowSet);
                String billID = rowSet.getString("id");
                String billPersionID = rowSet.getString("creator.name");
                if (rowSet.getObject("baseStatus") == null) continue;
                BizEnumValueDTO tempStatus = (BizEnumValueDTO)rowSet.getObject("baseStatus");
                switch (tempStatus.getInt()) {
                    case 0: {
                        billStatus = BillBaseStatusEnum.ADD;
                        break;
                    }
                    case 1: {
                        billStatus = BillBaseStatusEnum.TEMPORARILYSAVED;
                        break;
                    }
                    case -2: {
                        billStatus = BillBaseStatusEnum.ALTERING;
                        break;
                    }
                    case 4: {
                        billStatus = BillBaseStatusEnum.AUDITED;
                        break;
                    }
                    case 7: {
                        billStatus = BillBaseStatusEnum.CLOSED;
                        break;
                    }
                    case 2: {
                        billStatus = BillBaseStatusEnum.SUBMITED;
                        break;
                    }
                    default: {
                        billStatus = BillBaseStatusEnum.ADD;
                    }
                }
                Date secrecyEndDate = rowSet.getDate("disibleDate");
                String purchaseOrgUnitID = rowSet.getString("purchaseOrgUnit.id");
                try {
                    PurUtil.purQuoPriceSecrecyForListHelper(billID, billStatus, billPersionID, purchaseOrgUnitID, secrecyEndDate, SECRECY_STRFIELDS, SECRECY_NOSTRFIELDS, rowSet);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("disibleDate"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.discount"));
        return sic;
    }

    public String[] getAmountColumns() {
        return new String[]{TB_ENTTAXRATE};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_ENTQTYFROM, TB_ENTQTYTO, TB_QTY, TB_BASEQTY};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_ENTPRICE, TB_ENTTAXPRICE, TB_ENTACTUALTAXPRICE};
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PurQuotationQueryUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PurQuotationQueryUI();
        }
        return this.conditionPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        try {
            String[] selIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
            if (selIDs == null) {
                this.handleException((Exception)((Object)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, new String[]{""})));
                return;
            }
            SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])selIDs);
            this.setOprtState("AUDIT");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
            IPurQuotation iPurQuotation = PurQuotationFactory.getRemoteInstance();
            iPurQuotation.auditBill(pks);
            this.showSuccessMsg("PURINV_AUDITSUCCESS");
            this.refreshList();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancelBill_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        try {
            this.setOprtState("REVOKE");
            if (id != null) {
                Object reasonCodeInfo;
                this.pubFireVOChangeListener(id);
                IPurQuotation iPurQuotation = PurQuotationFactory.getRemoteInstance();
                PurQuotationInfo purQuoInfo = iPurQuotation.getPurQuotationInfo((IObjectPK)new ObjectUuidPK(id));
                if (purQuoInfo != null && MakeBillFlagEnum.SUPPLIER.equals((Object)purQuoInfo.getMakeBillFlag())) {
                    MsgBox.showWarning((String)PurUtil.getPurQuotationResource("QUO_SUPPLIER_CANCAL"));
                    SysUtil.abort();
                }
                if (purQuoInfo != null && BillBaseStatusEnum.SUBMITED.equals((Object)purQuoInfo.getBaseStatus())) {
                    String supplierID = null;
                    if (purQuoInfo.getSupplier() != null) {
                        supplierID = purQuoInfo.getSupplier().getId().toString();
                    }
                    String purchaseOrgUnitID = null;
                    if (purQuoInfo.getPurchaseOrgUnit() != null) {
                        purchaseOrgUnitID = purQuoInfo.getPurchaseOrgUnit().getId().toString();
                    }
                    if (PurUtil.isPurSyn() && PurUtil.isSupplierPurSyn(supplierID, purchaseOrgUnitID) && QuoteStyleEnum.WEB.equals((Object)purQuoInfo.getQuoteType())) {
                        MsgBox.showWarning((String)PurUtil.getPurQuotationResource("QUO_SUPPLIER_CANCAL"));
                        SysUtil.abort();
                    }
                }
                if ((reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()))) == null) {
                    return;
                }
                if (reasonCodeInfo instanceof IObjectValue) {
                    iPurQuotation.calcelBill((IObjectPK)new ObjectUuidPK(id), ((ReasonCodeInfo)reasonCodeInfo).getName());
                }
                if (reasonCodeInfo instanceof String) {
                    iPurQuotation.calcelBill((IObjectPK)new ObjectUuidPK(id), (String)reasonCodeInfo);
                }
                this.showSuccessMsg("PURINV_CANCELSUCCESS");
                this.refreshList();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(PurUtil.getUIResource(msgResource));
        this.showMessage();
    }

    public void actoinAlter_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            while (iterat.hasNext()) {
                ObjectUuidPK pk = new ObjectUuidPK((String)iterat.next());
                IPurQuotation iPurQuotation = PurQuotationFactory.getRemoteInstance();
                PurQuotationInfo purQuotationInfo = iPurQuotation.getPurQuotationInfo((IObjectPK)pk);
                if (purQuotationInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    String openBillEditUIClassName = "com.kingdee.eas.scm.sm.pur.client.PurQuotationEditUI";
                    UIContext map = new UIContext((Object)this);
                    map.put("ID", purQuotationInfo.getId().toString());
                    IUIWindow uiWindow = null;
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(openBillEditUIClassName, (Map)map, null, "alert");
                    uiWindow.show();
                    continue;
                }
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PURAutoGenerateResource", (String)"6_PurQuotationListUI"));
            }
        }
    }

    protected ArrayList getSelectedEntryIdValues() {
        ArrayList list = new ArrayList();
        ArrayList<Integer> selectList = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (this.isTableSelectModel(this.tblMain)) {
            list = this.getSelectIdForTableSelect(this.tblMain);
            return list;
        }
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return list;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell("entries.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            list.add(cell.getValue().toString());
            selectList.add(new Integer(rowNum));
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    String id;
                    ICell cell = this.tblMain.getRow(j).getCell("entries.id");
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (list.contains(id = cell.getValue().toString())) continue;
                    list.add(id);
                    selectList.add(new Integer(j));
                }
            }
        }
        return list;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("purchasePerson.id"));
        sic.add(new SelectorItemInfo("purchasePerson.number"));
        sic.add(new SelectorItemInfo("purchasePerson.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.add(new SelectorItemInfo("entries.materialGroup"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseQtyFrom"));
        sic.add(new SelectorItemInfo("entries.baseQtyTo"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo(TB_ENTQTYFROM));
        sic.add(new SelectorItemInfo(TB_ENTQTYTO));
        sic.add(new SelectorItemInfo(TB_ENTPRICE));
        sic.add(new SelectorItemInfo(TB_ENTTAXRATE));
        sic.add(new SelectorItemInfo(TB_ENTTAXPRICE));
        sic.add(new SelectorItemInfo("entries.discount"));
        sic.add(new SelectorItemInfo(TB_ENTACTUALTAXPRICE));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modificationTime"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("enabledDate"));
        sic.add(new SelectorItemInfo("disibleDate"));
        sic.add(new SelectorItemInfo("baseStatus"));
        return sic;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected void logPrint() {
        String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurQuotationInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return "purchaseOrgUnit.id";
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.sm.pur.app.PurQuotationQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/SCM/SM/PurQuotation";
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurQuotationFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurQuotationEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", "number", "entries.seq", "purchaseOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)issueBill, (ItemAction)this.actionIssue, (String)"issueBill");
        this.actionManager.registerBatchAction(actionProxy, "actionIssue");
        actionProxy.bindTo((AbstractButton)this.btnIssue);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getMainContext().put((Object)"isFromGUI", (Object)"1");
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
        return true;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        String purOrderType = new PurPriceRelationsInfo().getBOSType().toString();
        destBosTypeList.remove(purOrderType);
        return destBosTypeList;
    }

    protected FilterInfo getPrintFilter(List ids) {
        FilterInfo filter = new FilterInfo();
        if (ids.size() == 1) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toArray()[0].toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        }
        return filter;
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    @Override
    public void actionAlter_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        if (idList != null && idList.size() > 0) {
            String sql = PurUtil.getInStringFromList(idList);
            IPurQuotation iPurQuotation = PurQuotationFactory.getRemoteInstance();
            PurQuotationCollection cols = iPurQuotation.getPurQuotationCollection("select id,Supplier,PurchaseOrgUnit,basestatus,quoteType where id in " + sql);
            if (cols.size() != idList.size()) {
                throw new ObjectNotFoundException();
            }
            Iterator iterat = cols.iterator();
            while (iterat.hasNext()) {
                PurQuotationInfo purQuotationInfo = (PurQuotationInfo)iterat.next();
                if (purQuotationInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    String supplierID = null;
                    String purchaseOrgUnitID = null;
                    if (purQuotationInfo.getSupplier() != null) {
                        supplierID = purQuotationInfo.getSupplier().getId().toString();
                    }
                    if (purQuotationInfo.getPurchaseOrgUnit() != null) {
                        purchaseOrgUnitID = purQuotationInfo.getPurchaseOrgUnit().getId().toString();
                    }
                    if (PurUtil.isPurSyn() && PurUtil.isSupplierPurSyn(supplierID, purchaseOrgUnitID) && QuoteStyleEnum.WEB.equals((Object)purQuotationInfo.getQuoteType())) {
                        MsgBox.showWarning((String)PurUtil.getPurQuotationResource("QUO_SUPPLIER_ALTER"));
                        SysUtil.abort();
                    }
                    String openBillEditUIClassName = "com.kingdee.eas.scm.sm.pur.client.PurQuotationEditUI";
                    UIContext map = new UIContext((Object)this);
                    map.put("ID", purQuotationInfo.getId().toString());
                    IUIWindow uiWindow = null;
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(openBillEditUIClassName, (Map)map, null, "ALERT");
                    uiWindow.show();
                    continue;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PURAutoGenerateResource", (String)"7_PurQuotationListUI"));
            }
        }
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        if (selIDs == null) {
            this.handleException((Exception)new QuotationException(QuotationException.QUO_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BillID", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.pur.client.PurQuotationVersionUI", (Map)uiContext, null);
        window.show();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        this.importData();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            EntityViewInfo viewInfo = (EntityViewInfo)this.mainQuery.clone();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)CompareType.INCLUDE));
            dp.putContextParam((Object)"mainQuery", (Object)viewInfo);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    private void importData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame && this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0, true, true);
        }
        this.refreshList();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "com.kingdee.eas.scm.sm.pur.PurQuotation";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"F7_PurQuotation");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "com.kingdee.eas.scm.sm.pur.PurQuotation";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"F7_PurQuotation");
        param.datataskMode = 1;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurQuotationInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    public CommonQueryDialog initCommonQueryDialog() {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(340);
        this.commonQueryDialog.setWidth(534);
        this.commonQueryDialog.setProcessor((IProcessor)new PurSynProcessor());
        return this.commonQueryDialog;
    }

    @Override
    public void actionCreateApprovedSupplier_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateApprovedSupplier_actionPerformed(e);
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"entries.id");
        if (selIDs == null) {
            this.handleException((Exception)new QuotationException(QuotationException.QUO_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        int materialKey = this.tblMain.getColumnIndex("materailNumber");
        int materialGroupKey = this.tblMain.getColumnIndex("entries.materialGroup.name");
        Object materialValue = null;
        Object materialGroupValue = null;
        IRow row = null;
        KDTSelectBlock block = null;
        boolean flag = false;
        block0: for (int i = 0; i < blockCount; ++i) {
            block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                row = this.tblMain.getRow(j);
                materialValue = row.getCell(materialKey).getValue();
                materialGroupValue = row.getCell(materialGroupKey).getValue();
                if (materialValue == null && materialGroupValue == null) continue;
                flag = true;
                continue block0;
            }
        }
        if (!flag) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurQuotationResource", (String)"CANNT_UPDATE_ASINFO"));
            SysUtil.abort();
        }
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        IPurQuotationEntry iPurQuoEntry = PurQuotationEntryFactory.getRemoteInstance();
        iPurQuoEntry.createApprovedSupplier(pks);
        this.showSuccessMsg("PURQUO_UPDATESUCCESS");
    }
}

