/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.ReqParamDataVO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PurRequestMaterialHelper {
    Map<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
    Map<String, PurchaseOrgUnitInfo> materialDefaultPurOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
    Map<String, MaterialPurchasingInfo> materialPurchaseMap = new HashMap<String, MaterialPurchasingInfo>();
    Map<String, MaterialInventoryInfo> materialInventoryMap = new HashMap<String, MaterialInventoryInfo>();
    Map<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
    Map<String, MultiMeasureUnitInfo> multiUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
    Map<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
    Context mainOrgContext = null;

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    public void setMainOrgContext(Context mainOrgContext) {
        this.mainOrgContext = mainOrgContext;
    }

    public PurRequestMaterialHelper() {
        try {
            this.getAllRowType();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public RowTypeInfo getRowType(String rowId) {
        return this.rowTypeMap.get(rowId);
    }

    public MaterialInfo getMaterialInfo(String materiaId) {
        if (this.materialMap.containsKey(materiaId)) {
            return this.materialMap.get(materiaId);
        }
        return null;
    }

    public MaterialPurchasingInfo getMaterialPurchasingInfo(String materialId, String purOrgId) throws BOSException {
        String key = materialId + purOrgId;
        if (!this.materialPurchaseMap.containsKey(key)) {
            this.getMaterialPurchase(materialId, purOrgId);
        }
        return this.materialPurchaseMap.get(key);
    }

    public MaterialInventoryInfo getMaterialInventory(String materialId, String purOrgId) throws BOSException {
        String key = materialId + purOrgId;
        if (!this.materialInventoryMap.containsKey(key)) {
            this.getTheMaterialInventory(materialId, purOrgId);
        }
        return this.materialInventoryMap.get(key);
    }

    public MaterialPlanInfo getMaterialPlanInfo(String materialId, String storageOrgId) throws BOSException {
        String key = materialId + storageOrgId;
        if (!this.materialPlanMap.containsKey(key)) {
            this.getTheMaterialInventory(materialId, storageOrgId);
        }
        return this.materialPlanMap.get(key);
    }

    public Map<String, MaterialPlanInfo> getMaterialPlanMap() throws BOSException {
        return this.materialPlanMap;
    }

    public PurchaseOrgUnitInfo getMaterialDefaultPurOrg(String materialId) {
        if (this.materialDefaultPurOrgMap.containsKey(materialId)) {
            return this.materialDefaultPurOrgMap.get(materialId);
        }
        return null;
    }

    public int getQtyPrecision(String materialId, String unitId) {
        MultiMeasureUnitInfo mmuInfo;
        String key = materialId + unitId;
        if (!this.multiUnitMap.containsKey(key)) {
            try {
                this.getMultMeasureUnit(materialId, unitId);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        if ((mmuInfo = this.multiUnitMap.get(key)) != null) {
            return mmuInfo.getQtyPrecision();
        }
        return 2;
    }

    public MultiMeasureUnitInfo getMultiUnit(String materialId, String unitId) throws BOSException {
        String key = materialId + unitId;
        if (!this.multiUnitMap.containsKey(key)) {
            this.getMultMeasureUnit(materialId, unitId);
        }
        return this.multiUnitMap.get(key);
    }

    public void initData(List<String> materialIdList, ReqParamDataVO paramVo) throws EASBizException, BOSException {
        this.initData(materialIdList, paramVo, false);
    }

    public void initData(List<String> materialIdList, ReqParamDataVO paramVo, boolean isPurOrgFirst) throws EASBizException, BOSException {
        if (isPurOrgFirst) {
            PurchaseOrgUnitInfo purorg = null;
            if (paramVo.getPurchaseOrgID() != null) {
                purorg = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(paramVo.getPurchaseOrgID()));
            }
            for (String materialId : materialIdList) {
                this.materialDefaultPurOrgMap.put(materialId, purorg);
            }
        } else {
            this.getDefaultOrgs(paramVo, materialIdList);
        }
        this.getMaterialInfo(materialIdList);
        this.getMaterialPurchase(materialIdList);
        this.getMaterialPlan(materialIdList);
        this.getAllMultiUnitInfo();
    }

    public void getAllMaterialInventory(List<String> materialList, List<String> orgList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String key = null;
        int size = materialList.size();
        for (int i = 0; i < size; ++i) {
            key = materialList.get(i) + orgList.get(i);
            if (this.materialInventoryMap.containsKey(key)) continue;
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialList.get(i)));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgList.get(i)));
        }
        if (filter.getFilterItems().size() > 0) {
            StringBuffer maskString = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size() / 2; ++i) {
                maskString.append("(#").append(2 * i).append(" and #").append(2 * i + 1).append(")");
                if (i >= filter.getFilterItems().size() / 2 - 1) continue;
                maskString.append(" or ");
            }
            filter.setMaskString(maskString.toString());
            view.setFilter(filter);
            SelectorItemCollection sic = this.getSelectors();
            view.setSelector(sic);
            MaterialInventoryCollection collection = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                key = collection.get(i).getMaterial().getId().toString() + collection.get(i).getOrgUnit().getId().toString();
                this.materialInventoryMap.put(key, collection.get(i));
            }
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("defaultWarehouse.id"));
        sic.add(new SelectorItemInfo("defaultWarehouse.number"));
        sic.add(new SelectorItemInfo("defaultWarehouse.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        return sic;
    }

    private void getTheMaterialInventory(String materialId, String orgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId));
        view.setFilter(filter);
        SelectorItemCollection sic = this.getSelectors();
        view.setSelector(sic);
        MaterialInventoryCollection collection = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            String key = collection.get(i).getMaterial().getId().toString() + collection.get(i).getOrgUnit().getId().toString();
            this.materialInventoryMap.put(key, collection.get(i));
        }
    }

    public void getAllRowType() throws BOSException {
        IRowType irowtype = RowTypeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("destinationType"));
        view.getSelector().add(new SelectorItemInfo("requestOrgType"));
        view.getSelector().add(new SelectorItemInfo("isHasMaterialNumber"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        RowTypeCollection col = irowtype.getRowTypeCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            this.rowTypeMap.put(col.get(i).getId().toString(), col.get(i));
        }
    }

    public void getMaterialInfo(List<String> materialIdList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("model"));
        view.getSelector().add(new SelectorItemInfo("helpCode"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.id"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.name"));
        view.getSelector().add(new SelectorItemInfo("baseUnit.id"));
        view.getSelector().add(new SelectorItemInfo("baseUnit.number"));
        view.getSelector().add(new SelectorItemInfo("baseUnit.name"));
        view.getSelector().add(new SelectorItemInfo("assistUnit.id"));
        view.getSelector().add(new SelectorItemInfo("assistUnit.number"));
        view.getSelector().add(new SelectorItemInfo("assistUnit.name"));
        view.getSelector().add(new SelectorItemInfo("pricePrecision"));
        view.getSelector().add(new SelectorItemInfo("assistAttr"));
        HashSet<String> idSet = new HashSet<String>();
        for (String mId : materialIdList) {
            if (this.materialMap.containsKey(mId)) continue;
            idSet.add(mId);
        }
        if (idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialCollection collection = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                this.materialMap.put(collection.get(i).getId().toString(), collection.get(i));
            }
        }
    }

    private void getAllMultiUnitInfo() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String mId2 = null;
        MaterialInfo m = null;
        MaterialPurchasingInfo mp = null;
        PurchaseOrgUnitInfo purOrg = null;
        String key = null;
        for (String mId2 : this.materialMap.keySet()) {
            m = this.materialMap.get(mId2);
            if (m.getBaseUnit() != null && !this.multiUnitMap.containsKey(key = mId2 + m.getBaseUnit().getId().toString())) {
                filter.getFilterItems().add(new FilterItemInfo("material", (Object)mId2));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)m.getBaseUnit().getId().toString()));
            }
            if (m.getAssistUnit() != null && !this.multiUnitMap.containsKey(key = mId2 + m.getAssistUnit().getId().toString())) {
                filter.getFilterItems().add(new FilterItemInfo("material", (Object)mId2));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)m.getAssistUnit().getId().toString()));
            }
            if ((purOrg = this.materialDefaultPurOrgMap.get(mId2)) == null || !this.materialPurchaseMap.containsKey(key = mId2 + purOrg.getId().toString()) || (mp = this.materialPurchaseMap.get(key)).getUnit() == null || this.multiUnitMap.containsKey(key = mId2 + mp.getUnit().getId().toString())) continue;
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)mId2));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)mp.getUnit().getId().toString()));
        }
        if (filter.getFilterItems().size() > 0) {
            StringBuffer maskString = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size() / 2; ++i) {
                maskString.append("(#").append(2 * i).append(" and #").append(2 * i + 1).append(")");
                if (i >= filter.getFilterItems().size() / 2 - 1) continue;
                maskString.append(" or ");
            }
            filter.setMaskString(maskString.toString());
            view.setFilter(filter);
            view.getSelector().add("material");
            view.getSelector().add("measureUnit");
            view.getSelector().add("qtyPrecision");
            view.getSelector().add("baseConvsRate");
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                this.multiUnitMap.put(collection.get(i).getMaterial().getId().toString() + collection.get(i).getMeasureUnit().getId().toString(), collection.get(i));
            }
        }
    }

    private void getMultMeasureUnit(String mId, String unitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)mId));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)unitId));
        view.setFilter(filter);
        view.getSelector().add("material");
        view.getSelector().add("measureUnit");
        view.getSelector().add("qtyPrecision");
        view.getSelector().add("baseConvsRate");
        MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            this.multiUnitMap.put(collection.get(i).getMaterial().getId().toString() + collection.get(i).getMeasureUnit().getId().toString(), collection.get(i));
        }
    }

    public List<String> checkMultiUnit(List<String> materialIdList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMaterialID,count(FMaterialID) mucount ").append("from T_BD_MultiMeasureUnit ").append("where FIsBasicUnit = 1").append("and FMaterialID in (");
        String conStr = "";
        for (String id : materialIdList) {
            sql.append(conStr).append("'").append(id).append("'");
            conStr = ",";
        }
        sql.append(") ").append("group by FMaterialID");
        ArrayList<String> errorMaterialList = new ArrayList<String>();
        IRowSet rs = this.getSQLDataAccess().getRowSet(sql.toString());
        try {
            while (rs.next()) {
                if (rs.getInt("mucount") <= 1) continue;
                errorMaterialList.add(rs.getString("FMaterialID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorMaterialList;
    }

    public List<String> checkMaterialPurchase(List<String> materialIdList) throws BOSException {
        this.getMaterialPurchase(materialIdList);
        String key = null;
        ArrayList<String> errorMaterialList = new ArrayList<String>();
        for (String id : materialIdList) {
            PurchaseOrgUnitInfo purOrg = this.materialDefaultPurOrgMap.get(id);
            if (purOrg == null || this.materialPurchaseMap.containsKey(key = id + purOrg.getId().toString())) continue;
            errorMaterialList.add(id);
        }
        return errorMaterialList;
    }

    public Map<String, MaterialPurchasingInfo> getMaterialPurchase(List<String> materialIdList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        boolean hasSetDefaultPermOrg = false;
        String key = null;
        for (String id : materialIdList) {
            PurchaseOrgUnitInfo purOrg = this.materialDefaultPurOrgMap.get(id);
            if (purOrg == null) continue;
            if (!hasSetDefaultPermOrg) {
                this.mainOrgContext.put((Object)OrgType.Purchase, (Object)purOrg);
                hasSetDefaultPermOrg = true;
            }
            if (this.materialPurchaseMap.containsKey(key = id + purOrg.getId().toString())) continue;
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)id));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)purOrg.getId().toString()));
        }
        if (filter.getFilterItems().size() > 0) {
            StringBuffer maskString = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size() / 2; ++i) {
                maskString.append("(#").append(2 * i).append(" and #").append(2 * i + 1).append(")");
                if (i >= filter.getFilterItems().size() / 2 - 1) continue;
                maskString.append(" or ");
            }
            filter.setMaskString(maskString.toString());
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("purPerson.id"));
            sic.add(new SelectorItemInfo("purPerson.number"));
            sic.add(new SelectorItemInfo("purPerson.name"));
            sic.add(new SelectorItemInfo("purGroup.id"));
            sic.add(new SelectorItemInfo("purGroup.number"));
            sic.add(new SelectorItemInfo("purGroup.name"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.number"));
            sic.add(new SelectorItemInfo("unit.name"));
            sic.add(new SelectorItemInfo("supplier.id"));
            sic.add(new SelectorItemInfo("supplier.number"));
            sic.add(new SelectorItemInfo("supplier.name"));
            sic.add(new SelectorItemInfo("supplier.taxRate"));
            sic.add(new SelectorItemInfo("useSupplyPrice"));
            sic.add(new SelectorItemInfo("useSupplyList"));
            sic.add(new SelectorItemInfo("isNotControlTime"));
            sic.add(new SelectorItemInfo("isNotControlQty"));
            sic.add(new SelectorItemInfo("price"));
            view.setSelector(sic);
            MaterialPurchasingCollection collection = MaterialPurchasingFactory.getRemoteInstanceWithObjectContext((Context)this.mainOrgContext).getMaterialPurchasingCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                key = collection.get(i).getMaterial().getId().toString() + collection.get(i).getOrgUnit().getId().toString();
                this.materialPurchaseMap.put(key, collection.get(i));
            }
        }
        return this.materialPurchaseMap;
    }

    private void getMaterialPurchase(String materialId, String purOrgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)purOrgId));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("purPerson.id"));
        sic.add(new SelectorItemInfo("purPerson.number"));
        sic.add(new SelectorItemInfo("purPerson.name"));
        sic.add(new SelectorItemInfo("purGroup.id"));
        sic.add(new SelectorItemInfo("purGroup.number"));
        sic.add(new SelectorItemInfo("purGroup.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.taxRate"));
        sic.add(new SelectorItemInfo("useSupplyPrice"));
        sic.add(new SelectorItemInfo("useSupplyList"));
        sic.add(new SelectorItemInfo("isNotControlTime"));
        sic.add(new SelectorItemInfo("isNotControlQty"));
        sic.add(new SelectorItemInfo("price"));
        view.setSelector(sic);
        MaterialPurchasingCollection collection = MaterialPurchasingFactory.getRemoteInstanceWithObjectContext((Context)this.mainOrgContext).getMaterialPurchasingCollection(view);
        String key = null;
        for (int i = 0; i < collection.size(); ++i) {
            key = collection.get(i).getMaterial().getId().toString() + collection.get(i).getOrgUnit().getId().toString();
            this.materialPurchaseMap.put(key, collection.get(i));
        }
    }

    public Map<String, MaterialPlanInfo> getMaterialPlan(List<String> materialIdList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (String mId : materialIdList) {
            if (this.materialPlanMap.containsKey(mId)) continue;
            idSet.add(mId);
        }
        if (idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialPlanCollection collection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                this.materialPlanMap.put(collection.get(i).getId().toString(), collection.get(i));
            }
        }
        return this.materialPlanMap;
    }

    public Map<String, PurchaseOrgUnitInfo> getDefaultOrgs(ReqParamDataVO paramVo, List<String> materialIdList) throws EASBizException, BOSException {
        ArrayList<String> reqList = new ArrayList<String>();
        for (String materialId : materialIdList) {
            if (this.materialDefaultPurOrgMap.containsKey(materialId)) continue;
            reqList.add(materialId);
        }
        if (reqList.size() > 0) {
            paramVo.setMaterialList(reqList);
            Map retMap = this.getIPurRequest().getDefaultPurOrg(paramVo);
            if (retMap != null) {
                this.materialDefaultPurOrgMap.putAll(retMap);
            }
        }
        return this.materialDefaultPurOrgMap;
    }

    public ISQLDataAccess getSQLDataAccess() throws BOSException {
        return SQLDataAccessFactory.getRemoteInstance();
    }

    public IPurRequest getIPurRequest() throws BOSException {
        return PurRequestFactory.getRemoteInstance();
    }

    public void clearDefaultPurOrgMap() {
        this.materialDefaultPurOrgMap.clear();
    }
}

