/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static Logger logger = Logger.getLogger(SQLUtil.class);
    private static final int MAX_DATA_ROW = 8000;

    public static int[] executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        long startTime = 0L;
        long timeOffset = 0L;
        int[] resultNum = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    ps.setObject(j + 1, params[j]);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = SQLUtil.arraycopy(resultNum, result);
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = SQLUtil.arraycopy(resultNum, result);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)sql, (Throwable)exc);
            throw new BOSException(sql, (Throwable)exc);
        }
        finally {
            logger.debug((Object)("sql : " + sql + " execute time : " + timeOffset));
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        return resultNum;
    }

    public static final int[] arraycopy(int[] resultNum, int[] result) {
        int[] temp = null;
        if (resultNum != null && result != null) {
            temp = new int[result.length + resultNum.length];
            System.arraycopy(resultNum, 0, temp, 0, resultNum.length);
            System.arraycopy(result, 0, temp, resultNum.length, result.length);
        }
        return temp;
    }
}

