/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.common.util.ListMap;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.verify.BatchVerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class SupplyInfoVerifyItem
extends BatchVerifyItem {
    private Date bizDate;

    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public SupplyInfoVerifyItem(Component component) {
        super(component);
    }

    protected boolean doVerify() throws Exception {
        boolean result = true;
        if (this.getCaller() == null) {
            return result;
        }
        OrgUnitInfo mainOrg = this.getCaller().getMainOrgInfo();
        SupplierInfo supplier = (SupplierInfo)this.compareValue;
        boolean isVerifySupplyInfo = false;
        boolean isCheckSupplierQty = false;
        boolean isSuppInfoOnDeliveryDate = false;
        for (int i = 0; i < this.precondition.length; ++i) {
            if (this.precondition[i].getName().equals("isVerifySupplyInfo")) {
                isVerifySupplyInfo = (Boolean)this.precondition[i].invoke((Object)this.getCaller(), null);
                continue;
            }
            if (this.precondition[i].getName().equals("isCheckSupplierQty")) {
                isCheckSupplierQty = (Boolean)this.precondition[i].invoke((Object)this.getCaller(), null);
                continue;
            }
            if (!this.precondition[i].getName().equals("isSuppInfoOnDeliveryDate")) continue;
            isSuppInfoOnDeliveryDate = (Boolean)this.precondition[i].invoke((Object)this.getCaller(), null);
        }
        if (mainOrg != null && supplier != null) {
            FetchSupplyInfoCollection fetchSupplyInfoCollection = ((PurEntryDataVO)this.vo).getFetchSupplyInfoCollection();
            result = isVerifySupplyInfo ? this.doVerifySupplyInfo(fetchSupplyInfoCollection, mainOrg.getId().toString(), supplier.getId().toString()) : true;
            this.isIgnoredByUser = !isCheckSupplierQty;
            return result ? this.doVerifySupplyQty(fetchSupplyInfoCollection, isCheckSupplierQty, mainOrg.getId().toString(), supplier.getId().toString(), isSuppInfoOnDeliveryDate) : false;
        }
        return result;
    }

    private boolean doVerifySupplyQty(FetchSupplyInfoCollection fetchSupplyInfoCollection, boolean isCheckSupplierQty, String orgID, String supplierID, boolean isSuppInfoOnDeliveryDate) throws EASBizException, BOSException {
        boolean result = true;
        String colUnit = (String)this.columns.get("TB_UNIT");
        String colMaterial = (String)this.columns.get("MATERIAL");
        String colQty = (String)this.columns.get("QTY");
        if (this.component instanceof KDTable && colMaterial != null && colUnit != null && colQty != null) {
            KDTable table = (KDTable)this.component;
            ObjectListMap materialsMap = new ObjectListMap(4);
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow arow = table.getRow(i);
                MaterialInfo materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue();
                if (materialInfo == null) continue;
                ApprovedSupplierInfo approveInfo = fetchSupplyInfoCollection.getApprovedSupplierInfoBy(orgID, supplierID, materialInfo.getId().toString());
                SupplyInfoInfo sii = fetchSupplyInfoCollection.getPriceInfoBy(approveInfo, this.getBizDateOrDeliveryDate(approveInfo, i, this.getBizDate(), isSuppInfoOnDeliveryDate));
                MeasureUnitInfo unitInfo = (MeasureUnitInfo)arow.getCell(colUnit).getValue();
                if (sii == null || unitInfo == null || sii.getPurMeasureUnit() == null || unitInfo.getId().toString().equals(sii.getPurMeasureUnit().getId().toString())) continue;
                materialsMap.put2((Object)new Integer(i), new Object[]{materialInfo.getId().toString(), unitInfo.getId().toString(), sii.getPurMeasureUnit().getId().toString()});
            }
            if (materialsMap.size() > 0) {
                BatchFetchDataUtils.fetchUOMRates((ListMap)materialsMap);
            }
            StringBuffer sb1 = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            BigDecimal zero = new BigDecimal("0.0");
            for (int i = 0; i < table.getRowCount(); ++i) {
                BigDecimal rate;
                ApprovedSupplierInfo approveInfo;
                SupplyInfoInfo sii;
                IRow arow = table.getRow(i);
                BigDecimal orderQty = (BigDecimal)arow.getCell(colQty).getValue();
                if (orderQty == null) continue;
                Integer iSeq = new Integer(i);
                MaterialInfo materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue();
                if (materialInfo == null || (sii = fetchSupplyInfoCollection.getPriceInfoBy(approveInfo = fetchSupplyInfoCollection.getApprovedSupplierInfoBy(orgID, supplierID, materialInfo.getId().toString()), this.getBizDateOrDeliveryDate(approveInfo, i, this.getBizDate(), isSuppInfoOnDeliveryDate))) == null || !isCheckSupplierQty) continue;
                BigDecimal minQty = sii.getQtyOrderBottom();
                BigDecimal maxQty = sii.getQtyOrderTop();
                if (materialsMap.containsKey((Object)iSeq) && (rate = (BigDecimal)materialsMap.get((Object)iSeq, 3)) != null) {
                    orderQty = orderQty.multiply(rate);
                }
                if (minQty != null && minQty.compareTo(zero) == 1 && orderQty.compareTo(minQty) == -1) {
                    if (sb1.length() > 0) {
                        sb1.append(", ");
                    }
                    sb1.append(i + 1);
                    continue;
                }
                if (minQty == null || minQty.compareTo(zero) != 1 || orderQty == null || maxQty == null || orderQty.compareTo(maxQty) != 1) continue;
                if (sb2.length() > 0) {
                    sb2.append(", ");
                }
                sb2.append(i + 1);
            }
            this.setIgnoredByUser(!isCheckSupplierQty);
            this.setErrMsg(PurUtil.getUIResource("ORDER_FIELD_ORDERQTYMUSTNOTLESSTHANMINQTY"));
            boolean bl = result = !this.isError(sb1);
            if (result) {
                this.setErrMsg(PurUtil.getUIResource("ORDER_FIELD_ORDERQTYMUSTNOTGREATERTHANMINQTY"));
                result = !this.isError(sb2);
            }
        }
        return result;
    }

    private boolean doVerifySupplyInfo(FetchSupplyInfoCollection fetchSupplyInfoCollection, String orgID, String supplierID) {
        if (this.materialMap.size() != fetchSupplyInfoCollection.size()) {
            Iterator iter = this.materialMap.keySet().iterator();
            StringBuffer sb = new StringBuffer();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (fetchSupplyInfoCollection.isExistsApprovedSupplierInfo(orgID, supplierID, key)) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(this.materialMap.get(key));
            }
            Object[] seqs = sb.toString().split(", ");
            SortUtil.sortArrayByIntValue((Object[])seqs, (boolean)true);
            sb.setLength(0);
            for (int i = 0; i < seqs.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)seqs[i]);
            }
            return !this.isError(sb);
        }
        return true;
    }

    private Date getBizDateOrDeliveryDate(ApprovedSupplierInfo approveInfo, int rowIdx, Date bizDate, boolean isSuppInfoOnDeliveryDate) throws EASBizException, BOSException {
        Date date = bizDate;
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (approveInfo == null) {
            return date;
        }
        if (isSuppInfoOnDeliveryDate) {
            cal.add(5, approveInfo.getLeadtime());
            date = cal.getTime();
        }
        return date;
    }

    public SupplyInfoVerifyItem(Component component, VerifyType verifyType, Object compareValue, String errMsg) {
        super(component, verifyType, compareValue, errMsg);
    }
}

