/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.common.util.ListMap;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import com.kingdee.eas.scm.common.verify.BatchVerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Map;

public class TopPriceVerifyItem
extends BatchVerifyItem {
    public TopPriceVerifyItem(Component component, VerifyType verifyType, Object compareValue, String errMsg) {
        super(component, verifyType, compareValue, errMsg);
    }

    public TopPriceVerifyItem(Component component) {
        super(component);
    }

    protected boolean doVerify() throws Exception {
        PurchaseOrgUnitInfo purchaseOrg = (PurchaseOrgUnitInfo)this.compareValue;
        ObjectListMap entriesMap = new ObjectListMap(6);
        String[] materialIds = this.getMaterialIds((Map)entriesMap);
        if (purchaseOrg != null && materialIds != null) {
            SCMFetchDataCondition condition = new SCMFetchDataCondition();
            condition.setFetchMaterialPurchasing(true);
            condition.setMaterialPKs(materialIds);
            condition.setPou(purchaseOrg);
            PurEntryDataVO outVO = (PurEntryDataVO)this.vo;
            Map map = outVO.getMaterialPurchasingInfos();
            ObjectListMap materialsMap = new ObjectListMap(4);
            BigDecimal zero = new BigDecimal("0.0");
            BigDecimal asbase = new BigDecimal(1.0);
            MaterialPurchasingInfo mpi = null;
            for (int i = 0; i < materialIds.length; ++i) {
                Integer key = new Integer(i + 1);
                mpi = (MaterialPurchasingInfo)map.get(materialIds[i]);
                if (mpi == null || mpi.getUnit() == null || mpi.getPriceTop() == null || mpi.getPriceTop().compareTo(zero) != 1 || entriesMap.get((Object)key, 2) == null) continue;
                entriesMap.set((Object)key, 3, (Object)mpi.getPriceTop());
                if (mpi.getUnit().getId().toString().equals(((MeasureUnitInfo)entriesMap.get((Object)key, 2)).getId().toString())) continue;
                String mapKey = new StringBuffer().append(materialIds[i]).append(((MeasureUnitInfo)entriesMap.get((Object)key, 2)).getId().toString()).append(mpi.getUnit().getId().toString()).toString();
                entriesMap.set((Object)key, 0, (Object)mapKey);
                materialsMap.put((Object)mapKey, (Object)new Object[]{materialIds[i], mpi.getUnit().getId().toString(), ((MeasureUnitInfo)entriesMap.get((Object)key, 2)).getId().toString()});
            }
            if (materialsMap.size() > 0) {
                BatchFetchDataUtils.fetchUOMRates((ListMap)materialsMap);
            }
            StringBuffer sb = new StringBuffer();
            Object[] rownums = entriesMap.keySet().toArray();
            for (int i = 0; i < rownums.length; ++i) {
                if (materialsMap.containsKey(entriesMap.get(rownums[i], 0))) {
                    entriesMap.set(rownums[i], 5, materialsMap.get(entriesMap.get(rownums[i], 0), 3));
                } else {
                    entriesMap.set(rownums[i], 5, (Object)asbase);
                }
                if (entriesMap.get(rownums[i], 3) == null || entriesMap.get(rownums[i], 5) == null || ((BigDecimal)entriesMap.get(rownums[i], 3)).compareTo(((BigDecimal)entriesMap.get(rownums[i], 1)).multiply((BigDecimal)entriesMap.get(rownums[i], 5))) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(rownums[i]);
            }
            return !this.isError(sb);
        }
        return true;
    }

    private String[] getMaterialIds(Map entriesMap) {
        String colIsPresent = (String)this.columns.get("ISPRESENT");
        String colMaterial = (String)this.columns.get("MATERIAL");
        String colUnit = (String)this.columns.get("TB_UNIT");
        String colTaxPrice = (String)this.columns.get("TAXPRICE");
        if (this.component instanceof KDTable && colIsPresent != null && colMaterial != null) {
            KDTable table = (KDTable)this.component;
            String[] values = new String[table.getRowCount()];
            int idx = -1;
            for (int i = 0; i < table.getRowCount(); ++i) {
                MaterialInfo materialInfo;
                IRow arow = table.getRow(i);
                if (((Boolean)arow.getCell(colIsPresent).getValue()).booleanValue() || (materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue()) == null) continue;
                values[++idx] = materialInfo.getId().toString();
                entriesMap.put(new Integer(i + 1), new Object[]{materialInfo.getId().toString(), arow.getCell(colTaxPrice).getValue(), arow.getCell(colUnit).getValue()});
            }
            if (idx > -1) {
                String[] results = new String[idx + 1];
                System.arraycopy(values, 0, results, 0, idx + 1);
                return results;
            }
        }
        return null;
    }
}

