/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.report.PurConsumeAnalysisFacadeFactory;
import com.kingdee.eas.scm.sm.report.client.AbstractPurConsumeAnalysisConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurConsumeAnalysisConditionUI
extends AbstractPurConsumeAnalysisConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(PurConsumeAnalysisConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private SCMRptMultiOrgsF7 f7;

    public PurConsumeAnalysisConditionUI() throws Exception {
        this.setSize(436, 310);
        this.isReport = true;
        this.addCkBxSimpleNameListener();
        this.f7 = new SCMRptMultiOrgsF7(this.prmtstorageOrg, OrgType.Storage, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("StorageOrg", this.f7, this.prmtstorageOrg);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        Date date = SCMClientUtils.getServerDate2();
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"endDate"));
        elements.add((FilterElement)element);
        MultiF7FilterElement materialElement = new MultiF7FilterElement("MaterialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)materialElement);
        element = new SingleFilterElement("MaterialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        CheckRadioFilterElement expendEl = new CheckRadioFilterElement("ckExpendByStorageOrgUnit", (Component)this.ckExpendByStorageOrgUnit);
        expendEl.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)expendEl);
        element = new SingleFilterElement("MaterialGroupFrom", (Component)this.prmtMaterialGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("MaterialGroupTo", (Component)this.prmtMaterialGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.initF7Control();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo, this.prmtMaterialGroupFrom, this.prmtMaterialGroupTo});
        this.prmtstorageOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                PurConsumeAnalysisConditionUI.this.orgsChanged(PurConsumeAnalysisConditionUI.this.f7, PurConsumeAnalysisConditionUI.this.f7Manager);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMQueryFormat.formatStartTime((KDDatePicker)this.datePickerStart);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.datePickerEnd);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtMaterialGroupFrom.setValue(null);
        this.prmtMaterialGroupTo.setValue(null);
        this.ckBxShowMShortName.setSelected(false);
        this.ckExpendByStorageOrgUnit.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
    }

    private void initF7Control() {
        try {
            this.prmtMaterialGroupFrom.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
            this.prmtMaterialGroupFrom.setDisplayFormat("$name$");
            this.prmtMaterialGroupTo.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
            this.prmtMaterialGroupTo.setDisplayFormat("$name$");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrg;
    }

    protected String getViewPermission() {
        String viewPermission = "PurConsumeAnalysisUI_wiew";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean verify() {
        Object[] purchaseOrg;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtstorageOrg.getValue() == null || ((Object[])this.prmtstorageOrg.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtstorageOrg.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtstorageOrg.getValue())[0] == null || purchaseOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        RptParams params = this.getCustomCondition();
        try {
            int result = PurConsumeAnalysisFacadeFactory.getRemoteInstance().check_Currency_unique(params);
            if (result == -2) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIODTYPE_UNIQUE"));
                return false;
            }
            if (result == -1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"Storage_urrency_unique"));
                return false;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PurConsumeAnalysisConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    PurConsumeAnalysisConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }
}

