/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.sm.report.PurConsumeAnalysisFacadeFactory;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.client.AbstractPurConsumeAnalysisUI;
import com.kingdee.eas.scm.sm.report.client.PurConsumeAnalysisConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurConsumeAnalysisUI
extends AbstractPurConsumeAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(PurConsumeAnalysisUI.class);
    private boolean firstLoadData = true;
    private String orgTempTable;
    private boolean hasError = false;
    private String baseCurrencyName;
    private boolean shouldReloadPrintVar = true;

    public PurConsumeAnalysisUI() throws Exception {
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT2");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new BOSObjectType("C12130CE"), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new PurConsumeAnalysisConditionUI();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    public String getTreeCol() {
        return "STORAGEORG_NAME";
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"MATERIAL_NUMBER", "MATERIAL_NAME", "MATERIAL_MODEL", "MATERIALGROUP_NAME"};
        return strMergeColKeys;
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams para = new RptParams();
        para.setString("tempTable", this.getTempTable());
        para.setString("StorageORGTempTable", this.orgTempTable);
        para.setString("baseCurrencyName", this.baseCurrencyName);
        IRow row = this.getTable().getRow(rowIndex);
        para.setString("fparentid", companyUserObject.getCompanyId().toString());
        para.setString("fmaterialid", (String)row.getCell("MATERIAL_FID").getValue());
        para.setBoolean("ckBxShowMShortName", this.params.getBoolean("ckBxShowMShortName"));
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(para, -1, -1, this.getTempTable(), (Object)companyUserObject);
        return result;
    }

    protected void initListener() {
        Object[] listeners = this.getTable().getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            this.getTable().removeKDTMouseListener((KDTMouseListener)listeners[i + 1]);
        }
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3) {
                    KDTMenuManager tm = PurConsumeAnalysisUI.this.getMenuManager(PurConsumeAnalysisUI.this.getTable());
                    if (tm == null) {
                        return;
                    }
                    KDPopupMenu menu = tm.getMenu();
                    if (menu == null) {
                        menu = new KDPopupMenu();
                    }
                    menu.setUserObject((Object)e);
                    if (e.getButton() == 3 && e.getClickCount() == 1) {
                        menu.show(e.getOriginView(), e.getX(), e.getY());
                    }
                } else {
                    int row = e.getRowIndex();
                    int column = e.getColIndex();
                    if (e.getClickCount() == 1) {
                        PurConsumeAnalysisUI.this.cellClicked(row, column, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return PurConsumeAnalysisFacadeFactory.getRemoteInstance();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return PurConsumeAnalysisFacadeFactory.getRemoteInstance();
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.hasError = false;
        try {
            this.tblMain.removeRows();
            if (!this.hasError) {
                super.query();
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        Object[] storageOrg = (Object[])this.params.getObject("StorageOrg");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; storageOrg != null && i < storageOrg.length; ++i) {
            if (i != storageOrg.length - 1) {
                buffer.append((String)((FullOrgUnitInfo)storageOrg[i]).get("name") + ";");
                continue;
            }
            buffer.append((String)((FullOrgUnitInfo)storageOrg[i]).get("name"));
        }
        this.kdtstorageORG.setText(buffer.toString());
        String[] materialFromArray = null;
        String mFNumber = null;
        String mFNumbers = null;
        String matTo = null;
        if (this.params.getObject("MaterialFrom") != null) {
            materialFromArray = SCMUtil.getF7Numbers((Object)this.params.getObject("MaterialFrom"), (Boolean)false, (String)";");
            mFNumber = materialFromArray[0];
            mFNumbers = materialFromArray[1];
        }
        matTo = this.params.getString("MaterialTo") == null ? "" : this.params.getString("MaterialTo");
        if (mFNumbers != null) {
            this.kdtMaterial.setText(mFNumbers);
        } else {
            if (mFNumber == null) {
                mFNumber = "";
            }
            this.kdtMaterial.setText(mFNumber + "-" + matTo);
        }
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bd = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        Date endDate = tempEDCalendar.getTime();
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        String dateStart = format.format(beginDate).toString();
        String dateEnd = format.format(endDate).toString();
        this.kdtDate.setText(dateStart + "-" + dateEnd);
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo().getId();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        Date nowBegin = new Date();
        RptParams para = new RptParams();
        try {
            if (start == 0 && this.firstLoadData) {
                try {
                    para.clear();
                    para.putAll(this.params.toMap());
                    this.tblMain.getMergeManager().setMergeMode(0);
                    para.setString("tempTable", this.getTempTable());
                    para.setString("StorageORGTempTable", this.orgTempTable);
                    this.firstLoadData = false;
                    RptParams rpt = PurConsumeAnalysisFacadeFactory.getRemoteInstance().createTempTable(para);
                    this.setTempTable(rpt.getString("tempTable"));
                    this.orgTempTable = rpt.getString("StorageORGTempTable");
                    this.baseCurrencyName = rpt.getString("baseCurrencyName");
                    para.setString("tempTable", this.getTempTable());
                    para.setString("StorageORGTempTable", this.orgTempTable);
                    para.setString("baseCurrencyName", this.baseCurrencyName);
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                    this.kdtCurrency.setText(this.baseCurrencyName);
                    int freezeCol = this.tblMain.getColumnIndex("STORAGEORG_NAME");
                    this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
                    this.tblMain.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                    rpt = PurConsumeAnalysisFacadeFactory.getRemoteInstance().query(para, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.tblMain.setRowCount(rs.getRowCount());
                    this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                    this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
                catch (SMReportException sme) {
                    logger.error((Object)"the Base Currency is not same");
                    MsgBox.showError((String)sme.getMessage());
                    this.hasError = true;
                    return;
                }
                finally {
                    this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
                    this.initUserConfig();
                }
                return;
            }
            ArrayList newList = new ArrayList(length);
            if (this.allIdList != null) {
                for (int i = start; i < start + length && i < this.allIdList.size(); ++i) {
                    newList.add(this.allIdList.get(i));
                }
            }
            if (newList != null && newList.size() > 0) {
                para.setString("tempTable", this.getTempTable());
                RptParams rpt = PurConsumeAnalysisFacadeFactory.getRemoteInstance().getDataForIdList(newList, para);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
            }
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.abort();
        }
        Date nowEnd = new Date();
        float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
        logger.debug((Object)("getData used of times : " + waitSecond + " second."));
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        boolean isDisplay = true;
        if (this.params.getObject("StorageOrg") != null && ((Object[])this.params.getObject("StorageOrg")).length > 1) {
            isDisplay = false;
        }
        Boolean ckExpendByStorageOrgUnit = this.params.getBoolean("ckExpendByStorageOrgUnit");
        while (rs.next()) {
            IRow row = table.addRow(rowIndex++);
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            companyUserObject.setCompanyId(rs.getString("fstorageorgunitid"));
            companyUserObject.setName(rs.getString("STORAGEORG_NAME"));
            if (ckExpendByStorageOrgUnit.booleanValue()) {
                companyUserObject.setExpanded(true);
                companyUserObject.setHasExpanded(true);
            } else {
                companyUserObject.setExpanded(false);
            }
            companyUserObject.setBlockId(rs.getString("FMaterialID"));
            int isleaf = rs.getInt("storageorg_isleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("storageorg_level"));
            companyUserObject.setisIconEmpty(isDisplay);
            handler.setTableRowData(row, rs.toRowArray());
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        String cur = this.baseCurrencyName;
        StringBuffer sbStorageORG = new StringBuffer();
        sbStorageORG.append(EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"StorageORGConfince"));
        sbStorageORG.append(" : &[StorageORGConfince]");
        sbStorageORG.append("&| &| ");
        header.addRow(sbStorageORG.toString(), sa);
        StringBuffer sbCurrency = new StringBuffer();
        sbCurrency.append(EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"MaterialConfince"));
        sbCurrency.append(" : &[MaterialConfince]");
        sbCurrency.append("&| &|");
        header.addRow(sbCurrency.toString(), sa);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"Date"));
        sb.append(" : &[DateStart]");
        sb.append("-&[DateEnd]");
        sb.append("&|");
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"Currency"));
        sb.append(" : &[baseCurrencyName]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bd = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        Date endDate = tempEDCalendar.getTime();
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        String dateStart = format.format(beginDate).toString();
        String dateEnd = format.format(endDate).toString();
        this.kdtDate.setText(dateStart + "-" + dateEnd);
        map.put("DateStart", dateStart);
        map.put("DateEnd", dateEnd);
        Object[] storageOrg = (Object[])this.params.getObject("StorageOrg");
        String fNumberFrom = ((FullOrgUnitInfo)storageOrg[0]).toString();
        String fNumberTo = ((FullOrgUnitInfo)storageOrg[storageOrg.length - 1]).toString();
        map.put("StorageORGConfince", fNumberFrom + " - " + fNumberTo);
        map.put("baseCurrencyName", this.baseCurrencyName);
        String materialFrom = this.params.getString("MaterialFrom") == null ? " " : this.params.getString("MaterialFrom");
        String materialTo = this.params.getString("MaterialTo") == null ? " " : this.params.getString("MaterialTo");
        map.put("MaterialConfince", materialFrom + " - " + materialTo);
        return map;
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                this.shouldReloadPrintVar = true;
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(523);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setToolButton();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected void setToolButton() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected boolean isAllowOAMenu() {
        return true;
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            PurConsumeAnalysisFacadeFactory.getRemoteInstance().dropTempTable(this.orgTempTable);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionOnLoad".equals(actionName) && this.getOnloadPermItemName() == null) {
            return;
        }
        super.handlePermissionForItemAction(action);
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sm.report.client.PurConsumeAnalysisUI";
    }

    public boolean isAsynchronism() {
        return true;
    }
}

