/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.report.client.AbstractPurMaterialABCQueryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurMaterialABCQueryUI
extends AbstractPurMaterialABCQueryUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(PurMaterialABCQueryUI.class);
    private static SCMRptMultiOrgsF7 f7;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";

    public PurMaterialABCQueryUI() throws Exception {
        this.setSize(436, 300);
        this.addCkBxSimpleNameListener();
        this.aPercent.setPrecision(4);
        this.aPercent.setMaximumValue((Comparable)new Double(1.0));
        this.aPercent.setMinimumValue((Comparable)new Double(0.0));
        this.bPercent.setPrecision(4);
        this.bPercent.setMaximumValue((Comparable)new Double(1.0));
        this.bPercent.setMinimumValue((Comparable)new Double(0.0));
        this.cPercent.setPrecision(4);
        this.cPercent.setMaximumValue((Comparable)new Double(1.0));
        this.cPercent.setMinimumValue((Comparable)new Double(0.0));
        this.isReport = true;
        try {
            SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.storageUnitBegin);
            SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.storageUnitEnd);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        f7 = new SCMRptMultiOrgsF7(this.purChaseUnitBegin, OrgType.Purchase, EASResource.getString((String)resClassName, (String)"purchaseOrgUnitMutilF7"));
        f7.setPermItemName(this.getViewPermission());
        f7.setUseCache(true);
        f7.setNeedWait4UIOpen(false);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Date date = SCMClientUtils.getServerDate2();
        SingleFilterElement element = new SingleFilterElement("dateBegin", (Component)this.timeBegin);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.timeEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"endDate"));
        elements.add((FilterElement)element);
        MultiF7FilterElement elementMaterial = new MultiF7FilterElement("materialNumBegin", this.materialNumBegin, Boolean.valueOf(false));
        elements.add((FilterElement)elementMaterial);
        element = new SingleFilterElement("materialNumEnd", (Component)this.materialNumEnd);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialBaseClassBegin", (Component)this.materialBaseClassBegin);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialBaseClassEnd", (Component)this.materialBaseClassEnd);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        CheckRadioFilterElement e2 = new CheckRadioFilterElement("ckBxIsContainSysBill", (Component)this.ckBxIsContainSysBill);
        e2.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)e2);
        element = new SingleFilterElement("storageUnitBegin", (Component)this.storageUnitBegin);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("storageUnitEnd", (Component)this.storageUnitEnd);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullOrgUnit", f7, this.purChaseUnitBegin);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"PURORGNOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.combStatus.removeAllItems();
        this.combStatus.addItems(new Object[]{BillBaseStatusEnum.NULL, BillBaseStatusEnum.TEMPORARILYSAVED, BillBaseStatusEnum.SUBMITED, BillBaseStatusEnum.AUDITED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.DELETED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.ALTERING});
        element = new SingleFilterElement("combStatus", (Component)this.combStatus);
        element.setDefaultValue((Object)BillBaseStatusEnum.NULL);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("aPercent", (Component)this.aPercent);
        element.setDefaultValue((Object)new Double(0.7));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("bPercent", (Component)this.bPercent);
        element.setDefaultValue((Object)new Double(0.2));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("cPercent", (Component)this.cPercent);
        element.setDefaultValue((Object)new Double(0.1));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setBizMaterialF7(this.materialNumBegin, true, null);
        this.setBizMaterialF7(this.materialNumEnd, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.materialNumBegin, (KDBizPromptBox)this.materialNumEnd);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.storageUnitBegin, this.storageUnitEnd, this.materialNumBegin, this.materialNumEnd});
        this.storageUnitBegin.setCommitFormat("$number$");
        this.storageUnitEnd.setCommitFormat("$number$");
        this.materialNumBegin.setCommitFormat("$number$");
        this.materialNumEnd.setCommitFormat("$number$");
        this.materialBaseClassBegin.setCommitFormat("$number$");
        this.materialBaseClassEnd.setCommitFormat("$number$");
        this.purChaseUnitBegin.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                PurMaterialABCQueryUI.this.orgsChanged(f7, PurMaterialABCQueryUI.this.f7Manager);
            }
        });
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.purChaseUnitBegin;
    }

    protected String getViewPermission() {
        String viewPermission = "materialABC_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        this.storageUnitEnd.setData(null);
        this.storageUnitBegin.setData(null);
        this.materialNumBegin.setData(null);
        this.materialNumEnd.setData(null);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public boolean verify() {
        Object[] purchaseOrg;
        if (this.purChaseUnitBegin.getValue() == null || ((Object[])this.purChaseUnitBegin.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"purChaseOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.purChaseUnitBegin.getValue()).length == 1 && ((purchaseOrg = (Object[])this.purChaseUnitBegin.getValue())[0] == null || purchaseOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"purChaseOrgUnitNotNull"));
            return false;
        }
        Timestamp dateBegin = SCMUtils.getDayStartTime((Date)((Date)this.timeBegin.getValue()));
        Timestamp dateEnd = SCMUtils.getDayEndTime((Date)((Date)this.timeEnd.getValue()));
        if (dateBegin == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.timeBegin.requestFocus();
            return false;
        }
        if (dateEnd == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.timeEnd.requestFocus();
            return false;
        }
        if (((Date)dateEnd).getTime() < ((Date)dateBegin).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.timeEnd.requestFocus();
            return false;
        }
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        if (this.aPercent.getText().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"APercent_Not_Null"));
            this.aPercent.requestFocus();
            return false;
        }
        a = this.aPercent.getNumberValue().doubleValue();
        if (this.bPercent.getText().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"BPercent_Not_Null"));
            this.bPercent.requestFocus();
            return false;
        }
        b = this.bPercent.getNumberValue().doubleValue();
        if (this.cPercent.getText().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"CPercent_Not_Null"));
            this.cPercent.requestFocus();
            return false;
        }
        c = this.cPercent.getNumberValue().doubleValue();
        double sumPercent = (double)Math.round((a + b + c) * 1000.0) / 1000.0;
        if (!new Double(sumPercent).equals(new Double(1.0))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"NOT_EQUAL_TO_ONE"));
            this.aPercent.requestFocus();
            return false;
        }
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PurMaterialABCQueryUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    PurMaterialABCQueryUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }
}

