/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.report.client.AbstractPurPriceWMRptConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurPriceWMRptConditionUI
extends AbstractPurPriceWMRptConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(PurPriceWMRptConditionUI.class);
    private Object[] fullPurchaseOrgUnit;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private static SCMRptMultiOrgsF7 f7;

    public PurPriceWMRptConditionUI() throws Exception {
        this.setSize(436, 310);
        this.addCkBxSimpleNameListener();
        this.isReport = true;
        f7 = new SCMRptMultiOrgsF7(this.prmtPurchaseOrgUnit, OrgType.Purchase, EASResource.getString((String)resClassName, (String)"purchaseOrgUnitMutilF7"));
        f7.setPermItemName(this.getViewPermission());
        f7.setUseCache(true);
        f7.setNeedWait4UIOpen(false);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.initF7Control();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullPurchaseOrgUnit", f7, this.prmtPurchaseOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"PURORGNOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        Date date = SCMClientUtils.getServerDate2();
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"endDate"));
        elements.add((FilterElement)element);
        MultiF7FilterElement materialElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)materialElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        el = new CheckRadioFilterElement("ckBIsTax", (Component)this.ckBIsTax);
        elements.add((FilterElement)el);
        element = new SingleFilterElement("MaterialGroupFrom", (Component)this.prmtMaterialGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("MaterialGroupTo", (Component)this.prmtMaterialGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("Currency", (Component)this.prmtCurrency);
        element.setCompareType(CompareType.EQUALS);
        CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        element.setDefaultValue((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId())));
        elements.add((FilterElement)element);
        CheckRadioFilterElement chrElement = new CheckRadioFilterElement("Type", (Component)this.kdrMonth);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        chrElement = new CheckRadioFilterElement("Type", (Component)this.kdrWeek);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        chrElement = new CheckRadioFilterElement("Type1", (Component)this.kdrPeriod);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo, this.prmtMaterialGroupFrom, this.prmtMaterialGroupTo, this.prmtCurrency});
        this.prmtPurchaseOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                PurPriceWMRptConditionUI.this.orgsChanged(f7, PurPriceWMRptConditionUI.this.f7Manager);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMQueryFormat.formatStartTime((KDDatePicker)this.datePickerStart);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.datePickerEnd);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtMaterialGroupFrom.setValue(null);
        this.prmtMaterialGroupTo.setValue(null);
        CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        try {
            this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId())));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.ckBxShowMShortName.setSelected(false);
        this.ckBIsTax.setSelected(true);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
    }

    private void initF7Control() {
        try {
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1), CompareType.EQUALS));
            view.setFilter(filterInfo);
            this.prmtMaterialGroupFrom.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
            this.prmtMaterialGroupFrom.setDisplayFormat("$name$");
            this.prmtMaterialGroupFrom.setEntityViewInfo(view);
            this.prmtMaterialGroupTo.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
            this.prmtMaterialGroupTo.setDisplayFormat("$name$");
            this.prmtMaterialGroupTo.setEntityViewInfo(view);
            this.prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
            this.prmtCurrency.setDisplayFormat("$name$");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtPurchaseOrgUnit;
    }

    protected String getViewPermission() {
        String viewPermission = "purpriceWMRpt_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public boolean verify() {
        Object[] purchaseOrg;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFrom);
        calendar.add(1, 2);
        Date compareDate = calendar.getTime();
        if (compareDate.getTime() < ((Date)dateTo).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"Error_Query_TWO_Years"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtPurchaseOrgUnit.getValue() == null || ((Object[])this.prmtPurchaseOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"purChaseOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtPurchaseOrgUnit.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtPurchaseOrgUnit.getValue())[0] == null || purchaseOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"purChaseOrgUnitNotNull"));
            return false;
        }
        if (this.prmtPurchaseOrgUnit.getValue() != null && ((Object[])this.prmtPurchaseOrgUnit.getValue()).length > 1 && this.kdrPeriod.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"ExistMultiPurchaseUnitOrg"));
            return false;
        }
        if (this.kdrPeriod.isSelected()) {
            FullOrgUnitInfo purOrg = (FullOrgUnitInfo)((Object[])this.prmtPurchaseOrgUnit.getValue())[0];
            try {
                IOrgUnitRelation iorg = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection cols = iorg.getToUnit(purOrg.getId().toString(), 3, 1);
                if (null == cols || cols.size() == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"TO_COMPANY_NULL"));
                    return false;
                }
            }
            catch (BOSException bOSException) {
            }
            catch (EASBizException eASBizException) {
                // empty catch block
            }
        }
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PurPriceWMRptConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    PurPriceWMRptConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }
}

