/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ABCArithmetic;
import com.kingdee.eas.scm.sm.report.PurSupplierABCFacadeFactory;
import com.kingdee.eas.scm.sm.report.client.AbstractPurSupplierABCUI;
import com.kingdee.eas.scm.sm.report.client.PurSupplierABCQueryPanel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurSupplierABCUI
extends AbstractPurSupplierABCUI {
    private static final Logger logger = CoreUIObject.getLogger(PurSupplierABCUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private ABCArithmetic abc = null;
    private boolean shouldReloadPrintVar = true;
    public BigDecimal orderAmount = new BigDecimal("0.00");
    private BigDecimal ZERO = new BigDecimal("0.00");

    public PurSupplierABCUI() throws Exception {
        this.tblSupplier.checkParsed();
        this.tblSupplier.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblSupplier.getStyleAttributes().setLocked(true);
        this.enableExportExcel(this.tblSupplier);
        this.tblSupplier.getDataRequestManager().setExportMemoryCallback(false);
        this.abc = new ABCArithmetic("FABC", "FPercentSupplier");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT5");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)resClassName, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new BOSObjectType("51BDF04C"), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        initParam.setString("init_title", "AA");
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new PurSupplierABCQueryPanel();
    }

    protected void query() {
        this.tblSupplier.removeColumns();
        this.abc.setPercent(Double.valueOf(this.params.getString("aPercent")).doubleValue(), Double.valueOf(this.params.getString("bPercent")).doubleValue());
        this.abc.reset();
        this.tblSupplier.removeRows();
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        SimpleDateFormat dateFomat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String date = this.params.getString("dateBegin").substring(0, 10);
            this.txtDateBegin.setStringValue(format.format(dateFomat.parse(date)));
            date = this.params.getString("dateEnd").substring(0, 10);
            this.txtDateEnd.setStringValue(format.format(dateFomat.parse(date)));
        }
        catch (ParseException e) {
            this.handleException(e);
        }
        this.txtDateBegin.setEnabled(false);
        this.txtDateEnd.setEnabled(false);
        DecimalFormat numberFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        numberFormat.applyPattern("#,##0.0000");
        this.txtPercentForA.setText(numberFormat.format(Double.valueOf(this.params.getString("aPercent"))));
        this.txtPercentForB.setText(numberFormat.format(Double.valueOf(this.params.getString("bPercent"))));
        this.txtPercentForC.setText(numberFormat.format(Double.valueOf(this.params.getString("cPercent"))));
        this.txtPercentForA.setEnabled(false);
        this.txtPercentForB.setEnabled(false);
        this.txtPercentForC.setEnabled(false);
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        decimalFormat.applyPattern("#,##0.00");
        this.totalOrderAmount.setText(decimalFormat.format(this.orderAmount));
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo().getId();
        }
        return object;
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tblSupplier.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            if (from == 0) {
                int precision;
                pp.clear();
                pp.setObject("dateBegin", (Object)this.params.getString("dateBegin"));
                pp.setObject("dateEnd", (Object)this.params.getString("dateEnd"));
                if (this.params.getObject("prmtSupplierBegin") != null) {
                    pp.setObject("prmtSupplierBegin", this.params.getObject("prmtSupplierBegin"));
                }
                if (this.params.getString("prmtSupplierEnd") != null) {
                    pp.setString("prmtSupplierEnd", this.params.getString("prmtSupplierEnd"));
                }
                if (this.params.getString("prmtSupplierGroupBegin") != null) {
                    pp.setString("prmtSupplierGroupBegin", this.params.getString("prmtSupplierGroupBegin"));
                }
                if (this.params.getString("prmtSupplierGroupEnd") != null) {
                    pp.setString("prmtSupplierGroupEnd", this.params.getString("prmtSupplierGroupEnd"));
                }
                pp.setObject("fullOrgUnit", this.params.getObject("fullOrgUnit"));
                if (this.params.getString("prmtCompanyOrgBegin") != null) {
                    pp.setString("prmtCompanyOrgBegin", this.params.getString("prmtCompanyOrgBegin"));
                }
                if (this.params.getString("prmtCompanyOrgEnd") != null) {
                    pp.setString("prmtCompanyOrgEnd", this.params.getString("prmtCompanyOrgEnd"));
                }
                pp.setString("aPercent", this.params.getString("aPercent"));
                pp.setString("bPercent", this.params.getString("bPercent"));
                pp.setString("cPercent", this.params.getString("cPercent"));
                pp.setString("combStatus", this.params.getString("combStatus"));
                pp.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
                if (ficompanyOrgInfo != null && ficompanyOrgInfo.getBaseCurrency() != null) {
                    CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
                    precision = baseCurrInfo.getPrecision();
                } else {
                    precision = 2;
                }
                pp.setString("currPrecision", "" + precision);
                RptParams rpt = PurSupplierABCFacadeFactory.getRemoteInstance().createTempTable(pp);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblSupplier);
                if (this.tblSupplier.getRowCount() < 100) {
                    this.tblSupplier.setRowCount(from + this.tblSupplier.getRowCount());
                } else {
                    int forNextFetchCount = 100;
                    this.tblSupplier.setRowCount(from + len + forNextFetchCount);
                }
                RptParams pp2 = new RptParams();
                pp2.setString("tempTable", this.getTempTable());
                RptParams rpt2 = PurSupplierABCFacadeFactory.getRemoteInstance().query(pp2, from, len);
                this.orderAmount = rpt2.getObject("FTotalOrderAmount") != null ? (BigDecimal)rpt2.getObject("FTotalOrderAmount") : this.ZERO;
            }
            pp.setString("tempTable", this.getTempTable());
            RptParams rpt = PurSupplierABCFacadeFactory.getRemoteInstance().query(pp, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.abc.Calculate(rs);
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblSupplier, (KDTableInsertHandler)new KDTableInsertHandler(){

                public void setTableRowData(IRow row, Object[] rowData) {
                    int n = rowData.length;
                    for (int i = 0; i < n; ++i) {
                        row.getCell(i).setValue(rowData[i]);
                    }
                    row.getCell("FPercentSupplier").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)4, (boolean)true));
                }
            });
            DecimalFormat numberFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
            numberFormat.applyPattern("#,##0.00");
            this.totalOrderAmount.setText(numberFormat.format(this.orderAmount));
            this.tblSupplier.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
            if (from == 0) {
                this.initUserConfig();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)resClassName, (String)"Period"));
        sb.append(" : &[DateBegin]");
        sb.append(" - &[DateEnd]");
        sb.append("&|");
        sb.append(EASResource.getString((String)resClassName, (String)"A_percent"));
        sb.append(" : &[aPercent] ");
        sb.append(EASResource.getString((String)resClassName, (String)"B_percent"));
        sb.append(" : &[bPercent] ");
        sb.append(EASResource.getString((String)resClassName, (String)"C_percent"));
        sb.append(" : &[cPercent]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String dateStart = this.params.getString("dateBegin");
        map.put("DateBegin", dateStart);
        String dateEnd = this.params.getString("dateEnd");
        map.put("DateEnd", dateEnd);
        String percentA = this.params.getString("aPercent");
        map.put("aPercent", percentA);
        String percentB = this.params.getString("bPercent");
        map.put("bPercent", percentB);
        String percentC = this.params.getString("cPercent");
        map.put("cPercent", percentC);
        return map;
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                this.shouldReloadPrintVar = true;
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(560);
            this.queryDialog.setHeight(315);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblSupplier;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return CommRptBaseFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionOnLoad".equals(actionName) && this.getOnloadPermItemName() == null) {
            return;
        }
        super.handlePermissionForItemAction(action);
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sm.report.client.PurSupplierABCUI";
    }

    public boolean isAsynchronism() {
        return true;
    }
}

