/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.biz.util.AtsServerBizUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsHolidayFileBaseBiz {
    private static Logger logger = Logger.getLogger(AtsHolidayFileBaseBiz.class);

    public static AtsHolidayFileInfo addHolidayFileAndHisInfo(Context ctx, PersonBURelationInfo personBURelationInfo, Map<String, Object> paraMap) throws BOSException, EASBizException {
        AtsHolidayFileCollection holidayColl;
        PersonBURelationInfo relationInfo = personBURelationInfo;
        Map defaultHolidayPolicySetMap = (Map)paraMap.get("allDefaultHolidayPolicySetInfos");
        AtsHolidayFileInfo info = AtsHolidayFileBaseBiz.parseJsonToFileInfo(ctx, relationInfo, defaultHolidayPolicySetMap);
        if (info == null) {
            return null;
        }
        AbstractAtsHolidayFileInfo originInfo = null;
        String personid = info.getProposer().getId().toString();
        if (StringUtils.isNotBlank((String)personid) && (holidayColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id ='" + personid + "' ")) != null && holidayColl.size() > 0) {
            originInfo = holidayColl.get(0);
            info.setIsDefaultManage(originInfo.isIsDefaultManage());
        }
        boolean isGenerateHis = false;
        boolean isSaveFileInfo = false;
        boolean isUpdateFileInfo = false;
        if (originInfo == null) {
            info.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
            info.setIsDefaultManage(true);
            isGenerateHis = true;
            isSaveFileInfo = true;
        } else {
            String editHolidayPolicySetId = info.getHolidayPolicySet().getId().toString();
            String orginHolidayPolicySetId = originInfo.getHolidayPolicySet().getId().toString();
            String editHrOrgUnitId = info.getHrOrgUnit().getId().toString();
            String originHrOrgUnitId = originInfo.getHrOrgUnit().getId().toString();
            if (!(editHolidayPolicySetId.equals(orginHolidayPolicySetId) && editHrOrgUnitId.equals(originHrOrgUnitId) || originInfo.getAttendFileState().getValue() != "1" || info.getEFFDT().getTime() == originInfo.getEFFDT().getTime())) {
                info.setId(BOSUuid.read((String)originInfo.getId().toString()));
                info.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
                isGenerateHis = true;
                isUpdateFileInfo = true;
            }
            if (!editHrOrgUnitId.equals(originHrOrgUnitId) && AtsLeaveBillUtil.validLeaveBillBeforeBUTransfer(ctx, info.getEFFDT(), info.getProposer().getId().toString())) {
                logger.error((Object)("AtsHolidayFileBaseBiz method\uff1a " + info.getProposer().getName() + " please process the leave bill which cross holiday hrOrgUnit befor holidayfile transfer<br>"));
                return info;
            }
        }
        if (isSaveFileInfo) {
            AtsHolidayFileFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            AtsServerBizUtil.updateHolidayFileHis(ctx, info);
        }
        if (isUpdateFileInfo) {
            String orginFileID = originInfo.getId().toString();
            AtsHolidayFileFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(orginFileID), info);
            AtsServerBizUtil.updateHolidayFileHis(ctx, info);
        }
        if (isGenerateHis && originInfo != null) {
            Date effdtHis = originInfo.getEFFDT();
            AtsServerBizUtil.generateHis(ctx, (AtsHolidayFileInfo)originInfo, effdtHis, info.getEFFDT());
        }
        return info;
    }

    public static AtsHolidayFileInfo parseJsonToFileInfo(Context ctx, PersonBURelationInfo relationInfo, Map<String, HolidayPolicySetInfo> allDefaultholidayPolicySet) throws EASBizException, BOSException {
        String personId = relationInfo.getPerson().getId().toString();
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        String personName = personInfo.getNumber();
        String hrOrgUnitId = relationInfo.getHrOrgUnit().getId().toString();
        String empposrelationId = relationInfo.getEmpOrgRelation().getId().toString();
        EmpPosOrgRelationInfo empRelationInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(empposrelationId));
        String adminOrgUnitId = empRelationInfo.getAdminOrg().getId().toString();
        String policySetKey = hrOrgUnitId + "_" + adminOrgUnitId;
        HolidayPolicySetInfo policySetInfo = AtsServerBizUtil.getDefaultHolidayPolicy(ctx, personId);
        if (policySetInfo == null) {
            logger.error((Object)("analyze file error,holiday policy is null ,the person is \uff1a " + personName));
            return null;
        }
        String positionId = empRelationInfo.getPosition().getId().toString();
        AtsHolidayFileInfo atsHolidayFileInfo = new AtsHolidayFileInfo();
        atsHolidayFileInfo.setAttendFileState(AttendFileStateEnum.enable);
        atsHolidayFileInfo.setEFFDT(relationInfo.getEFFDT());
        PersonInfo person = new PersonInfo();
        person.setName(personName);
        person.setId(BOSUuid.read((String)personId));
        atsHolidayFileInfo.setProposer(person);
        HROrgUnitInfo hrOrgUnit = new HROrgUnitInfo();
        hrOrgUnit.setId(BOSUuid.read((String)hrOrgUnitId));
        atsHolidayFileInfo.setHrOrgUnit(hrOrgUnit);
        atsHolidayFileInfo.setHolidayPolicySet(policySetInfo);
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)adminOrgUnitId));
        atsHolidayFileInfo.setAdminOrgUnit(adminInfo);
        PositionInfo position = new PositionInfo();
        position.setId(BOSUuid.read((String)positionId));
        atsHolidayFileInfo.setPosition(position);
        return atsHolidayFileInfo;
    }
}

