/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsSumDataLogFactory;
import com.kingdee.eas.hr.ats.AtsSumDataLogInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.DataLogBaseInfo;
import com.kingdee.eas.hr.ats.dataLog.observer.LogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsSumDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.pool.AtsDataLogPool;
import com.kingdee.eas.hr.ats.dataLog.service.DataLogService;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumDataLogServiceImpl
implements DataLogService {
    private static Logger logger = Logger.getLogger(AtsSumDataLogServiceImpl.class);

    @Override
    public void recordLog(final LogObserver observer) {
        Runnable logTask = new Runnable(){

            @Override
            public void run() {
                AtsSumDataLogServiceImpl.this.saveDataLog(observer);
            }
        };
        AtsDataLogPool.getPool().execute(logTask);
    }

    @Override
    public boolean saveDataLog(LogObserver observer) {
        try {
            DataLogBaseInfo dataLogInfo = this.assembleDataLog(observer);
            if (null != dataLogInfo) {
                AtsSumDataLogFactory.getLocalInstance(observer.getCtx()).addnew(dataLogInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("save dataLogInfo error, observer objectId:" + observer.getObjectId() + ",error message:" + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public DataLogBaseInfo assembleDataLog(LogObserver observer) {
        if (null == observer.getCtx() || null == observer) {
            return null;
        }
        AtsSumDataLogObserver logObserver = (AtsSumDataLogObserver)observer;
        AtsSumDataLogInfo dataLog = new AtsSumDataLogInfo();
        try {
            dataLog.setObjectId(logObserver.getObjectId());
            if (StringUtils.isNotEmpty((String)logObserver.getPersonId())) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)logObserver.getPersonId()));
                dataLog.setPerson(person);
            }
            if (StringUtils.isNotEmpty((String)logObserver.getAttendancePeriodId())) {
                AttendancePeriodInfo attendancePeriod = new AttendancePeriodInfo();
                attendancePeriod.setId(BOSUuid.read((String)logObserver.getAttendancePeriodId()));
                dataLog.setAttendancePeriod(attendancePeriod);
            }
            dataLog.setPeriodName(logObserver.getPeriodName());
            dataLog.setOperType(logObserver.getOperType());
            dataLog.setOperAction(logObserver.getOperAction());
            dataLog.setObjectOldDesc(logObserver.getObjectOldDesc());
            dataLog.setObjectDesc(logObserver.getObjectDesc());
            dataLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
            String creatorId = HRFilterUtils.getCurrentUserId((Context)observer.getCtx());
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)creatorId));
            dataLog.setCreator(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataLog;
    }

    @Override
    public boolean deleteDataLogDateAgo(Context ctx, Date date) {
        return DataLogUtil.deleteDataLogDateAgo(ctx, date, "T_HR_ATS_SUMDATALOG");
    }
}

