/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttCalTimeConsumeLogInfo;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.DataAutoSaver;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsCostTimeRelUtils {
    private static Logger logger = Logger.getLogger(AtsCostTimeRelUtils.class);
    private static final String WHATHEROPENCOSTLOGRECORD = "whatherOpenCostLogRecord";

    public static boolean whatherOpenCostLogRecordByFile() {
        String logRecordType = ConfigAts.getPropertyFromConfig(WHATHEROPENCOSTLOGRECORD);
        return StringUtils.isNotEmpty((CharSequence)logRecordType) && "true".equalsIgnoreCase(logRecordType);
    }

    public static void initDataAutoSaver(Context ctx, Map<Object, Object> globalMap) {
        if (null == globalMap.get(WHATHEROPENCOSTLOGRECORD)) {
            boolean whatherOpenCostLogRecord = AtsCostTimeRelUtils.whatherOpenCostLogRecordByFile();
            globalMap.put(WHATHEROPENCOSTLOGRECORD, whatherOpenCostLogRecord);
            if (whatherOpenCostLogRecord) {
                DataAutoSaver dataAutoSaver = new DataAutoSaver(ctx);
                globalMap.put("dataAutoSaverInfo", dataAutoSaver);
            }
        }
    }

    public static void initBaseTime2CostTimeLog(Map<Object, Object> globalMap, long startTime, long endTime) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecord(globalMap)) {
            return;
        }
        if (null == globalMap.get("initBaseTime")) {
            globalMap.put("initBaseTime", endTime - startTime);
        }
    }

    public static void creatAndInitCostLogInfo(Map<Object, Object> globalMap, Context ctx, long startTime, long endTime) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecord(globalMap)) {
            return;
        }
        AtsAttCalTimeConsumeLogInfo atsAttCalTimeConsumeLogInfo = new AtsAttCalTimeConsumeLogInfo();
        atsAttCalTimeConsumeLogInfo.setInitDynamicTime(endTime - startTime);
        long INITBASETIME = null == globalMap.get("initBaseTime") ? 0L : (Long)globalMap.get("initBaseTime");
        atsAttCalTimeConsumeLogInfo.setInitBaseTime(INITBASETIME);
        String jobId = (String)ctx.get((Object)"jobInstId");
        if (StringUtils.isEmpty((CharSequence)jobId)) {
            jobId = Thread.currentThread().getName();
        }
        atsAttCalTimeConsumeLogInfo.setJobid(jobId);
        globalMap.put("T_ATS_AtsAttCalTimeConsumeLog", atsAttCalTimeConsumeLogInfo);
    }

    public static void setCostTime(Map<Object, Object> globalMap, String propertyName, long startTime, long endTime) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecord(globalMap)) {
            return;
        }
        AtsAttCalTimeConsumeLogInfo atsAttCalTimeConsumeLogInfo = (AtsAttCalTimeConsumeLogInfo)globalMap.get("T_ATS_AtsAttCalTimeConsumeLog");
        if (null == atsAttCalTimeConsumeLogInfo) {
            return;
        }
        long beforeVal = atsAttCalTimeConsumeLogInfo.getLong(propertyName);
        atsAttCalTimeConsumeLogInfo.setLong(propertyName, beforeVal + (endTime - startTime));
    }

    public static void setCostTimeByAttProject(Map<Object, Object> globalMap, int attProjectType, int attProjectIndex, long startTime, long endTime) {
        String propertyName = AtsCostTimeRelUtils.requirePropertyNameByAttProject(globalMap, attProjectType, attProjectIndex);
        AtsCostTimeRelUtils.setCostTime(globalMap, propertyName, startTime, endTime);
    }

    public static void addLog(Map<Object, Object> globalMap) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecord(globalMap)) {
            return;
        }
        AtsAttCalTimeConsumeLogInfo atsAttCalTimeConsumeLogInfo = (AtsAttCalTimeConsumeLogInfo)globalMap.get("T_ATS_AtsAttCalTimeConsumeLog");
        if (null == atsAttCalTimeConsumeLogInfo) {
            return;
        }
        DataAutoSaver dataAutoSaver = (DataAutoSaver)globalMap.get("dataAutoSaverInfo");
        if (null == dataAutoSaver) {
            return;
        }
        dataAutoSaver.add((CoreBaseInfo)atsAttCalTimeConsumeLogInfo);
    }

    public static void completeDataAutoSaver(Map<Object, Object> globalMap) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecord(globalMap)) {
            return;
        }
        DataAutoSaver dataAutoSaver = (DataAutoSaver)globalMap.get("dataAutoSaverInfo");
        if (null == dataAutoSaver) {
            return;
        }
        try {
            dataAutoSaver.complete();
        }
        catch (BOSException e) {
            logger.error((Object)MessageFormat.format(" completeDataAutoSaver BOSException : {0} ", e.getMessage()));
        }
    }

    public static boolean whatherOpenCostLogRecord(Map<Object, Object> globalMap) {
        Boolean whatherOpenCostLogRecord = (Boolean)globalMap.get(WHATHEROPENCOSTLOGRECORD);
        return null != whatherOpenCostLogRecord && whatherOpenCostLogRecord != false;
    }

    public static boolean delCostTimeLog(Context ctx, Date date) {
        if (!AtsCostTimeRelUtils.whatherOpenCostLogRecordByFile()) {
            return false;
        }
        if (null == date) {
            return false;
        }
        try {
            DbUtil.execute((Context)ctx, (String)"DELETE FROM T_ATS_AtsAttCalTimeConsumeLog where FCreateTime < ? ", (Object[])new Object[]{new Timestamp(date.getTime())});
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(" delCostTimeLog Exception : {0} ", e.getMessage()));
            return false;
        }
        return true;
    }

    private static String requirePropertyNameByAttProject(Map<Object, Object> globalMap, int attProjectType, int attProjectIndex) {
        String caculateType = (String)globalMap.get("caculateType");
        if (StringUtils.isEmpty((CharSequence)caculateType)) {
            if (attProjectType == 5) {
                switch (attProjectIndex) {
                    case 0: {
                        return "leaveCostTime";
                    }
                    case 1: {
                        return "otCostTime";
                    }
                    case 2: {
                        return "tripCostTime";
                    }
                    case 3: {
                        return "excepCostTime";
                    }
                }
                return "otherCostTime";
            }
            switch (attProjectIndex) {
                case 0: {
                    return "leaveCostTime";
                }
                case 1: {
                    return "otCostTime";
                }
                case 2: {
                    return "tripCostTime";
                }
            }
            return "otherCostTime";
        }
        if (attProjectType == 6) {
            switch (attProjectIndex) {
                case 0: {
                    return "leaveCostTime";
                }
                case 1: {
                    return "otCostTime";
                }
                case 2: {
                    return "tripCostTime";
                }
                case 3: {
                    return "supBillCostTime";
                }
                case 4: {
                    return "excepCostTime";
                }
            }
            return "otherCostTime";
        }
        switch (attProjectIndex) {
            case 0: {
                return "leaveCostTime";
            }
            case 1: {
                return "otCostTime";
            }
            case 2: {
                return "tripCostTime";
            }
            case 3: {
                return "supBillCostTime";
            }
        }
        return "otherCostTime";
    }
}

