/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.entryhelper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AttendanceFileHelper {
    public AttendanceFileInfo setAttendanceFileValue(PersonPositionInfo ppInfo, AtsShiftInfo atsShiftInfo, AttencePolicyInfo attencePolicyInfo, HolidayPolicySetInfo holidayPolicySetInfo) {
        AttendanceFileInfo info = new AttendanceFileInfo();
        info.setAttendanceNum(ppInfo.getPerson() != null ? ppInfo.getPerson().getNumber() : null);
        info.setIsAttendance(IsAttendanceEnum.yes);
        if (atsShiftInfo == null || attencePolicyInfo == null || holidayPolicySetInfo == null) {
            info.setAttendFileState(AttendFileStateEnum.disable);
        } else {
            info.setAttendFileState(AttendFileStateEnum.enable);
        }
        info.setFileType(1);
        if (ppInfo != null) {
            info.setProposer(ppInfo.getPerson());
            info.setAdminOrgUnit(ppInfo.getPersonDep());
            info.setPosition(ppInfo.getPrimaryPosition());
            info.setHrOrgUnit(ppInfo.getHrOrgUnit());
        }
        info.setAtsShift(atsShiftInfo);
        info.setAttencePolicy(attencePolicyInfo);
        info.setHolidayPolicySet(holidayPolicySetInfo);
        return info;
    }

    public static ArrayList<Map<String, String>> duplicatedAtsNum(Context ctx, String atsNum, String personId, Date effdt, Date leffdt) {
        ArrayList<Map<String, String>> duplicatedAtsNum = new ArrayList<Map<String, String>>();
        IRowSet rowset = AttendanceFileHelper.duplicatedAtsNumRowset(ctx, atsNum, personId, effdt, leffdt);
        try {
            if (rowset != null && rowset.size() > 0) {
                while (rowset.next()) {
                    HashMap<String, String> rowMap = new HashMap<String, String>();
                    String pid = rowset.getString("personId");
                    String pNum = rowset.getString("personNum");
                    String name = rowset.getString("name");
                    String effdtStr = rowset.getString("effdt");
                    String leffdtStr = rowset.getString("leffdt");
                    rowMap.put("personId", pid);
                    rowMap.put("personNum", pNum);
                    rowMap.put("name", name);
                    rowMap.put("atsNum", atsNum);
                    rowMap.put("effdt", effdtStr.substring(0, 10));
                    rowMap.put("leffdt", leffdtStr.substring(0, 10));
                    duplicatedAtsNum.add(rowMap);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return duplicatedAtsNum;
    }

    public static IRowSet duplicatedAtsNumRowset(Context ctx, String atsNum, String personId, Date effdt, Date leffdt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String effdtStr = sdf.format(effdt);
        String leffdtStr = sdf.format(leffdt);
        StringBuffer sb = new StringBuffer().append(" SELECT  fileHisOther.FProposerID as personId, others.FNumber as personNum,  others.FName" + MLUtile.getMlFlag(ctx) + " as name, fileHisOther.FEffdt as effdt, fileHisOther.FLeffdt as leffdt ").append(" FROM T_HR_Ats_AttendanceFileHis fileHisOther ").append(" LEFT OUTER JOIN T_BD_PERSON others ON others.FID = fileHisOther.FProposerID ").append(" WHERE  fileHisOther.FAttendanceNum = '" + atsNum + "' and fileHisOther.FProposerID <> '" + personId + "' ").append(" AND ((fileHisOther.FEffdt >= {ts '" + effdtStr + "'} AND fileHisOther.FEffdt <= {ts '" + leffdtStr + "'}) ").append(" \t\tOR (fileHisOther.FLeffdt <= {ts '" + leffdtStr + "'} AND fileHisOther.FLeffdt >= {ts '" + effdtStr + "'}) ").append(" \t\tOR (fileHisOther.FEffdt < {ts '" + effdtStr + "'} AND fileHisOther.FLeffdt >={ts '" + effdtStr + "'}) ").append(" \t\tOR (fileHisOther.FLeffdt > {ts '" + leffdtStr + "'} AND fileHisOther.FEffdt <={ts '" + effdtStr + "'})) ");
        IRowSet duplicatedRowset = null;
        try {
            String sql = sb.toString();
            duplicatedRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return duplicatedRowset;
    }

    public static String getPersonID(Context ctx, String personNum) {
        String personID = "";
        IRowSet personIDRowset = null;
        try {
            String sql = "SELECT FID AS personID FROM T_BD_PERSON WHERE FNUMBER = '" + personNum + "' ";
            personIDRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (personIDRowset != null && personIDRowset.size() > 0 && personIDRowset.next()) {
                personID = personIDRowset.getString("personID");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personID;
    }
}

