/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.helper;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftSegResEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class ScheduleShiftItemHelper {
    public static String getRealTimeByType(int type, String atdtString, String atdtPreDayString, String atdtNextDayString, String timeStr) {
        String value = "";
        if (type == 0) {
            value = atdtPreDayString + " " + timeStr + ":00";
        } else if (type == 1) {
            value = atdtString + " " + timeStr + ":00";
        } else if (type == 2) {
            value = atdtNextDayString + " " + timeStr + ":00";
        }
        return value;
    }

    public static String getRealRestTime(String preTimeStr, int preTimeValue, String restPreTime, String restNextTime, String atdtString, String atdtPreDayString, String atdtNextDayString, String flag) {
        long preTimeStrValue = Long.parseLong(preTimeStr.substring(0, 2)) * 60L + Long.parseLong(preTimeStr.substring(3, 5));
        long restPreTimeValue = Long.parseLong(restPreTime.substring(0, 2)) * 60L + Long.parseLong(restPreTime.substring(3, 5));
        long restNextTimeValue = Long.parseLong(restNextTime.substring(0, 2)) * 60L + Long.parseLong(restNextTime.substring(3, 5));
        if ("restPreTime".equals(flag)) {
            if (restPreTimeValue >= preTimeStrValue) {
                String restPreDate = ScheduleShiftItemHelper.getRealDateByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString);
                String restPreDateTime = restPreDate + " " + restPreTime + ":00";
                return restPreDateTime;
            }
            String restPreDate = ScheduleShiftItemHelper.getRealDateByType(++preTimeValue, atdtString, atdtPreDayString, atdtNextDayString);
            String restPreDateTime = restPreDate + " " + restPreTime + ":00";
            return restPreDateTime;
        }
        if ("restNextTime".equals(flag)) {
            if (restNextTimeValue >= preTimeStrValue) {
                String restNextDate = ScheduleShiftItemHelper.getRealDateByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString);
                String resrNextDateTime = restNextDate + " " + restNextTime + ":00";
                return resrNextDateTime;
            }
            String restNextDate = ScheduleShiftItemHelper.getRealDateByType(++preTimeValue, atdtString, atdtPreDayString, atdtNextDayString);
            String resrNextDateTime = restNextDate + " " + restNextTime + ":00";
            return resrNextDateTime;
        }
        return "";
    }

    public static String checkAtsShiftItems(Context ctx, AtsShiftInfo atsShiftInfo) {
        AtsShiftItemInfo temp1;
        String error = "";
        AtsShiftItemCollection items = atsShiftInfo.getItems();
        if (items.size() == 1) {
            AtsShiftItemInfo temp = items.get(0);
            int prevalue = temp.getPreTimeDayType().getValue();
            int nextvalue = temp.getNextTimeDayType().getValue();
            if (prevalue == 0 && nextvalue == 0) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidWorkOffTimeUnitBepreDay, ctx);
            }
            if (prevalue == 0 && nextvalue == 2) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidWorkPreDayOffTimeUnitBepreDay, ctx);
            }
            if (prevalue == 1 && nextvalue == 0) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidOffTimeUnitBepreDay, ctx);
            }
            if (prevalue == 2) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidWorkTimeUnitBeNextDay, ctx);
            }
        }
        if (items.size() == 2) {
            temp1 = items.get(0);
            AtsShiftItemInfo temp2 = items.get(1);
            String pretime1 = temp1.getPreTime();
            String nexttime1 = temp1.getNextTime();
            String pretime2 = temp2.getPreTime();
            String nexttime2 = temp2.getNextTime();
            int prevalue1 = temp1.getPreTimeDayType().getValue();
            int nextvalue1 = temp1.getNextTimeDayType().getValue();
            int prevalue2 = temp2.getPreTimeDayType().getValue();
            int nextvalue2 = temp2.getNextTimeDayType().getValue();
            String currdate = AtsDateUtils.dateShortToString(new Date());
            Timestamp ontime1 = AtsDateUtils.stringToTimestamp(currdate + " " + pretime1 + ":00");
            if (prevalue1 == 0) {
                ontime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + pretime1 + ":00");
            } else if (prevalue1 == 2) {
                ontime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + pretime1 + ":00");
            }
            Timestamp offtime1 = AtsDateUtils.stringToTimestamp(currdate + " " + nexttime1 + ":00");
            if (nextvalue1 == 0) {
                offtime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + nexttime1 + ":00");
            } else if (nextvalue1 == 2) {
                offtime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + nexttime1 + ":00");
            }
            Timestamp ontime2 = AtsDateUtils.stringToTimestamp(currdate + " " + pretime2 + ":00");
            if (prevalue2 == 0) {
                ontime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + pretime2 + ":00");
            } else if (prevalue2 == 2) {
                ontime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + pretime2 + ":00");
            }
            Timestamp offtime2 = AtsDateUtils.stringToTimestamp(currdate + " " + nexttime2 + ":00");
            if (nextvalue2 == 0) {
                offtime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + nexttime2 + ":00");
            } else if (nextvalue2 == 2) {
                offtime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + nexttime2 + ":00");
            }
            if (offtime1.getTime() < ontime1.getTime()) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate29, ctx);
            }
            if (offtime2.getTime() < ontime2.getTime()) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate22, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate34, ctx);
            }
            if (prevalue1 == 0 && prevalue2 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate26, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 1 && (prevalue2 == 0 || prevalue2 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate27, ctx);
            }
            if (prevalue1 == 0 && (nextvalue2 == 0 || nextvalue2 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate28, ctx);
            }
            if (prevalue1 == 1 && nextvalue1 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate25, ctx);
            }
            if (prevalue1 == 1 && prevalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate23, ctx);
            }
            if (prevalue1 == 1 && nextvalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate24, ctx);
            }
            if (nextvalue1 == 1 && prevalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate30, ctx);
            }
            if (nextvalue1 == 1 && nextvalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate31, ctx);
            }
            if (prevalue2 == 2 && (nextvalue2 == 0 || nextvalue2 == 1)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate21, ctx);
            }
            if (prevalue1 == 2) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidWorkTimeUnitBeNextDay, ctx);
            }
        }
        if (items.size() == 3) {
            temp1 = items.get(0);
            AtsShiftItemInfo temp2 = items.get(1);
            AtsShiftItemInfo temp3 = items.get(2);
            String pretime1 = temp1.getPreTime();
            String nexttime1 = temp1.getNextTime();
            String pretime2 = temp2.getPreTime();
            String nexttime2 = temp2.getNextTime();
            String pretime3 = temp3.getPreTime();
            String nexttime3 = temp3.getNextTime();
            int prevalue1 = temp1.getPreTimeDayType().getValue();
            int nextvalue1 = temp1.getNextTimeDayType().getValue();
            int prevalue2 = temp2.getPreTimeDayType().getValue();
            int nextvalue2 = temp2.getNextTimeDayType().getValue();
            int prevalue3 = temp3.getPreTimeDayType().getValue();
            int nextvalue3 = temp3.getNextTimeDayType().getValue();
            String currdate = AtsDateUtils.dateShortToString(new Date());
            Timestamp ontime1 = AtsDateUtils.stringToTimestamp(currdate + " " + pretime1 + ":00");
            if (prevalue1 == 0) {
                ontime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + pretime1 + ":00");
            } else if (prevalue1 == 2) {
                ontime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + pretime1 + ":00");
            }
            Timestamp offtime1 = AtsDateUtils.stringToTimestamp(currdate + " " + nexttime1 + ":00");
            if (nextvalue1 == 0) {
                offtime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + nexttime1 + ":00");
            } else if (nextvalue1 == 2) {
                offtime1 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + nexttime1 + ":00");
            }
            Timestamp ontime2 = AtsDateUtils.stringToTimestamp(currdate + " " + pretime2 + ":00");
            if (prevalue2 == 0) {
                ontime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + pretime2 + ":00");
            } else if (prevalue2 == 2) {
                ontime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + pretime2 + ":00");
            }
            Timestamp offtime2 = AtsDateUtils.stringToTimestamp(currdate + " " + nexttime2 + ":00");
            if (nextvalue2 == 0) {
                offtime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + nexttime2 + ":00");
            } else if (nextvalue2 == 2) {
                offtime2 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + nexttime2 + ":00");
            }
            Timestamp ontime3 = AtsDateUtils.stringToTimestamp(currdate + " " + pretime3 + ":00");
            if (prevalue3 == 0) {
                ontime3 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + pretime3 + ":00");
            } else if (prevalue3 == 2) {
                ontime3 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + pretime3 + ":00");
            }
            Timestamp offtime3 = AtsDateUtils.stringToTimestamp(currdate + " " + nexttime3 + ":00");
            if (nextvalue3 == 0) {
                offtime3 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getPreDay(currdate) + " " + nexttime3 + ":00");
            } else if (nextvalue3 == 2) {
                offtime3 = AtsDateUtils.stringToTimestamp(AtsDateUtils.getNextDay(currdate) + " " + nexttime3 + ":00");
            }
            if (offtime1.getTime() < ontime1.getTime()) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate65, ctx);
            }
            if (offtime2.getTime() < ontime2.getTime()) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate39, ctx);
            }
            if (offtime3.getTime() < ontime3.getTime()) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate45, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate64, ctx);
            }
            if (prevalue1 == 0 && prevalue2 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate51, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 1 && (prevalue2 == 0 || prevalue2 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate52, ctx);
            }
            if (prevalue1 == 0 && nextvalue2 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate53, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 1 && (nextvalue2 == 0 || nextvalue2 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate54, ctx);
            }
            if (prevalue1 == 0 && prevalue2 == 1 && (nextvalue2 == 0 || nextvalue2 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate54, ctx);
            }
            if (prevalue1 == 0 && prevalue3 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate56, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 1 && (prevalue3 == 0 || prevalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate57, ctx);
            }
            if (prevalue1 == 0 && prevalue2 == 1 && (prevalue3 == 0 || prevalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate57, ctx);
            }
            if (prevalue1 == 0 && nextvalue2 == 1 && (prevalue3 == 0 || prevalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate57, ctx);
            }
            if (prevalue1 == 0 && nextvalue3 == 2) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate60, ctx);
            }
            if (prevalue1 == 0 && nextvalue1 == 1 && (nextvalue3 == 0 || nextvalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate61, ctx);
            }
            if (prevalue1 == 0 && prevalue2 == 1 && (nextvalue3 == 0 || nextvalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate61, ctx);
            }
            if (prevalue1 == 0 && nextvalue2 == 1 && (nextvalue3 == 0 || nextvalue3 == 2)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate61, ctx);
            }
            if (prevalue1 == 1 && nextvalue1 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate50, ctx);
            }
            if (prevalue1 == 1 && prevalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate46, ctx);
            }
            if (prevalue1 == 1 && nextvalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate47, ctx);
            }
            if (prevalue1 == 1 && prevalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate48, ctx);
            }
            if (prevalue1 == 1 && nextvalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate49, ctx);
            }
            if (nextvalue1 == 1 && prevalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate66, ctx);
            }
            if (nextvalue1 == 1 && nextvalue2 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate67, ctx);
            }
            if (nextvalue1 == 1 && prevalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate68, ctx);
            }
            if (nextvalue1 == 1 && nextvalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate69, ctx);
            }
            if (prevalue2 == 2 && (nextvalue2 == 0 || nextvalue2 == 1)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate38, ctx);
            }
            if (nextvalue2 == 1 && prevalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate40, ctx);
            }
            if (nextvalue2 == 1 && nextvalue3 == 0) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate41, ctx);
            }
            if (nextvalue2 == 2 && (prevalue3 == 0 || prevalue3 == 1)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate42, ctx);
            }
            if (nextvalue2 == 2 && (nextvalue3 == 0 || nextvalue3 == 1)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate43, ctx);
            }
            if (prevalue3 == 2 && (nextvalue3 == 0 || nextvalue3 == 1)) {
                error = error + MLUtile.getRes(AtsShiftSegResEnum.ShiftRelate44, ctx);
            }
            if (prevalue1 == 2) {
                error = error + MLUtile.getRes(AtsShiftResEnum.ForbidWorkTimeUnitBeNextDay, ctx);
            }
        }
        return error;
    }

    private static String getRealDateByType(int type, String atdtString, String atdtPreDayString, String atdtNextDayString) {
        String value = "";
        if (type == 0) {
            value = atdtPreDayString;
        } else if (type == 1) {
            value = atdtString;
        } else if (type == 2) {
            value = atdtNextDayString;
        }
        return value;
    }

    public static double getStandardHour(AtsShiftInfo atsShiftInfo) {
        double standardHour = 0.0;
        int time1 = 0;
        int time2 = 0;
        AtsShiftItemCollection atsShiftItemCollection = atsShiftInfo.getItems();
        int items = atsShiftItemCollection.size();
        for (int i = 0; i < items; ++i) {
            AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(i);
            String attendanceType = atsShiftItemInfo.getAttendanceType().getValue();
            String preTime = atsShiftItemInfo.getPreTime();
            String nextTime = atsShiftItemInfo.getNextTime();
            BigDecimal restTime = atsShiftItemInfo.getSegmentInRest();
            if (restTime == null) {
                restTime = new BigDecimal(0);
            }
            if (!attendanceType.equals("1") && !attendanceType.equals("3")) continue;
            int hhPre = Integer.valueOf(preTime.substring(0, 2));
            int mmPre = Integer.valueOf(preTime.substring(3, 5));
            int preTimeDayType = atsShiftItemInfo.getPreTimeDayType().getValue();
            int hhNext = Integer.valueOf(nextTime.substring(0, 2));
            int mmNext = Integer.valueOf(nextTime.substring(3, 5));
            int nextTimeDayType = atsShiftItemInfo.getNextTimeDayType().getValue();
            time1 = hhPre * 60 + mmPre;
            time2 = hhNext * 60 + mmNext;
            time1 = ScheduleShiftItemHelper.getRealTimeByType(time1, preTimeDayType);
            time2 = ScheduleShiftItemHelper.getRealTimeByType(time2, nextTimeDayType);
            standardHour += (double)(time2 - time1) - restTime.doubleValue();
        }
        return standardHour;
    }

    private static int getRealTimeByType(int time, int type) {
        if (type == 0) {
            time -= 1440;
        } else if (type == 2) {
            time += 1440;
        }
        return time;
    }
}

