/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.holidayLimit.IBaseOperateHolidayLimit;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractBaseDeductLimit
implements IBaseOperateHolidayLimit {
    private final AtsLeaveBillInfo atsLeaveBillInfo;
    private final int changType;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.holidayLimit.AbstractBaseDeductLimit");

    public int getChangType() {
        return this.changType;
    }

    public AtsLeaveBillInfo getAtsLeaveBillInfo() {
        return this.atsLeaveBillInfo;
    }

    public AbstractBaseDeductLimit(Context ctx, String billId, int changType) throws EASBizException, BOSException {
        this.atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo("where id = '" + billId + "'");
        this.changType = changType;
    }

    public AbstractBaseDeductLimit(Context ctx, AtsLeaveBillInfo leaveBillInfo, int changType) throws EASBizException, BOSException {
        this.atsLeaveBillInfo = leaveBillInfo;
        this.changType = changType;
    }

    @Override
    public void operateHolidayLimitProcess(Context ctx) throws BOSException, EASBizException {
        this.beforeDeductLimit(ctx, this.atsLeaveBillInfo, this.changType);
        this.coreBaseBeforeDeductLimit(ctx, this.atsLeaveBillInfo, this.changType);
        this.afterDeductLimit(ctx, this.atsLeaveBillInfo, this.changType);
    }

    public abstract void coreBaseBeforeDeductLimit(Context var1, AtsLeaveBillInfo var2, int var3) throws EASBizException, BOSException;

    public void beforeDeductLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, int changType) {
    }

    public void afterDeductLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, int changType) {
    }

    protected HolidayLimitDetailInfo generateHolildayLimitDetail(Context ctx, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo billEntryInfo, Map<String, Object> mapBalance, HolidayLimitChangeType holidayLimitChangeType, PersonPositionInfo personPositionInfo) {
        String holidayLimitId;
        String cancelBillId;
        logger.info((Object)"record detail table start...");
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        detailInfo.setHrOrgUnit(personPositionInfo.getHrOrgUnit());
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(AtsDateUtils.dateToTimestamp(new Date()));
        detailInfo.setCreateTime(AtsDateUtils.dateToTimestamp(new Date()));
        detailInfo.setChangeType(holidayLimitChangeType);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBill(billInfo);
        detailInfo.setLeaveBillNumber(billInfo.getNumber());
        detailInfo.setLeaveBillEntry(billEntryInfo);
        detailInfo.setChangeValue((BigDecimal)mapBalance.get("changeValue"));
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String string = cancelBillId = mapBalance.get("cancelBillId") == null ? "" : (String)mapBalance.get("cancelBillId");
        if (!cancelBillId.isEmpty()) {
            CancelLeaveBillInfo cancelBill = new CancelLeaveBillInfo();
            cancelBill.setId(BOSUuid.read((String)cancelBillId));
            detailInfo.setCancelLeaveBill(cancelBill);
        }
        if ((holidayLimitId = (String)mapBalance.get("holidayLimitId")) != null) {
            HolidayLimitInfo limitInfo = new HolidayLimitInfo();
            limitInfo.setId(BOSUuid.read((String)holidayLimitId));
            detailInfo.setHolidayLimit(limitInfo);
        }
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        logger.info((Object)"record detail table end...");
        return detailInfo;
    }
}

