/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.BillSubmitTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeFactory;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.lightapp.util.AtsDataTypeChange;
import com.kingdee.eas.hr.ats.lightapp.util.AtsLeaveBillLimit;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.HolidayPolicyParameterUtil;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.TimeUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.LeaveBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryFactory;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.SubmitStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.TimeBaseFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class lightAppUtil {
    public String getParameter(Map params, String paramName) {
        if (params == null) {
            return "";
        }
        Object retName = params.get(paramName);
        return retName == null ? "" : retName.toString();
    }

    public AtsLeaveBillInfo createNewDataNew(Context ctx, String timeOffApplyType, String timeOffStartDate, String timeOffEndDate, String reason, String leaveLength, String personId) throws Exception {
        AtsLeaveBillInfo atsLeaveBillInfo = new AtsLeaveBillInfo();
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        PersonInfo personInfo = SHRBillUtil.getPersonDetailInfo(personId, ctx);
        PersonPositionInfo personPositionInfo = SHRBillUtil.getAdminOrgUnit(personInfo.getId().toString(), ctx);
        atsLeaveBillInfo.setProposer(personInfo);
        atsLeaveBillInfo.setApplyDate(nowDate);
        atsLeaveBillInfo.setAdminOrg(personPositionInfo.getPersonDep());
        HROrgUnitInfo hrInfo = null;
        hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        atsLeaveBillInfo.setHrOrgUnit(hrInfo);
        atsLeaveBillInfo.setBizDate(nowDate);
        atsLeaveBillInfo.setIsMultiEntry(false);
        atsLeaveBillInfo.setBillType(BillSubmitTypeEnum.getEnum(1));
        if (null == hrInfo) {
            throw new AtsCommonBizException(AtsCommonBizException.LEAKHRORGFORADMINORG);
        }
        AtsLeaveBillInfo leaveBill = new AtsLeaveBillInfo();
        String billNumber = NumberCodeRule.readCodeRuleNumber((IObjectValue)leaveBill, NumberCodeRule.getMainOrgByCu(ctx), ctx);
        if (StringUtils.isNotBlank((String)billNumber)) {
            atsLeaveBillInfo.setNumber(billNumber);
        } else {
            String empNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getNumber();
            billNumber = "M-" + empNumber + "-" + DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            atsLeaveBillInfo.setNumber(billNumber);
        }
        AtsLeaveBillEntryInfo entryInfo = new AtsLeaveBillEntryInfo();
        entryInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        entryInfo.setPerson(personInfo);
        entryInfo.setPosition(personPositionInfo.getPrimaryPosition());
        atsLeaveBillInfo.getEntries().add(entryInfo);
        if (timeOffStartDate.indexOf("AM") > -1 || timeOffStartDate.indexOf("PM") > -1) {
            entryInfo.setBeginTime(TimeUtil.getBeginTimeStampNew(ctx, timeOffStartDate, personId));
            entryInfo.setEndTime(TimeUtil.getEndTimeStampNew(ctx, timeOffEndDate, personId));
            entryInfo.setRealBeginTime(TimeUtil.getBeginTimeStampNew(ctx, timeOffStartDate, personId));
            entryInfo.setRealEndTime(TimeUtil.getEndTimeStampNew(ctx, timeOffEndDate, personId));
        } else {
            entryInfo.setBeginTime(AtsDateUtils.stringToTimestamp(timeOffStartDate));
            entryInfo.setEndTime(AtsDateUtils.stringToTimestamp(timeOffEndDate));
            entryInfo.setRealBeginTime(AtsDateUtils.stringToTimestamp(timeOffStartDate));
            entryInfo.setRealEndTime(AtsDateUtils.stringToTimestamp(timeOffEndDate));
        }
        entryInfo.setLeaveLength(new BigDecimal(leaveLength));
        entryInfo.setRealLeaveLength(new BigDecimal(leaveLength));
        entryInfo.setReason(reason);
        AttendanceFileCollection attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" select id,attencePolicy.id,attencePolicy.workCalendar.id,attencePolicy.workCalendar.name,holidayPolicySet where proposer.id='" + personInfo.getId().toString() + "' and attendFileState='1' ");
        if (attendanceFileColl.size() == 0) {
            String msg = MLUtile.getRes(AtsFileResEnum.NotExistFile, ctx);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        HolidayPolicySetInfo holidayPolicySetInfo = attendanceFileColl.get(0).getHolidayPolicySet();
        if (holidayPolicySetInfo == null) {
            String msg = MLUtile.getRes(AtsFileResEnum.NullHPolicy, ctx);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        HolidayTypeInfo holidayTypeInfo = HolidayTypeFactory.getLocalInstance(ctx).getHolidayTypeInfo("select id,number,name where id='" + timeOffApplyType + "' ");
        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection("select id,holidayType.id,holidayType.name,isIncludeLegal,isIncludeRest,unit,isOver where holidayPolicySet='" + holidayPolicySetInfo.getId().toString() + "' and holidayType='" + timeOffApplyType + "' ");
        if (policyColl == null || policyColl.size() < 1) {
            String msg = MLUtile.getRes((ResourceEnum)AtsFileResEnum.NullHPolicyWithParam, ctx, holidayTypeInfo.getName());
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        entryInfo.setPolicy(policyColl.get(0));
        entryInfo.setRealUnit(policyColl.get(0).getUnit());
        return atsLeaveBillInfo;
    }

    public LeaveBillInfo createNewData(Context ctx, String attendanceId, String timeOffStartDate, String timeOffEndDate, String reason, String leaveLength, String personId) throws Exception {
        Map<String, Object> rt = this.hasRepeatDay(ctx, TimeUtil.getBeginTimeStampNew(ctx, timeOffStartDate, personId), TimeUtil.getEndTimeStampNew(ctx, timeOffEndDate, personId), personId);
        if (((Boolean)rt.get("isDuplicate")).booleanValue()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{(String)rt.get("msg")});
        }
        String hrUnitId = TimeUtil.getHRUnitId(ctx);
        if (StringUtils.isEmpty((String)hrUnitId)) {
            throw new AtsCommonBizException(AtsCommonBizException.LEAKHRORGFORADMINORG);
        }
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrUnitId), "Is_allow_leave");
        if ("00000000-0000-0000-0000-000000000008649E3405".equals(attendanceId) && "true".equals(val) && this.isExtendedDay(ctx, leaveLength, personId)) {
            throw new Exception("isExtendedDay");
        }
        LeaveBillInfo info = new LeaveBillInfo();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean result = codingRuleManager.isExist((IObjectValue)info, hrUnitId);
        String number = "";
        if (!result) {
            String empNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getNumber();
            number = "M-" + empNumber + "-" + DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            info.setNumber(number);
        }
        info.setIsMultiEntry(false);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)TimeBaseFacadeFactory.getLocalInstance((Context)ctx).getServerTime()));
        info.setAdminOrg(this.getAdminOrg(ctx, personId));
        HROrgUnitInfo hrInfo = new HROrgUnitInfo();
        hrInfo.setId(BOSUuid.read((String)hrUnitId));
        info.setHrOrgUnit(hrInfo);
        PersonInfo personInfo = SHRBillUtil.getPersonDetailInfo(personId, ctx);
        info.setProposer(personInfo);
        info.setPhone(personInfo.getOfficePhone());
        info.setSubmitState(SubmitStateEnum.SUBMIT);
        val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrUnitId), "QJ001");
        if ("true".equals(val)) {
            info.setApproveState(ApproveStateEnum.WORKFLOW);
        } else {
            info.setApproveState(ApproveStateEnum.DIRECT);
        }
        LeaveBillEntryInfo entry = new LeaveBillEntryInfo();
        entry.setBeginTime(TimeUtil.getBeginTimeStampNew(ctx, timeOffStartDate, personId));
        entry.setEndTime(TimeUtil.getEndTimeStampNew(ctx, timeOffEndDate, personId));
        entry.setReason(reason);
        entry.setLeaveLength(BigDecimal.valueOf(Float.parseFloat(leaveLength)));
        entry.setPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        TimeAttendanceInfo timeAttendanceInfo = new TimeAttendanceInfo();
        timeAttendanceInfo.setId(BOSUuid.read((String)attendanceId));
        entry.setType(timeAttendanceInfo);
        entry.setOrg(this.getAdminOrg(ctx, personId));
        info.getEntries().add(entry);
        return info;
    }

    public AdminOrgUnitInfo getAdminOrg(Context ctx, String personId) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        evi.setFilter(fi);
        evi.setSelector(sic);
        PositionMemberCollection pColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
        if (pColl.size() > 0) {
            return pColl.get(0).getPosition().getAdminOrgUnit();
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo fi1 = new FilterInfo();
        fi1.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        sic1.add(new SelectorItemInfo("gkAdmin.id"));
        sic1.add(new SelectorItemInfo("gkAdmin.name"));
        evi1.setFilter(fi1);
        evi1.setSelector(sic1);
        PersonPositionCollection psColl = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi1);
        if (psColl.size() > 0) {
            return psColl.get(0).getGkAdmin();
        }
        return null;
    }

    public Map<String, Object> hasRepeatDay(Context ctx, Timestamp beginTimestamp, Timestamp endTimestamp, String personId) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("bill.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("bill.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("beginTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("endTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("bill.applyDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("type.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("type.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", (Object)-1, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        FilterInfo timefilterInfo = new FilterInfo();
        timefilterInfo.getFilterItems().add(new FilterItemInfo("beginTime", (Object)endTimestamp, CompareType.LESS_EQUALS));
        timefilterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)beginTimestamp, CompareType.GREATER_EQUALS));
        filterInfo.mergeFilter(timefilterInfo, "and");
        viewInfo.setFilter(filterInfo);
        LeaveBillEntryCollection leavebillcol = LeaveBillEntryFactory.getLocalInstance((Context)ctx).getLeaveBillEntryCollection(viewInfo);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean isDuplicate = false;
        String msg = "";
        StringBuilder infoSB = new StringBuilder();
        if (leavebillcol.size() > 0) {
            isDuplicate = true;
            for (int i = 0; i < leavebillcol.size(); ++i) {
                LeaveBillEntryInfo leaveBillEntryInfo = leavebillcol.get(i);
                String applyDateStr = TimeUtil.dateShortToString(leaveBillEntryInfo.getBill().getApplyDate());
                String beginDateStr = TimeUtil.getDtAPMStr(ctx, leaveBillEntryInfo.getBeginTime());
                String endDateStr = TimeUtil.getDtAPMStr(ctx, leaveBillEntryInfo.getEndTime());
                String typeStr = leaveBillEntryInfo.getType().getName();
                if (i > 0) {
                    infoSB.append(";");
                }
                infoSB.append(MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.AppliedAlready, ctx, applyDateStr, beginDateStr, endDateStr, typeStr));
                if (i != leavebillcol.size() - 1) continue;
                infoSB.append(";").append(MLUtile.getRes(AtsCommonResEnum.ForbidRepeatApply, ctx)).append("\uff01");
            }
        }
        msg = infoSB.toString();
        ret.put("isDuplicate", isDuplicate);
        ret.put("msg", msg);
        return ret;
    }

    public boolean isExtendedDay(Context ctx, String leaveLength, String personId) throws BOSException, SQLException {
        int year = DateTimeUtils.getYear((Date)new Date());
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from t_hr_yvbalance ");
        sql.append(" where fpersonid = ? and fyear = ? ");
        Object[] params = new Object[]{personId, year};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        float currAvaiable = 0.0f;
        while (rowSet.next()) {
            currAvaiable = rowSet.getFloat("FCurrAvaiable");
        }
        HashSet<String> stateSet = new HashSet<String>();
        stateSet.add("0");
        stateSet.add("1");
        float usedDay = 0.0f;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("leaveLength"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type.id", (Object)"00000000-0000-0000-0000-000000000008649E3405", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", stateSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setFilter(filterInfo);
        LeaveBillEntryCollection leavebillcol = LeaveBillEntryFactory.getLocalInstance((Context)ctx).getLeaveBillEntryCollection(viewInfo);
        LeaveBillEntryInfo leavebill = null;
        int size = leavebillcol.size();
        for (int i = 0; i < size; ++i) {
            leavebill = leavebillcol.get(i);
            usedDay += leavebill.getLeaveLength().floatValue();
        }
        return Float.parseFloat(leaveLength) > currAvaiable - usedDay;
    }

    public void beforeSubmitNew(CoreBaseInfo model) throws EASBizException {
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)model;
        billInfo.setBillState(HRBillStateEnum.SUBMITED);
        billInfo.setExtendedProperty("isAddNew", "isAddNew");
    }

    public IObjectPK runSubmitNew(Context ctx, CoreBaseInfo model) throws Exception {
        this.beforeSubmitNew(model);
        AtsLeaveBillInfo billInfo = (AtsLeaveBillInfo)model;
        Timestamp startTime = billInfo.getEntries().get(0).getBeginTime();
        Timestamp endTime = billInfo.getEntries().get(0).getEndTime();
        String leaveLength = billInfo.getEntries().get(0).getLeaveLength().toString();
        String msg = "";
        AtsLeaveBillLimit leaveBillLimit = new AtsLeaveBillLimit();
        String personId = billInfo.getProposer().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = billInfo.getEntries().get(0).getPolicy();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        HolidayLimitCollection holidayLimitCollection = AtsWebUtils.getHolidayLimitCollectionByPersonIdAndStartOrEndTime(ctx, personId, holidayTypeId, startTime, endTime);
        if (holidayPolicyInfo == null) {
            msg = MLUtile.getRes(AtsHolidayResEnum.NotFindHolidayPolicyToLeave, ctx);
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        if (HolidayPolicyParameterUtil.getIsCtrlLimit(ctx, personId, holidayTypeId).booleanValue() || holidayLimitCollection != null && holidayLimitCollection.size() != 0) {
            Boolean isOver = holidayPolicyInfo.isIsOver();
            if (holidayLimitCollection == null || holidayLimitCollection.size() == 0) {
                if (!isOver.booleanValue()) {
                    HolidayLimitCollection holidayLimitColl = AtsWebUtils.getHolidayLimitCollectionByPersonIdAndStartOrEndTimeAll(ctx, personId, holidayTypeId, startTime, endTime);
                    if (holidayLimitColl != null && holidayLimitColl.size() != 0) {
                        msg = MLUtile.getRes(AtsLeaveBillResEnum.FailForUnauditLimitRecord, ctx);
                        throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
                    }
                    msg = MLUtile.getRes(AtsHolidayResEnum.LeaveFailForNoLimitInfo, ctx);
                    throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
                }
            } else {
                HolidayLimitCollection holidayLimitCollectionReal = AtsWebUtils.getHolidayLimitCollectionByPersonIdAndStartEndTime(ctx, personId, holidayTypeId, startTime, endTime);
                if (holidayLimitCollectionReal == null || holidayLimitCollectionReal.size() == 0) {
                    msg = MLUtile.getRes(AtsLeaveBillResEnum.SaveFailInForbidOverCycleLeave, ctx);
                    throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
                }
                BigDecimal remainLimitLength = BigDecimal.valueOf(0L);
                for (int i = 0; i < holidayLimitCollectionReal.size(); ++i) {
                    remainLimitLength = remainLimitLength.add(holidayLimitCollectionReal.get(i).getRemainLimit());
                }
                if (AtsDataTypeChange.string2BigDecimal(leaveLength).compareTo(remainLimitLength) == 1 && !isOver.booleanValue()) {
                    msg = MLUtile.getRes(AtsHolidayResEnum.LeaveFailForLeakRemainLimit, ctx);
                    throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
                }
            }
            HttpServletRequest request = null;
            HttpServletResponse response = null;
            if (HolidayPolicyParameterUtil.getIsCtrlLimit(ctx, personId, holidayTypeId).booleanValue()) {
                leaveBillLimit.operatorFreezeAndRemainLimitAndPreOverdraftLimit(ctx, request, response, model);
            }
        }
        return AtsLeaveBillFactory.getLocalInstance(ctx).submit(model);
    }

    public static Object reflectSetFieldValue(Map<String, Object> map, Object o) throws Exception {
        if (!map.isEmpty()) {
            for (String k : map.keySet()) {
                Object v = "";
                if (!k.isEmpty()) {
                    v = map.get(k);
                }
                Field field = o.getClass().getDeclaredField(k);
                field.setAccessible(true);
                field.set(o, v);
            }
        }
        return o;
    }
}

