/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.pcRule.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsPCRuleConditionCollection;
import com.kingdee.eas.hr.ats.AtsPCRuleInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.DefaultValForAtsCollection;
import com.kingdee.eas.hr.ats.pcRule.EmpQueryImpl;
import com.kingdee.eas.hr.ats.pcRule.GridDataEntity;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public abstract class PCRuleHandler {
    protected PCRuleHandler successor;
    protected boolean configPcRuleHandler = Boolean.valueOf(ConfigAts.getPropertyFromConfig("configPcRuleHandler")) == false;
    protected String conditionSQL;

    public abstract Map<String, Object> handleRequest(Context var1, PersonBURelaConfirmInfo var2);

    public PCRuleHandler getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(PCRuleHandler successor) {
        this.successor = successor;
    }

    public AtsPCRuleConditionCollection getConditonColl(AtsPCRuleInfo atsPCRuleInfo) {
        AtsPCRuleConditionCollection conditionColl = new AtsPCRuleConditionCollection();
        if (atsPCRuleInfo.getConditionItems().size() > 0) {
            conditionColl = atsPCRuleInfo.getConditionItems().get(0).getItems();
        }
        return conditionColl;
    }

    public DefaultValForAtsCollection getDefaultValForAtsCollection(AtsPCRuleInfo atsPCRuleInfo) {
        DefaultValForAtsCollection defaultValForAtsCollection = new DefaultValForAtsCollection();
        if (atsPCRuleInfo.getConditionItems().size() > 0) {
            defaultValForAtsCollection = atsPCRuleInfo.getConditionItems().get(0).getDefaultValueItems();
        }
        return defaultValForAtsCollection;
    }

    public Boolean adminOrgDeal(Context ctx, AtsPCRuleInfo atsPCRuleInfo, PersonBURelaConfirmInfo info) {
        String orgStr = atsPCRuleInfo.getRuleOrgUnit();
        boolean isSub = atsPCRuleInfo.isIsSub();
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        try {
            String personId = info.getPerson().getId().toString();
            if ((info.getAffairActionOperate().getValue() == 70 || info.getAffairActionOperate().getValue() == 60) && info.getBizDefineType().getValue() == 43) {
                EmpPosOrgRelationCollection empPosOrgRelationInfoColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("where person.id='" + personId + "' and ASSIGNTYPE = 1 order by EFFDT desc");
                if (empPosOrgRelationInfoColl.size() > 0) {
                    empPosOrgRelationInfo = empPosOrgRelationInfoColl.get(0);
                }
            } else if (info.getCurEmpOrgRelation() != null) {
                empPosOrgRelationInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(info.getCurEmpOrgRelation().getId()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)orgStr)) {
            return true;
        }
        if (!isSub) {
            if (empPosOrgRelationInfo != null && empPosOrgRelationInfo.getAdminOrg() != null && orgStr.contains(empPosOrgRelationInfo.getAdminOrg().getId().toString())) {
                return true;
            }
            return false;
        }
        String orgStrIn = AtsUtil.getStrFromStringArr(orgStr.split(","));
        if (empPosOrgRelationInfo != null && empPosOrgRelationInfo.getAdminOrg() != null) {
            String adminOrgID = empPosOrgRelationInfo.getAdminOrg().getId().toString();
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            AdminOrgUnitCollection adminOrgUnitColl = new AdminOrgUnitCollection();
            try {
                adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgID));
                adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id in (" + orgStrIn + ")");
            }
            catch (EASBizException e) {
                System.out.println("PCRuleHandler error--101");
            }
            catch (BOSException e) {
                System.out.println("PCRuleHandler error--105");
            }
            for (int i = 0; i < adminOrgUnitColl.size(); ++i) {
                if (adminOrgUnitInfo == null || !adminOrgUnitInfo.getLongNumber().startsWith(adminOrgUnitColl.get(i).getLongNumber())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean adminOrgDeal(Context ctx, AtsPCRuleInfo atsPCRuleInfo, String adminOrgID) {
        String orgStr = atsPCRuleInfo.getRuleOrgUnit();
        boolean isSub = atsPCRuleInfo.isIsSub();
        if (StringUtils.isEmpty((CharSequence)orgStr)) {
            return true;
        }
        if (!isSub) {
            if (StringUtils.isNotEmpty((CharSequence)adminOrgID) && orgStr.contains(adminOrgID)) {
                return true;
            }
            return false;
        }
        String orgStrIn = AtsUtil.getStrFromStringArr(orgStr.split(","));
        if (StringUtils.isNotEmpty((CharSequence)adminOrgID)) {
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            AdminOrgUnitCollection adminOrgUnitColl = new AdminOrgUnitCollection();
            try {
                adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgID));
                adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id in (" + orgStrIn + ")");
            }
            catch (EASBizException e) {
                System.out.println("PCRuleHandler error--101");
            }
            catch (BOSException e) {
                System.out.println("PCRuleHandler error--105");
            }
            for (int i = 0; i < adminOrgUnitColl.size(); ++i) {
                if (adminOrgUnitInfo == null || !adminOrgUnitInfo.getLongNumber().startsWith(adminOrgUnitColl.get(i).getLongNumber())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected Boolean conditionDealByCacheSql(Context ctx, AtsPCRuleConditionCollection conditionColl, String personId, PersonBURelaConfirmInfo info) {
        if (this.conditionSQL == null) {
            this.initConditionSQL(ctx, conditionColl, info);
        }
        if (StringUtils.isEmpty((CharSequence)this.conditionSQL)) {
            return true;
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.conditionSQL, (Object[])new Object[]{personId});
            if (rs.next()) {
                return rs.getInt(1) > 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean conditionDeal(Context ctx, AtsPCRuleConditionCollection conditionColl, String personId, PersonBURelaConfirmInfo info) {
        if (this.configPcRuleHandler) {
            return this.conditionDealByCacheSql(ctx, conditionColl, personId, info);
        }
        Object value = null;
        FilterInfo filterInfo = new FilterInfo();
        if (conditionColl == null || conditionColl.size() == 0) {
            return true;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        for (int i = 0; i < conditionColl.size(); ++i) {
            CompareType tmpCompareType;
            CompareType compareType;
            String config = conditionColl.get(i).getConfig();
            if (config == null || config.equals("")) {
                return false;
            }
            String prop_field = JSONObject.fromObject((Object)config).get("name").toString();
            String prop_op = JSONObject.fromObject((Object)config).get("compareType").toString();
            String prop_value = JSONObject.fromObject((Object)config).get("value").toString();
            String field_type = JSONObject.fromObject((Object)config).get("type").toString();
            try {
                value = PCRuleHandler.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (prop_field.equals("jobGrade.name")) {
                compareType = CompareType.getEnum((String)prop_op);
                if (value != null && value instanceof Set) {
                    if (compareType.equals((Object)CompareType.LIKE)) {
                        compareType = CompareType.INCLUDE;
                    } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                        compareType = CompareType.NOTINCLUDE;
                    }
                    value = "(" + AtsUtil.convertSetToString((Set)value) + ")";
                }
                if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                    value = "'%" + value + "%'";
                }
                JobGradeCollection jobGradeColl = new JobGradeCollection();
                try {
                    jobGradeColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(" select number where name " + compareType + value);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                prop_field = "jobGrade.number";
                field_type = "String";
                prop_op = CompareType.INCLUDE.toString();
                prop_value = "";
                int len = jobGradeColl.size();
                for (int j = 0; j < len; ++j) {
                    prop_value = prop_value + jobGradeColl.get(j).getNumber();
                    if (j == len - 1) continue;
                    prop_value = prop_value + ",";
                }
            }
            try {
                value = PCRuleHandler.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            compareType = CompareType.getEnum((String)prop_op);
            if (value != null && value instanceof Set) {
                if (compareType.equals((Object)CompareType.LIKE)) {
                    compareType = CompareType.INCLUDE;
                } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                    compareType = CompareType.NOTINCLUDE;
                }
            }
            if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                value = "%" + value + "%";
            }
            if ((tmpCompareType = CompareType.getEnum((String)prop_op)).equals((Object)CompareType.NOTLIKE) || tmpCompareType.equals((Object)CompareType.NOTEQUALS)) {
                try {
                    FilterInfo isNullFilterInfo = new FilterInfo();
                    isNullFilterInfo.getFilterItems().add(new FilterItemInfo(prop_field, null, CompareType.EQUALS));
                    FilterInfo notEqualFilter = new FilterInfo();
                    notEqualFilter.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                    notEqualFilter.mergeFilter(isNullFilterInfo, "OR");
                    filterInfo.mergeFilter(notEqualFilter, "AND");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                continue;
            }
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
            try {
                filterInfo.mergeFilter(filterInfo1, "AND");
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        String selector = "person.id";
        SqlParam param = new SqlParam();
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        param.setFilterDate(effectDate);
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        param.setSelectMapping(map);
        param.setFilterInfo(filterInfo);
        param.setScheme("001");
        param.setNeedDistinct(false);
        param.setHistoryMode(false);
        param.setRows(999999999);
        param.setPage(1);
        param.setNewSearch(true);
        param.setSupportQueryUuid(true);
        GridDataEntity gridData = null;
        try {
            String uipk = "com.kingdee.eas.basedata.person.app.Person.list";
            gridData = EmpQueryImpl.execQuery(ctx, uipk, param);
            if (gridData.getTotal() > 0L) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void initConditionSQL(Context ctx, AtsPCRuleConditionCollection conditionColl, PersonBURelaConfirmInfo info) {
        if (StringUtils.isNotBlank((CharSequence)this.conditionSQL)) {
            return;
        }
        Object value = null;
        FilterInfo filterInfo = new FilterInfo();
        if (conditionColl == null || conditionColl.size() == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)"?", CompareType.EQUALS));
        for (int i = 0; i < conditionColl.size(); ++i) {
            CompareType tmpCompareType;
            CompareType compareType;
            String config = conditionColl.get(i).getConfig();
            if (config == null || config.equals("")) continue;
            String prop_field = JSONObject.fromObject((Object)config).get("name").toString();
            String prop_op = JSONObject.fromObject((Object)config).get("compareType").toString();
            String prop_value = JSONObject.fromObject((Object)config).get("value").toString();
            String field_type = JSONObject.fromObject((Object)config).get("type").toString();
            try {
                value = PCRuleHandler.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (prop_field.equals("jobGrade.name")) {
                compareType = CompareType.getEnum((String)prop_op);
                if (value != null && value instanceof Set) {
                    if (compareType.equals((Object)CompareType.LIKE)) {
                        compareType = CompareType.INCLUDE;
                    } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                        compareType = CompareType.NOTINCLUDE;
                    }
                    value = "(" + AtsUtil.convertSetToString((Set)value) + ")";
                }
                if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                    value = "'%" + value + "%'";
                }
                JobGradeCollection jobGradeColl = new JobGradeCollection();
                try {
                    jobGradeColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(" select number where name " + compareType + value);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                prop_field = "jobGrade.number";
                field_type = "String";
                prop_op = CompareType.INCLUDE.toString();
                prop_value = "";
                int len = jobGradeColl.size();
                for (int j = 0; j < len; ++j) {
                    prop_value = prop_value + jobGradeColl.get(j).getNumber();
                    if (j == len - 1) continue;
                    prop_value = prop_value + ",";
                }
            }
            try {
                value = PCRuleHandler.convertData(prop_value, field_type);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            compareType = CompareType.getEnum((String)prop_op);
            if (value != null && value instanceof Set) {
                if (compareType.equals((Object)CompareType.LIKE)) {
                    compareType = CompareType.INCLUDE;
                } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                    compareType = CompareType.NOTINCLUDE;
                }
            }
            if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                value = "%" + value + "%";
            }
            if ((tmpCompareType = CompareType.getEnum((String)prop_op)).equals((Object)CompareType.NOTLIKE) || tmpCompareType.equals((Object)CompareType.NOTEQUALS)) {
                try {
                    FilterInfo isNullFilterInfo = new FilterInfo();
                    isNullFilterInfo.getFilterItems().add(new FilterItemInfo(prop_field, null, CompareType.EQUALS));
                    FilterInfo notEqualFilter = new FilterInfo();
                    notEqualFilter.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                    notEqualFilter.mergeFilter(isNullFilterInfo, "OR");
                    filterInfo.mergeFilter(notEqualFilter, "AND");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                continue;
            }
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
            try {
                filterInfo.mergeFilter(filterInfo1, "AND");
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        String selector = "person.id";
        SqlParam param = new SqlParam();
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        param.setFilterDate(effectDate);
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        param.setSelectMapping(map);
        param.setFilterInfo(filterInfo);
        param.setScheme("001");
        param.setNeedDistinct(false);
        param.setHistoryMode(false);
        param.setRows(999999999);
        param.setPage(1);
        param.setNewSearch(true);
        param.setSupportQueryUuid(true);
        try {
            this.conditionSQL = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            if (null != info && this.conditionSQL.contains("T_HR_PERSONBURELACONFIRM") && this.conditionSQL.contains("\"ATSFRU\"")) {
                this.conditionSQL = this.conditionSQL + " and \"ATSFRU\".FID ='" + info.getId().toString() + "' ";
            }
            System.out.println("initConditionSql:" + this.conditionSQL);
            this.conditionSQL = "select count(*) " + this.conditionSQL.substring(this.conditionSQL.indexOf("FROM")).replaceAll("'\\?'", "?");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        AtsLog.getLog().info((Object)("initConditionSql cost:" + (System.currentTimeMillis() - start)));
    }

    public static Object convertData(String value, String dataType) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (value.indexOf(",") > -1 || value.indexOf("\uff0c") > -1) {
            String[] str = value.split(",");
            if (str.length == 1) {
                str = value.split("\uff0c");
            }
            HashSet set = new HashSet();
            Collections.addAll(set, str);
            return set;
        }
        if ("String".equalsIgnoreCase(dataType) || "StringEnum".equalsIgnoreCase(dataType)) {
            return value;
        }
        if ("Date".equalsIgnoreCase(dataType)) {
            Date dateValue = null;
            try {
                dateValue = DateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return dateValue;
        }
        if ("Boolean".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("Integer".equalsIgnoreCase(dataType) || "IntEnum".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("BigDecimal".equalsIgnoreCase(dataType)) {
            return new BigDecimal(value);
        }
        return value;
    }
}

