/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

public class TypeParameterResolver {
    public static Type resolveFieldType(Field field, Type srcType) {
        Type fieldType = field.getGenericType();
        Class<?> declaringClass = field.getDeclaringClass();
        return TypeParameterResolver.resolveType(fieldType, srcType, declaringClass);
    }

    public static Type resolveReturnType(Method method, Type srcType) {
        Type returnType = method.getGenericReturnType();
        Class<?> declaringClass = method.getDeclaringClass();
        return TypeParameterResolver.resolveType(returnType, srcType, declaringClass);
    }

    public static Type[] resolveParamTypes(Method method, Type srcType) {
        Type[] paramTypes = method.getGenericParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Type[] result = new Type[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            result[i] = TypeParameterResolver.resolveType(paramTypes[i], srcType, declaringClass);
        }
        return result;
    }

    private static Type resolveType(Type type, Type srcType, Class<?> declaringClass) {
        if (type instanceof TypeVariable) {
            return TypeParameterResolver.resolveTypeVar((TypeVariable)type, srcType, declaringClass);
        }
        if (type instanceof ParameterizedType) {
            return TypeParameterResolver.resolveParameterizedType((ParameterizedType)type, srcType, declaringClass);
        }
        if (type instanceof GenericArrayType) {
            return TypeParameterResolver.resolveGenericArrayType((GenericArrayType)type, srcType, declaringClass);
        }
        return type;
    }

    private static Type resolveGenericArrayType(GenericArrayType genericArrayType, Type srcType, Class<?> declaringClass) {
        Type componentType = genericArrayType.getGenericComponentType();
        Type resolvedComponentType = null;
        if (componentType instanceof TypeVariable) {
            resolvedComponentType = TypeParameterResolver.resolveTypeVar((TypeVariable)componentType, srcType, declaringClass);
        } else if (componentType instanceof GenericArrayType) {
            resolvedComponentType = TypeParameterResolver.resolveGenericArrayType((GenericArrayType)componentType, srcType, declaringClass);
        } else if (componentType instanceof ParameterizedType) {
            resolvedComponentType = TypeParameterResolver.resolveParameterizedType((ParameterizedType)componentType, srcType, declaringClass);
        }
        if (resolvedComponentType instanceof Class) {
            return Array.newInstance((Class)resolvedComponentType, 0).getClass();
        }
        return new GenericArrayTypeImpl(resolvedComponentType);
    }

    private static ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType, Type srcType, Class<?> declaringClass) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        Type[] args = new Type[typeArgs.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            args[i] = typeArgs[i] instanceof TypeVariable ? TypeParameterResolver.resolveTypeVar((TypeVariable)typeArgs[i], srcType, declaringClass) : (typeArgs[i] instanceof ParameterizedType ? TypeParameterResolver.resolveParameterizedType((ParameterizedType)typeArgs[i], srcType, declaringClass) : (typeArgs[i] instanceof WildcardType ? TypeParameterResolver.resolveWildcardType((WildcardType)typeArgs[i], srcType, declaringClass) : typeArgs[i]));
        }
        return new ParameterizedTypeImpl(rawType, null, args);
    }

    private static Type resolveWildcardType(WildcardType wildcardType, Type srcType, Class<?> declaringClass) {
        Type[] lowerBounds = TypeParameterResolver.resolveWildcardTypeBounds(wildcardType.getLowerBounds(), srcType, declaringClass);
        Type[] upperBounds = TypeParameterResolver.resolveWildcardTypeBounds(wildcardType.getUpperBounds(), srcType, declaringClass);
        return new WildcardTypeImpl(lowerBounds, upperBounds);
    }

    private static Type[] resolveWildcardTypeBounds(Type[] bounds, Type srcType, Class<?> declaringClass) {
        Type[] result = new Type[bounds.length];
        for (int i = 0; i < bounds.length; ++i) {
            result[i] = bounds[i] instanceof TypeVariable ? TypeParameterResolver.resolveTypeVar((TypeVariable)bounds[i], srcType, declaringClass) : (bounds[i] instanceof ParameterizedType ? TypeParameterResolver.resolveParameterizedType((ParameterizedType)bounds[i], srcType, declaringClass) : (bounds[i] instanceof WildcardType ? TypeParameterResolver.resolveWildcardType((WildcardType)bounds[i], srcType, declaringClass) : bounds[i]));
        }
        return result;
    }

    private static Type resolveTypeVar(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass) {
        Type[] superInterfaces;
        Type result = null;
        Class clazz = null;
        if (srcType instanceof Class) {
            clazz = (Class)srcType;
        } else if (srcType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)srcType;
            clazz = (Class)parameterizedType.getRawType();
        } else {
            throw new IllegalArgumentException("The 2nd arg must be Class or ParameterizedType, but was: " + srcType.getClass());
        }
        if (clazz == declaringClass) {
            Type[] bounds = typeVar.getBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            return Object.class;
        }
        Type superclass = clazz.getGenericSuperclass();
        result = TypeParameterResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superclass);
        if (result != null) {
            return result;
        }
        for (Type superInterface : superInterfaces = clazz.getGenericInterfaces()) {
            result = TypeParameterResolver.scanSuperTypes(typeVar, srcType, declaringClass, clazz, superInterface);
            if (result == null) continue;
            return result;
        }
        return Object.class;
    }

    private static Type scanSuperTypes(TypeVariable<?> typeVar, Type srcType, Class<?> declaringClass, Class<?> clazz, Type superclass) {
        Type result = null;
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parentAsType = (ParameterizedType)superclass;
            Class parentAsClass = (Class)parentAsType.getRawType();
            if (declaringClass == parentAsClass) {
                Type[] typeArgs = parentAsType.getActualTypeArguments();
                TypeVariable<Class<?>>[] declaredTypeVars = declaringClass.getTypeParameters();
                block0: for (int i = 0; i < declaredTypeVars.length; ++i) {
                    if (declaredTypeVars[i] != typeVar) continue;
                    if (typeArgs[i] instanceof TypeVariable) {
                        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
                        for (int j = 0; j < typeParams.length; ++j) {
                            if (typeParams[j] != typeArgs[i]) continue;
                            if (!(srcType instanceof ParameterizedType)) continue block0;
                            result = ((ParameterizedType)srcType).getActualTypeArguments()[j];
                            continue block0;
                        }
                        continue;
                    }
                    result = typeArgs[i];
                }
            } else if (declaringClass.isAssignableFrom(parentAsClass)) {
                result = TypeParameterResolver.resolveTypeVar(typeVar, parentAsType, declaringClass);
            }
        } else if (superclass instanceof Class && declaringClass.isAssignableFrom((Class)superclass)) {
            result = TypeParameterResolver.resolveTypeVar(typeVar, superclass, declaringClass);
        }
        return result;
    }

    private TypeParameterResolver() {
    }

    static class GenericArrayTypeImpl
    implements GenericArrayType {
        private Type genericComponentType;

        private GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }
    }

    static class WildcardTypeImpl
    implements WildcardType {
        private Type[] lowerBounds;
        private Type[] upperBounds;

        private WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private Class<?> rawType;
        private Type ownerType;
        private Type[] actualTypeArguments;

        public ParameterizedTypeImpl(Class<?> rawType, Type ownerType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        public String toString() {
            return "ParameterizedTypeImpl [rawType=" + this.rawType + ", ownerType=" + this.ownerType + ", actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + "]";
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }
    }
}

