/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sqlParam;

import com.kingdee.eas.hr.ats.sqlParam.AbstractSqlParam;
import com.kingdee.eas.hr.ats.sqlParam.AdminExtModel;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import org.apache.commons.lang.StringUtils;

public class AdminSqlParam
extends AbstractSqlParam {
    boolean relationEnableFilter = true;
    boolean subAdminOrgOfHrorg = false;
    protected String hrOrgManageType;

    public AdminSqlParam() {
        this.useTempTable = true;
    }

    @Override
    protected void initSelector() {
        this.addSelectField("ASPAdmin.fid");
    }

    @Override
    public void initSql() {
        this.ASPSql.append(" from t_org_admin ASPAdmin");
        if (StringUtils.isNotBlank((String)this.adminRangeSql)) {
            this.ASPSql.append(" join (").append(this.adminRangeSql).append(") ASPrange on ASPrange.FAdminOrgID=ASPAdmin.fid");
        }
        this.initHrOrgRelation();
        this.initByIdsAndNumbers();
    }

    private void initHrOrgRelation() {
        if (!this.subAdminOrgOfHrorg) {
            this.ASPSql.append(" where 1=1 ");
            return;
        }
        this.ASPSql.append(" join T_HR_AdminOrgBURelation ASPelation on ASPAdmin.fid = ASPrelation.fadminOrgid");
        if (StringUtils.isNotBlank((String)this.hrOrgRangeSql)) {
            this.ASPSql.append(" join (").append(this.hrOrgRangeSql).append(") ASPhrOrgRange on ASPhrOrgRange.fid=ASPelation.fmanageHrOrgId");
        }
        if (this.relationEnableFilter) {
            this.ASPSql.append(" where ASPelation.fstate = ").append(1);
        } else {
            this.ASPSql.append(" where 1=1 ");
        }
        if (StringUtils.isNotBlank((String)this.hrOrgManageType)) {
            this.ASPSql.append(" and ASPelation.fbizManageTypeId='").append(this.hrOrgManageType).append("'");
        }
        if (StringUtils.isNotBlank((String)this.hrOrgIds)) {
            this.ASPSql.append(" and ASPelation.fmanageHrOrgId ").append(AtsCommonUtile.getInSql(this.hrOrgIds));
        }
        if (StringUtils.isBlank((String)this.hrOrgRangeSql) && StringUtils.isBlank((String)this.hrOrgIds)) {
            this.ASPSql.append(" and 1=2");
        }
    }

    private void initByIdsAndNumbers() {
        boolean hasIds;
        this.ASPSql.append(" and ( 1=1");
        boolean bl = hasIds = StringUtils.isNotBlank((String)this.adminIds) || StringUtils.isNotBlank((String)this.adminRangeSql);
        if (hasIds) {
            StringBuffer inBuffer = new StringBuffer();
            if (StringUtils.isNotBlank((String)this.adminIds)) {
                inBuffer.append(this.adminExtModel != AdminExtModel.NOEXT ? " and fid " : " and ASPAdmin.fid");
                inBuffer.append(AtsCommonUtile.getInSql(this.adminIds));
            }
            if (this.adminExtModel != AdminExtModel.NOEXT) {
                this.ASPSql.append(" and exists (select 1 from t_org_admin where");
                if (this.adminExtModel == AdminExtModel.DOWN) {
                    this.ASPSql.append(" CHARINDEX(concat(ASPAdmin.flongnumber, '!'),flongnumber)=1");
                } else {
                    this.ASPSql.append(" CHARINDEX(concat('!',ASPAdmin.flongnumber),flongnumber)=len(flongnumber)-len(ASPAdmin.flongnumber)");
                }
                this.ASPSql.append(" OR ASPAdmin.flongnumber = flongnumber)");
            }
            this.ASPSql.append(inBuffer);
        }
        if (StringUtils.isNotBlank((String)this.adminLongNumbers)) {
            this.ASPSql.append(hasIds ? " or" : " ");
            if (this.adminExtModel != AdminExtModel.NOEXT) {
                this.ASPSql.append(AtsCommonUtile.getAdminContainSql(this.adminLongNumbers, "ASPAdmin", this.adminExtModel == AdminExtModel.DOWN));
            } else {
                this.ASPSql.append("ASPAdmin.flongNumber").append(AtsCommonUtile.getInSql(this.adminLongNumbers));
            }
        }
        this.ASPSql.append(")");
    }

    public AdminSqlParam setAttendanceManageType() {
        this.hrOrgManageType = "a1XVAx7aQEiqGkQqicFzfmWJ1dE=";
        return this;
    }

    public AdminSqlParam seHolidayManageType() {
        this.hrOrgManageType = "WMwl/vtBvkmbWdGELoP6Y2WJ1dE=";
        return this;
    }

    @Override
    public AdminExtModel getAdminExtModel() {
        return this.adminExtModel;
    }

    @Override
    public AdminSqlParam setAdminExtModel(AdminExtModel adminExtModel) {
        this.adminExtModel = adminExtModel;
        return this;
    }

    @Override
    public String getHrOrgIds() {
        return this.hrOrgIds;
    }

    @Override
    public AdminSqlParam setHrOrgIds(String hrOrgIds) {
        this.hrOrgIds = hrOrgIds;
        return this;
    }

    public String getHrOrgManageType() {
        return this.hrOrgManageType;
    }

    public AdminSqlParam setHrOrgManageType(String hrOrgManageType) {
        this.hrOrgManageType = hrOrgManageType;
        return this;
    }

    @Override
    public String getAdminIds() {
        return this.adminIds;
    }

    @Override
    public AdminSqlParam setAdminIds(String adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    @Override
    public String getAdminRangeSql() {
        return this.adminRangeSql;
    }

    @Override
    public AdminSqlParam setAdminRangeSql(String adminRangeSql) {
        this.adminRangeSql = adminRangeSql;
        return this;
    }

    @Override
    public String getAdminLongNumbers() {
        return this.adminLongNumbers;
    }

    @Override
    public AdminSqlParam setAdminLongNumbers(String adminLongNumbers) {
        this.adminLongNumbers = adminLongNumbers;
        return this;
    }

    public boolean isRelationEnableFilter() {
        return this.relationEnableFilter;
    }

    public AdminSqlParam setRelationEnableFilter(boolean relationEnableFilter) {
        this.relationEnableFilter = relationEnableFilter;
        return this;
    }

    public boolean isSubAdminOrgOfHrorg() {
        return this.subAdminOrgOfHrorg;
    }

    public AdminSqlParam setSubAdminOrgOfHrorg(boolean subAdminOrgOfHrorg) {
        this.subAdminOrgOfHrorg = subAdminOrgOfHrorg;
        return this;
    }
}

